/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.preview;

import com.iscobol.gui.Events;
import com.iscobol.gui.export.ExportFileChooser;
import com.iscobol.preview.DrawStringItem;
import com.iscobol.preview.PreviewDialog;
import com.iscobol.preview.PreviewDialogSettings;
import com.iscobol.preview.PreviewEvent;
import com.iscobol.preview.PreviewListener;
import com.iscobol.rts.print.SpoolPrinter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class Preview
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final double THUMB_SCALE = 15.0 / (double)Toolkit.getDefaultToolkit().getScreenResolution();
    private static final double FIT_WIDTH = -1.0;
    private static final double FIT_PAGE = -2.0;
    private final float screenResolution;
    private boolean doPrint;
    private boolean doPdf;
    private String filename;
    private int currentPageNumber = 1;
    private int nPages;
    private Printable printable;
    private Pageable pageable;
    private PageFormat pageFormat;
    private double scale = 1.0;
    boolean antialiasing;
    private DrawStringItem findToken;
    private int findTokenStart;
    private int findTokenEnd;
    private Rectangle findRect;
    private MyPanel previewPanel;
    private JScrollPane scrollPane;
    private JPanel thumbsPanel;
    private JScrollPane thumbsScrollPane;
    private ArrayList previewListeners = new ArrayList();
    private Color selForeground;
    private Color selBackground;
    private boolean showThumbnails;
    private PreviewDialog parent;

    public Preview(Printable prn, Pageable pg, int pageCount, String fn, Color boxColor, PreviewDialog parent) {
        this.parent = parent;
        this.pageable = pg;
        JTextField tf = new JTextField();
        this.selBackground = tf.getSelectionColor();
        this.selForeground = tf.getSelectedTextColor();
        this.setLayout(new BorderLayout(10, 0));
        this.setFilename(fn);
        this.printable = prn;
        this.screenResolution = this.printable instanceof SpoolPrinter ? (float)((SpoolPrinter)this.printable).getGuiFactory().getScreenRes() : 96.0f;
        this.intSetPageFormat(pg.getPageFormat(0), false);
        this.previewPanel = new MyPanel(-1);
        this.previewPanel.boxColor = boxColor;
        this.scrollPane = new JScrollPane(this.previewPanel);
        this.scrollPane.getVerticalScrollBar().setFocusable(false);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.scrollPane.getVerticalScrollBar().setBlockIncrement(100);
        this.scrollPane.getHorizontalScrollBar().setFocusable(false);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement(100);
        this.scrollPane.getViewport().setScrollMode(2);
        this.thumbsPanel = new JPanel(new FlowLayout(1, 10, 5)){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                if (Preview.this.nPages == 0 || this.getComponentCount() == 0) {
                    return new Dimension(125, 170);
                }
                int maxW = 0;
                int maxH = 0;
                int cc = this.getComponentCount();
                for (int i = 0; i < cc; ++i) {
                    ThumbPanel thumbP = (ThumbPanel)this.getComponent(i);
                    Dimension d = thumbP.getPreferredSize();
                    if (d.width > maxW) {
                        maxW = d.width;
                    }
                    if (d.height <= maxH) continue;
                    maxH = d.height;
                }
                return new Dimension(maxW, (maxH + 5) * Preview.this.nPages + 5);
            }
        };
        this.thumbsScrollPane = new JScrollPane(this.thumbsPanel){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = ((Preview)Preview.this).thumbsPanel.getPreferredSize().width + 30;
                d.height = ((Preview)Preview.this).scrollPane.getPreferredSize().height;
                return d;
            }
        };
        this.thumbsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.thumbsScrollPane.getVerticalScrollBar().setBlockIncrement(100);
        this.thumbsScrollPane.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, Color.lightGray));
        this.add((Component)this.scrollPane, "Center");
        this.setPageNumber(1);
        this.scrollPane.setPreferredSize(new Dimension((int)(this.previewPanel.docWidth * (double)this.screenResolution / 80.0), (int)(this.previewPanel.docHeight * (double)this.screenResolution / 144.0)));
        this.setPageCount(pageCount);
        this.setVisible(true);
    }

    public void addPreviewListener(PreviewListener pl) {
        this.previewListeners.add(pl);
    }

    public void removePreviewListener(PreviewListener pl) {
        this.previewListeners.remove(pl);
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isDoPrint() {
        return this.doPrint;
    }

    public void setDoPrint(boolean doPrint) {
        this.doPrint = doPrint;
    }

    public boolean isDoPdf() {
        return this.doPdf;
    }

    public void setDoPdf(boolean doPdf) {
        this.doPdf = doPdf;
    }

    public int getPageNumber() {
        return this.currentPageNumber;
    }

    public void setPageNumber(int newPageNumber) {
        if (newPageNumber > 0 && newPageNumber <= this.nPages && newPageNumber != this.currentPageNumber) {
            if (this.pageFormat == null) {
                this.intSetPageFormat(this.getPageFormat(newPageNumber - 1), true);
                this.doLayout();
            }
            this.currentPageNumber = newPageNumber;
            for (int i = 0; i < this.thumbsPanel.getComponentCount(); ++i) {
                ThumbPanel tp = (ThumbPanel)this.thumbsPanel.getComponent(i);
                tp.setSelected(i == newPageNumber - 1);
                if (!tp.sel) continue;
                this.thumbsPanel.scrollRectToVisible(tp.getBounds());
            }
            this.redrawPreview();
        }
    }

    public static PreviewDialog previewDialog(Printable prn, Pageable pg, int nPages, String filename, PreviewDialogSettings settings, Events events) {
        PreviewDialog Return2 = new PreviewDialog(prn, pg, nPages, filename, settings, events);
        Return2.openWindow();
        return Return2;
    }

    public void showFirstPage() {
        this.setPageNumber(1);
    }

    public void showLastPage() {
        this.setPageNumber(this.getPageCount());
    }

    public void showNextPage() {
        this.setPageNumber(this.getPageNumber() + 1);
    }

    public void showPreviousPage() {
        this.setPageNumber(this.getPageNumber() - 1);
    }

    public int getPageCount() {
        return this.nPages;
    }

    public void setPageCount(int pages) {
        this.nPages = pages;
        this.thumbsPanel.removeAll();
        for (int i = 1; i <= pages; ++i) {
            this.thumbsPanel.add(new ThumbPanel(i));
        }
        if (pages > 0) {
            ((ThumbPanel)this.thumbsPanel.getComponent(0)).setSelected(true);
        }
        if (this.currentPageNumber > this.nPages) {
            this.showLastPage();
        }
        this.thumbsPanel.doLayout();
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
        double locScale = this.previewPanel.getLocalScale();
        this.scrollPane.getVerticalScrollBar().setValue(0);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement((int)(10.0 * locScale));
        this.scrollPane.getVerticalScrollBar().setBlockIncrement((int)(100.0 * locScale));
        this.scrollPane.getHorizontalScrollBar().setValue(0);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement((int)(10.0 * locScale));
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement((int)(100.0 * locScale));
        this.previewPanel.setSize(this.previewPanel.getPreferredSize());
        this.previewPanel.repaint();
    }

    public boolean isAntialiasing() {
        return this.antialiasing;
    }

    public void setAntialiasing(boolean antialiasing) {
        this.antialiasing = antialiasing;
        this.previewPanel.repaint();
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Printable getPrintable() {
        return this.printable;
    }

    private void redrawPreview() {
        this.previewPanel.repaint();
    }

    private void redrawThumbnails() {
        if (this.isShowThumbnails()) {
            for (int i = 0; i < this.thumbsPanel.getComponentCount(); ++i) {
                this.thumbsPanel.getComponent(i).repaint();
            }
        }
    }

    public PageFormat getPageFormat(int pageIndex) {
        if (pageIndex < 0) {
            pageIndex = 0;
        }
        return this.pageFormat != null ? this.pageFormat : this.pageable.getPageFormat(pageIndex);
    }

    public void setPageFormat(PageFormat pageFormat, boolean update) {
        this.pageFormat = pageFormat;
        this.intSetPageFormat(pageFormat, update);
    }

    private void intSetPageFormat(PageFormat pageFormat, boolean update) {
        if (this.previewPanel != null) {
            this.previewPanel.pageFormat(pageFormat, update);
            this.redrawPreview();
            this.redrawThumbnails();
            this.revalidate();
        }
    }

    public String openSavePdfDialog(Component parent, String dir, String fileName) {
        String fn;
        if (fileName != null && !fileName.toLowerCase().endsWith(".pdf")) {
            int idx = fileName.lastIndexOf(46);
            fileName = idx >= 0 ? fileName.substring(0, idx) + ".pdf" : fileName + ".pdf";
        }
        if ((fn = Preview.openSaveDialog(parent, "pdf", "Portable Document Format (*.pdf)", dir, fileName)) != null) {
            this.filename = fn;
            this.doPrint = true;
            this.doPdf = true;
            return fn;
        }
        return null;
    }

    public static String openSaveDialog(Component parent, String defExt, String defExtDesc, String defFile) {
        return Preview.openSaveDialog(parent, defExt, defExtDesc, SpoolPrinter.getSaveDefaultDirectory(), defFile);
    }

    public static String openSaveDialog(Component parent, String defExt, String defExtDesc, String defDir, String defFile) {
        String[] descriptions;
        String[] extensions;
        if (defExt != null) {
            extensions = new String[]{defExt};
            descriptions = new String[]{defExtDesc != null ? defExtDesc : ""};
        } else {
            extensions = new String[]{};
            descriptions = new String[]{};
        }
        String fileName = defFile != null ? defFile : (defDir != null ? defDir : null);
        return ExportFileChooser.openSaveDialog(fileName, extensions, descriptions, defExt, false);
    }

    public void setFindToken(DrawStringItem findToken, int start, int end) {
        this.findToken = findToken;
        this.findTokenStart = start;
        this.findTokenEnd = end;
        if (findToken != null) {
            if (findToken.pageIndex != this.currentPageNumber) {
                this.currentPageNumber = findToken.pageIndex;
            }
            this.previewPanel.repaint();
            SwingUtilities.invokeLater(() -> {
                Rectangle viewRect = this.scrollPane.getViewport().getViewRect();
                if (this.findRect != null && !viewRect.contains(this.findRect)) {
                    Point viewPos = viewRect.getLocation();
                    int d = this.findRect.x + this.findRect.width - viewRect.x - viewRect.width;
                    if (d > 0) {
                        viewPos.x += d;
                    } else {
                        d = viewRect.x - this.findRect.x;
                        if (d > 0) {
                            viewPos.x -= d;
                        }
                    }
                    d = this.findRect.y + this.findRect.height - viewRect.y - viewRect.height;
                    if (d > 0) {
                        viewPos.y += d;
                    } else {
                        d = viewRect.y - this.findRect.y;
                        if (d > 0) {
                            viewPos.y -= d;
                        }
                    }
                    this.scrollPane.getViewport().setViewPosition(viewPos);
                    this.findRect = null;
                }
            });
        } else {
            this.previewPanel.repaint();
        }
    }

    private int getCoordinate(float c) {
        return Math.round(c * this.screenResolution * (float)this.scale / 72.0f);
    }

    public JPanel getPanel() {
        return this.previewPanel;
    }

    public boolean isShowThumbnails() {
        return this.showThumbnails;
    }

    public void setShowThumbnails(boolean showThumbnails) {
        if (this.showThumbnails != showThumbnails) {
            this.showThumbnails = showThumbnails;
            if (this.showThumbnails) {
                this.add((Component)this.thumbsScrollPane, "West");
            } else {
                this.remove(this.thumbsScrollPane);
            }
            this.revalidate();
        }
    }

    static float getHeight(TextLayout layout) {
        return layout.getAscent() + layout.getDescent() + layout.getLeading();
    }

    private class ThumbPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        final MyPanel thumb;
        final JLabel lbl;
        final JPanel p;
        private boolean sel;
        private final Border selBorder;

        ThumbPanel(final int pageNumber) {
            Border b;
            super(new BorderLayout());
            this.thumb = new MyPanel(pageNumber);
            this.lbl = new JLabel("" + pageNumber, 0);
            this.add((Component)this.lbl, "South");
            this.p = new JPanel(new BorderLayout(0, 0));
            this.p.add((Component)this.thumb, "Center");
            this.add((Component)this.p, "Center");
            this.selBorder = b = BorderFactory.createBevelBorder(1, Color.blue.brighter().brighter(), Color.blue.brighter(), Color.white.darker().darker(), Color.white.darker());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Preview.this.setPageNumber(pageNumber);
                    Preview.this.parent.updateToolbar();
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = this.thumb.getPreferredSize();
            d.height += this.lbl.getPreferredSize().height + 5;
            return d;
        }

        void setSelected(boolean s) {
            if (this.sel != s) {
                this.sel = s;
                if (this.sel) {
                    this.p.setBorder(this.selBorder);
                } else {
                    this.p.setBorder(null);
                }
            }
        }
    }

    class MyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private double docHeight = 500.0;
        private double docWidth = 500.0;
        private Rectangle2D.Double clipping;
        private Rectangle2D.Double fullPage;
        private Color boxColor;
        private int pageNumber;
        private final boolean isThumbnail;

        MyPanel(int pageNumber) {
            this.pageNumber = pageNumber;
            boolean bl = this.isThumbnail = pageNumber >= 0;
            if (this.isThumbnail) {
                this.setOpaque(false);
            } else {
                this.setBackground(Color.lightGray);
            }
            PageFormat pf = Preview.this.getPageFormat(pageNumber - 1);
            this.pageFormat(pf, true);
            this.setLayout(null);
        }

        private int pageNumber() {
            return this.isThumbnail ? this.pageNumber : Preview.this.currentPageNumber;
        }

        @Override
        public Dimension getPreferredSize() {
            double locScale = this.getLocalScale();
            return new Dimension((int)(this.docWidth * locScale), (int)(this.docHeight * locScale));
        }

        double getLocalScale() {
            double locScale;
            if (this.isThumbnail) {
                locScale = THUMB_SCALE;
            } else {
                Dimension d = Preview.this.scrollPane.getViewport().getSize();
                locScale = Preview.this.scale;
                if (Preview.this.scale < 0.0) {
                    if (Preview.this.scale == -1.0) {
                        locScale = (double)d.width / this.docWidth;
                    } else if (Preview.this.scale == -2.0) {
                        locScale = Math.min((double)d.height / this.docHeight, (double)d.width / this.docWidth);
                    }
                }
            }
            return locScale * (double)Preview.this.screenResolution / 72.0;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, Preview.this.antialiasing ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            double locScale = this.getLocalScale();
            Printable prn = Preview.this.getPrintable();
            PageFormat pf = Preview.this.getPageFormat(this.pageNumber - 1);
            if (prn == null || pf == null) {
                g2d.drawString("Test MyPanel", 0, 0);
            } else {
                try {
                    SpoolPrinter sp;
                    g2d.setColor(this.getBackground());
                    g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g2d.scale(locScale, locScale);
                    g2d.setColor(Color.white);
                    g2d.fill(this.fullPage);
                    g2d.setColor(Color.black);
                    g2d.draw(this.fullPage);
                    g2d.clip(this.clipping);
                    int pageNumber = this.pageNumber();
                    if (prn.print(g2d, pf, pageNumber - 1) == 1 && pageNumber > 1) {
                        --pageNumber;
                        PreviewEvent evt = new PreviewEvent(Preview.this);
                        for (int i = 0; i < Preview.this.previewListeners.size(); ++i) {
                            ((PreviewListener)Preview.this.previewListeners.get(i)).noSuchPage(evt);
                        }
                        prn.print(g2d, pf, pageNumber - 1);
                    }
                    g2d.setColor(this.boxColor);
                    g2d.setStroke(new BasicStroke(1.0f));
                    double[] margins = new double[4];
                    if (prn instanceof SpoolPrinter && (sp = (SpoolPrinter)prn).isReportPreview()) {
                        margins = sp.getMargins(4);
                    }
                    g2d.draw(new Rectangle2D.Double(0.0, 0.0, pf.getImageableWidth() - 1.0 - margins[2] - margins[3], pf.getImageableHeight() - 1.0 - margins[0] - margins[1]));
                    if (Preview.this.findToken != null && ((Preview)Preview.this).findToken.pageIndex == pageNumber) {
                        g2d.setFont(((Preview)Preview.this).findToken.font);
                        String text = ((Preview)Preview.this).findToken.text;
                        float x = ((Preview)Preview.this).findToken.x;
                        if (Preview.this.findTokenStart >= 0 && Preview.this.findTokenStart < Preview.this.findTokenEnd && Preview.this.findTokenEnd <= text.length()) {
                            if (Preview.this.findTokenStart > 0) {
                                TextLayout layout = new TextLayout(text.substring(0, Preview.this.findTokenStart), g2d.getFont(), g2d.getFontRenderContext());
                                x += layout.getAdvance();
                            }
                            text = text.substring(Preview.this.findTokenStart, Preview.this.findTokenEnd);
                        }
                        TextLayout layout = new TextLayout(text, g2d.getFont(), g2d.getFontRenderContext());
                        float height = Preview.getHeight(layout) + 1.0f;
                        Rectangle2D.Float rect = new Rectangle2D.Float(x, ((Preview)Preview.this).findToken.y - height + layout.getDescent(), layout.getAdvance() + 1.0f, height);
                        g2d.setColor(Preview.this.selBackground);
                        g2d.fill(rect);
                        g2d.setColor(Preview.this.selForeground);
                        g2d.drawString(text, x, ((Preview)Preview.this).findToken.y);
                        Preview.this.findRect = new Rectangle(Preview.this.getCoordinate(rect.x), Preview.this.getCoordinate(rect.y), Preview.this.getCoordinate(rect.width), Preview.this.getCoordinate(rect.height));
                    }
                }
                catch (PrinterException e) {
                    g2d.drawString("" + e, 0, 0);
                }
            }
        }

        void pageFormat(PageFormat pf, boolean update) {
            if (pf != null) {
                this.docWidth = pf.getWidth();
                this.docHeight = pf.getHeight();
                this.clipping = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
            } else {
                this.docHeight = 500.0;
                this.docWidth = 500.0;
                this.clipping = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
            }
            if (update) {
                this.fullPage = new Rectangle2D.Double(0.0, 0.0, this.docWidth, this.docHeight);
            }
        }
    }
}

