/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.RemoteImage;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.SerializableImage;
import com.iscobol.gui.server.CobolGUIBitmap;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.rts.BarcodeCreationException;
import com.iscobol.rts.BitmapNotFoundException;
import com.iscobol.rts.Config;
import com.iscobol.rts.File;
import com.iscobol.rts.Handle;
import java.awt.Image;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;

public class FileImage
implements Serializable,
Handle,
Cloneable {
    private String filePathStr;
    private java.io.File filePath;
    private long fileTimestamp;
    private boolean replaced;
    private byte[] imgStream;
    private URL fileUrl;
    private RemoteImage imagePeer;
    private int imagePeerId = -1;
    private RemoteImage imagePeerDestroyed;
    private int imagePeerIdDestroyed = -1;
    private Image nativeImage;
    private CobolGUIBitmap guiBitmap;
    public int refCount;
    private FileImage clonesource;
    private boolean destroyed;
    private boolean loadedFromClient;
    private boolean lightGrayIsTransparent = Config.getProperty("iscobol.gui.light_gray_is_transparent", true);

    public FileImage(String filePath) throws BitmapNotFoundException {
        this(filePath, false);
    }

    public FileImage(String filePath, boolean loadFromClient) throws BitmapNotFoundException {
        this.setFilePath(filePath, !loadFromClient);
        if (loadFromClient) {
            this.imagePeer = this.loadFromClient();
            this.loadedFromClient = loadFromClient;
        } else {
            this.imagePeer = this.loadFromFile();
        }
    }

    public FileImage(InputStream is, String filePath) throws BitmapNotFoundException {
        this.setFilePath(filePath, true);
        this.imagePeer = this.loadFromInputStream(is);
    }

    public FileImage(byte[] imgStream) throws BitmapNotFoundException {
        this.setFilePath(null, false);
        this.imgStream = imgStream;
        this.imagePeer = this.loadFromStream();
    }

    public FileImage(URL url) throws BitmapNotFoundException {
        this.setFilePath(url.toString(), false);
        this.fileUrl = url;
        try {
            this.imagePeer = this.loadFromInputStream(url.openStream());
        }
        catch (IOException e) {
            throw new BitmapNotFoundException(e.toString());
        }
    }

    public FileImage(int width, FontCmp[] font, String[] charSeq, int[] color, String filePath) {
        this.setFilePath(filePath, false);
        this.imagePeer = this.loadFromFontSymbols(width, font, charSeq, color);
    }

    public FileImage(int width, int shape, FontCmp font, String text, int fgColor, int bgColor, int grdOr, int bgColor2, String filePath) {
        this.setFilePath(filePath, false);
        this.imagePeer = this.loadTextBox(width, shape, font, text, fgColor, bgColor, grdOr, bgColor2);
    }

    public FileImage(String text, int width, int height, int type, int dpi, int orientation, int antialiasing, int textPosition, int background, int foreground, int logoId, String filePath) throws BarcodeCreationException {
        this.setFilePath(filePath, false);
        this.imagePeer = this.loadBarcodeBox(text, width, height, type, dpi, orientation, antialiasing, textPosition, background, foreground, logoId);
    }

    public FileImage(RemoteImage imagePeer) {
        this.setFilePath(null, false);
        this.imagePeer = imagePeer;
    }

    private void setFilePath(String f, boolean isFile) {
        this.filePathStr = f;
        if (this.filePathStr != null && isFile) {
            this.filePath = File.get(this.filePathStr.trim());
            if (this.filePath.exists() && this.filePath.isFile()) {
                this.fileTimestamp = this.filePath.lastModified();
            }
        }
    }

    public boolean isLoadedFromClient() {
        return this.loadedFromClient;
    }

    public boolean isModified() {
        return this.filePath != null && this.fileTimestamp > 0L && this.fileTimestamp < this.filePath.lastModified();
    }

    private RemoteImage loadFromFontSymbols(int width, FontCmp[] font, String[] charSeq, int[] color) {
        int[] fontId = new int[font.length];
        for (int i = 0; i < font.length; ++i) {
            fontId[i] = font[i].getFontId(false);
        }
        GuiFactory gf = ScreenUtility.getGuiFactory();
        try {
            return gf.loadImage(width, fontId, charSeq, color);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
            return null;
        }
    }

    private RemoteImage loadTextBox(int width, int shape, FontCmp font, String text, int fgColor, int bgColor, int grdOr, int bgColor2) {
        GuiFactory gf = ScreenUtility.getGuiFactory();
        try {
            return gf.loadImage(width, shape, font.getFontId(false), text, fgColor, bgColor, grdOr, bgColor2);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
            return null;
        }
    }

    private RemoteImage loadBarcodeBox(String text, int width, int height, int type, int dpi, int orientation, int antialiasing, int textPosition, int background, int foreground, int logoId) throws BarcodeCreationException {
        GuiFactory gf = ScreenUtility.getGuiFactory();
        try {
            Object ret = gf.loadImage(text, width, height, type, dpi, orientation, antialiasing, textPosition, background, foreground, logoId);
            if (ret instanceof RemoteImage) {
                return (RemoteImage)ret;
            }
            throw new BarcodeCreationException((String)ret);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
            return null;
        }
    }

    private RemoteImage loadFromClient() {
        GuiFactory gf = ScreenUtility.getGuiFactory();
        try {
            return gf.loadClientImage(this.filePathStr);
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
            return null;
        }
    }

    private RemoteImage loadFromStream() {
        if (this.imgStream != null) {
            GuiFactory gf = ScreenUtility.getGuiFactory();
            try {
                RemoteImage Return2 = gf.loadImage(this.imgStream);
                return Return2;
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
                return null;
            }
        }
        return null;
    }

    private RemoteImage loadFromFile() throws BitmapNotFoundException {
        if (this.filePath.exists()) {
            try {
                FileInputStream is = new FileInputStream(this.filePath);
                return this.loadFromInputStream(is);
            }
            catch (FileNotFoundException e) {
                throw new BitmapNotFoundException(this.filePathStr);
            }
        }
        throw new BitmapNotFoundException(this.filePathStr);
    }

    private RemoteImage loadFromInputStream(InputStream is) {
        try {
            this.imgStream = new byte[is.available()];
            int rc = 0;
            for (int cnt = 0; cnt < this.imgStream.length && (rc = is.read(this.imgStream, cnt, this.imgStream.length - cnt)) >= 0; cnt += rc) {
            }
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.loadFromStream();
    }

    public Image getNativeImage() {
        if (this.nativeImage == null) {
            byte[] b = this.getImgStream();
            if (b != null) {
                this.nativeImage = ScreenUtility.createImage(this.getImgStream(), new int[]{0}, true, this.lightGrayIsTransparent, Config.getProperty("iscobol.wbitmap.load_method", 1));
            } else if (this.imagePeer != null) {
                try {
                    SerializableImage sim = this.imagePeer.getImage();
                    if (sim != null) {
                        this.nativeImage = sim.getImage();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.nativeImage;
    }

    public RemoteImage getImage() {
        return this.imagePeer;
    }

    public int getImageId() {
        try {
            if (this.imagePeerId == -1 && this.imagePeer != null && !this.destroyed) {
                this.imagePeerId = this.imagePeer.getTheObjectId();
            }
            return this.imagePeerId;
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
            return -1;
        }
    }

    public byte[] getStream() {
        return this.getImgStream();
    }

    public int getWidth() {
        if (this.imagePeer != null) {
            try {
                return this.imagePeer.getWidth();
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
                return 0;
            }
        }
        return 0;
    }

    public int getHeight() {
        if (this.imagePeer != null) {
            try {
                return this.imagePeer.getHeight();
            }
            catch (IOException _re) {
                ScreenUtility.handleIOException(_re);
                return 0;
            }
        }
        return 0;
    }

    public void destroy() {
        if (this.guiBitmap != null) {
            ScrFactory.getGUIEnviroment().destroy(this.guiBitmap);
        }
        try {
            if (this.getRefCount() <= 0 && this.imagePeer != null) {
                this.imagePeer.destroy();
                this.imagePeerDestroyed = null;
                this.imagePeerIdDestroyed = -1;
            } else if (this.clonesource == null && this.imgStream != null) {
                this.imagePeerDestroyed = this.imagePeer;
                this.imagePeerIdDestroyed = this.getImageId();
            }
            this.imagePeer = null;
            this.imagePeerId = -1;
            this.clonesource = null;
            this.destroyed = true;
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
        }
    }

    @Override
    public int type() {
        return 7;
    }

    public void setControl(CobolGUIBitmap bmp) {
        this.guiBitmap = bmp;
    }

    public String getFilePath() {
        return this.filePathStr;
    }

    public Object clone() {
        Object Return2 = null;
        if (this.refCount > 1 && this.destroyed && this.imgStream != null && this.imagePeerDestroyed != null && this.imagePeerIdDestroyed >= 0) {
            Return2 = this;
            this.imagePeer = this.imagePeerDestroyed;
            this.imagePeerId = this.imagePeerIdDestroyed;
            --this.refCount;
            this.destroyed = false;
            this.imagePeerDestroyed = null;
            this.imagePeerIdDestroyed = -1;
        } else {
            try {
                Return2 = super.clone();
                ((FileImage)Return2).initClone(this);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return Return2;
    }

    public void initClone(FileImage cs) {
        this.imgStream = null;
        this.refCount = 0;
        this.clonesource = cs;
    }

    public int getRefCount() {
        if (this.clonesource != null) {
            return this.clonesource.getRefCount();
        }
        return this.refCount;
    }

    public void setRefCount(int rf) {
        if (this.clonesource != null) {
            this.clonesource.setRefCount(rf);
        } else {
            this.refCount = rf;
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    private byte[] getImgStream() {
        if (this.clonesource != null) {
            return this.clonesource.getStream();
        }
        return this.imgStream;
    }

    public FileImage getCloneSource() {
        return this.clonesource;
    }

    public static FileImage getBroken() {
        return new FileImage(new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 16, 0, 0, 0, 16, 8, 2, 0, 0, 0, -112, -111, 104, 54, 0, 0, 0, 1, 115, 82, 71, 66, 0, -82, -50, 28, -23, 0, 0, 0, 4, 103, 65, 77, 65, 0, 0, -79, -113, 11, -4, 97, 5, 0, 0, 0, 9, 112, 72, 89, 115, 0, 0, 14, -61, 0, 0, 14, -61, 1, -57, 111, -88, 100, 0, 0, 0, 115, 73, 68, 65, 84, 56, 79, -91, -110, 9, 14, -128, 32, 12, 4, -47, 119, -15, -5, -14, 47, 93, -78, -92, -44, -46, 84, -116, -109, 32, 41, -35, -31, 72, 44, 34, 114, 109, -125, 112, -31, -60, 58, -121, -79, 46, 104, -111, -96, -127, 33, -128, -60, -79, -83, 41, -128, -48, 113, -117, 15, 1, -72, -10, -70, -123, 23, -128, -122, -62, 3, 15, -116, -78, -48, 90, -61, -73, -42, -54, -46, 114, -114, 121, 31, 30, 100, -55, -81, -12, -17, -47, -31, -106, 110, 113, 10, 97, -102, -40, -42, 16, -110, 52, -47, 64, 23, 94, -45, -124, -79, -113, -65, -73, -56, 13, 25, -33, -113, -49, 112, 100, 36, -64, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66});
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    public void setReplaced(boolean replaced) {
        this.replaced = replaced;
    }
}

