/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class FindDialog
extends JDialog {
    private static final long serialVersionUID = 123L;
    private JTextField toSearch;
    private JCheckBox matchCase;
    private JCheckBox backSearch;
    private JCheckBox matchMinusUnderscore;
    private JButton find;
    private JButton close;
    private FindParam param;
    private FindListener listener;

    public FindDialog(JFrame owner, String title, boolean modal) {
        this(owner, title, modal, true);
    }

    public FindDialog(JFrame owner, String title, boolean modal, boolean allowMatchMU) {
        super(owner, title, modal);
        this.init(allowMatchMU);
    }

    public FindDialog(JDialog owner, String title, boolean modal) {
        this(owner, title, modal, true);
    }

    public FindDialog(JDialog owner, String title, boolean modal, boolean allowMatchMU) {
        super(owner, title, modal);
        this.init(allowMatchMU);
    }

    private void init(boolean allowMathcMU) {
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent evt) {
                FindDialog findDialog = FindDialog.this;
                synchronized (findDialog) {
                    FindDialog.this.notify();
                }
            }
        });
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                if (k.getKeyCode() == 27) {
                    FindDialog.this.dispose();
                }
            }
        };
        SpringLayout springLayout = new SpringLayout();
        this.getContentPane().setLayout(springLayout);
        this.matchCase = new JCheckBox("Match Case");
        if (allowMathcMU) {
            this.matchMinusUnderscore = new JCheckBox("Match -/_");
        }
        this.backSearch = new JCheckBox("Backward Search");
        this.getContentPane().add(this.matchCase);
        if (allowMathcMU) {
            this.getContentPane().add(this.matchMinusUnderscore);
        }
        this.getContentPane().add(this.backSearch);
        this.find = new JButton("Find");
        this.find.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.responseOnAction();
            }
        });
        this.close = new JButton("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindDialog.this.dispose();
            }
        });
        this.find.setMnemonic('f');
        this.close.setMnemonic('c');
        FindDialog.setButtonsPreferredSizes(new AbstractButton[]{this.find, this.close});
        this.getContentPane().add(this.find);
        this.getContentPane().add(this.close);
        JLabel findLbl = new JLabel("Find:");
        this.toSearch = new JTextField();
        this.getContentPane().add(this.toSearch);
        this.getContentPane().add(findLbl);
        this.toSearch.addKeyListener(kl);
        this.matchCase.addKeyListener(kl);
        if (allowMathcMU) {
            this.matchMinusUnderscore.addKeyListener(kl);
        }
        this.backSearch.addKeyListener(kl);
        this.find.addKeyListener(kl);
        this.close.addKeyListener(kl);
        springLayout.putConstraint("North", (Component)findLbl, 12, "North", (Component)this.getContentPane());
        springLayout.putConstraint("West", (Component)findLbl, 10, "West", (Component)this.getContentPane());
        springLayout.putConstraint("North", (Component)this.toSearch, 10, "North", (Component)this.getContentPane());
        springLayout.putConstraint("West", (Component)this.toSearch, 10, "East", (Component)findLbl);
        springLayout.putConstraint("East", (Component)this.toSearch, 300, "West", (Component)this.toSearch);
        springLayout.putConstraint("South", (Component)this.toSearch, 28, "North", (Component)this.toSearch);
        springLayout.putConstraint("East", (Component)this.getContentPane(), 10, "East", (Component)this.toSearch);
        springLayout.putConstraint("North", (Component)this.matchCase, 15, "South", (Component)this.toSearch);
        springLayout.putConstraint("West", (Component)this.matchCase, 0, "West", (Component)findLbl);
        if (allowMathcMU) {
            springLayout.putConstraint("North", (Component)this.matchMinusUnderscore, 15, "South", (Component)this.toSearch);
            springLayout.putConstraint("West", (Component)this.matchMinusUnderscore, 15, "East", (Component)this.matchCase);
        }
        springLayout.putConstraint("North", (Component)this.backSearch, 15, "South", (Component)this.matchCase);
        springLayout.putConstraint("West", (Component)this.backSearch, 0, "West", (Component)findLbl);
        springLayout.putConstraint("South", (Component)this.getContentPane(), 50, "South", (Component)this.backSearch);
        springLayout.putConstraint("East", (Component)this.close, 0, "East", (Component)this.toSearch);
        springLayout.putConstraint("South", (Component)this.close, -10, "South", (Component)this.getContentPane());
        springLayout.putConstraint("North", (Component)this.find, 0, "North", (Component)this.close);
        springLayout.putConstraint("East", (Component)this.find, -10, "West", (Component)this.close);
        this.getRootPane().setDefaultButton(this.find);
        this.setResizable(false);
        this.pack();
    }

    public void setMatchCaseSelected(boolean b) {
        this.matchCase.setSelected(b);
    }

    public void setMatchMinusUnderscoreSelected(boolean b) {
        if (this.matchMinusUnderscore != null) {
            this.matchMinusUnderscore.setSelected(b);
        }
    }

    public void setBackwardSearchSelected(boolean b) {
        this.backSearch.setSelected(b);
    }

    public boolean isMatchCaseSelected() {
        return this.matchCase.isSelected();
    }

    public boolean isMatchMinusUnderscoreSelected() {
        return this.matchMinusUnderscore != null ? this.matchMinusUnderscore.isSelected() : false;
    }

    public boolean isBackwardSearchSelected() {
        return this.backSearch.isSelected();
    }

    public void open() {
        this.getRootPane().setDefaultButton(this.find);
        this.toSearch.selectAll();
        this.setVisible(true);
        this.param = null;
        Container c = this.getParent();
        if (c != null) {
            this.setLocationRelativeTo(c);
        }
    }

    private void responseOnAction() {
        String txt = this.toSearch.getText();
        if (txt.length() > 0) {
            this.param = new FindParam();
            this.param.toSearch = txt;
            this.param.matchCase = this.isMatchCaseSelected();
            this.param.matchMinusUnderscore = this.isMatchMinusUnderscoreSelected();
            this.param.backSearch = this.backSearch.isSelected();
            if (this.listener != null) {
                this.listener.find(this.param);
            }
        }
    }

    public static void setButtonsPreferredSizes(AbstractButton[] buttons) {
        int i;
        Dimension prefSize = buttons[0].getPreferredSize();
        for (i = 1; i < buttons.length; ++i) {
            Dimension d = buttons[i].getPreferredSize();
            if (d.width > prefSize.width) {
                prefSize.width = d.width;
            }
            if (d.height <= prefSize.height) continue;
            prefSize.height = d.height;
        }
        for (i = 0; i < buttons.length; ++i) {
            buttons[i].setPreferredSize(prefSize);
        }
    }

    public void setFindListener(FindListener fl) {
        this.listener = fl;
    }

    public FindListener getFindListener() {
        return this.listener;
    }

    public static class FindParam {
        public String toSearch;
        public boolean matchCase;
        public boolean backSearch;
        public boolean matchMinusUnderscore;

        public FindParam() {
        }

        public FindParam(String s, boolean mc, boolean bs, boolean mmu) {
            this.toSearch = s;
            this.matchCase = mc;
            this.backSearch = bs;
            this.matchMinusUnderscore = mmu;
        }
    }

    public static interface FindListener {
        public void find(FindParam var1);
    }
}

