/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.io.IOException;
import java.io.Reader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAJParser {
    private String rootName;
    private Attributes dummyAttr = new AttributesImpl();
    private int line = 1;
    private int col;
    private int _lookup = -1;
    private Reader input;
    private DefaultHandler handler;
    private final boolean escapeAnyCharacter;
    private final boolean copyGen;

    public SAJParser() {
        this(false, false);
    }

    public SAJParser(boolean escapeAnyCharacter) {
        this(escapeAnyCharacter, false);
    }

    public SAJParser(boolean escapeAnyCharacter, boolean copyGen) {
        this.escapeAnyCharacter = escapeAnyCharacter;
        this.copyGen = copyGen;
    }

    private void exceptionChar(int c) throws SAXException {
        throw new SAXException("Unxpected character '" + (char)c + "' line=" + this.line + ", col=" + this.col);
    }

    private void ungetChar(char c) {
        if (this._lookup >= 0) {
            throw new RuntimeException("Internal error: lookup > 1!");
        }
        this._lookup = c;
    }

    private char getChar() throws IOException {
        return this.getChar(false);
    }

    private char getChar(boolean keepSpaces) throws IOException {
        int c;
        if (this._lookup >= 0) {
            int c2 = this._lookup;
            this._lookup = -1;
            return (char)c2;
        }
        while ((c = this.input.read()) >= 0) {
            if (c == 10) {
                ++this.line;
                this.col = 1;
                continue;
            }
            ++this.col;
            if (c <= 32 && !keepSpaces) continue;
            return (char)c;
        }
        this.input.close();
        throw new EndOfFileException();
    }

    private MyCharBuffer getNumber(char c) throws IOException, SAXException {
        MyCharBuffer Return2 = new MyCharBuffer();
        if (c == '-' || c >= '0' && c <= '9') {
            Return2.append(c);
            while ((c = this.getChar()) >= '0' && c <= '9') {
                Return2.append(c);
            }
            if (c == '.') {
                Return2.append(c);
                while ((c = this.getChar()) >= '0' && c <= '9') {
                    Return2.append(c);
                }
            }
            if (c == 'e' || c == 'E') {
                Return2.append(c);
                c = this.getChar();
                if (c == '+' || c == '-') {
                    Return2.append(c);
                    c = this.getChar();
                }
                while (c >= '0' && c <= '9') {
                    Return2.append(c);
                    c = this.getChar();
                }
                this.ungetChar(c);
            } else {
                this.ungetChar(c);
            }
        } else {
            this.exceptionChar(c);
        }
        return Return2;
    }

    private MyCharBuffer getString(char c) throws IOException, SAXException {
        MyCharBuffer Return2 = new MyCharBuffer();
        if (c == '\"') {
            try {
                block16: while ((c = this.getChar(true)) != '\"') {
                    if (c == '\\') {
                        c = this.getChar();
                        switch (c) {
                            case '\"': 
                            case '/': 
                            case '\\': {
                                Return2.append(c);
                                continue block16;
                            }
                            case 'b': {
                                Return2.append('\b');
                                continue block16;
                            }
                            case 'f': {
                                Return2.append('\f');
                                continue block16;
                            }
                            case 'n': {
                                Return2.append('\n');
                                continue block16;
                            }
                            case 'r': {
                                Return2.append('\r');
                                continue block16;
                            }
                            case 't': {
                                Return2.append('\t');
                                continue block16;
                            }
                            case 'u': {
                                char chr = '\u0000';
                                block17: for (int i = 0; i < 4; ++i) {
                                    chr = (char)(chr * 16);
                                    c = this.getChar();
                                    switch (c) {
                                        case '0': 
                                        case '1': 
                                        case '2': 
                                        case '3': 
                                        case '4': 
                                        case '5': 
                                        case '6': 
                                        case '7': 
                                        case '8': 
                                        case '9': {
                                            chr = (char)(chr + (c - 48));
                                            continue block17;
                                        }
                                        case 'A': 
                                        case 'B': 
                                        case 'C': 
                                        case 'D': 
                                        case 'E': 
                                        case 'F': {
                                            chr = (char)(chr + (c - 65 + 10));
                                            continue block17;
                                        }
                                        case 'a': 
                                        case 'b': 
                                        case 'c': 
                                        case 'd': 
                                        case 'e': 
                                        case 'f': {
                                            chr = (char)(chr + (c - 97 + 10));
                                            continue block17;
                                        }
                                        default: {
                                            this.exceptionChar(c);
                                        }
                                    }
                                }
                                Return2.append(chr);
                                continue block16;
                            }
                        }
                        if (this.escapeAnyCharacter) {
                            Return2.append(c);
                            continue;
                        }
                        this.exceptionChar(c);
                        continue;
                    }
                    Return2.append(c);
                }
            }
            catch (EndOfFileException _ex) {
                throw new SAXException("Unclosed string");
            }
        } else {
            this.exceptionChar(c);
        }
        return Return2;
    }

    private void characters(char[] ch, int start, int length, ElementType type) throws SAXException {
        if (this.handler instanceof Handler) {
            ((Handler)this.handler).characters(ch, start, length, type);
        } else {
            this.handler.characters(ch, start, length);
        }
    }

    private void getValue(char c) throws IOException, SAXException {
        switch (c) {
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                MyCharBuffer buff = this.getNumber(c);
                this.characters(buff.array(), 0, buff.length(), ElementType.NUMERIC);
                break;
            }
            case '\"': {
                MyCharBuffer buff = this.getString(c);
                this.characters(buff.array(), 0, buff.length(), ElementType.STRING);
                break;
            }
            case '{': {
                this.getObject(c);
                break;
            }
            case 't': {
                c = this.getChar();
                if (c == 'r' && (c = this.getChar()) == 'u' && (c = this.getChar()) == 'e') {
                    this.characters(new char[]{'t', 'r', 'u', 'e'}, 0, 4, ElementType.BOOLEAN);
                    break;
                }
                this.exceptionChar(c);
                break;
            }
            case 'f': {
                c = this.getChar();
                if (c == 'a' && (c = this.getChar()) == 'l' && (c = this.getChar()) == 's' && (c = this.getChar()) == 'e') {
                    this.characters(new char[]{'f', 'a', 'l', 's', 'e'}, 0, 5, ElementType.BOOLEAN);
                    break;
                }
                this.exceptionChar(c);
                break;
            }
            case 'n': {
                c = this.getChar();
                if (c == 'u' && (c = this.getChar()) == 'l' && (c = this.getChar()) == 'l') {
                    this.characters(new char[]{'n', 'u', 'l', 'l'}, 0, 4, ElementType.STRING);
                    break;
                }
                this.exceptionChar(c);
                break;
            }
            default: {
                this.exceptionChar(c);
            }
        }
    }

    private void getArray(String name) throws IOException, SAXException {
        char c;
        do {
            if ((c = this.getChar()) == ']') {
                if (!this.copyGen) break;
                this.handler.startElement("array", name, name, this.dummyAttr);
                this.characters(new char[0], 0, 0, ElementType.STRING);
                this.handler.endElement("", name, name);
                break;
            }
            this.handler.startElement(this.copyGen ? "array" : "", name, name, this.dummyAttr);
            if (c == '[') {
                this.getArray(name);
            } else {
                this.getValue(c);
            }
            this.handler.endElement("", name, name);
        } while ((c = this.getChar()) == ',');
        if (c != ']') {
            this.exceptionChar(c);
        }
    }

    private void getObject(char c) throws IOException, SAXException {
        int count = 0;
        do {
            if ((c = this.getChar()) != '}') {
                ++count;
                String name = this.getString(c).toString();
                c = this.getChar();
                if (c == ':') {
                    c = this.getChar();
                    if (c == '[') {
                        this.getArray(name);
                        continue;
                    }
                    this.handler.startElement("", name, name, this.dummyAttr);
                    this.getValue(c);
                    this.handler.endElement("", name, name);
                    continue;
                }
                this.exceptionChar(c);
                continue;
            }
            this.ungetChar(c);
        } while ((c = this.getChar()) == ',');
        if (c != '}') {
            this.exceptionChar(c);
        }
        if (count == 0) {
            this.characters(new char[0], 0, 0, ElementType.STRING);
        }
    }

    public void parse(Reader in, DefaultHandler dh, String rName) throws IOException, SAXException {
        this.input = in;
        this.rootName = rName;
        this.handler = dh;
        try {
            char c = this.getChar();
            this.handler.startDocument();
            if (this.rootName != null) {
                this.handler.startElement("", this.rootName, this.rootName, this.dummyAttr);
            }
            try {
                switch (c) {
                    case '{': {
                        this.getObject(c);
                        break;
                    }
                    case '[': {
                        this.getArray("");
                        break;
                    }
                    default: {
                        this.exceptionChar(c);
                        break;
                    }
                }
            }
            catch (EndOfFileException endOfFileException) {
                // empty catch block
            }
            if (this.rootName != null) {
                this.handler.endElement("", this.rootName, this.rootName);
            }
            this.handler.endDocument();
        }
        catch (EndOfFileException _ex) {
            throw new SAXException("Void JSON file!");
        }
    }

    static class MyCharBuffer {
        private char[] buffer = new char[8];
        private int len;

        MyCharBuffer() {
        }

        public void append(char c) {
            if (this.len == this.buffer.length) {
                char[] newBuff = new char[this.len << 1];
                System.arraycopy(this.buffer, 0, newBuff, 0, this.len);
                this.buffer = newBuff;
            }
            this.buffer[this.len++] = c;
        }

        public int length() {
            return this.len;
        }

        public char[] array() {
            return this.buffer;
        }

        public String toString() {
            return new String(this.buffer, 0, this.len);
        }
    }

    static class EndOfFileException
    extends IOException {
        EndOfFileException() {
        }
    }

    public static abstract class Handler
    extends DefaultHandler {
        public abstract void characters(char[] var1, int var2, int var3, ElementType var4) throws SAXException;
    }

    public static enum ElementType {
        STRING,
        NUMERIC,
        BOOLEAN;

    }
}

