/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import java.awt.Font;

public class PDFFontMapper
extends DefaultFontMapper {
    private String defaultFont;

    public PDFFontMapper(String defaultFont) {
        this.defaultFont = defaultFont;
    }

    private BaseFont getDefaultFont(String fontName, Font origFont) {
        return super.awtToPdf(new Font(fontName, origFont.getStyle(), origFont.getSize()));
    }

    public BaseFont awtToPdf(Font font) {
        try {
            DefaultFontMapper.BaseFontParameters p = this.getBaseFontParameters(font.getFontName());
            if (p != null) {
                return BaseFont.createFont((String)p.fontName, (String)p.encoding, (boolean)p.embedded, (boolean)p.cached, (byte[])p.ttfAfm, (byte[])p.pfb);
            }
            if (this.defaultFont != null) {
                return this.getDefaultFont(this.defaultFont, font);
            }
            return super.awtToPdf(font);
        }
        catch (ExceptionConverter e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }
}

