/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetBackground
extends PrintCommand {
    private Color color;

    public SetBackground(GuiFactory gf, Color f) {
        super(gf, 17);
        this.color = f;
    }

    public SetBackground(GuiFactory gf, RandomAccessFile inOut) throws IOException {
        super(gf, 3);
        int rgb = inOut.readInt();
        this.color = rgb == 0xFFFFFF ? null : new Color(rgb, true);
    }

    @Override
    void toFile(RandomAccessFile inOut) throws IOException {
        if (this.color == null) {
            inOut.writeInt(0xFFFFFF);
        } else {
            inOut.writeInt(this.color.getRGB());
        }
    }

    @Override
    public boolean testPrint(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        return this.print(pc, g2d, pf);
    }

    @Override
    public boolean print(PrintContext pc, Graphics2D g2d, PageFormat pf) {
        pc.background = this.color;
        return true;
    }
}

