/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolVar;
import com.iscobol.types.FloatingPointConverter;
import com.iscobol.types.MemMan;
import com.iscobol.types.Pic1;

public class Pic1Bit
extends Pic1 {
    private int bitOffset;
    private int currBitOffset;
    private int bitLength;

    public Pic1Bit(byte[] m, int i, int l, int[] dimSize, int[] dim, String n, boolean dComma, int bitOffs, int bitLen) {
        super(m, i, l, dimSize, dim, n, dComma);
        this.bitOffset = bitOffs;
        this.currBitOffset = bitOffs;
        this.bitLength = bitLen;
    }

    public Pic1Bit(CobolVar p, int i, int l, int[] dimSize, int[] dim, String n, boolean dComma, int bitOffs, int bitLen) {
        super(p, i, l, dimSize, dim, n, dComma);
        this.bitOffset = bitOffs;
        this.currBitOffset = bitOffs;
        this.bitLength = bitLen;
    }

    @Override
    public int getBitOffset() {
        return this.currBitOffset;
    }

    @Override
    public int getBitLength() {
        return this.bitLength;
    }

    @Override
    public boolean set(String value) {
        StringBuilder Return2 = new StringBuilder();
        boolean err = this.getBitValue(value, Return2);
        this.setBits(Return2);
        return err;
    }

    private void setBits(StringBuilder bits) {
        byte[] mem = this.getMemory();
        int offs = this.getOffset();
        int bitIdx = this.currBitOffset;
        int i = 0;
        while (i < this.bitLength) {
            if (bitIdx == 8) {
                bitIdx = 0;
                ++offs;
            }
            mem[offs] = bits.charAt(i) == '1' ? (byte)(mem[offs] | SET_BIT[bitIdx]) : (byte)(mem[offs] & UNSET_BIT[bitIdx]);
            ++i;
            ++bitIdx;
        }
    }

    @Override
    public boolean set(boolean value) {
        StringBuilder Return2 = new StringBuilder();
        this.getBitValue(value, Return2);
        this.setBits(Return2);
        return false;
    }

    @Override
    public boolean set(byte value) {
        StringBuilder Return2 = new StringBuilder();
        this.getBitValue(value, Return2);
        this.setBits(Return2);
        return false;
    }

    @Override
    public boolean set(short value) {
        StringBuilder Return2 = new StringBuilder();
        this.getBitValue(value, Return2);
        this.setBits(Return2);
        return false;
    }

    @Override
    public boolean set(int value) {
        StringBuilder Return2 = new StringBuilder();
        this.getBitValue(value, Return2);
        this.setBits(Return2);
        return false;
    }

    @Override
    public boolean set(long value) {
        StringBuilder Return2 = new StringBuilder();
        this.getBitValue(value, Return2);
        this.setBits(Return2);
        return false;
    }

    @Override
    public boolean set(float value) {
        StringBuilder Return2 = new StringBuilder();
        this.getBitValue(FloatingPointConverter.floatToIntBits(value), Return2);
        this.setBits(Return2);
        return false;
    }

    @Override
    public boolean set(double value) {
        StringBuilder Return2 = new StringBuilder();
        this.getBitValue(FloatingPointConverter.doubleToLongBits(value), Return2);
        this.setBits(Return2);
        return false;
    }

    @Override
    public String toString() {
        byte[] mem = this.getMemory();
        int offs = this.getOffset();
        int bitIdx = this.currBitOffset;
        StringBuilder Return2 = new StringBuilder();
        int i = 0;
        while (i < this.bitLength) {
            if (bitIdx == 8) {
                bitIdx = 0;
                ++offs;
            }
            if ((mem[offs] & SET_BIT[bitIdx]) == 0) {
                Return2.append('0');
            } else {
                Return2.append('1');
            }
            ++i;
            ++bitIdx;
        }
        return Return2.toString();
    }

    @Override
    public long tolong() {
        byte[] mem = this.getMemory();
        int offs = this.getOffset();
        int bitIdx = this.currBitOffset;
        long Return2 = 0L;
        int i = BIT_MASK.length - this.bitLength;
        while (i < BIT_MASK.length) {
            if (bitIdx == 8) {
                bitIdx = 0;
                ++offs;
            }
            if ((mem[offs] & SET_BIT[bitIdx]) != 0) {
                Return2 |= BIT_MASK[i];
            }
            ++i;
            ++bitIdx;
        }
        return Return2;
    }

    @Override
    public CobolVar intAt(int[] idxs) {
        Pic1Bit Return2 = (Pic1Bit)super.intAt(idxs);
        Return2.currBitOffset = this.getBitOffsetIncr(idxs);
        return Return2;
    }

    @Override
    public CobolVar intAt(int ix) {
        Pic1Bit Return2 = (Pic1Bit)super.intAt(ix);
        Return2.currBitOffset = this.getBitOffsetIncr(ix - 1, 0);
        return Return2;
    }

    @Override
    protected int getOffsetIncr(int idx, int dimIdx) {
        int d = idx * this.dimensionsSize[dimIdx] - 8 + this.bitOffset;
        if (d < 0) {
            return 0;
        }
        if (d == 0) {
            return 1;
        }
        return d / 8 + 1;
    }

    @Override
    protected int getOffsetIncr(int[] idxs) {
        int d = super.getOffsetIncr(idxs) - 8 + this.bitOffset;
        if (d < 0) {
            return 0;
        }
        if (d == 0) {
            return 1;
        }
        return d / 8 + 1;
    }

    private int getBitOffsetIncr(int idx, int dimIdx) {
        int nBits = idx * this.dimensionsSize[dimIdx];
        int d = nBits - 8 + this.bitOffset;
        if (d < 0) {
            return nBits + this.bitOffset;
        }
        if (d == 0) {
            return 0;
        }
        return d % 8;
    }

    private int getBitOffsetIncr(int[] idxs) {
        int nBits = super.getOffsetIncr(idxs);
        int d = nBits - 8 + this.bitOffset;
        if (d < 0) {
            return nBits + this.bitOffset;
        }
        if (d == 0) {
            return 0;
        }
        return d % 8;
    }

    @Override
    public Pic1Bit subBit(int start) {
        return this.subBit(start, this.getBitLength() - start + 1);
    }

    @Override
    public Pic1Bit subBit(int start, int subLen) {
        Pic1Bit Return2;
        int len = this.getBitLength();
        if (this.checkSubLen(start, subLen, len) <= 0) {
            switch (substringCheck) {
                case 1: {
                    throw new IscobolRuntimeException(1, this.name + "(" + start + ":" + subLen + ") [" + len + "]");
                }
                case -1: {
                    Factory.log("CHECK SUBSTRING: detected index out of bound " + this.name + "(" + start + ":" + subLen + ") [" + len + "]");
                }
            }
        }
        if (start < 1) {
            start = 1;
        }
        if (!substr0lenAll && subLen <= 0) {
            Return2 = new Pic1Bit(new byte[0], 0, 0, null, null, "", false, 0, 0);
        } else {
            int incrOffs;
            int bitOffs;
            if (subLen <= 0) {
                subLen = len - start + 1;
            } else {
                int maxLen = Factory.substrUnbound ? (this.getMemory().length - this.getOffset()) / 2 : len;
                subLen = Math.max(0, Math.min(subLen, maxLen - start + 1));
            }
            int nBits = start - 1;
            int d = nBits - 8 + this.bitOffset;
            if (d < 0) {
                bitOffs = nBits + this.bitOffset;
                incrOffs = 0;
            } else if (d == 0) {
                bitOffs = 0;
                incrOffs = 1;
            } else {
                bitOffs = d % 8;
                incrOffs = d / 8 + 1;
            }
            Return2 = new Pic1Bit(this.getMemory(), this.getOffset() + incrOffs, subLen / 8, null, null, this.name, this.isDecPointComma, bitOffs, subLen);
            if (this.memory.isDynamic()) {
                Return2.memory = new MemMan(this.getMemory());
            }
        }
        return Return2;
    }
}

