/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Factory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;

public class MemoryByteArray
extends Memory {
    private static final long serialVersionUID = 123L;
    private static HandlesManager memBlocks = new HandlesManager(128);
    private byte[] memory;
    private long address;
    private int displ;
    private boolean isAllocated;
    private boolean optimized;

    @Override
    public void init(long addr, int sz, boolean optmzd) {
        this.address = addr;
        this.memory = (byte[])memBlocks.getObject((int)(this.address >>> 32));
        if (this.memory == null) {
            throw new IscobolRuntimeException(133, "Invalid address: " + this.address);
        }
        this.displ = (int)(this.address & 0xFFFFFFFFL);
        this.length = sz;
        this.isAllocated = false;
        this.optimized = optmzd;
    }

    @Override
    public void init(int sz, boolean optmzd) {
        this.memory = new byte[sz];
        this.length = sz;
        this.address = (long)memBlocks.newHandle(this) << 32;
        this.displ = 0;
        this.isAllocated = true;
        this.optimized = optmzd;
    }

    @Override
    public void init(byte[] val, boolean optmzd) {
        this.init(val.length, optmzd);
        System.arraycopy(val, 0, this.memory, 0, this.length);
    }

    @Override
    public long getBaseAddress() {
        return this.address;
    }

    @Override
    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public byte get(int offset) {
        return this.memory[this.displ + offset];
    }

    @Override
    public void put(int offset, byte val) {
        this.memory[this.displ + offset] = val;
    }

    @Override
    public void fill(byte value) {
        for (int i = this.displ + this.length - 1; i >= this.displ; --i) {
            this.memory[i] = value;
        }
    }

    @Override
    public void fill(int offset, int end, byte value) {
        int e = this.displ + end;
        for (int i = this.displ + offset; i < e; ++i) {
            this.memory[i] = value;
        }
    }

    @Override
    public void fill(int offset, int len, byte[] value) {
        Factory.myFill(this.memory, offset, len, value);
    }

    @Override
    public void set(int dstOffset, byte[] src, int srcOffset, int len) {
        int l = this.displ + dstOffset;
        int i = 0;
        while (i < len) {
            this.memory[l] = src[srcOffset];
            ++l;
            ++i;
            ++srcOffset;
        }
    }

    @Override
    public void copy(int srcOffset, Memory dst, int dstOffset, int len) {
        dst.set(dstOffset, this.memory, srcOffset, len);
    }

    @Override
    public void finalize() {
        if (this.isAllocated) {
            memBlocks.removeHandle((int)(this.address >>> 32));
            this.isAllocated = false;
        }
    }

    @Override
    public String toString() {
        return new String(this.toByteArray(0, this.length));
    }

    @Override
    public byte[] toByteArray(int offs, int len) {
        if (this.displ == 0 && len == this.length) {
            return this.memory;
        }
        byte[] Return2 = new byte[len];
        int l = this.displ + offs;
        int i = 0;
        while (i < len) {
            Return2[i] = this.memory[l];
            ++i;
            ++l;
        }
        return Return2;
    }
}

