/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.utility;

import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.XMLStreamConstants;
import com.iscobol.utility.AbstractXml2Wrk;
import com.iscobol.utility.ElementIterator;
import com.iscobol.utility.QName;
import com.iscobol.utility.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WSDL2Wrk
extends AbstractXml2Wrk {
    private static final String SOAP_ENVELOPE_START = " 01 soap-";
    private static final String SOAP_NS_PFX = "soapenv";
    private static final String[] SOAP_ENVELOPE_NS = new String[]{"http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope"};
    public static final int V1_1 = 0;
    public static final int V1_2 = 1;
    public static final String NS_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static final String NS_SOAPENC = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String NS_SOAPHTTP = "http://schemas.xmlsoap.org/soap/http";
    private static final Map<String, String> soapTypes = new HashMap<String, String>();
    private boolean elementFormQualified;
    private final List<Message> messages = new ArrayList<Message>();
    private final List<PortType> portTypes = new ArrayList<PortType>();
    private final List<Binding> bindings = new ArrayList<Binding>();
    private final int version;
    private Set<String> wsdlImports = new HashSet<String>();
    private Map<String, String> nsPrefixes;
    private boolean encoded;
    public static final String usage;

    public WSDL2Wrk(String uri, int v) {
        super(uri);
        this.version = v;
    }

    public Map<String, StringBuilder> generateCopyfiles() throws ParserConfigurationException, IOException, SAXException {
        return this.generateCopyfiles(WSDL2Wrk.openXml(this.uri));
    }

    private static Element openXml(String uri) throws IOException, SAXException, ParserConfigurationException {
        InputStream is;
        DocumentBuilderFactory dbf = RtsUtil.newDocumentBuilderFactory();
        dbf.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbf.newDocumentBuilder();
        try {
            URL url = new URL(uri);
            is = url.openStream();
        }
        catch (MalformedURLException ex) {
            is = new FileInputStream(uri);
        }
        Document doc = dBuilder.parse(is);
        is.close();
        doc.getDocumentElement().normalize();
        return doc.getDocumentElement();
    }

    public int getVersion() {
        return this.version;
    }

    public String getURI() {
        return this.uri;
    }

    private void scanTypesSchema(Element node) throws SAXException {
        if (node.hasChildNodes()) {
            Map nsSave = this.namespaces;
            String tnSave = this.targetNamespace;
            boolean efqSave = this.elementFormQualified;
            this.namespaces = new HashMap(this.namespaces);
            this.targetNamespace = node.getAttribute("targetNamespace");
            this.addNamespaces(node);
            this.elementFormQualified = "qualified".equals(node.getAttribute("elementFormDefault"));
            ElementIterator ei = new ElementIterator(node);
            Element e = ei.next();
            while (e != null) {
                if ("import".equals(e.getLocalName())) {
                    String schemaLocation = e.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                    if (schemaLocation.length() > 0 || (schemaLocation = e.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")).length() > 0) {
                        try {
                            Element rootElem;
                            File fUri;
                            File f = new File(schemaLocation);
                            if (!f.isAbsolute() && (fUri = new File(this.uri)).isFile() && fUri.getParent() != null) {
                                schemaLocation = fUri.getParent() + File.separator + schemaLocation;
                            }
                            if ("schema".equalsIgnoreCase((rootElem = WSDL2Wrk.openXml(schemaLocation)).getLocalName())) {
                                this.scanTypesSchema(rootElem);
                            }
                        }
                        catch (ParserConfigurationException ex) {
                            this.warning(ex.getMessage());
                        }
                        catch (IOException ex) {
                            this.warning(ex.getMessage());
                        }
                    }
                } else if ("element".equals(e.getLocalName())) {
                    this.scanElement(e, false);
                } else if ("complexType".equals(e.getLocalName())) {
                    this.scanComplexType(e, null);
                } else if ("simpleType".equals(e.getLocalName())) {
                    this.scanSimpleType(e, null);
                }
                e = ei.next();
            }
            this.targetNamespace = tnSave;
            this.namespaces = nsSave;
            this.elementFormQualified = efqSave;
        }
    }

    private void scanTypes(Element node) throws SAXException {
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                if (!"schema".equalsIgnoreCase(nName)) continue;
                this.scanTypesSchema(ei);
            }
        }
    }

    private void scanMessage(Element node) throws SAXException {
        String name = node.getAttribute("name");
        if (name == null || name.length() == 0) {
            this.warning("<message> without name: " + WSDL2Wrk.nodeToString(node));
        } else if (!node.hasChildNodes()) {
            this.warning("<message> without part(s): " + WSDL2Wrk.nodeToString(node));
        } else {
            Element ei;
            Message msg = new Message(name);
            this.messages.add(msg);
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                if (!"part".equalsIgnoreCase(ei.getLocalName())) continue;
                Type t0 = this.getType(ei, "type");
                if (t0 == null) {
                    t0 = this.getType(ei, "element");
                }
                if (t0 != null) {
                    if (WSDL2Wrk.isSimpleType(t0.name)) {
                        QName st = t0.name;
                        QName t0Name = new QName();
                        t0Name.name = ei.getAttribute("name");
                        t0 = new Type(t0Name, this.isElementFormQualified());
                        t0.simpleType = st;
                    }
                    msg.addPart(t0);
                    continue;
                }
                this.warning("type undefined: '" + WSDL2Wrk.nodeToString(ei) + "'");
            }
        }
    }

    private QName scanAttribute(Element elmnt, Type par) throws SAXException {
        Element ei;
        ElementIterator ni = new ElementIterator(elmnt);
        QName nsArrayType = null;
        while ((ei = ni.next()) != null) {
            if (!"attribute".equals(ei.getLocalName())) continue;
            QName nsItem = this.getAttribute(ei, "ref");
            if (nsItem != null) {
                if (!"arrayType".equals(nsItem.name) || !NS_SOAPENC.equals(nsItem.ns)) continue;
                nsArrayType = this.getAttribute(ei, "arrayType", NS_WSDL);
                continue;
            }
            QName attrName = this.getAttribute(ei, "name");
            QName attrType = this.getAttribute(ei, "type");
            if (attrName == null || attrType == null) continue;
            par.attrNames.put(attrName.name, attrType);
        }
        if (nsArrayType != null) {
            int offs = 0;
            String name = nsArrayType.name;
            if ((offs = name.indexOf(91, offs)) > 0) {
                int offs2;
                nsArrayType.name = name.substring(0, offs);
                if ((offs2 = name.indexOf(93, ++offs)) > offs) {
                    par.minOccurs = "1";
                    par.maxOccurs = name.substring(offs, offs2);
                } else if (offs2 == offs) {
                    par.minOccurs = "1";
                    par.maxOccurs = "unbounded";
                }
            }
            if (this.targetNamespace.equals(nsArrayType.ns)) {
                return nsArrayType;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(nsArrayType.ns)) {
                if (!XMLStreamConstants.xsdSimpleTypes.containsKey(nsArrayType.name)) {
                    throw new SAXException("Invalid type " + nsArrayType.name);
                }
                return nsArrayType;
            }
            throw new SAXException("Unhandled type " + nsArrayType.ns + ":" + nsArrayType.name);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void scanRestrictionBase(Element element, QName base, Type par) throws SAXException {
        if (NS_SOAPENC.equals(base.ns)) {
            if (soapTypes.get(base.name) == null) {
                throw new SAXException("Invalid type " + base.name);
            }
            if ("Array".equals(base.name)) {
                if (!element.hasChildNodes()) throw new SAXException("void array:" + base.name);
                base = this.scanAttribute(element, par);
                if (base == null) {
                    ElementIterator exti = new ElementIterator(element);
                    Element e3 = exti.next();
                    while (e3 != null) {
                        if ("sequence".equals(e3.getLocalName())) {
                            ElementIterator seqi = new ElementIterator(e3);
                            Element e4 = seqi.next();
                            while (e4 != null) {
                                Type t;
                                if ("element".equals(e4.getLocalName()) && (t = this.scanElement(e4, true)) != null) {
                                    par.minOccurs = t.minOccurs;
                                    par.maxOccurs = t.maxOccurs;
                                    base = t.name;
                                    par.components.put(t.name, t);
                                }
                                e4 = seqi.next();
                            }
                        }
                        e3 = exti.next();
                    }
                }
            } else {
                this.scanComplexType(element, par);
                return;
            }
        }
        super.scanRestrictionBase(element, base, par);
    }

    private Operation scanOperation(Element node) throws SAXException {
        QName nsName = this.getAttribute(node, "name");
        if (nsName == null) {
            throw new SAXException("<operation> without name");
        }
        Operation Return2 = new Operation(nsName.ns, nsName.name);
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                QName nsMsg = this.getAttribute(ei, "message");
                if (nsMsg == null) continue;
                Message msg = WSDL2Wrk.findMessage(this.messages, nsMsg.name);
                Return2.addParams(nName, msg);
            }
        }
        return Return2;
    }

    private void scanPortType(Element node) throws SAXException {
        String name = node.getAttribute("name");
        if (name == null || name.length() == 0) {
            throw new SAXException("<portType> without name");
        }
        PortType pt = new PortType(name);
        this.portTypes.add(pt);
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                if (!"operation".equalsIgnoreCase(nName)) continue;
                pt.addOperation(this.scanOperation(ei));
            }
        }
    }

    private void scanBinding2(Element node, Binding binding) throws SAXException {
        String style = node.getAttribute("style");
        String transport = node.getAttribute("transport");
        if (transport == null || transport.length() == 0) {
            this.warning("Missing 'transport' attribute");
        } else if (!NS_SOAPHTTP.equals(transport)) {
            this.warning("Invalid 'transport' value: " + transport);
        }
        binding.setStyle(style);
        binding.setTransport(transport);
    }

    private void scanBinding(Element node) throws SAXException {
        String name = node.getAttribute("name");
        QName type = this.getAttribute(node, "type");
        Binding binding = new Binding(name, type, this.portTypes);
        this.bindings.add(binding);
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String nName = ei.getLocalName();
                if ("binding".equalsIgnoreCase(nName)) {
                    this.scanBinding2(ei, binding);
                    continue;
                }
                if (!"operation".equalsIgnoreCase(nName)) continue;
                this.scanOperation2(ei, binding.portType, "rpc".equalsIgnoreCase(binding.style));
            }
        }
    }

    private void scanOperation2(Element node, PortType pt, boolean rpcStyle) throws SAXException {
        if (pt != null && node.hasChildNodes()) {
            String name = node.getAttribute("name");
            for (Operation op : pt.operations) {
                Element ei;
                if (!op.name.equals(name)) continue;
                ElementIterator ni = new ElementIterator(node);
                block1: while ((ei = ni.next()) != null) {
                    String nName = ei.getLocalName();
                    for (Operation.Param param : op.params) {
                        Element ei2;
                        if (!param.key.equals(nName)) continue;
                        if (!ei.hasChildNodes()) continue block1;
                        ElementIterator ni2 = new ElementIterator(ei);
                        while ((ei2 = ni2.next()) != null) {
                            QName fn;
                            String nName2 = ei2.getLocalName();
                            if ("body".equals(nName2)) {
                                if (NS_SOAPENC.equals(ei2.getAttribute("encodingStyle")) && "encoded".equals(ei2.getAttribute("use"))) {
                                    param.msg.encoded = true;
                                }
                                if (!rpcStyle) continue;
                                this.setRpcURI(param, ei2);
                                continue;
                            }
                            if (!"header".equals(nName2) || (fn = this.getAttribute(ei2, "message")) == null) continue;
                            param.hdr = WSDL2Wrk.findMessage(this.messages, fn.name);
                            if (param.hdr == null) continue;
                            if (NS_SOAPENC.equals(ei2.getAttribute("encodingStyle")) && "encoded".equals(ei2.getAttribute("use"))) {
                                param.hdr.encoded = true;
                            }
                            param.uri = ei2.getAttribute("namespace");
                            if (!rpcStyle) continue;
                            this.setRpcURI(param, ei2);
                        }
                        continue block1;
                    }
                }
                break block0;
            }
        }
    }

    private void setRpcURI(Operation.Param param, Element ei2) {
        param.uri = ei2.getAttribute("namespace");
    }

    private Map<String, StringBuilder> generateCopyfiles(Element node) throws SAXException, IOException, ParserConfigurationException {
        this.scanRoot(node);
        LinkedHashMap<String, StringBuilder> copyFilesMap = new LinkedHashMap<String, StringBuilder>();
        for (Binding bnd : this.bindings) {
            boolean rpcStyle;
            PortType pt = bnd.portType;
            boolean bl = rpcStyle = bnd.style != null && bnd.style.equals("rpc");
            if (pt == null || !NS_SOAPHTTP.equals(bnd.transport)) continue;
            for (Operation op : pt.operations) {
                StringBuilder sb = new StringBuilder();
                op.getCode(sb, pt.name, rpcStyle);
                if (sb.length() <= 0) continue;
                copyFilesMap.put(op.name, sb);
            }
        }
        return copyFilesMap;
    }

    private void scanRoot(Element node) throws SAXException, IOException, ParserConfigurationException {
        if (node.getNodeType() != 1 || !"definitions".equalsIgnoreCase(node.getLocalName())) {
            throw new SAXException("Invalid root element: expected <definitions> found <" + node.getLocalName() + ">");
        }
        this.targetNamespace = node.getAttribute("targetNamespace");
        this.addNamespaces(node);
        if (node.hasChildNodes()) {
            Element ei;
            ElementIterator ni = new ElementIterator(node);
            while ((ei = ni.next()) != null) {
                String location;
                String nName = ei.getLocalName();
                if ("types".equalsIgnoreCase(nName)) {
                    this.scanTypes(ei);
                    continue;
                }
                if ("message".equalsIgnoreCase(nName)) {
                    this.scanMessage(ei);
                    continue;
                }
                if ("portType".equalsIgnoreCase(nName)) {
                    this.scanPortType(ei);
                    continue;
                }
                if ("binding".equalsIgnoreCase(nName)) {
                    this.scanBinding(ei);
                    continue;
                }
                if (!"import".equalsIgnoreCase(nName) || (location = ei.getAttribute("location")).length() <= 0 || this.wsdlImports.contains(location)) continue;
                this.wsdlImports.add(location);
                this.scanRoot(WSDL2Wrk.openXml(location));
            }
        }
    }

    public void debug() {
        for (Binding bnd : this.bindings) {
            System.out.println(bnd);
        }
        for (PortType pt : this.portTypes) {
            System.out.println(pt);
        }
        for (Message msg : this.messages) {
            System.out.println(msg);
        }
        for (Type t : this.allTypes.values()) {
            System.out.println(t);
        }
    }

    private static Message findMessage(List<Message> all, String name) {
        for (Message m : all) {
            if (!name.equals(m.name)) continue;
            return m;
        }
        return null;
    }

    @Override
    protected String getPrefix() {
        return "";
    }

    @Override
    protected boolean isDisambiguate() {
        return true;
    }

    @Override
    protected boolean mustAddGroupNames() {
        return false;
    }

    @Override
    protected void getCodeAttrs(Type t, int level, StringBuilder sb) {
        if (this.encoded) {
            String typeStr;
            if (t.simpleType != null) {
                typeStr = "xsd:" + t.simpleType.name;
            } else {
                Type t0 = t.refType;
                if (t0 == null) {
                    t0 = t.restriction;
                }
                typeStr = t0 != null ? (t0.name.ns != null ? this.nsPrefixes.get(t0.name.ns) + ":" + t0.name.name : t0.name.name) : null;
            }
            if (typeStr != null) {
                WSDL2Wrk.putLevel(sb, level);
                sb.append(" identified by 'xsi:type' is attribute.");
                sb.append(eol);
                WSDL2Wrk.putLevel(sb, level + 2);
                boolean dyn = "unbounded".equals(t.maxOccurs);
                if (dyn) {
                    sb.append(" " + this.getCobolName("t-" + t.name));
                } else {
                    sb.append(" filler");
                }
                sb.append(" pic x(" + typeStr.length() + ")");
                sb.append(" value '" + typeStr + "'");
                sb.append(".");
                sb.append(eol);
            }
        }
        super.getCodeAttrs(t, level, sb);
    }

    @Override
    protected String buildDataName(String name) {
        return this.getCobolName("a-" + name);
    }

    @Override
    protected String buildCapacityName(String name) {
        return this.getCobolName("a-c-" + name);
    }

    @Override
    protected String buildAttrName(String name) {
        return this.getCobolName("attr-" + name);
    }

    @Override
    protected void getQualifiedName(Type t, boolean isRoot, String parentNs, StringBuilder sb) {
        String pfx;
        sb.append("'");
        if ((isRoot || t.elemFormQual) && t.name.ns != null && (pfx = this.nsPrefixes.get(t.name.ns)) != null) {
            sb.append(pfx);
            sb.append(":");
        }
        sb.append(t.name.name);
        sb.append("'");
    }

    @Override
    protected boolean isElementFormQualified() {
        return this.elementFormQualified;
    }

    private void addNsPrefixes(Type t, Set<Type> set) {
        if (set.contains(t)) {
            return;
        }
        set.add(t);
        if (t.name.ns != null) {
            this.addNSPrefix(t.name.ns);
        }
        if (t.refType != null) {
            t = t.refType;
        } else if (t.restriction != null) {
            t = t.restriction;
        }
        if (t.extension != null || !t.components.isEmpty()) {
            Type ext = t.extension;
            if (ext != null) {
                this.addNsPrefixesExt(ext, set);
            }
            for (Type c : t.components.values()) {
                this.addNsPrefixes(c, set);
            }
        }
    }

    private void addNSPrefix(String ns) {
        String pfx = this.nsPrefixes.get(ns);
        if (pfx == null) {
            pfx = "ns" + this.nsPrefixes.size();
            this.nsPrefixes.put(ns, pfx);
        }
    }

    private void addNsPrefixesExt(Type ext, Set<Type> set) {
        if (ext.extension != null) {
            this.addNsPrefixesExt(ext.extension, set);
        }
        if (ext.refType != null) {
            ext = ext.refType;
        }
        for (Type c : ext.components.values()) {
            this.addNsPrefixes(c, set);
        }
    }

    public static void main(String[] argv) throws Exception {
        String outBaseName;
        if (argv.length == 1 && "-v".equals(argv[0])) {
            String version = RuntimeProperties.getFullVersionNumber();
            if (version.startsWith("isCOBOL")) {
                version = "isCOBOL-WSDL2Wrk" + version.substring(7);
            }
            System.out.println(version);
            System.exit(0);
        }
        if (argv.length == 0) {
            WSDL2Wrk.usage();
        }
        String uri = argv[0];
        String outputFile = null;
        int wsdlV11 = 1;
        StringBuilder hs = new StringBuilder();
        hs.append("WSDL2Wrk options:");
        try {
            for (int i = 1; i < argv.length; ++i) {
                if ("-o".equals(argv[i])) {
                    hs.append(" ").append(argv[i]);
                    outputFile = argv[++i];
                    hs.append(" ").append(argv[i]);
                    continue;
                }
                if (!"-v1.1".equals(argv[i])) continue;
                wsdlV11 = 0;
                hs.append(" ").append(argv[i]);
            }
        }
        catch (Exception ex) {
            WSDL2Wrk.usage();
        }
        String[] resultContents = null;
        String[] resultSuffix = null;
        WSDL2Wrk wsdl2wrk = new WSDL2Wrk(uri, wsdlV11);
        wsdl2wrk.setHeaderString(hs.toString());
        Map<String, StringBuilder> map = wsdl2wrk.generateCopyfiles();
        resultContents = new String[map.size()];
        resultSuffix = new String[map.size()];
        int i = 0;
        for (String str : map.keySet()) {
            resultContents[i] = map.get(str).toString();
            resultSuffix[i] = "-" + str;
            ++i;
        }
        if (outputFile != null) {
            outBaseName = outputFile;
        } else {
            try {
                URL url = new URL(uri);
                outBaseName = new File(url.getPath()).getName();
            }
            catch (MalformedURLException ex) {
                outBaseName = uri;
            }
        }
        String outExt = ".wrk";
        int idx = outBaseName.lastIndexOf(46);
        if (idx >= 0) {
            if (outputFile != null) {
                outExt = outBaseName.substring(idx);
            }
            outBaseName = outBaseName.substring(0, idx);
        }
        for (i = 0; i < resultContents.length; ++i) {
            String out = outBaseName + resultSuffix[i] + outExt;
            PrintWriter pw = new PrintWriter(new FileOutputStream(out));
            pw.println(resultContents[i]);
            pw.close();
            System.out.println("Generated '" + out + "'.");
        }
    }

    private static void usage() {
        System.err.println(usage);
        System.exit(1);
    }

    static {
        soapTypes.put("string", "S");
        soapTypes.put("Array", "S");
        usage = "java " + WSDL2Wrk.class.getName() + " uri [-o outputfile] [-v1.1]\n-v print version number";
    }

    class Binding {
        private final String name;
        private final QName type;
        private final PortType portType;
        private String style;
        private String transport;

        Binding(String n, QName fn, List<PortType> ptl) throws SAXException {
            this.name = n;
            this.type = fn;
            int size = ptl.size();
            PortType pt = null;
            for (int i = 0; i < size && !(pt = ptl.get(i)).name.equals(this.type.name); ++i) {
                pt = null;
            }
            this.portType = pt;
            if (this.portType == null) {
                throw new SAXException("<binding>:portType " + this.type.name + " not found");
            }
        }

        void setStyle(String s) {
            this.style = s;
        }

        void setTransport(String t) {
            this.transport = t;
        }

        public String toString() {
            return "binding=" + this.name + ",style=" + this.style + ",transport=" + this.transport + ":" + this.portType;
        }
    }

    class PortType {
        private final String name;
        private final List<Operation> operations = new ArrayList<Operation>();

        PortType(String n) {
            this.name = n;
        }

        void addOperation(Operation m) {
            this.operations.add(m);
        }

        public String toString() {
            StringBuilder Return2 = new StringBuilder("PortType:");
            Return2.append(this.name);
            Return2.append('\n');
            for (Operation op : this.operations) {
                Return2.append(op);
            }
            return Return2.toString();
        }
    }

    class Operation {
        private final String uri;
        private final String name;
        private final List<Param> params = new ArrayList<Param>();

        Operation(String u, String n) {
            this.uri = u;
            this.name = n;
        }

        void addParams(String t, Message m) {
            this.params.add(new Param(t, m));
        }

        public void getCode(StringBuilder code, String portTypeName, boolean rpcStyle) {
            code.append("       >>SOURCE FORMAT FREE");
            code.append(AbstractXml2Wrk.eol);
            if (WSDL2Wrk.this.headerString != null) {
                code.append(RtsUtil.getCopyHeader("WSDL", WSDL2Wrk.this.uri, WSDL2Wrk.this.headerString));
            }
            code.append("*> binding name=");
            code.append(this.name);
            code.append(", style=");
            code.append(rpcStyle ? "rpc" : "document");
            code.append(AbstractXml2Wrk.eol);
            for (Param p : this.params) {
                WSDL2Wrk.this.nsPrefixes = new LinkedHashMap();
                int level = 5;
                boolean output = p.key.equals("output");
                code.append(WSDL2Wrk.SOAP_ENVELOPE_START);
                if (output) {
                    code.append("out-");
                } else {
                    code.append("in-");
                }
                if (this.uri != null) {
                    WSDL2Wrk.this.addNSPrefix(this.uri);
                }
                if (rpcStyle && p.uri != null) {
                    WSDL2Wrk.this.addNSPrefix(p.uri);
                }
                code.append(this.name);
                code.append(" identified by 'soapenv:Envelope'." + AbstractXml2Wrk.eol);
                AbstractXml2Wrk.putLevel(code, 3);
                code.append(" identified by 'xmlns:soapenv' is attribute." + AbstractXml2Wrk.eol);
                AbstractXml2Wrk.putLevel(code, 5);
                code.append(" filler pic x(" + SOAP_ENVELOPE_NS[WSDL2Wrk.this.version].length() + ") value '" + SOAP_ENVELOPE_NS[WSDL2Wrk.this.version] + "'." + AbstractXml2Wrk.eol);
                if (p.msg.encoded) {
                    AbstractXml2Wrk.putLevel(code, 3);
                    code.append(" identified by 'xmlns:xsd' is attribute.");
                    code.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(code, 5);
                    code.append(" filler pic x(" + "http://www.w3.org/2001/XMLSchema".length() + ")");
                    code.append(" value \"");
                    code.append("http://www.w3.org/2001/XMLSchema");
                    code.append("\".");
                    code.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(code, 3);
                    code.append(" identified by 'xmlns:xsi' is attribute.");
                    code.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(code, 5);
                    code.append(" filler pic x(" + "http://www.w3.org/2001/XMLSchema-instance".length() + ")");
                    code.append(" value \"");
                    code.append("http://www.w3.org/2001/XMLSchema-instance");
                    code.append("\".");
                    code.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(code, 3);
                    code.append(" identified by 'xmlns:soapenc' is attribute.");
                    code.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(code, 5);
                    code.append(" filler pic x(" + WSDL2Wrk.NS_SOAPENC.length() + ")");
                    code.append(" value \"");
                    code.append(WSDL2Wrk.NS_SOAPENC);
                    code.append("\".");
                    code.append(AbstractXml2Wrk.eol);
                }
                HashSet set = new HashSet();
                if (p.hdr != null) {
                    for (Type t : p.hdr.parts) {
                        WSDL2Wrk.this.addNsPrefixes(t, set);
                    }
                }
                for (Type t : p.msg.parts) {
                    WSDL2Wrk.this.addNsPrefixes(t, set);
                }
                for (String ns : WSDL2Wrk.this.nsPrefixes.keySet()) {
                    String pfx = (String)WSDL2Wrk.this.nsPrefixes.get(ns);
                    AbstractXml2Wrk.putLevel(code, 3);
                    code.append(" identified by 'xmlns:" + pfx + "' is attribute." + AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(code, 5);
                    code.append(" filler pic x(" + ns.length() + ") value '" + ns + "'." + AbstractXml2Wrk.eol);
                }
                if (p.hdr != null) {
                    AbstractXml2Wrk.putLevel(code, 3);
                    code.append(" identified by 'soapenv:Header'." + AbstractXml2Wrk.eol);
                    p.hdr.getCode(code, level, this.uri, output);
                }
                AbstractXml2Wrk.putLevel(code, 3);
                code.append(" identified by 'soapenv:Body'." + AbstractXml2Wrk.eol);
                if (rpcStyle) {
                    AbstractXml2Wrk.putLevel(code, 5);
                    code.append(" identified by '");
                    if (p.uri != null) {
                        code.append((String)WSDL2Wrk.this.nsPrefixes.get(p.uri));
                        code.append(":");
                    }
                    code.append(this.name);
                    if (output) {
                        code.append("Response");
                    }
                    code.append("'.");
                    code.append(AbstractXml2Wrk.eol);
                    if (p.msg.encoded) {
                        this.putEncodingStyle(code, 7);
                    }
                    level += 2;
                }
                p.msg.getCode(code, level, this.uri, output);
                code.append(AbstractXml2Wrk.eol);
            }
            code.append("       >>SOURCE FORMAT PREVIOUS" + AbstractXml2Wrk.eol);
        }

        private void putEncodingStyle(StringBuilder code, int level) {
            AbstractXml2Wrk.putLevel(code, level);
            code.append(" identified by 'soapenv:encodingStyle' is attribute.");
            code.append(AbstractXml2Wrk.eol);
            AbstractXml2Wrk.putLevel(code, level + 2);
            code.append(" filler pic x(" + WSDL2Wrk.NS_SOAPENC.length() + ") value '" + WSDL2Wrk.NS_SOAPENC + "'.");
            code.append(AbstractXml2Wrk.eol);
        }

        public String toString() {
            StringBuilder Return2 = new StringBuilder("Operation:");
            Return2.append(this.name);
            Return2.append('\n');
            if (this.params != null) {
                for (Param p : this.params) {
                    Return2.append("<");
                    Return2.append(p.key);
                    Return2.append(">\n");
                    Return2.append(p.msg);
                }
            }
            return Return2.toString();
        }

        class Param {
            private final String key;
            private final Message msg;
            private Message hdr;
            private String uri;

            private Param(String n, Message m) {
                this.key = n;
                this.msg = m;
            }
        }
    }

    class Message {
        private final String name;
        private boolean encoded;
        private final List<Type> parts = new ArrayList<Type>();

        Message(String n) {
            this.name = n;
        }

        void addPart(Type p) {
            this.parts.add(p);
        }

        public void getCode(StringBuilder code, int level, String uri, boolean output) {
            WSDL2Wrk.this.allCobolNames = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            WSDL2Wrk.this.encoded = this.encoded;
            for (Type t : this.parts) {
                WSDL2Wrk.this.getCode(t, level, null, code, new Vector<Type>());
            }
        }

        public String toString() {
            StringBuilder Return2 = new StringBuilder("msg:");
            Return2.append(this.name);
            for (int i = 0; i < this.parts.size(); ++i) {
                Return2.append("\n");
                Return2.append(this.parts.get(i));
            }
            return Return2.toString();
        }
    }
}

