/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.ast;

import com.veryant.cobol.compiler.Code;
import com.veryant.cobol.compiler.Collector;
import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.EntryPoint;
import com.veryant.cobol.compiler.Procedure;
import com.veryant.cobol.compiler.ast.AstNode;
import com.veryant.cobol.compiler.ast.AstParagraphLabel;
import com.veryant.cobol.compiler.ast.AstSection;
import com.veryant.cobol.compiler.frontend.Token;
import com.veryant.cobol.compiler.stmts.CodeBlock;

public class AstParagraph
extends AstNode {
    private Procedure procedure;

    public AstParagraph(Collector collector) {
        super(collector, Token.NULL);
    }

    public boolean insideDeclaratives() {
        return ((AstSection)this.getParent()).insideDeclaratives();
    }

    @Override
    public void validate() {
        AstParagraphLabel astParagraphLabel = this.getUniqueChild(AstParagraphLabel.class);
        if (astParagraphLabel != null) {
            this.procedure = this.getCode().createProcedure(new CodeBlock(astParagraphLabel.getToken()));
            astParagraphLabel.getLabel().setIndex(this.procedure.getIndex());
        } else {
            this.procedure = this.getCode().createProcedure(new CodeBlock());
        }
    }

    @Override
    public void walk() {
        Code code;
        if (!this.insideDeclaratives() && (code = this.getCode()).getEntryPointsCount() == 0) {
            EntryPoint entryPoint = new EntryPoint(this.procedure.getIndex(), this.getCollector().getModuleName(), this.getCollector().getDefaultArguments());
            code.addEntryPoint(entryPoint);
            if (!Context.registerEntryPoint(entryPoint)) {
                this.consoleWrite(82, Token.NULL, entryPoint.getName());
            }
        }
        this.getCode().switchToProcedure(this.procedure.getIndex());
        super.walk();
        if (this.procedure.getCode().getUnreachableStatements() > 0) {
            this.consoleWrite(79, this.procedure.getCode().getLastStatement(), new Object[0]);
        }
    }

    @Override
    public String toString() {
        return "paragraph";
    }
}

