/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler.directives;

import com.veryant.cobol.compiler.Directives;
import com.veryant.cobol.compiler.directives.BaseDirective;
import com.veryant.cobol.exceptions.InvalidDirectiveException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DEFINE
extends BaseDirective {
    private static final Pattern variableName = Pattern.compile("^[^ (\"]+");
    public static final String NAME = "DEFINE";
    private HashMap<String, Object> defines;

    @Override
    protected void initialize() {
        this.defines = new HashMap();
    }

    @Override
    protected String parseTokensImpl(String string) throws InvalidDirectiveException {
        Matcher matcher = variableName.matcher(string);
        if (matcher.find()) {
            this.tokens.add(string.substring(matcher.start(), matcher.end()));
            string = string.substring(matcher.end()).trim();
        }
        return super.parseTokensImpl(string);
    }

    @Override
    public void setValues() throws InvalidDirectiveException {
        if (this.getTokenCount() == 0) {
            throw Directives.invalidDirectiveException("Directive %s: You must specify a name for this variable.", NAME);
        }
        String string = ((String)this.tokens.get(0)).toUpperCase();
        if (string.startsWith("\"") || string.startsWith("(")) {
            throw Directives.invalidDirectiveException("Directive %s: Invalid variable name '%s'.", NAME, string);
        }
        switch (this.getTokenCount()) {
            case 1: {
                this.addVariable(string, null);
                break;
            }
            case 2: {
                String string2 = (String)this.tokens.get(1);
                if (string2.startsWith("\"")) {
                    this.addVariable(string, this.getTokenValue(1));
                    break;
                }
                if (string2.startsWith("(")) {
                    if (this.getTokenValue(1).equalsIgnoreCase("true")) {
                        this.addVariable(string, true);
                        break;
                    }
                    if (this.getTokenValue(1).equalsIgnoreCase("false")) {
                        this.addVariable(string, false);
                        break;
                    }
                    this.addVariable(string, this.getTokenIntegerValue(1));
                    break;
                }
                throw Directives.invalidDirectiveException("Directive %s: Invalid variable value '%s'.", NAME, string2);
            }
            default: {
                throw Directives.invalidDirectiveException("Directive %s: Only one value is allowed.", NAME);
            }
        }
    }

    public void addVariable(String string, Object object) {
        this.defines.put(string, object);
    }

    public void merge(DEFINE dEFINE) {
        this.defines.putAll(dEFINE.getDefines());
    }

    @Override
    public boolean hasParameters() {
        return true;
    }

    @Override
    public boolean isNoAllowed() {
        return false;
    }

    @Override
    public BaseDirective.Set getSet() {
        return BaseDirective.Set.Any;
    }

    public HashMap<String, Object> getDefines() {
        return this.defines;
    }

    public DEFINE(boolean bl) {
        super(bl, null, null);
    }

    @Override
    public int getIndex() {
        return 84;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

