/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.data;

import com.veryant.cobol.data.IMemory;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class NativeMemory
implements IMemory {
    private static Unsafe unsafe;
    private final long baseAddress;
    private final int size;

    @Override
    public long getBaseAddress() {
        return this.baseAddress;
    }

    @Override
    public long getAddress(int n) {
        return this.getBaseAddress() + (long)n;
    }

    @Override
    public void free() {
        unsafe.freeMemory(this.baseAddress);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public byte get(int n) {
        return unsafe.getByte(this.getAddress(n));
    }

    @Override
    public void put(int n, byte by) {
        unsafe.putByte(this.getAddress(n), by);
    }

    @Override
    public void or(int n, byte by) {
        long l = this.getAddress(n);
        unsafe.putByte(l, (byte)(unsafe.getByte(l) | by));
    }

    @Override
    public void and(int n, byte by) {
        long l = this.getAddress(n);
        unsafe.putByte(l, (byte)(unsafe.getByte(l) & by));
    }

    @Override
    public void xor(int n, byte by) {
        long l = this.getAddress(n);
        unsafe.putByte(l, (byte)(unsafe.getByte(l) ^ by));
    }

    @Override
    public void copy(IMemory iMemory, int n, int n2, int n3) {
        while (n3-- > 0) {
            this.put(n2++, iMemory.get(n++));
        }
    }

    @Override
    public void copy(byte[] byArray, int n, int n2, int n3) {
        while (n3-- > 0) {
            this.put(n2++, byArray[n++]);
        }
    }

    @Override
    public byte[] toArray() {
        return this.toArray(0, this.size);
    }

    @Override
    public byte[] toArray(int n, int n2) {
        return this.toArrayWithTrailingBytes(n, n2, 0);
    }

    @Override
    public byte[] toArrayWithTrailingBytes(int n, int n2, int n3) {
        byte[] byArray = new byte[n2 + n3];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = this.get(n++);
        }
        return byArray;
    }

    @Override
    public byte[] toArrayWithLeadingBytes(int n, int n2, int n3) {
        byte[] byArray = new byte[n2 + n3];
        n2 += n3;
        for (int i = n3; i < n2; ++i) {
            byArray[i] = this.get(n++);
        }
        return byArray;
    }

    public NativeMemory(int n) {
        this.size = n;
        this.baseAddress = unsafe.allocateMemory(n);
    }

    protected void finalize() throws Throwable {
        this.free();
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

