/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.vision4j.file;

import com.veryant.vision4j.file.Config;
import com.veryant.vision4j.file.File;
import com.veryant.vision4j.file.FileInfoHelper;
import com.veryant.vision4j.file.FileSystemCache;
import com.veryant.vision4j.file.FileTable;
import com.veryant.vision4j.file.Offset;
import com.veryant.vision4j.file.SegmentInfoHelper;
import com.veryant.vision4j.file.TransactionLog;
import com.veryant.vision4j.file.Vision;
import com.veryant.vision4j.file.internals.Block;
import com.veryant.vision4j.file.internals.BlockType;
import com.veryant.vision4j.file.internals.CacheDataType;
import com.veryant.vision4j.file.internals.FileAddress;
import com.veryant.vision4j.file.internals.FileDescriptor;
import com.veryant.vision4j.file.internals.KeyInfo;
import com.veryant.vision4j.file.internals.Lock;
import com.veryant.vision4j.file.internals.LogicalAttributes;
import com.veryant.vision4j.file.internals.PhysicalAttributes;
import com.veryant.vision4j.file.internals.PointerState;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class VisionFactory
extends Vision {
    private static final int INVALID_FILE_ID = 0;

    public VisionFactory(Config config, FileTable fileTable) {
        super(config, fileTable);
    }

    public int getErrno() {
        return this.status.getErrno();
    }

    public int getIntErrno() {
        return this.status.getIntErrno();
    }

    public int open(String fileName, int openMode) {
        int id;
        this.status.setErrno(0);
        File visionFile = this.openFile(fileName, openMode, false);
        if (visionFile == null) {
            return 0;
        }
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        visionFile.setPointerState(PointerState.AT_START);
        visionFile.setCurrentKeyNum(0);
        visionFile.getCurrentRecord().invalidate();
        int version = visionFile.getVersion();
        boolean inputOnly = this.isInputOnly(visionFile.getOpenMode());
        if (!inputOnly || this.config.V_OPEN_STRICT.isOn()) {
            boolean broken = false;
            if (version == 3) {
                broken = !fileSystemCache.checkSize(this.retrieveSegment(visionFile, BlockType.DATA, 0), visionFile.getFileSize().getOffset());
            } else {
                int i;
                int limit = visionFile.getSegmentCount();
                for (i = 0; !broken && i < limit; ++i) {
                    broken = !fileSystemCache.checkSize(this.retrieveSegment(visionFile, BlockType.DATA, i), visionFile.getSegmentSize(i));
                }
                limit = visionFile.getIndexFile().getSegmentCount();
                for (i = 0; !broken && i < limit; ++i) {
                    broken = !fileSystemCache.checkSize(this.retrieveSegment(visionFile, BlockType.NODE, i), visionFile.getIndexFile().getSegmentSize(i));
                }
            }
            if (broken) {
                this.closeAdditionalSegments(visionFile);
                this.unlockHeader(visionFile, false);
                this.closeFile(visionFile);
                this.status.setErrno(6);
                this.status.setIntErrno(1);
                return 0;
            }
            boolean invalid = false;
            if (visionFile.getNextRec().gt(visionFile.getFileSize())) {
                invalid = true;
            } else if (visionFile.getNextRec().gtZero()) {
                int checkAmount = version > 4 ? 4 : 2;
                Block bytes = new Block(checkAmount);
                FileAddress endAddr = visionFile.getNextRec().copy();
                endAddr.incOffset(checkAmount);
                if ((version == 4 || version == 5) && endAddr.getOffset() > visionFile.getMaxSegmentSize()) {
                    endAddr.incSegment();
                    endAddr.setOffset(512 + checkAmount);
                }
                if (endAddr.lt(visionFile.getFileSize())) {
                    FileDescriptor segment = this.retrieveSegment(visionFile, BlockType.DATA, endAddr.getSegment());
                    fileSystemCache.seek(segment, endAddr.getOffset() - (long)(--checkAmount));
                    if (fileSystemCache.read(segment, bytes, 1, checkAmount, CacheDataType.RECORD) == checkAmount) {
                        for (int i = 1; i <= checkAmount; ++i) {
                            if (bytes.get8(i) == 0) continue;
                            invalid = true;
                            break;
                        }
                    } else {
                        invalid = true;
                    }
                }
            }
            if (invalid && this.config.V_FORCE_OPEN.isOff()) {
                this.closeAdditionalSegments(visionFile);
                this.unlockHeader(visionFile, false);
                this.closeFile(visionFile);
                this.status.setErrno(6);
                this.status.setIntErrno(2);
                return 0;
            }
        }
        if (!inputOnly) {
            visionFile.getHeaderCache().put16(Offset.OPEN_CNT.get(visionFile.getVersion()), (short)visionFile.incOpenCounter());
            this.saveHeader(visionFile, true);
        }
        if ((id = this.fileTable.add(visionFile, this.config.V_INTERNAL_LOCKS.isOn())) > 0) {
            this.unlockHeader(visionFile, false);
            return visionFile.getId();
        }
        this.closeAdditionalSegments(visionFile);
        this.unlockHeader(visionFile, false);
        this.closeFile(visionFile);
        this.status.setErrno(id == 0 ? 3 : 11);
        return 0;
    }

    public boolean close(int fileId, TransactionLog transactionLog) {
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return false;
        }
        this.status.setErrno(0);
        boolean inputOnly = this.isInputOnly(visionFile.getOpenMode());
        if (this.useTransactionLog(visionFile, transactionLog) && visionFile.isPendingTransaction()) {
            transactionLog.postponedClose(fileId);
            return true;
        }
        if (!this.unlock(visionFile)) {
            return false;
        }
        boolean forceOpen = this.config.V_FORCE_OPEN.isOn();
        if (!forceOpen) {
            this.config.V_FORCE_OPEN.set(true);
        }
        boolean success = this.lockHeader(visionFile, true, !inputOnly, false);
        this.config.V_FORCE_OPEN.set(forceOpen);
        if (!success) {
            return false;
        }
        if (!this.closeAdditionalSegments(visionFile)) {
            success = false;
        }
        if (!inputOnly) {
            visionFile.getHeaderCache().put16(Offset.OPEN_CNT.get(visionFile.getVersion()), (short)visionFile.decOpenCounter());
            this.saveHeader(visionFile, false);
        }
        this.unlockHeader(visionFile, false);
        if (!this.closeFile(visionFile)) {
            success = false;
        }
        this.fileTable.remove(visionFile);
        return success;
    }

    public boolean remove(String fileName) {
        int fileId = this.open(fileName, 0);
        if (fileId == 0) {
            return false;
        }
        File visionFile = this.fileTable.get(fileId);
        int version = visionFile.getVersion();
        int numDataSegments = visionFile.getSegmentCount();
        int numIndexSegments = 0;
        if (version > 3) {
            numIndexSegments = visionFile.getIndexFile().getSegmentCount();
        }
        this.close(fileId, null);
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        boolean success = fileSystemCache.remove(this.getDataSegmentName(fileName, 0));
        if (version > 3) {
            int i;
            for (i = 1; success && i < numDataSegments; ++i) {
                success = fileSystemCache.remove(this.getDataSegmentName(fileName, i));
            }
            for (i = 0; success && i < numIndexSegments; ++i) {
                success = fileSystemCache.remove(this.getIndexSegmentName(fileName, i));
            }
        }
        return success;
    }

    public byte[] info(int fileId, int mode, byte[] arg) {
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return null;
        }
        this.status.setErrno(0);
        LogicalAttributes logicalAttributes = visionFile.getLogicalAttributes();
        PhysicalAttributes physicalAttributes = visionFile.getPhysicalAttributes();
        switch (mode) {
            case -1: {
                return String.format("%010d,%010d,%03d", logicalAttributes.getMaxRecordSize(), logicalAttributes.getMinRecordSize(), logicalAttributes.getNumKeys()).getBytes(StandardCharsets.US_ASCII);
            }
            case -2: {
                return String.format("%02d,%05d,%02d,%03d,%1d", physicalAttributes.getBlockingFactor(), 0, physicalAttributes.getExtensionFactor(), logicalAttributes.getCompressFactor(), 0).getBytes(StandardCharsets.US_ASCII);
            }
            case -3: {
                return Arrays.copyOfRange(visionFile.getHeaderCache().getBytes(), Offset.COMMENT.get(visionFile.getVersion()), 30);
            }
            case -4: {
                return String.format("%010d", visionFile.getTotalRecords()).getBytes(StandardCharsets.US_ASCII);
            }
            case -5: {
                if (visionFile.hasCollate()) {
                    return visionFile.copyOfCollate();
                }
                return null;
            }
            case -6: {
                int numLocks;
                Lock[] lock = visionFile.getLocks();
                for (numLocks = 0; numLocks < lock.length && lock[numLocks] != null; ++numLocks) {
                }
                return String.format("%04d", numLocks).getBytes(StandardCharsets.US_ASCII);
            }
            case -7: {
                if (visionFile.getVersion() > 3) {
                    return String.format("%05d,%05d", visionFile.getSegmentCount(), visionFile.getIndexFile().getSegmentCount()).getBytes(StandardCharsets.US_ASCII);
                }
                return "00000,00000".getBytes(StandardCharsets.US_ASCII);
            }
            case -8: {
                SegmentInfoHelper segmentInfo = new SegmentInfoHelper(arg);
                if (visionFile.getVersion() == 3) {
                    segmentInfo.setSegmentName(visionFile.getName());
                    segmentInfo.setSegmentSize(visionFile.getFileSize().getOffset());
                } else {
                    int segmentNum = segmentInfo.getSegmentNumber();
                    boolean isDataSegment = segmentInfo.isDataSegment();
                    if (!isDataSegment && !segmentInfo.isIndexSegment()) {
                        return null;
                    }
                    if (segmentNum < 1 || isDataSegment ? segmentNum > visionFile.getSegmentCount() : segmentNum > visionFile.getIndexFile().getSegmentCount()) {
                        return null;
                    }
                    segmentInfo.setSegmentName(isDataSegment ? this.getDataSegmentName(visionFile.getName(), segmentNum - 1) : this.getIndexSegmentName(visionFile.getName(), segmentNum - 1));
                    segmentInfo.setSegmentSize(isDataSegment ? visionFile.getSegmentSize(segmentNum - 1) : visionFile.getIndexFile().getSegmentSize(segmentNum - 1));
                }
                return arg;
            }
            case -9: {
                if (visionFile.getVersion() > 3) {
                    int i;
                    long totalSize = 0L;
                    for (i = 0; i < visionFile.getSegmentCount(); ++i) {
                        totalSize += visionFile.getSegmentSize(i);
                    }
                    for (i = 0; i < visionFile.getIndexFile().getSegmentCount(); ++i) {
                        totalSize += visionFile.getIndexFile().getSegmentSize(i);
                    }
                    return String.format("%015d", totalSize).getBytes(StandardCharsets.US_ASCII);
                }
                return String.format("%015d", visionFile.getFileSize().getOffset()).getBytes(StandardCharsets.US_ASCII);
            }
            case -10: {
                return String.format("%03d", visionFile.getVersion()).getBytes(StandardCharsets.US_ASCII);
            }
            case -11: {
                if (visionFile.getVersion() < 5) {
                    return String.format("%010d", visionFile.getDeletedRecords()).getBytes(StandardCharsets.US_ASCII);
                }
                return String.format("%010d", visionFile.getDeletedRecords() + visionFile.getAbandonedRecords()).getBytes(StandardCharsets.US_ASCII);
            }
        }
        if (mode >= visionFile.getLogicalAttributes().getNumKeys() || mode < 0) {
            this.status.setErrno(2);
            return null;
        }
        KeyInfo keyInfo = visionFile.getLogicalAttributes().getKey(mode);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%02d,%1d", keyInfo.getSegments(), keyInfo.isDuplicate() ? 1 : 0));
        for (int i = 0; i < keyInfo.getSegments(); ++i) {
            sb.append(String.format(",%03d,%010d", keyInfo.getSize(i), keyInfo.getOffset(i)));
        }
        return sb.toString().getBytes(StandardCharsets.US_ASCII);
    }

    private void storeKeyInfo(int version, Block block, int offset, KeyInfo keyInfo) {
        int keyOffset = Offset.KOFF.get(version);
        int keySize = Offset.KSIZE.get(version);
        int segMult = Offset.SEG_MULT.get(version);
        int segments = keyInfo.getSegments();
        block.put8(offset + Offset.NPARTS.get(version), (byte)segments);
        block.put8(offset + Offset.KDUP.get(version), (byte)(keyInfo.isDuplicate() ? 1 : 0));
        block.put8(offset + Offset.TOTALSIZE.get(version), (byte)keyInfo.getTotalSize());
        for (int i = 0; i < segments; ++i) {
            int segOffset = offset + i * segMult;
            block.put8(segOffset + keySize, (byte)keyInfo.getSize(i));
            if (version < 5) {
                block.put16(segOffset + keyOffset, (short)keyInfo.getOffset(i));
                continue;
            }
            block.put32(segOffset + keyOffset, keyInfo.getOffset(i));
        }
    }

    private KeyInfo retrieveKeyInfo(int version, Block block) {
        int segments = block.get8(Offset.NPARTS.get(version)) & 0xFF;
        if (segments < 1 || version == 3 && segments > 6 || segments > 16) {
            return null;
        }
        int segMult = Offset.SEG_MULT.get(version);
        int[] offsets = new int[segments];
        int[] sizes = new int[segments];
        for (int i = 0; i < segments; ++i) {
            int segOffset = i * segMult;
            sizes[i] = block.get8(segOffset + Offset.KSIZE.get(version)) & 0xFF;
            offsets[i] = version < 5 ? block.get16(segOffset + Offset.KOFF.get(version)) & 0xFFFF : block.get32(segOffset + Offset.KOFF.get(version));
        }
        KeyInfo keyInfo = new KeyInfo(block.get8(Offset.KDUP.get(version)) != 0, offsets, sizes);
        if (keyInfo.getTotalSize() != (block.get8(Offset.TOTALSIZE.get(version)) & 0xFF)) {
            return null;
        }
        keyInfo.setHeight((short)(block.get8(Offset.KEYHEIGHT.get(version)) & 0xFF));
        keyInfo.getKeyRoot().setOffset(version < 6 ? (long)block.get32(Offset.KEYROOT_OFF.get(version)) & 0xFFFFFFFFL : block.get48(Offset.KEYROOT_OFF.get(version)));
        keyInfo.getKeyRoot().setSegment(version == 4 || version == 5 ? block.get16(Offset.KEYROOT_SEG.get(version)) & 0xFFFF : 0);
        return keyInfo;
    }

    public boolean make(String fileName, PhysicalAttributes pp, LogicalAttributes lp, byte[] trans) {
        this.status.setErrno(2);
        if (pp == null) {
            pp = new PhysicalAttributes();
        }
        if (lp == null) {
            return false;
        }
        if (lp.getMinRecordSize() > lp.getMaxRecordSize()) {
            return false;
        }
        if (trans != null && trans.length != 256) {
            return false;
        }
        int version = this.config.V_VERSION.getIntegerValue();
        if (version < 5 ? lp.getMaxRecordSize() > Short.MAX_VALUE || pp.getBlockingFactor() > 2 || pp.getPreallocAmount() > 65535 || pp.getExtensionFactor() > 99 : lp.getMaxRecordSize() > 0x4000000 || pp.getBlockingFactor() > 16 || pp.getPreallocAmount() > 0x200000 || pp.getExtensionFactor() > 0x200000) {
            return false;
        }
        int numKeys = lp.getNumKeys();
        if (numKeys > 120 || numKeys < 1) {
            return false;
        }
        int maxKeySegments = version == 3 ? 6 : 16;
        int minimalRequiredSize = 0;
        for (int i = 0; i < numKeys; ++i) {
            KeyInfo k = lp.getKey(i);
            int nSegs = k.getSegments();
            int keySize = k.getTotalSize();
            if (nSegs > maxKeySegments || keySize > 250) {
                return false;
            }
            for (int y = 0; y < nSegs; ++y) {
                int tmp = k.getOffset(y) + k.getSize(y);
                if (tmp <= minimalRequiredSize) continue;
                minimalRequiredSize = tmp;
            }
        }
        if (minimalRequiredSize > lp.getMinRecordSize()) {
            return false;
        }
        if (lp.getMaxKeySize() > 125 && pp.getBlockingFactor() < 2) {
            pp = new PhysicalAttributes(2, pp.getPreallocAmount(), pp.getExtensionFactor());
        }
        this.status.setErrno(0);
        return this.createEmptyFile(fileName, version, pp, lp, trans);
    }

    private boolean createEmptyFile(String fileName, int version, PhysicalAttributes physicalAttributes, LogicalAttributes logicalAttributes, byte[] trans) {
        int i;
        int indexBlockPercent;
        long ialloc;
        int blockingFactor = physicalAttributes.getBlockingFactor();
        int preallocAmount = physicalAttributes.getPreallocAmount();
        int blockSize = blockingFactor * 512;
        int numberOfSectors = 1;
        int nkeys = logicalAttributes.getNumKeys();
        int blk1K = Offset.BLK_1_KEYS.get(version);
        int blkNK = Offset.BLK_N_KEYS.get(version);
        if (nkeys > blk1K) {
            numberOfSectors += (nkeys - blk1K + blkNK - 1) / blkNK;
        }
        if (trans != null) {
            ++numberOfSectors;
        }
        long nxtblk = (long)((numberOfSectors + blockingFactor - 1) / blockingFactor) * (long)blockingFactor;
        long inxtblk = (long)((1 + blockingFactor - 1) / blockingFactor) * (long)blockingFactor;
        long alloc = (long)preallocAmount * (long)blockingFactor;
        if (alloc < (long)numberOfSectors) {
            alloc = nxtblk;
        }
        if ((ialloc = (long)((double)alloc * ((double)(indexBlockPercent = this.config.V_INDEX_BLOCK_PERCENT.getIntegerValue()) / 100.0) + 0.5)) < 1L) {
            ialloc = 1L;
        }
        int segmentSize = this.config.V_SEG_SIZE.getIntegerValue();
        int fixedSegmentSize = segmentSize / blockSize * blockSize;
        if (version == 4 || version == 5) {
            int fixedMin;
            int fixedMax = 2147482112 / blockSize * blockSize;
            if (fixedSegmentSize > fixedMax || segmentSize == 0) {
                fixedSegmentSize = fixedMax;
            }
            if ((fixedMin = 81920 / blockSize * blockSize) < 81920) {
                fixedMin += blockSize;
            }
            if (fixedSegmentSize < fixedMin) {
                fixedSegmentSize = fixedMin;
            }
            if (alloc > (long)(fixedSegmentSize / 512)) {
                alloc = fixedSegmentSize / 512;
            }
            if (ialloc > (long)(fixedSegmentSize / 512)) {
                ialloc = fixedSegmentSize / 512;
            }
            if ((long)(logicalAttributes.getMaxRecordSize() + 15) > (long)fixedSegmentSize - nxtblk * 512L) {
                this.status.setErrno(17);
                return false;
            }
        }
        this.remove(fileName);
        FileSystemCache fileSystemCache = new FileSystemCache(this.status);
        FileDescriptor segment0 = fileSystemCache.open(this.getDataSegmentName(fileName, 0), 513);
        if (segment0 == null) {
            return false;
        }
        FileLock segment0Lock = fileSystemCache.lock(segment0);
        if (segment0Lock == null) {
            return false;
        }
        Block block = new Block(512);
        int i2 = 0;
        while ((long)i2 < alloc) {
            if (version == 3 && i2 % blockingFactor == 0) {
                block.put8(0, BlockType.EMPTY.getVal());
            }
            if (fileSystemCache.write(segment0, block, CacheDataType.RECORD) != 512) {
                fileSystemCache.unlock(segment0Lock);
                fileSystemCache.close(segment0);
                return false;
            }
            ++i2;
        }
        FileDescriptor ifile = null;
        FileLock ifileLock = null;
        if (version > 3) {
            ifile = fileSystemCache.open(this.getIndexSegmentName(fileName, 0), 513);
            if (ifile == null) {
                fileSystemCache.unlock(segment0Lock);
                fileSystemCache.close(segment0);
                return false;
            }
            ifileLock = fileSystemCache.lock(ifile);
            if (ifileLock == null) {
                fileSystemCache.unlock(segment0Lock);
                fileSystemCache.close(segment0);
                return false;
            }
            fileSystemCache.seek(ifile, 0L);
            int i3 = 0;
            while ((long)i3 < ialloc) {
                if (fileSystemCache.write(ifile, block, CacheDataType.INDEX) != 512) {
                    fileSystemCache.unlock(segment0Lock);
                    fileSystemCache.close(segment0);
                    fileSystemCache.unlock(ifileLock);
                    fileSystemCache.close(ifile);
                    return false;
                }
                ++i3;
            }
        }
        alloc *= 512L;
        ialloc *= 512L;
        nxtblk *= 512L;
        inxtblk *= 512L;
        if (version == 3) {
            block.put32(Offset.MAGIC.get(version), 269620246);
        } else {
            block.put32(Offset.MAGIC.get(version), 269620249);
            if (version < 6) {
                block.put32(Offset.WHOLE_DATA_OFF.get(version), (int)alloc);
                block.put16(Offset.WHOLE_DATA_SEG.get(version), (short)0);
                block.put32(Offset.WHOLE_INDEX_OFF.get(version), (int)ialloc);
                block.put16(Offset.WHOLE_INDEX_SEG.get(version), (short)0);
                block.put16(Offset.NXTBLK_SEG.get(version), (short)0);
            } else {
                block.put48(Offset.WHOLE_DATA_OFF.get(version), alloc);
                block.put48(Offset.WHOLE_INDEX_OFF.get(version), ialloc);
            }
            if (version == 4) {
                block.put32(Offset.I_NXTBLK_OFF.get(version), (int)nxtblk);
            } else if (version == 5) {
                block.put32(Offset.I_NXTBLK_OFF.get(version), (int)inxtblk);
            } else {
                block.put48(Offset.I_NXTBLK_OFF.get(version), inxtblk);
            }
            if (version < 6) {
                block.put16(Offset.I_NXTBLK_SEG.get(version), (short)0);
                block.put16(Offset.DATA_SEGS.get(version), (short)0);
                block.put16(Offset.INDEX_SEGS.get(version), (short)0);
                block.put32(Offset.MAX_SEG_SIZE.get(version), fixedSegmentSize);
            }
        }
        block.put16(Offset.VERSION.get(version), (short)version);
        block.put16(Offset.BLKMULT.get(version), (short)blockingFactor);
        if (version < 5) {
            block.put16(Offset.PREALLOC.get(version), (short)preallocAmount);
            block.put16(Offset.EXTENSION.get(version), (short)physicalAttributes.getExtensionFactor());
        } else {
            block.put32(Offset.PREALLOC.get(version), preallocAmount);
            block.put32(Offset.EXTENSION.get(version), physicalAttributes.getExtensionFactor());
        }
        if (version < 6) {
            block.put32(Offset.FILESIZE.get(version), (int)alloc);
            block.put32(Offset.NXTBLK_OFF.get(version), (int)nxtblk);
        } else {
            block.put48(Offset.FILESIZE.get(version), alloc);
            block.put48(Offset.NXTBLK_OFF.get(version), nxtblk);
        }
        if (trans != null) {
            block.put32(Offset.COLLATE.get(version), (numberOfSectors - 1) * 512);
        }
        int duplicates = 0;
        for (int i4 = 0; i4 < nkeys; ++i4) {
            if (!logicalAttributes.getKey(i4).isDuplicate()) continue;
            ++duplicates;
        }
        block.put16(Offset.DUPKEYS.get(version), (short)duplicates);
        if (version < 5) {
            if (duplicates == 0) {
                block.put16(Offset.REC_OVERHEAD.get(version), (short)4);
            } else {
                block.put16(Offset.REC_OVERHEAD.get(version), (short)8);
            }
        } else {
            block.put16(Offset.REC_OVERHEAD.get(version), (short)15);
        }
        if (version < 5) {
            block.put16(Offset.MAXREC.get(version), (short)logicalAttributes.getMaxRecordSize());
            block.put16(Offset.MINREC.get(version), (short)logicalAttributes.getMinRecordSize());
        } else {
            block.put32(Offset.MAXREC.get(version), logicalAttributes.getMaxRecordSize());
            block.put32(Offset.MINREC.get(version), logicalAttributes.getMinRecordSize());
        }
        block.put8(Offset.NKEYS.get(version), (byte)nkeys);
        block.put8(Offset.MAXKSIZE.get(version), (byte)logicalAttributes.getMaxKeySize());
        int compressFactor = logicalAttributes.getCompressFactor();
        if (compressFactor == 0 && this.config.V_COMPRESS_FILES.isOn()) {
            compressFactor = 1;
        }
        block.put8(Offset.COMPRESS.get(version), (byte)compressFactor);
        block.put8(Offset.ENCRYPT.get(version), (byte)0);
        if (this.config.V_APPLY_SIGNATURE.isOn()) {
            block.copy(Offset.COMMENT.get(version), DEFAULT_COMMENT, 0, 30);
        }
        int offsetKeyInfo = Offset.KEYINFO.get(version);
        int firstBlockSpace = Offset.BLK_1_KEYS.get(version);
        int keyMult = Offset.KEY_MULT.get(version);
        for (i = 0; i < nkeys && i < firstBlockSpace; ++i) {
            this.storeKeyInfo(version, block, offsetKeyInfo, logicalAttributes.getKey(i));
            offsetKeyInfo += keyMult;
        }
        fileSystemCache.seek(segment0, 0L);
        fileSystemCache.write(segment0, block, CacheDataType.HEADER);
        int additionalBlockCounter = 0;
        int additionalBlockSpace = Offset.BLK_N_KEYS.get(version);
        while (i < nkeys) {
            offsetKeyInfo = 0;
            Block additionalBlock = new Block(512);
            for (int x = 0; i < nkeys && x < additionalBlockSpace; ++x, ++i) {
                this.storeKeyInfo(version, additionalBlock, offsetKeyInfo, logicalAttributes.getKey(i));
                offsetKeyInfo += keyMult;
            }
            fileSystemCache.seek(segment0, (long)(++additionalBlockCounter) * 512L);
            fileSystemCache.write(segment0, additionalBlock, CacheDataType.HEADER);
        }
        if (trans != null) {
            Block collating = new Block(512);
            if (version != 4) {
                collating.put8(0, BlockType.COLLATE.getVal());
            }
            collating.copy(16, trans, 0, 256);
            fileSystemCache.seek(segment0, (long)(++additionalBlockCounter) * 512L);
            fileSystemCache.write(segment0, collating, CacheDataType.HEADER);
        }
        if (version > 3) {
            Block iblock = new Block(512);
            iblock.put32(Offset.I_MAGIC.get(version), 269620248);
            iblock.put16(Offset.I_VERSION.get(version), (short)version);
            if (version < 6) {
                iblock.put32(Offset.I_FILESIZE.get(version), (int)ialloc);
            } else {
                iblock.put48(Offset.I_FILESIZE.get(version), ialloc);
            }
            fileSystemCache.seek(ifile, 0L);
            fileSystemCache.write(ifile, iblock, CacheDataType.HEADER);
        }
        fileSystemCache.unlock(segment0Lock);
        if (version > 3) {
            fileSystemCache.unlock(ifileLock);
        }
        if (!fileSystemCache.close(segment0) || version > 3 && !fileSystemCache.close(ifile)) {
            this.status.setErrno(10);
            return false;
        }
        return true;
    }

    private File openFile(String fileName, int openMode, boolean rebuildMode) {
        int minRecSize;
        int maxRecSize;
        FileSystemCache fileSystemCache = new FileSystemCache(this.status);
        FileDescriptor segment0 = fileSystemCache.open(this.getDataSegmentName(fileName, 0), this.standardizeOpenMode(openMode));
        if (segment0 == null) {
            return null;
        }
        FileLock segment0Lock = fileSystemCache.lock(segment0);
        if (segment0Lock == null) {
            fileSystemCache.close(segment0);
            return null;
        }
        Block header = new Block(512);
        fileSystemCache.seek(segment0, 0L);
        if (fileSystemCache.read(segment0, header, CacheDataType.HEADER) < 512) {
            fileSystemCache.unlock(segment0Lock);
            fileSystemCache.close(segment0);
            this.status.setErrno(13);
            return null;
        }
        short version = 0;
        int magic = header.get32(0);
        if (magic == 269620246 || magic == 269620249) {
            version = header.get16(4);
        }
        if (version < 3 || version > 6) {
            fileSystemCache.unlock(segment0Lock);
            fileSystemCache.close(segment0);
            this.status.setErrno(13);
            return null;
        }
        if (header.get8(Offset.ENCRYPT.get(version)) != 0) {
            fileSystemCache.unlock(segment0Lock);
            fileSystemCache.close(segment0);
            this.status.setErrno(17);
            return null;
        }
        PhysicalAttributes physicalAttributes = new PhysicalAttributes(header.get16(Offset.BLKMULT.get(version)), version < 5 ? header.get16(Offset.PREALLOC.get(version)) : header.get32(Offset.PREALLOC.get(version)), version < 5 ? header.get16(Offset.EXTENSION.get(version)) : header.get32(Offset.EXTENSION.get(version)));
        if (version < 5) {
            maxRecSize = header.get16(Offset.MAXREC.get(version));
            minRecSize = header.get16(Offset.MINREC.get(version));
        } else {
            maxRecSize = header.get32(Offset.MAXREC.get(version));
            minRecSize = header.get32(Offset.MINREC.get(version));
        }
        int compressFactor = header.get8(Offset.COMPRESS.get(version)) & 0xFF;
        if (compressFactor == 1) {
            compressFactor = this.config.V_COMPRESS_FACTOR.getIntegerValue();
        }
        int numKeys = header.get8(Offset.NKEYS.get(version)) & 0xFF;
        KeyInfo[] keys = new KeyInfo[numKeys];
        int offset = Offset.KEYINFO.get(version);
        int keyMult = Offset.KEY_MULT.get(version);
        Block tmp = new Block(keyMult);
        for (int i = 0; i < numKeys; ++i) {
            int spaceLeft = 512 - offset % 512;
            if (spaceLeft < keyMult) {
                offset += spaceLeft;
            }
            fileSystemCache.seek(segment0, offset);
            if (fileSystemCache.read(segment0, tmp, CacheDataType.HEADER) != keyMult) {
                fileSystemCache.unlock(segment0Lock);
                fileSystemCache.close(segment0);
                this.status.setErrno(6);
                this.status.setIntErrno(8);
                return null;
            }
            offset += keyMult;
            keys[i] = this.retrieveKeyInfo(version, tmp);
            if (keys[i] != null) continue;
            fileSystemCache.unlock(segment0Lock);
            fileSystemCache.close(segment0);
            this.status.setErrno(6);
            this.status.setIntErrno(23);
            return null;
        }
        LogicalAttributes logicalAttributes = new LogicalAttributes(minRecSize, maxRecSize, keys, compressFactor);
        if (logicalAttributes.getMaxKeySize() != (header.get8(Offset.MAXKSIZE.get(version)) & 0xFF) || logicalAttributes.getDuplicates() != header.get16(Offset.DUPKEYS.get(version))) {
            fileSystemCache.unlock(segment0Lock);
            fileSystemCache.close(segment0);
            this.status.setErrno(6);
            this.status.setIntErrno(23);
            return null;
        }
        Block collate = null;
        long collateSectorOffset = (long)header.get32(Offset.COLLATE.get(version)) & 0xFFFFFFFFL;
        if (collateSectorOffset != 0L) {
            collate = new Block(256);
            fileSystemCache.seek(segment0, collateSectorOffset + 16L);
            if (fileSystemCache.read(segment0, collate, CacheDataType.HEADER) != 256) {
                fileSystemCache.unlock(segment0Lock);
                fileSystemCache.close(segment0);
                return null;
            }
        }
        FileDescriptor indexSegment0 = null;
        if (version > 3 && !rebuildMode) {
            indexSegment0 = fileSystemCache.open(this.getIndexSegmentName(fileName, 0), this.standardizeOpenMode(openMode));
            if (indexSegment0 == null) {
                if (this.status.getErrno() == 15) {
                    fileSystemCache.unlock(segment0Lock);
                    fileSystemCache.close(segment0);
                    this.status.setErrno(6);
                    this.status.setIntErrno(69);
                }
                return null;
            }
            FileLock indexSegment0Lock = fileSystemCache.lock(indexSegment0);
            if (indexSegment0Lock == null) {
                fileSystemCache.unlock(segment0Lock);
                fileSystemCache.close(segment0);
                fileSystemCache.close(indexSegment0);
                return null;
            }
            Block indexHeader = new Block(512);
            if (fileSystemCache.read(indexSegment0, indexHeader, CacheDataType.HEADER) != 512) {
                fileSystemCache.unlock(segment0Lock);
                fileSystemCache.close(segment0);
                fileSystemCache.unlock(indexSegment0Lock);
                fileSystemCache.close(indexSegment0);
                return null;
            }
            int imagic = indexHeader.get32(Offset.I_MAGIC.get(version));
            short iversion = indexHeader.get16(Offset.I_VERSION.get(version));
            int iseg = 0;
            if (version < 6) {
                iseg = indexHeader.get16(Offset.I_SEGNUM.get(version)) & 0xFFFF;
            }
            if (imagic != 269620248 || iversion != version || iseg != 0) {
                fileSystemCache.unlock(segment0Lock);
                fileSystemCache.close(segment0);
                fileSystemCache.unlock(indexSegment0Lock);
                fileSystemCache.close(indexSegment0);
                this.status.setErrno(13);
                return null;
            }
            int openCounter = header.get16(Offset.OPEN_CNT.get(version)) & 0xFFFF;
            if (openCounter == 0 && (this.config.V_OPEN_STRICT.isOn() || this.config.V_FORCE_OPEN.isOff()) && ((long)header.get32(Offset.IVERSION.get(version)) & 0xFFFFFFFFL) != ((long)indexHeader.get32(Offset.I_IVERSION.get(version)) & 0xFFFFFFFFL)) {
                fileSystemCache.unlock(segment0Lock);
                fileSystemCache.close(segment0);
                fileSystemCache.unlock(indexSegment0Lock);
                fileSystemCache.close(indexSegment0);
                this.status.setErrno(6);
                this.status.setIntErrno(89);
                return null;
            }
            fileSystemCache.unlock(indexSegment0Lock);
        }
        short recOverhead = header.get16(Offset.REC_OVERHEAD.get(version));
        long maxSegmentSize = 0L;
        if (version == 4 || version == 5) {
            maxSegmentSize = (long)header.get32(Offset.MAX_SEG_SIZE.get(version)) & 0xFFFFFFFFL;
        }
        File visionFile = new File(fileName, openMode, version, header, physicalAttributes, logicalAttributes, segment0, indexSegment0, collate, recOverhead, maxSegmentSize, this.isMultiLock(openMode) ? this.config.V_LOCKS_PER_FILE.getIntegerValue() : 1, this.canRollback(openMode), fileSystemCache);
        boolean inputOnly = this.isInputOnly(openMode);
        boolean forceOpen = this.config.V_FORCE_OPEN.isOn();
        if (!forceOpen && inputOnly && this.config.V_OPEN_STRICT.isOff()) {
            this.config.V_FORCE_OPEN.set(true);
        }
        fileSystemCache.unlock(segment0Lock);
        boolean success = this.lockHeader(visionFile, true, !inputOnly, false);
        this.config.V_FORCE_OPEN.set(forceOpen);
        if (!success) {
            this.unlockHeader(visionFile, false);
            fileSystemCache.close(segment0);
            if (indexSegment0 != null) {
                fileSystemCache.close(indexSegment0);
            }
            return null;
        }
        return visionFile;
    }

    private boolean closeAdditionalSegments(File visionFile) {
        int i;
        if (visionFile.getVersion() == 3) {
            return true;
        }
        boolean success = true;
        for (i = visionFile.getIndexFile().getSegmentCount() - 1; i >= 0; --i) {
            if (this.closeSegment(visionFile, BlockType.NODE, i)) continue;
            success = false;
        }
        for (i = visionFile.getSegmentCount() - 1; i >= 1; --i) {
            if (this.closeSegment(visionFile, BlockType.DATA, i)) continue;
            success = false;
        }
        return success;
    }

    private boolean closeFile(File visionFile) {
        boolean success = visionFile.getFileSystemCache().close(this.retrieveSegment(visionFile, BlockType.DATA, 0));
        return success;
    }

    private boolean closeSegment(File visionFile, BlockType type, int segmentNumber) {
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        FileDescriptor segment = this.retrieveSegment(visionFile, type, segmentNumber);
        boolean success = true;
        if (!this.isInputOnly(visionFile.getOpenMode())) {
            int offset = type == BlockType.DATA ? Offset.D_IVERSION.get(visionFile.getVersion()) : Offset.I_IVERSION.get(visionFile.getVersion());
            Block buffer = new Block(4);
            buffer.put32(0, (int)visionFile.getTreeVersion());
            fileSystemCache.seek(segment, offset);
            boolean bl = success = fileSystemCache.write(segment, buffer, CacheDataType.HEADER) == 4;
        }
        if (!fileSystemCache.close(segment)) {
            success = false;
        }
        return success;
    }

    public FileInfoHelper getFileInfo(int fileId) {
        File visionFile = this.fileTable.get(fileId);
        if (visionFile == null) {
            this.status.setErrno(1);
            return null;
        }
        return new FileInfoHelper(visionFile.getLogicalAttributes(), visionFile.getTotalRecords());
    }

    public boolean rename(String oldName, String newName) {
        this.status.setErrno(0);
        int fileId = this.open(oldName, 0);
        if (fileId == 0) {
            return false;
        }
        File visionFile = this.fileTable.get(fileId);
        int version = visionFile.getVersion();
        int numDataSegments = visionFile.getSegmentCount();
        int numIndexSegments = 0;
        if (version > 3) {
            numIndexSegments = visionFile.getIndexFile().getSegmentCount();
        }
        this.close(fileId, null);
        FileSystemCache fileSystemCache = visionFile.getFileSystemCache();
        boolean success = fileSystemCache.rename(this.getDataSegmentName(oldName, 0), this.getDataSegmentName(newName, 0));
        if (version > 3) {
            int i;
            for (i = 1; success && i < numDataSegments; ++i) {
                success = fileSystemCache.rename(this.getDataSegmentName(oldName, i), this.getDataSegmentName(newName, i));
            }
            for (i = 0; success && i < numIndexSegments; ++i) {
                success = fileSystemCache.rename(this.getIndexSegmentName(oldName, i), this.getIndexSegmentName(newName, i));
            }
        }
        return success;
    }
}

