/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import com.veryant.jdbc.PicoDbApi;
import java.net.InetAddress;
import java.sql.SQLException;

public class OdbcConnection {
    private int hDbc = 0;
    private PicoDbApi odbcApi;
    private final String host;
    private int port = 10996;
    private String dsn;

    public static String getLocalHost() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostName;
    }

    public OdbcConnection(PicoDbApi api, String connStr) throws SQLException {
        String myhost;
        String sport = "" + this.port;
        this.odbcApi = api;
        int i = connStr.indexOf(58);
        if (i >= 0) {
            myhost = connStr.substring(0, i);
            int j = connStr.indexOf(58, i + 1);
            if (j >= 0) {
                sport = connStr.substring(i + 1, j);
                this.dsn = connStr.substring(j + 1);
            } else {
                sport = connStr.substring(i);
            }
        } else {
            myhost = connStr;
        }
        if (myhost.length() == 0 || myhost.equals("@")) {
            this.host = OdbcConnection.getLocalHost();
        } else {
            if (myhost.charAt(0) == '@') {
                myhost = myhost.substring(1);
            }
            this.host = "".equals(myhost) ? OdbcConnection.getLocalHost() : myhost;
        }
        if (!"".equals(sport)) {
            try {
                this.port = Integer.parseInt(sport);
                if (this.port > 65535) {
                    throw new SQLException("Invalid port number: " + sport);
                }
            }
            catch (Exception _ex) {
                throw new SQLException("Invalid port number: " + sport);
            }
        }
        this.hDbc = this.odbcApi.SQLAllocConnect(this.host, this.port);
    }

    public void connect(String user, String passwd) throws SQLException {
        this.odbcApi.SQLConnect(this.hDbc, this.dsn, user, passwd);
    }

    public synchronized int getHDBC() {
        return this.hDbc;
    }

    public synchronized boolean isClosed() {
        return this.hDbc == 0;
    }

    public synchronized void close() throws SQLException {
        if (this.hDbc != 0) {
            this.odbcApi.SQLDisconnect(this);
            this.odbcApi.SQLFreeConnect(this);
            this.hDbc = 0;
        }
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        return super.toString() + ", hDbc=" + this.hDbc;
    }
}

