/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.jdbc;

import com.veryant.jdbc.OdbcStatement;
import com.veryant.jdbc.PicoConnection;
import com.veryant.jdbc.PicoDbApi;
import com.veryant.jdbc.PicoPseudoCol;
import com.veryant.jdbc.PicoResultSet;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class PicoDatabaseMetaData
implements DatabaseMetaData {
    protected PicoDbApi odbcApi;
    protected PicoConnection con;

    public PicoDatabaseMetaData(PicoDbApi api, PicoConnection conn) {
        this.odbcApi = api;
        this.con = conn;
    }

    protected String getInfoString(short opt) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("getInfoString opt=" + opt);
        }
        this.validateConnection();
        switch (opt) {
            case 19: {
                return "Y";
            }
            case 20: {
                return "N";
            }
            case 46: {
                return String.valueOf(4);
            }
            case 103: {
                return "Y";
            }
            case 41: {
                return "";
            }
            case 42: {
                return "";
            }
            case 17: {
                return "verySQL";
            }
            case 18: {
                return "4.00.0000";
            }
            case 7: {
                return "4.00.0000";
            }
            case 26: {
                return String.valueOf(1);
            }
            case 94: {
                return "";
            }
            case 29: {
                return " ";
            }
            case 112: {
                return "0";
            }
            case 34: {
                return "0";
            }
            case 108: {
                return "32767";
            }
            case 30: {
                return "30";
            }
            case 97: {
                return "0";
            }
            case 98: {
                return "0";
            }
            case 99: {
                return "0";
            }
            case 100: {
                return "0";
            }
            case 101: {
                return "0";
            }
            case 0: {
                return "0";
            }
            case 31: {
                return "0";
            }
            case 102: {
                return "250";
            }
            case 33: {
                return "0";
            }
            case 104: {
                return "32767";
            }
            case 32: {
                return "0";
            }
            case 105: {
                return "0";
            }
            case 1: {
                return "0";
            }
            case 35: {
                return "30";
            }
            case 106: {
                return "0";
            }
            case 107: {
                return "30";
            }
            case 49: {
                return String.valueOf(0x400001);
            }
            case 40: {
                return "";
            }
            case 89: {
                return "";
            }
            case 39: {
                return "";
            }
            case 14: {
                return "\\";
            }
            case 50: {
                return String.valueOf(7257);
            }
            case 51: {
                return "0";
            }
            case 52: {
                return "0";
            }
            case 47: {
                return "";
            }
            case 114: {
                return "0";
            }
            case 25: {
                return "N";
            }
            case 22: {
                return String.valueOf(1);
            }
            case 85: {
                return String.valueOf(2);
            }
            case 28: {
                return String.valueOf(1);
            }
            case 93: {
                return String.valueOf(1);
            }
            case 86: {
                return "0";
            }
            case 92: {
                return "0";
            }
            case 87: {
                return "Y";
            }
            case 48: {
                return String.valueOf(1);
            }
            case 15: {
                return String.valueOf(1);
            }
            case 95: {
                return String.valueOf(2);
            }
            case 27: {
                return "N";
            }
            case 38: {
                return "Y";
            }
            case 88: {
                return String.valueOf(2);
            }
            case 73: {
                return "N";
            }
            case 113: {
                return "N";
            }
            case 36: {
                return "N";
            }
            case 37: {
                return "N";
            }
            case 75: {
                return "0";
            }
            case 23: 
            case 24: {
                return String.valueOf(2);
            }
            case 80: {
                return "0";
            }
            case 91: {
                return "0";
            }
            case 21: {
                return "N";
            }
            case 74: {
                return String.valueOf(2);
            }
            case 96: {
                return "0";
            }
            case 84: {
                return String.valueOf(0);
            }
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoDatabaseMetaData.getInfoString(short " + opt + ")");
        }
        throw new UnsupportedOperationException();
    }

    protected int getInfo(short opt) throws SQLException {
        return Integer.parseInt(this.getInfoString(opt));
    }

    protected short getInfoShort(short opt) throws SQLException {
        return Short.parseShort(this.getInfoString(opt));
    }

    protected void validateConnection() throws SQLException {
        this.con.validateConnection();
    }

    protected boolean getInfoBooleanString(short opt) throws SQLException {
        this.validateConnection();
        String s = "N";
        return s.equalsIgnoreCase("Y");
    }

    public boolean allProceduresAreCallable() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.allProceduresAreCallable");
        }
        return this.getInfoBooleanString((short)20);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.allTablesAreSelectable");
        }
        return this.getInfoBooleanString((short)19);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.dataDefintionCausesTransactionCommit");
        }
        return ((i = this.getInfoShort((short)46)) & 3) > 0;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.dataDefintionIgnoredInTransactions");
        }
        return ((i = this.getInfoShort((short)46)) & 4) > 0;
    }

    public boolean deletesAreDetected(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.deletesAreDetected(int i)=false");
        }
        return false;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.doesMaxRowSizeIncludeBlobs");
        }
        return this.getInfoBooleanString((short)103);
    }

    public ResultSet getBestRowIdentifier(String s, String s1, String s2, int i, boolean flag) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getBestRowIdentifier (" + s + "," + s1 + "," + s2 + "," + i + "," + flag + ")");
        }
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLSpecialColumns(hstmt, (short)1, s, s1, s2, i, flag);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        rs.setSQLTypeColumn(3);
        return rs;
    }

    public String getCatalogSeparator() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getCatalogSeparator");
        }
        return this.getInfoString((short)41);
    }

    public String getCatalogTerm() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getCatalogTerm");
        }
        return this.getInfoString((short)42);
    }

    public ResultSet getCatalogs() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getCatalogs");
        }
        PicoResultSet rs = (PicoResultSet)this.getTables("%", "", "", null);
        int[] ai = new int[]{1};
        rs.setColumnMappings(ai);
        return rs;
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String column) throws SQLException {
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getColumnPrivileges(String s, String s1, String s2, String s3)");
        }
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLColumnPrivileges(hstmt, catalog, schema, table, column);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public ResultSet getColumns(String s, String s1, String s2, String s3) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getColumns (" + s + "," + s1 + "," + s2 + "," + s3 + ")");
        }
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLColumns(hstmt, s, s1, s2, s3);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        PicoPseudoCol[] pcol = new PicoPseudoCol[]{new PicoPseudoCol("COLUMN_DEF", 12, 254), new PicoPseudoCol("SQL_DATA_TYPE", 4, 0), new PicoPseudoCol("SQL_DATETIME_SUB", 4, 0), new PicoPseudoCol("CHAR_OCTET_LENGTH", 4, 0), new PicoPseudoCol("ORDINAL_POSITION", 4, 0), new PicoPseudoCol("IS_NULLABLE", 12, 254), new PicoPseudoCol("SCOPE_CATLOG", 12, 254), new PicoPseudoCol("SCOPE_SCHEMA", 12, 254), new PicoPseudoCol("SCOPE_TABLE", 12, 254), new PicoPseudoCol("SOURCE_DATA_TYPE", 5, 0)};
        rs.setPseudoCols(13, 22, pcol);
        rs.setSQLTypeColumn(5);
        return rs;
    }

    public Connection getConnection() {
        return this.con;
    }

    public ResultSet getCrossReference(String pkCat, String pkSch, String pkTab, String fkCat, String fkSch, String fkTab) throws SQLException {
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getCrossReference)");
        }
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLForeignKeys(hstmt, pkCat, pkSch, pkTab, fkCat, fkSch, fkTab);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public String getDatabaseProductName() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDatabaseProductName");
        }
        return this.getInfoString((short)17);
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDatabaseProductVersion");
        }
        return this.getInfoString((short)18);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDefaultTransactionIsolation");
        }
        return (byte)this.getInfo((short)26);
    }

    public int getDriverMajorVersion() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDriverMajorVersion()");
        }
        return 4;
    }

    public int getDriverMinorVersion() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDriverMinorVersion()");
        }
        return 1;
    }

    public String getDriverName() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDriverName");
        }
        return "verySQL JDBC driver";
    }

    public String getDriverVersion() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getDriverVersion");
        }
        int i = this.getDriverMinorVersion();
        String s = "";
        if (i < 1000) {
            s = s + "0";
        }
        if (i < 100) {
            s = s + "0";
        }
        if (i < 10) {
            s = s + "0";
        }
        s = s + "" + i;
        return this.getDriverMajorVersion() + "." + s + " (" + this.getInfoString((short)7) + ")";
    }

    public ResultSet getExportedKeys(String pkCat, String pkSch, String pkTab) throws SQLException {
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getExportedKeys(String s, String s1, String s2)");
        }
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLForeignKeys(hstmt, pkCat, pkSch, pkTab, null, null, null);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public String getExtraNameCharacters() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getExtraNameCharacters");
        }
        return this.getInfoString((short)94);
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getIdentifierQuoteString");
        }
        return this.getInfoString((short)29);
    }

    public ResultSet getImportedKeys(String fkCat, String fkSch, String fkTab) throws SQLException {
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getImportedKeys(String " + fkCat + ", String " + fkSch + ", String " + fkTab + ")");
        }
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLForeignKeys(hstmt, null, null, null, fkCat, fkSch, fkTab);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public ResultSet getIndexInfo(String s, String s1, String s2, boolean flag, boolean flag1) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getIndexInfo (" + s + "," + s1 + "," + s2 + flag + "," + flag1 + ")");
        }
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLStatistics(hstmt, s, s1, s2, flag, flag1);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxBinaryLiteralLength");
        }
        return this.getInfo((short)112);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxCatalogNameLength");
        }
        return this.getInfoShort((short)34);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxCharLiteralLength");
        }
        return this.getInfo((short)108);
    }

    public int getMaxColumnNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnNameLength");
        }
        return this.getInfoShort((short)30);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInGroupBy");
        }
        return this.getInfoShort((short)97);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInIndex");
        }
        return this.getInfoShort((short)98);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInOrderBy");
        }
        return this.getInfoShort((short)99);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInSeleted");
        }
        return this.getInfoShort((short)100);
    }

    public int getMaxColumnsInTable() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxColumnsInTable");
        }
        return this.getInfoShort((short)101);
    }

    public int getMaxConnections() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxConnections");
        }
        return this.getInfoShort((short)0);
    }

    public int getMaxCursorNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxCursorNameLength");
        }
        return this.getInfo((short)31);
    }

    public int getMaxIndexLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxIndexLength");
        }
        return this.getInfo((short)102);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxProcedureNameLength");
        }
        return this.getInfoShort((short)33);
    }

    public int getMaxRowSize() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxRowSize");
        }
        return this.getInfo((short)104);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxSchemaNameLength");
        }
        return this.getInfoShort((short)32);
    }

    public int getMaxStatementLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxStatementLength");
        }
        return this.getInfo((short)105);
    }

    public int getMaxStatements() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxStatements");
        }
        return this.getInfoShort((short)1);
    }

    public int getMaxTableNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxTableNameLength");
        }
        return this.getInfoShort((short)35);
    }

    public int getMaxTablesInSelect() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxTablesInSelect");
        }
        return this.getInfoShort((short)106);
    }

    public int getMaxUserNameLength() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getMaxUserNameLength");
        }
        return this.getInfoShort((short)107);
    }

    public String getNumericFunctions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getNumericFunctions");
        }
        String s = "";
        int i = this.getInfo((short)49);
        if ((i & 1) != 0) {
            s = s + "ABS,";
        }
        if ((i & 2) != 0) {
            s = s + "ACOS,";
        }
        if ((i & 4) != 0) {
            s = s + "ASIN,";
        }
        if ((i & 8) != 0) {
            s = s + "ATAN,";
        }
        if ((i & 0x10) != 0) {
            s = s + "ATAN2,";
        }
        if ((i & 0x20) != 0) {
            s = s + "CEILING,";
        }
        if ((i & 0x40) != 0) {
            s = s + "COS,";
        }
        if ((i & 0x80) != 0) {
            s = s + "COT,";
        }
        if ((i & 0x40000) != 0) {
            s = s + "DEGREES,";
        }
        if ((i & 0x100) != 0) {
            s = s + "EXP,";
        }
        if ((i & 0x200) != 0) {
            s = s + "FLOOR,";
        }
        if ((i & 0x400) != 0) {
            s = s + "LOG,";
        }
        if ((i & 0x80000) != 0) {
            s = s + "LOG10,";
        }
        if ((i & 0x800) != 0) {
            s = s + "MOD,";
        }
        if ((i & 0x10000) != 0) {
            s = s + "PI,";
        }
        if ((i & 0x100000) != 0) {
            s = s + "POWER,";
        }
        if ((i & 0x200000) != 0) {
            s = s + "RADIANS,";
        }
        if ((i & 0x20000) != 0) {
            s = s + "RAND,";
        }
        if ((i & 0x400000) != 0) {
            s = s + "ROUND,";
        }
        if ((i & 0x1000) != 0) {
            s = s + "SIGN,";
        }
        if ((i & 0x2000) != 0) {
            s = s + "SIN,";
        }
        if ((i & 0x4000) != 0) {
            s = s + "SQRT,";
        }
        if ((i & 0x8000) != 0) {
            s = s + "TAN,";
        }
        if ((i & 0x800000) != 0) {
            s = s + "TRUNCATE,";
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getPrimaryKeys (" + catalog + "," + schema + "," + table + ")");
        }
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLPrimaryKeys(hstmt, catalog, schema, table);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public ResultSet getProcedureColumns(String cat, String sch, String tab, String col) throws SQLException {
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getProcedureColumns(String s, String s1, String s2, String s3)");
        }
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLProcedureColumns(hstmt, cat, sch, tab, col);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public String getProcedureTerm() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getProcedureTerm");
        }
        return this.getInfoString((short)40);
    }

    public ResultSet getProcedures(String cat, String sch, String proc) throws SQLException {
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getProcedures(String s, String s1, String s2)");
        }
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLProcedures(hstmt, cat, sch, proc);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public String getSQLKeywords() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSQLKeywords");
        }
        return this.getInfoString((short)89);
    }

    public String getSchemaTerm() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSchemaTerm");
        }
        return this.getInfoString((short)39);
    }

    public ResultSet getSchemas() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSchemas");
        }
        PicoResultSet rs = (PicoResultSet)this.getTables("", "%", "", null);
        int[] ai = new int[]{2};
        rs.setColumnMappings(ai);
        return rs;
    }

    public String getSearchStringEscape() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSearchStringEscape");
        }
        return this.getInfoString((short)14);
    }

    public String getStringFunctions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getStringFunctions");
        }
        String s = "";
        int i = this.getInfo((short)50);
        if ((i & 0x2000) != 0) {
            s = s + "ASCII,";
        }
        if ((i & 0x4000) != 0) {
            s = s + "CHAR,";
        }
        if ((i & 1) != 0) {
            s = s + "CONCAT,";
        }
        if ((i & 0x8000) != 0) {
            s = s + "DIFFERENCE,";
        }
        if ((i & 2) != 0) {
            s = s + "INSERT,";
        }
        if ((i & 0x40) != 0) {
            s = s + "LCASE,";
        }
        if ((i & 4) != 0) {
            s = s + "LEFT,";
        }
        if ((i & 0x10) != 0) {
            s = s + "LENGTH,";
        }
        if ((i & 0x20) != 0) {
            s = s + "LOCATE,";
        }
        if ((i & 0x10000) != 0) {
            s = s + "LOCATE_2,";
        }
        if ((i & 8) != 0) {
            s = s + "LTRIM,";
        }
        if ((i & 0x80) != 0) {
            s = s + "REPEAT,";
        }
        if ((i & 0x100) != 0) {
            s = s + "REPLACE,";
        }
        if ((i & 0x200) != 0) {
            s = s + "RIGHT,";
        }
        if ((i & 0x400) != 0) {
            s = s + "RTRIM,";
        }
        if ((i & 0x20000) != 0) {
            s = s + "SOUNDEX,";
        }
        if ((i & 0x40000) != 0) {
            s = s + "SPACE,";
        }
        if ((i & 0x800) != 0) {
            s = s + "SUBSTRING,";
        }
        if ((i & 0x1000) != 0) {
            s = s + "UCASE,";
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String getSystemFunctions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getSystemFunctions");
        }
        String s = "";
        int i = this.getInfo((short)51);
        if ((i & 2) != 0) {
            s = s + "DBNAME,";
        }
        if ((i & 4) != 0) {
            s = s + "IFNULL,";
        }
        if ((i & 1) != 0) {
            s = s + "USERNAME,";
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public ResultSet getTablePrivileges(String cat, String sch, String tab) throws SQLException {
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getTablePrivileges(String s, String s1, String s2)");
        }
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLTablePrivileges(hstmt, cat, sch, tab);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public ResultSet getTableTypes() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getTableTypes");
        }
        String[] as = new String[]{"%"};
        PicoResultSet rs = (PicoResultSet)this.getTables("", "", "", as);
        int[] ai = new int[]{4};
        rs.setColumnMappings(ai);
        return rs;
    }

    public ResultSet getTables(String s, String s1, String s2, String[] as) throws SQLException {
        PicoResultSet rs = null;
        String s3 = null;
        SQLWarning sqlwarning = null;
        if (as != null) {
            s3 = "";
            boolean flag = false;
            for (int word0 = 0; word0 < as.length; word0 = (int)((short)(word0 + 1))) {
                String s4 = as[word0];
                if (word0 > 0) {
                    s3 = s3 + ",";
                }
                s3 = s3 + s4;
            }
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getTables (" + s + "," + s1 + "," + s2 + "," + s3 + ")");
        }
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLTables(hstmt, s, s1, s2, s3);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        return rs;
    }

    public String getTimeDateFunctions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getTimeDateFunctions");
        }
        String s = "";
        int i = this.getInfo((short)52);
        if ((i & 2) != 0) {
            s = s + "CURDATE,";
        }
        if ((i & 0x200) != 0) {
            s = s + "CURTIME,";
        }
        if ((i & 0x8000) != 0) {
            s = s + "DAYNAME,";
        }
        if ((i & 4) != 0) {
            s = s + "DAYOFMONTH,";
        }
        if ((i & 8) != 0) {
            s = s + "DAYOFWEEK,";
        }
        if ((i & 0x10) != 0) {
            s = s + "DAYOFYEAR,";
        }
        if ((i & 0x400) != 0) {
            s = s + "HOUR,";
        }
        if ((i & 0x800) != 0) {
            s = s + "MINUTE,";
        }
        if ((i & 0x20) != 0) {
            s = s + "MONTH,";
        }
        if ((i & 0x10000) != 0) {
            s = s + "MONTHNAME,";
        }
        if ((i & 1) != 0) {
            s = s + "NOW,";
        }
        if ((i & 0x40) != 0) {
            s = s + "QUARTER,";
        }
        if ((i & 0x1000) != 0) {
            s = s + "SECOND,";
        }
        if ((i & 0x2000) != 0) {
            s = s + "TIMESTAMPADD,";
        }
        if ((i & 0x4000) != 0) {
            s = s + "TIMESTAMPDIFF,";
        }
        if ((i & 0x80) != 0) {
            s = s + "WEEK,";
        }
        if ((i & 0x100) != 0) {
            s = s + "YEAR,";
        }
        if (s.length() > 0) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public ResultSet getTypeInfo() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getTypeInfo");
        }
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLGetTypeInfo(hstmt, (short)0);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        PicoPseudoCol[] pcol = new PicoPseudoCol[5];
        pcol[0] = new PicoPseudoCol("OdbcDef.SQL_DATA_TYPE", 5, 0);
        pcol[1] = new PicoPseudoCol("OdbcDef.SQL_DATETIME_SUB", 5, 0);
        pcol[2] = new PicoPseudoCol("NUM_PREC_RADIX", 5, 0);
        rs.setPseudoCols(16, 18, pcol);
        rs.setSQLTypeColumn(2);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("getTypeInfo rs=" + rs);
        }
        return rs;
    }

    public ResultSet getUDTs(String s, String s1, String s2, int[] ai) throws SQLException {
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getUDTs(String s, String s1, String s2, int ai[])");
        }
        Statement stmt = this.con.createStatement();
        ResultSet Return = null;
        try {
            Return = stmt.executeQuery("select '' TYPE_CAT, '' TYPE_SCHEM, '' TYPE_NAME, '' CLASS_NAME, '' DATA_TYPE, '' REMARKS, 0 BASE_TYPE  from __TABLES where 1 = 0");
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            stmt.close();
            throw sqlexception;
        }
        return Return;
    }

    public String getURL() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getURL");
        }
        return this.con.getURL();
    }

    public String getUserName() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getUserName");
        }
        return this.getInfoString((short)47);
    }

    public ResultSet getVersionColumns(String s, String s1, String s2) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.getVersionColumns (" + s + "," + s1 + "," + s2 + ")");
        }
        PicoResultSet rs = null;
        SQLWarning sqlwarning = null;
        OdbcStatement hstmt = new OdbcStatement(this.odbcApi, this.con.getHDBC());
        try {
            this.odbcApi.SQLSpecialColumns(hstmt, (short)2, s, s1, s2, 0, false);
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            hstmt.drop();
            throw sqlexception;
        }
        rs = new PicoResultSet(this.odbcApi, hstmt, this.con);
        rs.setWarning(sqlwarning);
        rs.setSQLTypeColumn(3);
        return rs;
    }

    public boolean insertsAreDetected(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.insertsAreDetected(int i)=flse");
        }
        return false;
    }

    public boolean isCatalogAtStart() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.isCatalogAtStart");
        }
        return (i = this.getInfoShort((short)114)) == 1;
    }

    public boolean isReadOnly() throws SQLException {
        boolean Return = this.getInfoBooleanString((short)25);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.isReadOnly() = " + Return);
        }
        return Return;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullPlusNullIsNull");
        }
        return (i = this.getInfoShort((short)22)) == 0;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullsAreSortedAtEnd");
        }
        return (i = this.getInfo((short)85)) == 4;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullsAreSortedAtStart");
        }
        return (i = this.getInfo((short)85)) == 2;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullsAreSortedHigh");
        }
        return (i = this.getInfoShort((short)85)) == 0;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.nullsAreSortedLow");
        }
        return (i = this.getInfo((short)85)) == 1;
    }

    public boolean othersDeletesAreVisible(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.othersDeletesAreVisible(int i)=false");
        }
        return false;
    }

    public boolean othersInsertsAreVisible(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.othersInsertsAreVisible(int i)=false");
        }
        return false;
    }

    public boolean othersUpdatesAreVisible(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.othersUpdatesAreVisible(int i)=false");
        }
        return false;
    }

    public boolean ownDeletesAreVisible(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.ownDeletesAreVisible(int i)=false");
        }
        return false;
    }

    public boolean ownInsertsAreVisible(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.ownInsertsAreVisible(int i)=false");
        }
        return false;
    }

    public boolean ownUpdatesAreVisible(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.ownUpdatesAreVisible(int i)=false");
        }
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesLowerCaseIdentifiers");
        }
        return (i = this.getInfoShort((short)28)) == 2;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesLowerCaseQuotedIdentifiers");
        }
        return (i = this.getInfoShort((short)93)) == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesMixedCaseIdentifiers");
        }
        return (i = this.getInfoShort((short)28)) == 4;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesMixedCaseQuotedIdentifiers");
        }
        return (i = this.getInfoShort((short)93)) == 4;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesUpperCaseIdentifiers");
        }
        return (i = this.getInfoShort((short)28)) == 1;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.storesUpperCaseQuotedIdentifiers");
        }
        return (i = this.getInfoShort((short)93)) == 1;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.supportsANSI92EntryLevelSQL()");
        }
        return true;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.supportsANSI92FullSQL()");
        }
        return false;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.supportsANSI92IntermediateSQL()");
        }
        return false;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsAlterTableWithAddColumn");
        }
        return ((i = this.getInfo((short)86)) & 1) > 0;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsAlterTableWithDropColumn");
        }
        return ((i = this.getInfo((short)86)) & 2) > 0;
    }

    public boolean supportsBatchUpdates() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.supportsBatchUpdates()=false");
        }
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInDataManipulation");
        }
        return ((i = this.getInfo((short)92)) & 1) > 0;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInIndexDefinitions");
        }
        return ((i = this.getInfo((short)92)) & 8) > 0;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInPrivilegeDefintions");
        }
        return ((i = this.getInfo((short)92)) & 0x10) > 0;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInProcedureCalls");
        }
        return ((i = this.getInfo((short)92)) & 2) > 0;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCatalogsInTableDefinitions");
        }
        return ((i = this.getInfo((short)92)) & 4) > 0;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsColumnAliasing");
        }
        return this.getInfoBooleanString((short)87);
    }

    public boolean supportsConvert() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsConvert");
        }
        return (i = this.getInfo((short)48)) == 1;
    }

    public boolean supportsConvert(int i, int j) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsConvert (" + i + "," + j + ")");
        }
        short word0 = 0;
        boolean flag = false;
        int k = 0;
        switch (i) {
            case -7: {
                word0 = 55;
                break;
            }
            case -6: {
                word0 = 68;
                break;
            }
            case 5: {
                word0 = 65;
                break;
            }
            case 4: {
                word0 = 61;
                break;
            }
            case -5: {
                word0 = 53;
                break;
            }
            case 6: {
                word0 = 60;
                break;
            }
            case 7: {
                word0 = 64;
                break;
            }
            case 8: {
                word0 = 59;
                break;
            }
            case 2: {
                word0 = 63;
                break;
            }
            case 3: {
                word0 = 58;
                break;
            }
            case 1: {
                word0 = 56;
                break;
            }
            case 12: {
                word0 = 70;
                break;
            }
            case -1: {
                word0 = 62;
                break;
            }
            case 91: {
                word0 = 57;
                break;
            }
            case 92: {
                word0 = 66;
                break;
            }
            case 93: {
                word0 = 67;
                break;
            }
            case -2: {
                word0 = 54;
                break;
            }
            case -3: {
                word0 = 69;
                break;
            }
            case -4: {
                word0 = 71;
            }
        }
        int l = this.getInfo(word0);
        switch (j) {
            case -7: {
                k = 4096;
                break;
            }
            case -6: {
                k = 8192;
                break;
            }
            case 5: {
                k = 16;
                break;
            }
            case 4: {
                k = 8;
                break;
            }
            case -5: {
                k = 16384;
                break;
            }
            case 6: {
                k = 32;
                break;
            }
            case 7: {
                k = 64;
                break;
            }
            case 8: {
                k = 128;
                break;
            }
            case 2: {
                k = 2;
                break;
            }
            case 3: {
                k = 4;
                break;
            }
            case 1: {
                k = 1;
                break;
            }
            case 12: {
                k = 256;
                break;
            }
            case -1: {
                k = 512;
                break;
            }
            case 91: {
                k = 32768;
                break;
            }
            case 92: {
                k = 65536;
                break;
            }
            case 93: {
                k = 131072;
                break;
            }
            case -2: {
                k = 1024;
                break;
            }
            case -3: {
                k = 2048;
                break;
            }
            case -4: {
                k = 262144;
            }
        }
        return (l & k) > 0;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        boolean Return = true;
        short i = this.getInfoShort((short)15);
        boolean bl = Return = i == 1 || i == 2;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCoreSQLGrammar=" + Return);
        }
        return Return;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsCorrelatedSubqueries");
        }
        return ((i = this.getInfo((short)95)) & 0x10) > 0;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsDataDefinitionAndDataManipulationTransactions");
        }
        return ((i = this.getInfoShort((short)46)) & 2) > 0;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsDataManipulationTransactionsOnly");
        }
        return ((i = this.getInfoShort((short)46)) & 1) > 0;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsDifferentTableCorrelationNames");
        }
        return (i = this.getInfoShort((short)74)) == 1;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsExpressionsInOrderBy");
        }
        return this.getInfoBooleanString((short)27);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        boolean Return;
        short i = this.getInfoShort((short)15);
        boolean bl = Return = i == 2;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsExtendedSQLGrammar" + Return);
        }
        return Return;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsFullOuterJoins");
        }
        String s = this.getInfoString((short)38);
        return s.equalsIgnoreCase("F");
    }

    public boolean supportsGroupBy() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsGroupBy");
        }
        return (i = this.getInfoShort((short)88)) != 0;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsGroupByBeyondSelect");
        }
        return (i = this.getInfoShort((short)88)) == 2;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsGroupByUnrelated");
        }
        return (i = this.getInfoShort((short)88)) == 3;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsIntegrityEnhancementFacility");
        }
        return this.getInfoBooleanString((short)73);
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsLikeEscapeClause");
        }
        return this.getInfoBooleanString((short)113);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsLimitedOuterJoins");
        }
        String s = this.getInfoString((short)38);
        return s.equalsIgnoreCase("P");
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMinimumSQLGrammar");
        }
        return (i = this.getInfoShort((short)15)) == 0 || i == 1 || i == 2;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMixedCaseIdentifiers");
        }
        return (i = this.getInfoShort((short)28)) == 4 || i == 1 || i == 2;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMixedCaseQuotedIdentifiers");
        }
        return (i = this.getInfoShort((short)93)) == 4 || i == 1 || i == 2;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMultipleResultSets");
        }
        return this.getInfoBooleanString((short)36);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsMultipleTransactions");
        }
        return this.getInfoBooleanString((short)37);
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsNonNullableColumns");
        }
        return (i = this.getInfoShort((short)75)) == 1;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOpenCursorsAcrossCommit");
        }
        return (i = this.getInfoShort((short)23)) == 2;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOpenCursorsAcrossRollback");
        }
        return (i = this.getInfoShort((short)24)) == 2;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOpenStatementsAcrossCommit");
        }
        return (i = this.getInfoShort((short)23)) == 2 || i == 1;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOpenStatementsAcrossRollback");
        }
        return (i = this.getInfoShort((short)24)) == 2 || i == 1;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOrderByUnrelated");
        }
        return this.getInfoBooleanString((short)90);
    }

    public boolean supportsOuterJoins() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsOuterJoins");
        }
        String s = this.getInfoString((short)38);
        return s.equalsIgnoreCase("N") ^ true;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsPositionedDelete");
        }
        return ((i = this.getInfo((short)80)) & 1) > 0;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsPositionedUpdate");
        }
        return ((i = this.getInfo((short)80)) & 2) > 0;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.supportsResultSetConcurrency(int i, int j)");
        }
        switch (type) {
            case 1003: {
                return concurrency != 1007;
            }
            case 1004: {
                if (concurrency == 1007) {
                    return false;
                }
                return false;
            }
            case 1005: {
                return concurrency != 1007;
            }
        }
        return false;
    }

    public boolean supportsResultSetType(int type) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.supportsResultSetType(int i)");
        }
        switch (type) {
            case 1003: {
                return true;
            }
            case 1004: {
                return false;
            }
            case 1005: {
                return true;
            }
        }
        return false;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInDataManipulation");
        }
        return ((i = this.getInfo((short)91)) & 1) > 0;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInIndexDefintions");
        }
        return ((i = this.getInfo((short)91)) & 8) > 0;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInPrivilegeDefintions");
        }
        return ((i = this.getInfo((short)91)) & 0x10) > 0;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInProcedureCalls");
        }
        return ((i = this.getInfo((short)91)) & 2) > 0;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSchemasInTableDefinitions");
        }
        return ((i = this.getInfo((short)91)) & 4) > 0;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSelectForUpdate");
        }
        return ((i = this.getInfo((short)80)) & 4) > 0;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsStoredProcedures");
        }
        return this.getInfoBooleanString((short)21);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSubqueriesInComparisions");
        }
        return ((i = this.getInfo((short)95)) & 1) > 0;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSubqueriesInExists");
        }
        return ((i = this.getInfo((short)95)) & 2) > 0;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSubqueriesInIns");
        }
        return ((i = this.getInfo((short)95)) & 4) > 0;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSubqueriesInQuantifieds");
        }
        return ((i = this.getInfo((short)95)) & 8) > 0;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsTableCorrelationNames");
        }
        return (i = this.getInfoShort((short)74)) == 1 || i == 2;
    }

    public boolean supportsTransactionIsolationLevel(int i) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsTransactionIsolationLevel (" + i + ")");
        }
        if (i == 0) {
            return !this.supportsTransactions();
        }
        int j = this.getInfo((short)72);
        boolean flag = false;
        switch (i) {
            case 1: {
                flag = (j & 1) > 0;
                break;
            }
            case 2: {
                flag = (j & 2) > 0;
                break;
            }
            case 4: {
                flag = (j & 4) > 0;
                break;
            }
            case 8: {
                flag = (j & 8) > 0;
            }
        }
        return flag;
    }

    public boolean supportsTransactions() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsTransactions");
        }
        return (i = this.getInfoShort((short)46)) != 0;
    }

    public boolean supportsUnion() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsUnion");
        }
        return ((i = this.getInfo((short)96)) & 1) > 0;
    }

    public boolean supportsUnionAll() throws SQLException {
        int i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsUnionAll");
        }
        return ((i = this.getInfo((short)96)) & 2) > 0;
    }

    public boolean supportsSavepoints() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.supportsSavepoints");
        }
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.supportsNamedParameters ()");
        }
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.supportsMultipleOpenResults()");
        }
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.supportsGetGeneratedKeys ()");
        }
        return true;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.supportsResultSetHoldability (int holdability)");
        }
        return false;
    }

    public boolean supportsStatementPooling() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.supportsStatementPooling ()");
        }
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.getResultSetHoldability()");
        }
        return 1;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getSuperTypes (String catalog, String schemaPattern, String typeNamePattern)");
        }
        Statement stmt = this.con.createStatement();
        ResultSet Return = null;
        try {
            Return = stmt.executeQuery("select '' TYPE_CAT, '' TYPE_SCHEM, '' TYPE_NAME,        '' SUPERTYPE_CAT, '' SUPERTYPE_SCHEM, '' SUPERTYPE_NAME  from __TABLES where 1 = 0");
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            stmt.close();
            throw sqlexception;
        }
        return Return;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.getDatabaseMajorVersion()");
        }
        return 5;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.getDatabaseMinorVersion()");
        }
        return 0;
    }

    public int getJDBCMajorVersion() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.getJDBCMajorVersion()");
        }
        return 1;
    }

    public int getJDBCMinorVersion() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.getJDBCMinorVersion()");
        }
        return 4;
    }

    public int getSQLStateType() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.getSQLStateType()");
        }
        return 1;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("DatabaseMetaData.locatorsUpdateCopy()");
        }
        return false;
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getSuperTables(String catalog, String schemaPattern, String tableNamePattern)");
        }
        Statement stmt = this.con.createStatement();
        ResultSet Return = null;
        try {
            Return = stmt.executeQuery("select '' TABLE_CAT, '' TABLE_SCHEM, '' TABLE_NAME,        '' SUPERTABLE_NAME  from __TABLES where 1 = 0");
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            stmt.close();
            throw sqlexception;
        }
        return Return;
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        SQLWarning sqlwarning = null;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern)");
        }
        Statement stmt = this.con.createStatement();
        ResultSet Return = null;
        try {
            Return = stmt.executeQuery("select '' TYPE_CAT, '' TYPE_SCHEM, '' TYPE_NAME, '' ATTR_NAME,  0 DATA_TYPE, '' ATTR_TYPE_NAME, 0 ATTR_SIZE,  0 DECIMAL_DIGITS, 0 NUM_PREC_RADIX, 0 NULLABLE, '' REMARKS, '' ATTR_DEF, 0 SQL_DATA_TYPE,  0 SQL_DATETIME_SUB, 0 CHAR_OCTET_LENGTH,  0 ORDINAL_POSITION, '' IS_NULLABLE, '' SCOPE_CATALOG, '' SCOPE_SCHEMA, '' SCOPE_TABLE, 0 SOURCE_DATA_TYPE  from __TABLES where 1 = 0");
        }
        catch (SQLWarning sqlwarning1) {
            sqlwarning = sqlwarning1;
        }
        catch (SQLException sqlexception) {
            stmt.close();
            throw sqlexception;
        }
        return Return;
    }

    public boolean updatesAreDetected(int i) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoDatabaseMetaData.updatesAreDetected(int i)=false");
        }
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.usesLocalFilePerTable");
        }
        return (i = this.getInfoShort((short)84)) == 1;
    }

    public boolean usesLocalFiles() throws SQLException {
        short i;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*DatabaseMetaData.usesLocalFiles");
        }
        return (i = this.getInfoShort((short)84)) == 2;
    }
}

