
##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**This sample shows how to create a SOAP webservice from a legacy COBOL source code using**
**the isCOBOL Service Bridge.**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder.**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

----------
 - 1 Using a command prompt window go to the "$ISCOBOL/sample/eis/webservice/bridge/soap" folder

 - 2 Compile the legacy program that will work as a server

        iscc -whttp SONGS.cbl 

 **NOTE:**

        The -whttp option will tell the compiler to show warnings for statements that are 
             not supported by EIS/Mobile

 - 3 Create the "songs-soap.war" running the build.sh

**NOTE:**

        The war created by build.sh creates a Jakarta servlet (Tomcat 10 or higher).
        If you need to use a JEE servlet (Tomcat 9 or lower), you must modify the build.sh file 
        to copy web.jee.servlet.xml instead of web.xml into the WEB-INF folder, renaming it to web.xml. 
        Update the line as follows:
        copy "$ISCOBOL/sample/eis/files/web.jee.servlet.xml" "$ISCOBOL/sample/eis/webservice/soap/songs-soap/WEB-INF/web.xml"

 - 4 Deploy the webapp from $ISCOBOL/sample/eis/webservice/bridge/soap/songs-soap.war 
     in your servlet container

 **NOTE:**

    To test the application follow the instructions at the end of README.md**

 **NOTE:**

    To run this sample in debug mode, follow these steps
    - add the option "-d" or "-dx" during compilation
    - add iscobol.rundebug=1 or iscobol.rundebug=2 to iscobol.properties file
    - optionally add iscobol.debug.port=<port-number>,  useful if you have more than 1 webapps 
    - execute the remote debugger with the following command
      iscrun -d -r <host-name> <port-number>
      from $ISCOBOL/sample/eis/webservice/bridge/soap/songs-soap folder

----------
#### There are multiple ways to test the web service application simulating client requests:
 - using third party application, such as SoapUI
 - using the COBOL bean program generated by compiling the web service application
 - using Java to call methods exposed in the COBOL bean program

----------
#### Test using SoapUI using the WSDL file that compilation process generated
 - 1 From the SoapUI main program, select the File / New SOAP project menu
       
 - 2 Type a project name, such as Songs

 - 3 In the Initial WSDL field, type the following link 
     "http://localhost:8080/songs-soap/servlet/SONGS?wsdl", or click browse, navigate to the sample 
     folder, and select the generated SONGS.WSDL file

 - 4 Click OK to create the project

 - 5 Expand  SoapUI's Navigator treeview all the way to Request 1, right click Request 1 and select 
     the "Show request editor" menu item.

 - 6 A new window will show the XML SOAP Request.  

 - 7 Check the Url into the toolbar of the Request 1 window.
     You may need to modify to reflect your servlet container actual IP and port information.
     An URL for Servlet container deployment might be

        http://localhost:8080/songs-soap/servlet 

 - 8 Modify the request, for example, the F op-code, which shows the first song, by changing the 
     following line in the request xml

        <son:Operation>?</son:Operation> 

     replacing the ? placeholder with the actual op-code: F

 - 9 Click the green play button in the toolbar, and SoapUI will execute the request, displaying 
     the response XML message in the right pane of the request window.
     If all the steps were carried out correctly, the xml will contain the song data.

----------
#### Test using the generated COBOL bean program 
 - 1 Modify the iscobol.properties file to set the correct connection url for your servlet container 

 - 2 Run the BEANSONGS program to test a sequence of requests

        iscrun beanSONGS 

----------
#### Test using Java to call methods exposed in the COBOL bean program 
 - 1 Edit the Java source code to use the correct connection url

 - 2 Compile the Java program

        "$ISCOBOL_JDK_ROOT/bin/javac" TestBean.java 

 - 3 Run the java program

        "$ISCOBOL_JDK_ROOT/bin/java" TestBean 
