       >>SOURCE FORMAT FREE
      >>set "servicebridge.bean.url" "http://localhost:8080/songs-soap/servlet"
       >>SOURCE FORMAT PREVIOUS
       >>set "servicebridge.bean.package" ""
       >>set "servicebridge.bean" "SOAP"
      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.
       >>set "servicebridge.soap.style" "Document"
       >>set "servicebridge" "1"
       >>SOURCE FORMAT FREE
      >>set "servicebridge.soap.url" "http://localhost:8080/songs-soap/servlet"
       >>SOURCE FORMAT PREVIOUS
       PROGRAM-ID. SONGS.
       CONFIGURATION SECTION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           select  songs assign to "songs"
                 organization is indexed
                 access is dynamic
                 record key is sr-key
                 alternate record key is sr-title duplicates
                 alternate record key is sr-artist duplicates
                 lock mode is manual
                 file status is file-status.
       DATA DIVISION.
       FILE SECTION.

       fd  songs.
       01  songs-record.
           05 sr-key.
              10 sr-id          pic 9(5).
           05 sr-data.
              10 sr-title       pic x(30).
              10 sr-length      pic x(5).
              10 sr-artist      pic x(20).
              10 sr-album       pic x(30).
              10 sr-genre       pic x(15).
              10 sr-label       pic x(30).
              10 sr-year        pic 9(4).
              10 sr-authors     occurs 5.
                 15 sr-author   pic x(20).

       WORKING-STORAGE SECTION.

       01  initial-song-table.
      ***
           03 filler pic x(30) value "Let It Be".
           03 filler pic x(5)  value "4:03".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Let It Be".
           03 filler pic x(15) value "Pop".
           03 filler pic x(30) value "Apple Records".
           03 filler pic 9(4)  value 1970.
           03 filler pic x(20) value "Paul McCartney".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Yellow Submarine".
           03 filler pic x(5)  value "2:40".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Revolver".
           03 filler pic x(15) value "Pop".
           03 filler pic x(30) value "Apple Records".
           03 filler pic 9(4)  value 1966.
           03 filler pic x(20) value "Paul McCartney".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Help!".
           03 filler pic x(5)  value "2:21".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Help!".
           03 filler pic x(15) value "Pop".
           03 filler pic x(30) value "Parlophone".
           03 filler pic 9(4)  value 1965.
           03 filler pic x(20) value "John Lennon".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Yesterday".
           03 filler pic x(5)  value "2:07".
           03 filler pic x(20) value "Beatles".
           03 filler pic x(30) value "Help!".
           03 filler pic x(15) value "Pop".
           03 filler pic x(30) value "Parlophone".
           03 filler pic 9(4)  value 1965.
           03 filler pic x(20) value "John Lennon".
           03 filler pic x(20) value "Paul McCartney".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Angie".
           03 filler pic x(5)  value "4:30".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "Goats Head Soup".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "R.S.Records".
           03 filler pic 9(4)  value 1973.
           03 filler pic x(20) value "Mick Jagger".
           03 filler pic x(20) value "Keith Richards".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Start Me Up".
           03 filler pic x(5)  value "3:32".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "Tattoo You".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Rolling Stones records".
           03 filler pic 9(4)  value 1981.
           03 filler pic x(20) value "Mick Jagger".
           03 filler pic x(20) value "Keith Richards".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Satisfaction".
           03 filler pic x(5)  value "3:45".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "Out of Our Heads".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Decca/ABKCO".
           03 filler pic 9(4)  value 1965.
           03 filler pic x(20) value "Mick Jagger".
           03 filler pic x(20) value "Keith Richards".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Rain Fall Down".
           03 filler pic x(5)  value "4:55".
           03 filler pic x(20) value "The Rolling Stones".
           03 filler pic x(30) value "A Bigger Bang".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Polydor Records".
           03 filler pic 9(4)  value 2005.
           03 filler pic x(20) value "Mick Jagger".
           03 filler pic x(20) value "Keith Richards".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Maria Maria".
           03 filler pic x(5)  value "4:19".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Supernatural".
           03 filler pic x(15) value "Latin Rock".
           03 filler pic x(30) value "BMG Arista/Ariola".
           03 filler pic 9(4)  value 1999.
           03 filler pic x(20) value "Raul Rekow".
           03 filler pic x(20) value "Jerry Duplessis".
           03 filler pic x(20) value "Wyclef Jean".
           03 filler pic x(20) value "Carlos Santana".
           03 filler pic x(20) value "Karl Perazzo".
      ***
           03 filler pic x(30) value "Oye como va".
           03 filler pic x(5)  value "4:36".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Abraxas".
           03 filler pic x(15) value "Latin Rock".
           03 filler pic x(30) value "Columbia Records".
           03 filler pic 9(4)  value 1970.
           03 filler pic x(20) value "Tito Puente".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Lightning in the sky".
           03 filler pic x(5)  value "3:50".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Marathon".
           03 filler pic x(15) value "Latin Rock".
           03 filler pic x(30) value "Columbia Records".
           03 filler pic 9(4)  value 1979.
           03 filler pic x(20) value "Keith Olsen".
           03 filler pic x(20) value "Santana".
           03 filler pic x(20) value "David De Vore".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Foo Foo".
           03 filler pic x(5)  value "6:29".
           03 filler pic x(20) value "Santana".
           03 filler pic x(30) value "Shaman".
           03 filler pic x(15) value "Latin Rock".
           03 filler pic x(30) value "Arista".
           03 filler pic 9(4)  value 2002.
           03 filler pic x(20) value "Clive Davis".
           03 filler pic x(20) value "Carlos Santana".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Money for Nothing".
           03 filler pic x(5)  value "6:19".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "After Midnight Live". 
           03 filler pic x(15) value "Rock/Pop".
           03 filler pic x(30) value "Immortal".
           03 filler pic 9(4)  value 2006.
           03 filler pic x(20) value "Mark Knopfler".
           03 filler pic x(20) value "Sting".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "After Midnight".
           03 filler pic x(5)  value "2:51".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "Eric Clapton".
           03 filler pic x(15) value "Rock/Pop".
           03 filler pic x(30) value "Atco, Polydor Records".
           03 filler pic 9(4)  value 1970.
           03 filler pic x(20) value "J.J. Cale".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Bad Love".
           03 filler pic x(5)  value "6:25".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "24 Nights".
           03 filler pic x(15) value "Blues rock".
           03 filler pic x(30) value "Duck Records".
           03 filler pic 9(4)  value 1991.
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Next Time You See Her".
           03 filler pic x(5)  value "4:02".
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(30) value "Slowhand".
           03 filler pic x(15) value "Blues".
           03 filler pic x(30) value "Polydor".
           03 filler pic 9(4)  value 1977.
           03 filler pic x(20) value "Eric Clapton".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Albachiara".
           03 filler pic x(5)  value "4:05".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "Non siamo mica gli americani".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Lotus LOP".
           03 filler pic 9(4)  value 1979.
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Tango".
           03 filler pic x(5)  value "3:07".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "Liberi Liberi".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Emi".
           03 filler pic 9(4)  value 1988.
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "C'e' chi dice no". 
           03 filler pic x(5)  value "4:38".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "C'e' chi dice no". 
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Carosello".
           03 filler pic 9(4)  value 1987.
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(20) value "Maurizio Solieri".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
      ***
           03 filler pic x(30) value "Bollicine".
           03 filler pic x(5)  value "5:40".
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(30) value "Bollicine".
           03 filler pic x(15) value "Rock".
           03 filler pic x(30) value "Carosello".
           03 filler pic 9(4)  value 1983.
           03 filler pic x(20) value "Vasco Rossi".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".
           03 filler pic x(20) value "".

       01  initial-song-table-red  redefines initial-song-table.
           03 ist-item        occurs 20.
              05 ist-title    pic x(30).
              05 ist-length   pic x(5).
              05 ist-artist   pic x(20).
              05 ist-album    pic x(30).
              05 ist-genre    pic x(15).
              05 ist-label    pic x(30).
              05 ist-year     pic 9(4).
              05 ist-authors  occurs 5.
                 10 ist-author pic x(20).


       77  file-status pic xx value "00".

       01  declaratives-switch pic 9 value 0.
           88  declaratives-on value 0.
           88  declaratives-off value 1.

       77  idx            pic 9(9).

       77  open-mode         pic xx.
           88 open-io        value "IO".
           88 open-input     value "IN".

       LINKAGE SECTION.
       >>elk input
       >>elk name=Operation
       >>elk mandatory
       01  lnk-op-code             pic x.
           88 lnk-insert           value "I".
           88 lnk-update           value "U".
           88 lnk-read             value "R".
           88 lnk-read-next        value "N".
           88 lnk-read-previous    value "P".
           88 lnk-delete           value "D".
           88 lnk-first            value "F".
           88 lnk-last             value "L".
       >>elk input
       >>elk name=SongData
       >>elk output
       >>elk name=SongData
       01  lnk-song-data.
       >>elk input
       >>elk name=Id
       >>elk output
       >>elk name=Id
           05 lnk-sd-id            pic 9(5).
       >>elk input
       >>elk name=Title
       >>elk output
       >>elk name=Title
           05 lnk-sd-title         pic x(30).
       >>elk input
       >>elk name=Length
       >>elk output
       >>elk name=Length
           05 lnk-sd-length        pic x(5).
       >>elk input
       >>elk name=Artist
       >>elk output
       >>elk name=Artist
           05 lnk-sd-artist        pic x(20).
       >>elk input
       >>elk name=Album
       >>elk output
       >>elk name=Album
           05 lnk-sd-album         pic x(30).
       >>elk input
       >>elk name=Genre
       >>elk output
       >>elk name=Genre
           05 lnk-sd-genre         pic x(15).
       >>elk input
       >>elk name=Label
       >>elk output
       >>elk name=Label
           05 lnk-sd-label         pic x(30).
       >>elk input
       >>elk name=Year
       >>elk output
       >>elk name=Year
           05 lnk-sd-year          pic 9(4).
       >>elk input
       >>elk name=Authors
       >>elk output
       >>elk name=Authors
           05 lnk-sd-authors       occurs 5.
       >>elk input
       >>elk name=Author
       >>elk output
       >>elk name=Author
              10 lnk-sd-author     pic x(20).
       >>elk output
       >>elk name=Status
       01  lnk-return-status.
       >>elk output
       >>elk name=ReturnStatus
           05 lnk-status           pic x(2).
              88 lnk-ok            value "OK".
              88 lnk-ko            value "KO".
       >>elk output
       >>elk name=FileStatus
           05 lnk-file-status      pic x(2).
       >>elk output
       >>elk name=ReturnMessage
           05 lnk-status-message   pic x(50).


       PROCEDURE DIVISION USING lnk-op-code, 
                                lnk-song-data, 
                                lnk-return-status.
       DECLARATIVES.
       decl section.
           use after standard error on songs.
           set lnk-ko  to true
           move file-status to lnk-file-status.
           evaluate file-status
           when "02"
               move "Song already exists"         to lnk-status-message
           when "10"
               move "At end or beginning of file" to lnk-status-message
           when "22"
               move "Song already into file"      to lnk-status-message
           when "35"
                if declaratives-off
                   set declaratives-on            to true
                   set lnk-ok                     to true
                   initialize lnk-file-status
                   perform INIT-DATA
                end-if
           when "23"
               move "Song not found"              to lnk-status-message
           when "46"
               move "No current record defined"   to lnk-status-message
           when "98"
               move "File is corrupted"           to lnk-status-message
           when other
               initialize lnk-status-message
               string "Error "                    delimited by size
                      file-status                 delimited by size
                      " on file 'songs'"          delimited by size
                      into lnk-status-message
           end-evaluate.

           if file-status not = "00"
              goback
           end-if.
       end declaratives.

       INIT.
           set lnk-OK  to true
           initialize lnk-file-status
           move "Operation successful"   to lnk-status-message.

           evaluate true
           when lnk-insert
                perform CHECK-DATA
                if lnk-ok
                   set open-io to true
                   perform OPEN-FILE
                   move high-value to sr-id
                   start songs key not > sr-key
                      invalid
                         move zero to sr-id
                      not invalid
                         read songs previous no lock
                           at end
                              move zero  to sr-id
                         end-read
                   end-start
                   add 1 to sr-id
                   move sr-id    to lnk-sd-id
                   perform MOVE-SONG-DATA-FROM-LNK-TO-FILE
                   write songs-record
                   perform CLOSE-FILE
                end-if

           when lnk-update
                perform CHECK-DATA
                if lnk-ok
                   set open-io to true
                   perform OPEN-FILE
                   move lnk-sd-id  to sr-id
                   perform MOVE-SONG-DATA-FROM-LNK-TO-FILE
                   rewrite songs-record
                   perform CLOSE-FILE
                end-if

           when lnk-read
                set open-input to true
                perform OPEN-FILE
                move lnk-sd-id  to sr-id
                read songs no lock
                perform MOVE-SONG-DATA-FROM-FILE-TO-LNK
                perform CLOSE-FILE

           when lnk-read-next
                set open-input to true
                perform OPEN-FILE
                move lnk-sd-id  to sr-id
                read songs no lock
                read songs next no lock
                perform MOVE-SONG-DATA-FROM-FILE-TO-LNK
                perform CLOSE-FILE

           when lnk-read-previous
                set open-input to true
                perform OPEN-FILE
                move lnk-sd-id  to sr-id
                read songs no lock
                read songs previous no lock
                perform MOVE-SONG-DATA-FROM-FILE-TO-LNK
                perform CLOSE-FILE

           when lnk-delete
                set open-io to true
                perform OPEN-FILE
                move lnk-sd-id  to sr-id
                delete songs record
                perform CLOSE-FILE

           when lnk-first
                set open-input to true
                perform OPEN-FILE
                start songs first
                read songs next no lock
                perform MOVE-SONG-DATA-FROM-FILE-TO-LNK
                perform CLOSE-FILE

           when lnk-last
                set open-input to true
                perform OPEN-FILE
                start songs last
                read songs previous no lock
                perform MOVE-SONG-DATA-FROM-FILE-TO-LNK
                perform CLOSE-FILE

           when other
                set lnk-ko   to true
                move "Invalid Op-code"   to lnk-status-message
           end-evaluate.
           
           goback.

       CHECK-DATA.
           if lnk-sd-title = space
              set lnk-ko                 to true
              move space                 to lnk-file-status
              move "Title is mandatory"  to lnk-status-message
           end-if.

       MOVE-SONG-DATA-FROM-LNK-TO-FILE.
           move lnk-sd-title          to sr-title
           move lnk-sd-length         to sr-length
           move lnk-sd-artist         to sr-artist
           move lnk-sd-album          to sr-album
           move lnk-sd-genre          to sr-genre
           move lnk-sd-label          to sr-label
           move lnk-sd-year           to sr-year

           perform varying   idx from 1 by 1 until idx > 5
              move lnk-sd-author(idx) to sr-author(idx)
           end-perform
           .

       MOVE-SONG-DATA-FROM-FILE-TO-LNK.
           move sr-id              to lnk-sd-id
           move sr-title           to lnk-sd-title
           move sr-length          to lnk-sd-length
           move sr-artist          to lnk-sd-artist
           move sr-album           to lnk-sd-album
           move sr-genre           to lnk-sd-genre
           move sr-label           to lnk-sd-label
           move sr-year            to lnk-sd-year
           perform varying   idx from 1 by 1 until idx > 5
              move sr-author(idx)  to lnk-sd-author(idx)
           end-perform
           .

       OPEN-FILE.
           set declaratives-off to true
           evaluate true
           when open-io
                open i-o songs
           when open-input
                open input songs
           end-evaluate.

       CLOSE-FILE.
           close songs.

       INIT-DATA.
           open output songs
           perform varying idx from 1 by 1 until idx > 20 
              move idx to sr-id
              move ist-item(idx)   to sr-data
              write songs-record
           end-perform.

           close songs
           evaluate true
           when open-io
                open i-o songs
           when open-input
                open input songs
           end-evaluate.


