      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       program-id. openhook.
       working-storage section.
       copy "iscobol.def".   
       77  cont                                pic 99.
       77  env-code                            pic 9.
       01                                      pic 9.
           88 temp-folder                      value 1 false 0.
       01                                      pic 9 value 1.
           88 first-time                       value 1 false 0.
       77  th-id                               pic 9(10).
       77  th-id-ed                            pic z(10).
       01  cblt-splitjoin-buf.
           03 cblte-sj-param-length            pic x(2) comp-x.
           03 cblte-sj-split-join-flag1        pic x comp-x.
           03 cblte-sj-split-join-flag2        pic x comp-x.
           03 cblte-sj-device-offset           pic x(2) comp-x.
           03 cblte-sj-device-length           pic x(2) comp-x.
           03 cblte-sj-basename-offset         pic x(2) comp-x.
           03 cblte-sj-basename-length         pic x(2) comp-x.
           03 cblte-sj-extension-offset        pic x(2) comp-x.
           03 cblte-sj-extension-length        pic x(2) comp-x.
           03 cblte-sj-total-length            pic x(2) comp-x.
           03 cblte-sj-split-buf-len           pic x(2) comp-x.
           03 cblte-sj-join-buf-len            pic x(2) comp-x.
           03 cblte-sj-first-component-length  pic x(2) comp-x.
       77  wrk-path                            pic x any length.
       77  wrk-basename                        pic x any length.
       77  wrk-extension                       pic x any length.
       77  wrk-path-separator                  pic x any length.
       77  listdir-Handle                      usage handle.
       77  ret-code                            pic s9.

       linkage section.
       77  file-path   pic x(300).
       77  file-class  pic x(300).

       procedure division using file-path, 
                                file-class.

       main.
      *    check the execution environment and retrieve the 
      *    Thread ID (TID) only at the first run
           if first-time
              call "C$GETRUNENV" GIVING env-code

              evaluate env-code
              when runenv-thin-client
              when runenv-web-client
                   call "A$GETTHREAD" giving th-id
                   move th-id   to th-id-ed
              end-evaluate
              set first-time to false
           end-if

      *    check if the file is inside the temp folder
           perform CHECK-TEMP-FOLDER

      *    if the file is into the temp folder, check if an open mode  
      *    change is needed
           if temp-folder

      *    if running in a "remote" environment, change the path
      *    in order to add a subfolder where the name is the TID of the
      *    running thread
              call "C$GETRUNENV" GIVING env-code

              evaluate env-code
              when runenv-thin-client
              when runenv-web-client
                   perform ADD-TID-TO-PATH
              end-evaluate

      *    If using easydb, force the ISAM format for the file instead
              if file-class = "com.iscobol.io.DynamicEasyDB"
                 move "com.iscobol.io.DynamicJIsam" to file-class
              end-if

           end-if

           goback.

       CHECK-TEMP-FOLDER.
      *    split the file-path variable received from the linkage
      *    into the path and the base name of the file
           set cblte-sj-param-length     to size of cblt-splitjoin-buf
           set cblte-sj-split-buf-len    to size of file-path
           move b#10                     to cblte-sj-split-join-flag1
           call "CBL_SPLIT_FILENAME" using cblt-splitjoin-buf
                                           file-path

           initialize wrk-path
                      wrk-basename
                      wrk-extension

           if cblte-sj-device-length > 0
              move file-path 
                       (cblte-sj-device-offset:cblte-sj-device-length)
                                    to wrk-path
              move file-path 
                       (cblte-sj-device-length:1)
                                    to wrk-path-separator
           end-if
           if cblte-sj-basename-length > 0
              move file-path
              (cblte-sj-basename-offset:cblte-sj-basename-length)
                                    to wrk-basename
           end-if
           if cblte-sj-extension-length > 0
               move file-path
               (cblte-sj-extension-offset:cblte-sj-extension-length)
                                  to wrk-extension
           end-if

      *    For this sample check if the term "tmp" string appears in
      *    the name.
      *    Adjust the following condition in order to fit the rules of 
      *    your environment
           initialize cont
           inspect function lower-case (wrk-path) 
                                      tallying cont for all "tmp"
           if cont > 0
              set temp-folder   to true
           else
              set temp-folder   to false
           end-if.
           

       ADD-TID-TO-PATH.
       
      *    Add a subfolder with name equals to the TID to the path
           string wrk-path                  delimited by trailing space
                  "TID-"                    delimited by size
                  function triml(th-id-ed)  delimited by size
                  into wrk-path 

      *    Check if the folder exists
           call "C$LIST_DIRECTORY" using listdir-open 
                                         wrk-path 
                                         "*"
                                  giving listdir-Handle
                        
           if listdir-Handle = 0
      *    Create the folder if it does not exists
              call "C$MAKEDIR" using wrk-path
                              giving ret-Code
           else
              call "C$LIST_DIRECTORY" USING LISTDIR-CLOSE 
                                            listdir-Handle
           end-if
           .

      *    Update the full path of the file
           initialize file-path
           string wrk-path            delimited by trailing space
                  wrk-path-separator  delimited by size
                  wrk-basename        delimited by size
                  into file-path
           if wrk-extension not = space
              string file-path  delimited by trailing space
                  "."           delimited by size
                  wrk-extension delimited by size
                  into file-path
           end-if
           .