      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. laf-comparison.

       WORKING-STORAGE SECTION.
       copy "iscrt.def".
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5). 
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  window-background-color pic s9(9).
       77  window-foreground-color pic s9(9).
       77  hEf                     handle of entry-field.

       SCREEN SECTION.
       01  Mask.     
           03 label
              line                 2
              col                  2
              size                 8 cells
              title                "Title:"
              .
           03 Ef1 
              entry-field    
              line                 2
              col                  12
              size                 54 cells
              id                   1001
              .
           03 label
              line                 4 
              col                  2
              size                 8 cells
              title                "Length:"
              .
           03 Ef2
              entry-field
              line                 4
              col                  12
              size                 54 cells
              .
           03 label
              line                 6
              col                  2
              size                 8 cells
              title                "Artist:"
              .
           03 Ef3
              entry-field
              line                 6
              col                  12
              size                 54 cells
              .
           03 label
              line                 8
              col                  2
              size                 8 cells
              title                "Genre:"
              .
           03 Ef4
              entry-field
              line                 8
              col                  12
              size                 54 cells
              .
           03 label
              line                 10
              col                  2
              size                 8 cells
              title                "Label:"
              .
           03 Ef5
              entry-field    
              line                 10
              col                  12
              size                 54 cells
              .
           03 label
              line                 12
              col                  2
              size                 8 cells
              title                "Year:"
              .
           03 Ef6
              entry-field
              line                 12
              col                  12
              size                 54 cells
              .
           03 check-box
              line                 14
              col                  2
              size                 13 cells
              title                "Hit:"
              left-text
              left-text-alignment  1
              .
           03 label
              line                 16
              col                  2
              size                 8 cells
              title                "Streaming:"
              .
           03 radio-button
              line                 16
              col                  12
              title                "Yes"
              group                1
              group-value          1
              value                1
              .
           03 radio-button
              line                 16
              col                  20
              title                "No"
              group                1
              group-value          2
              .
           03 Pb-exit
              push-button
              line                 20 
              col                  62 
              size                 8 cells
              title                "Exit" 
              exception-value      27
              .

       PROCEDURE DIVISION.
       MAIN.
           set environment "gui.native_style"  to "1"

           call "J$GETFROMLAF" using jget-laf-color
                               "Panel.background"
                               window-background-color.
           call "J$GETFROMLAF" using jget-laf-color
                               "Panel.foreground"
                               window-foreground-color.  
           call "J$GETFROMLAF" using jget-laf-font
                               "Label.font"
                               control-font.

           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "LAF comparison"
                   background-color window-background-color
                   foreground-color window-foreground-color
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           display Mask

           perform BUILD-MENU

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue
              end-accept

              move control-handle to hEf
              evaluate crt-status
              when 2001 
                   perform CUT-TEXT
              when 2002 
                   perform COPY-TEXT
              when 2003 
                   perform PASTE-TEXT
              end-evaluate

              move 4 to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .
        
       COPY-TEXT.
           modify hEf action action-copy
           .

       CUT-TEXT.
           modify hEf action action-cut
           .

       PASTE-TEXT.
           modify hEf action action-paste
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       BUILD-MENU.
           call "w$menu" using wmenu-new giving menu-handle.
           call "w$menu" using wmenu-new giving sub-handle-1.
           call "w$menu" using wmenu-add, menu-handle, 0, 0, "&File"
                               1000, sub-handle-1.
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0, "&Quit"
                               27.

           call "w$menu" using wmenu-new giving sub-handle-1.

           call "w$menu" using wmenu-add, menu-handle, 0, 0, "&Edit"
                               2000, sub-handle-1.
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0, "&Cut"
                               2001.
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0, "&Copy"
                               2002.
           call "w$menu" using wmenu-add, sub-handle-1, 0, 0, "&Paste"
                               2003.

           call "w$menu" using wmenu-show, menu-handle.
