      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION.

       CLASS-ID. MYCALLHANDLER as "MYCALLHANDLER" 
                               implements jCallHandler.

       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.

       REPOSITORY.
           class JObjects       as "java.lang.Object[]"
           class Jboolean       as "boolean"
           class JClass         as "java.lang.Class"
           class JString        as "java.lang.String"
           class jIscobolCall   as "com.iscobol.rts.IscobolCall"
           class jCallOverflowException 
                             as "com.iscobol.rts.CallOverflowException"
           class jCallHandler   as "com.iscobol.rts.CallHandler"
           class mapcallexception as 
                "com.iscobol.rts.MapCallException"
           class jWithName      as "com.iscobol.rts.WithName"
           class jexception     as "java.lang.Exception"
           class picx           as "com.iscobol.types.PicX"
           class pic9           as "com.iscobol.types.NumericVar"
           .

       IDENTIFICATION DIVISION.
       FACTORY.
       WORKING-STORAGE SECTION.
       PROCEDURE DIVISION.

       END FACTORY.

       IDENTIFICATION DIVISION.
       OBJECT.
       WORKING-STORAGE SECTION.
       PROCEDURE DIVISION.
       
      *    This method is executed before the execution of each called  
      *    program
       IDENTIFICATION DIVISION.
       METHOD-ID. IS-BEFORECALL AS "beforeCall" OVERRIDE.

       WORKING-STORAGE SECTION.
       77  class-name object reference JString.
       77  narg        pic 9(3).
       77  parx        object reference picx.
       77  par9        object reference pic9.

       LINKAGE SECTION.
       77  iscobol-call object reference jIscobolCall.
       77  j-objects    object reference JObjects.

       PROCEDURE DIVISION USING iscobol-call, j-objects 
                        RAISING jCallOverflowException.

       MAIN.
           display " "
           set class-name to self:>getName(iscobol-call)

           evaluate true
           when class-name:>startsWith("com.iscobol.lib")
      *    This is for the iscobol library routine
                display "HOOK program:  "
                        "Before execution of '"
                        class-name:>substring(16)
                        "' library routine"
                        upon sysout
           when class-name = "CALLEDPROG2"
      *    For a specifc program (CALLEDPROGRAM2) I'll manipulate the 
      *    parameter, uppercase for character paramter or add 1 to 
      *    numeric paramter. Also I'll call a different program
                display "HOOK program:  "
                        "Before execution of '" 
                        class-name 
                        "' program"
                        upon sysout
                display "List of paramter: "
                        upon sysout
 
                set narg  to j-objects:>length()
                perform varying i as "int" from 0 by 1 until i = narg
                   if picx:>class:>isInstance(j-objects(i))
                      display "Pameter " i upon sysout
                      set parx to j-objects(i) as picx
                      display "Original value: " parx upon sysout
                      move function upper-case(parx) to parx
                      display "new value: " parx upon sysout
                   end-if
                   if pic9:>class:>isInstance(j-objects(i))
                      display "Pameter " i upon sysout
                      set par9 to j-objects(i) as pic9
                      display "Original value: " par9 upon sysout
                      add 1 to par9
                      display "New value: " par9 upon sysout
                   end-if
               end-perform               
               raise mapcallexception:>new("CALLEDPROG2-NEW", j-objects)
           when other
      *    For the other call I'll make only a debug display
              display "HOOK program:  "
                      "Before execution of '" 
                      class-name 
                      "' program"
                      upon sysout

           end-evaluate.


      *     if class-name:>startsWith("com.iscobol.lib")
      *        display "HOOK program:  "
      *                "Before execution of '"
      *                class-name:>substring(16)
      *                "' library routine"
      *                upon sysout
      *     else
      *        display "HOOK program:  "
      *                "Before execution of '" 
      *                class-name 
      *                "' program"
      *                upon sysout
      *     end-if
           .
       END METHOD.

      *    This method is executed at the end of the excution of each 
      *    program
       IDENTIFICATION DIVISION.
       METHOD-ID. IS-AFTERCALL as "afterCall" OVERRIDE.

       WORKING-STORAGE SECTION.
       77  class-name object reference JString.

       LINKAGE SECTION.
       77  iscobol-call   object reference jIscobolCall.
       77  j-lang-object  object reference JObjects.

       procedure division using iscobol-call j-lang-object 
                        raising jCallOverflowException.

       MAIN.
           set class-name to self:>getName(iscobol-call)
           if not class-name:>equals("HOOK_LAST")
              display " "
              if class-name:>startsWith("com.iscobol.lib")
                 display "HOOK program:  "
                         "After execution of '"
                         class-name:>substring(16)
                         "' library routine"
                        upon sysout
             else
                display "HOOK program:  "
                        "After execution of '" 
                        class-name 
                        "' program"
                        upon sysout
             end-if
           end-if.
       end method.

      *    This method is executed before the cancel statement of a  
      *    specific program
       IDENTIFICATION DIVISION.

       METHOD-ID. IS-BEFORECANCEL AS "beforeCancel" OVERRIDE.

       WORKING-STORAGE SECTION.
       77  return-field object reference jboolean.
       77  class-name object reference JString.

       LINKAGE SECTION.
       77 iscobol-call object reference jIscobolCall.

       PROCEDURE DIVISION USING iscobol-call 
                      RETURNING return-field.

       MAIN.
           set class-name to self:>getName(iscobol-call)
           display " "
           display "HOOK program:  "
                   "Before cancel of '" 
                   class-name 
                   "' program"
                   upon sysout.
           set RETURN-FIELD to true.
       END METHOD.

      *    This method is executed after the cancel statement of a  
      *    specific program
       IDENTIFICATION DIVISION.
       METHOD-ID. IS-AFTERCANCEL AS "afterCancel" OVERRIDE.

       WORKING-STORAGE SECTION.
       77  class-name object reference JString.

       LINKAGE SECTION.
       77  iscobol-call object reference jIscobolCall.

       PROCEDURE DIVISION USING iscobol-call.

       MAIN.
           set class-name to self:>getName(iscobol-call)
           display " "
           display "HOOK program:  "
                   "After cancel of '" 
                   class-name 
                   "' program"
                   upon sysout.
       end method.

      *    This method is executed before the cancel all statement 
       IDENTIFICATION DIVISION.

       METHOD-ID. IS-BEFORECANCELALL AS "beforeCancelAll" OVERRIDE.

       WORKING-STORAGE SECTION.
       77  return-field object reference jboolean.

       PROCEDURE DIVISION RETURNING return-field.

       MAIN.
           display " "
           display "HOOK program:  "
                   "Before cancel all" 
                   upon sysout.
           set return-field to true.
       end method.

      *    This method is executed after the cancel all statement 
       IDENTIFICATION DIVISION.
       METHOD-ID. IS-AFTERCANCELALL as "afterCancelAll" OVERRIDE.

       WORKING-STORAGE SECTION.
       PROCEDURE DIVISION.

       MAIN.
           display " "
           display "HOOK program:  "
                   "After CANCEL ALL" 
                   upon sysout.
       end method.

      *    This method is not exposed, it's internally used by the other  
      *    methods of this class
       IDENTIFICATION DIVISION.
       METHOD-ID. IS-GETNAME AS "getName" PRIVATE.

       WORKING-STORAGE SECTION.
       77  obj        object reference.
       77  objwn      object reference jWithName.
       77  class-name object reference JString.
 
       LINKAGE SECTION.
       77  iscobol-call OBJECT REFERENCE jIscobolCall.

       PROCEDURE DIVISION USING iscobol-call              
                      RETURNING class-name.                      
       MAIN.
           set obj to iscobol-call
           try
              if JClass:>forName("com.iscobol.rts.WithName")
                       :>isAssignableFrom(obj:>getClass())
                 set objwn to obj as jWithName      
                 set class-name to objwn:>getName()     
              else
                 set class-name to obj:>getClass():>getName()
              end-if
           catch exception
              exception-object:>printStackTrace()
              stop run
           end-try
           .
       END METHOD.


       END OBJECT.
