
##### isCOBOL release 2025 R2 build#1158.10-20251128-41083 ######
##### Copyright (c) 2005 - 2025 Veryant. ######

----------
**This sample will show how to call isCOBOL from different Java thread using the isCOBOL**
**CobolVarHelper class. It also shows how the environment variables are shared between**
**Java and isCOBOL.**

**MainEnvIsolated.java run two COBOL programs in thread having a separate environment for each,**
**as the setEnv is done in the Runnable code.**

**MainEnvShared.java run two COBOL programs in thread having the same environment for each through**
**the new methods duplicateIscobolEnv and destroyIscobolEnv.**

**This document assumes the $ISCOBOL environment variable exists and points**
**to the isCOBOL SDK installation folder, and the $ISCOBOL_JDK_ROOT environment**
**variable exists and points to the JDK installation folder**

**When talking about a "command prompt window" it means an isCOBOL Shell**
**on the Windows OS and a standard shell on Linux/Unix**

**When running this on Unix/Linux make sure to have iscobol.jar in CLASSPATH**

----------
 - 1 Using a command prompt window go to the 
     "$ISCOBOL/sample/is-java/java-call-iscobol/multithread" folder.

 - 2 Compile the Java programs

        "$ISCOBOL_JDK_ROOT/bin/javac" *.java 

 - 3 Compile the COBOL programs

        iscc *.cbl 

 - 4 Run the java program with isolated environment

        "$ISCOBOL_JDK_ROOT/bin/java" MainEnvIsolated 

 - 5 Run the java program with shared environment

        "$ISCOBOL_JDK_ROOT/bin/java" MainEnvShared

 **NOTE:**

    This test depends by hardware performances, so it could take some minutes to be completed.

 **NOTE:**

    To run the COBOL part of this sample in debug, take these steps:
    - add the option "-d" or "-dx" during compilation
    - create a new iscobol.properties file
    - add iscobol.rundebug=2 to iscobol.properties file
    - optionally add iscobol.debug.port=<port-number> 
    - execute the remote debugger with the following command
      iscrun -d -r <host-name> <port-number>
      from sample/is-java/java-call-iscobol/cobolvarhelper folder before executing
      the java program

 **NOTE:**

    If you need to compile the COBOL program with the -cp option, modify the java source code
    in order to use 'static int opt = CobolVarHelper._CP;' otherwise use 'static int opt = 0;'
