      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       IDENTIFICATION DIVISION.

       PROGRAM-ID. IWC-PANEL.

       ENVIRONMENT DIVISION.

       CONFIGURATION SECTION.
       REPOSITORY.
           class jsonStream    as "com.iscobol.rts.JSONStream"
           class JString       as "java.lang.String"
           class string-buffer as "java.lang.StringBuffer"
           .

       INPUT-OUTPUT SECTION.

       DATA DIVISION.

       FILE SECTION.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".
       copy "isresize.def".

       77  objJsonStream           object reference jsonStream.
       77  objString               object reference JString.
       77  strbuffer               object reference string-buffer.

       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9      value 0. 

       78  78-iwc-crt-status       value 1001.

       01  offices occurs dynamic capacity office-length 
                                      identified by "offices".
           05 filler                  identified by "description".
              10 description          pic x any length.
           05 filler                  identified by "address".
              10 office-address       pic x any length.
           05 filler                  identified by "lat".
              10 lat                  pic s9(3)v9(7).
           05 filler                  identified by "lng".
              10 lng                  pic s9(3)v9(7).

       01  selected-office            identified by "office".
           05 filler                  identified by "description".
              10 sel-description      pic x any length.
           05 filler                  identified by "address".
              10 sel-office-address   pic x any length.
           05 filler                  identified by "lat".
              10 sel-lat              pic s9(3)v9(7).
           05 filler                  identified by "lng".
              10 sel-lng              pic s9(3)v9(7).

       77  office-index               pic 9(3) value 0.

      *    WebClient comm. struct.
       01  iwc-struct.
           03 iwc-action              pic x any length.
           03 iwc-data                pic x any length.
           03 iwc-bytes               pic x any length.
           
       77  msg                        pic x any length.

       77  env-code                   pic 9.

       77  selected-office-name       pic x any length.

       01  fmap-struct.
           03 fmap-ACTION             PIC X any length.
           03 fmap-DATA               PIC X any length.
           03 fmap-BYTES              PIC X any length.
       
       77  v-office-details           pic 9.
       
       01                             pic 9.
           88 check-ok                value 1 false 0.

       77  returncode                 pic s99.

       screen section.
       01  Mask.
           03 lbl-office 
              Label
              line                 2
              column               2
              size                 15 cells 
              title                "Select an office:"
              .
           03 cb-office 
              Combo-Box
              line                 2
              column               16
              size                 30 cells 
              drop-list
              unsorted
              notify-selchange
              event procedure      CB-OFFICE-EVT-PROC
              .
           03 f-map
              iwc-panel
              line                 5
              column               2
              size                 68 cells 
              lines                15 cells 
              js-name              "f-map"
              value                fmap-struct
              event procedure      fmap-proc
              .
           03 office-details
              visible              v-office-details
              .
              05 f-info 
                 Frame
                 line              1
                 column            48
                 size              22 cells 
                 lines             18 cells 
                 .
              05 pb-close-info 
                 Push-Button
                 line              2
                 column            66
                 size              3 cells 
                 lines             1.5 cells 
                 title             "X"
                 exception-value   100
                 .
              05 lbl-selected-office 
                 Label
                 line              2
                 column            49
                 title             "Selected office"
                 .
              05 ef-office-description 
                 Entry-Field
                 line              4
                 column            49
                 size              20 cells 
                 lines             2.5 cells
                 multiline 
                 read-only 
                 .
              05 ef-office-address 
                 Entry-Field
                 line              7
                 column            49
                 size              20 cells 
                 lines             6 cells 
                 multiline
                 read-only 
                 .
              05 ef-office-lat 
                 Entry-Field
                 line              14
                 column            49
                 size              12 cells 
                 read-only 
                 .
              05 ef-office-lng 
                 Entry-Field
                 line              16
                 column            49
                 size              12 cells
                 read-only 
                 .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.
           move 0   to v-office-details
           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display independent window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "IWC-PANEL Control"
                   control font control-font
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   handle hWin
                   system menu
                   event  WIN-EVT

           move 0   to crt-status
                       close-win
           call "C$GETRUNENV" GIVING env-code
           if env-code not = runenv-web-client
              display message 
                    "This sample works only in Web Client environment"
                      icon mb-warning-icon
              destroy hWin
              goback
           end-if

           display mask.
           
           call "IWC$INIT" using 78-iwc-crt-status 
                          giving returncode
           if returncode not = 0
              display message "Failed to activate IWC comunication"
              goback
           end-if.

           perform CHECK-JS.

           perform INIT-OFFICES.

           perform INIT-COMBO.

           perform SEND-OFFICES.

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 100
                   perform HIDE-DETAILS
              end-evaluate
              move 4   to accept-control
           end-perform
          
           call "IWC$STOP" giving returncode

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       CHECK-JS.
           set check-ok   to true

           initialize iwc-struct.
           move "CheckJS" to iwc-action
           call "IWC$SEND" using iwc-struct
                          giving returncode

           if returncode not = 0
              set check-ok   to false
              move "Failed to send IWC comunication"   to msg
           else
      *    I'm waitng for the JS answer
              call "IWC$GET" using iwc-struct
                                   150
                            giving returncode
              evaluate returncode
              when 0
                   if iwc-action = "CheckOK"
                      set check-ok   to true
                   else
                      move "Wrong JS"   to msg
                      set check-ok      to false
                   end-if
              when -1
                   move "Failed to receive IWC comunication"   to msg
                   set check-ok   to false
              when 99
                   move "IWC comunication timeout"   to msg
                   set check-ok   to false
              end-evaluate
           end-if.

           if not check-ok 
              display message msg
              destroy hWin
              goback
           end-if.

       INIT-COMBO.
            perform varying office-index from 1 by 1 until 
                                            office-index > office-length
              modify cb-office item-to-add description(office-index)
           end-perform.
           modify cb-office value description(1).

       CB-OFFICE-EVT-PROC.
           if event-type = ntf-selchange 
              move event-data-1 to office-index
              perform SET-SELECTED-OFFICE-INFO
              perform SHOW-DETAILS
              perform SHOW-ON-MAP
           end-if
           .

       SET-SELECTED-OFFICE-INFO.
      *    move selected office info to data structure
           move description(office-index)      to sel-description 
           move office-address(office-index)   to sel-office-address 
           move lat(office-index)              to sel-lat 
           move lng (office-index)             to sel-lng 
           modify cb-office value = description(office-index)
               
      *    set selected office frame fields
           modify ef-office-description value description (office-index).
           modify ef-office-address value office-address (office-index).
           modify ef-office-lat value lat(office-index).
           modify ef-office-lng value lng(office-index).
           .

       SEND-OFFICES.
           set objJsonStream  to jsonStream:>new(offices(1), 1);;

           set strbuffer to string-buffer:>new;;
           objJsonStream:>writeToStringBuffer(strbuffer)
           move strbuffer:>toString to iwc-data

           move "addOffices" to fmap-action.
           move strbuffer:>toString to fmap-data.
           modify f-map value fmap-struct.

       SHOW-ON-MAP.
           move "selectOffice"        to fmap-action.
           move offices(office-index) to selected-office.
           
           set objJsonStream to jsonStream:>new(selected-office, 1);;

           set strbuffer     to string-buffer:>"new"
           objJsonStream:>writeToStringBuffer(strbuffer)
           move strbuffer:>toString to fmap-data
           modify f-map value fmap-struct.  

       SHOW-DETAILS.
           move 1   to v-office-details
           display office-details 
           modify f-map size 45 cells.

       HIDE-DETAILS.
           move "closeDetails" to fmap-action
           modify f-map value fmap-struct.  
           move 0   to v-office-details
           display office-details 

           modify f-map size 68 cells.

       FMAP-PROC.
           if event-type = ntf-iwc-event
              inquire f-map value in fmap-struct
              evaluate fmap-action 
              when "pinClicked"
                   move fmap-data to sel-description 
                   perform SEARCH-OFFICE
                   perform SET-SELECTED-OFFICE-INFO
                   perform SHOW-DETAILS
              when "pinClosed"
                   perform HIDE-DETAILS
              when other 
                   string "INQUIRE IWC-PANEL VALUE: IWC-ACTION = '" 
                          fmap-action 
                          "', IWC-DATA = '" fmap-data
                          "', IWC-BYTES = '" fmap-bytes "'"
                          delimited size 
                          into msg
                   display message msg
              end-evaluate
           end-if.

       SEARCH-OFFICE.
           perform varying office-index from 1 by 1 
                          until office-index > office-length or
                                description of offices(office-index) = 
                                sel-description 
              continue
           end-perform
           .

       INIT-OFFICES.
           move 1 to office-index.

           move "Veryant LLC"         to description (office-index).
           move "6390 Greenwich Dr. #225, San Diego, CA 92122"
                                      to office-address(office-index).
           move 32.825069             to lat(office-index).
           move -117.118674           to lng(office-index).
           
           add 1                      to office-index,
           move "Veryant Italia s.r.l." 
                                      to description(office-index).
           move "Via Pirandello 29, 29121 Piacenza, Italy" 
                                      to office-address(office-index).
           move 45.0480593            to lat(office-index).
           move 9.6594815             to lng(office-index).

           add 1                      to office-index
           move "Veryant France"      to description(office-index).
           move "Le Kern, All�e Nolis 2474 RN 7 06270 Villeneuve-loubet,
      -          " France"            to office-address(office-index).
           move 43.6274843            to lat(office-index).
           move 7.1281879             to lng(office-index).

           add 1                      to office-index
           move "Veryant Deutschland GmbH" 
                                      to description(office-index).
           move "Blumenstra�e 14 D-73779 Deizisau, Deutschland" 
                                      to office-address(office-index).
           move 48.71426              to lat(office-index).
           move  9.39161              to lng(office-index).

           add 1                      to office-index
           move "Interon Informatica" to description(office-index).
           move "Rua Apucarana 272, 3� floor 03311-000 Sa� Paulo SP, Bra
      -          "zil              "  to office-address(office-index).
           move -23.5407846           to lat(office-index).
           move -46.5672545           to lng(office-index).

           add 1                      to office-index
           move "Inside - Inform�tica e Sistemas, L.da" 
                                      to description(office-index).
           move "Rua Principal, 2, Cabanas de Torres" 
                                      to office-address(office-index).
           move 39.1464952            to lat(office-index).
           move -9.0614804            to lng(office-index).

           add 1                      to office-index
           move "ChannelMaker Technology Corporation" 
                                      to description(office-index).
           move "115 Emei Street, Taipei City 108, Taiwan" 
                                      to office-address(office-index).
           move 25.044442             to lat(office-index).
           move 121.503676            to lng(office-index).

           add 1                      to office-index
           move "Veryant Northern"    to description(office-index).
           move "O.T. Bjanes Vei 7b 1352 Kols�s, Norge" 
                                      to office-address(office-index).
           move 59.9034461            to lat(office-index).
           move 10.488617             to lng(office-index).

           add 1                      to office-index
           move "Arise Innovation, Inc" 
                                      to description(office-index).
           move "Kachidoki 3-13-1, Chuo-ku, Tokyo, Japan" 
                                      to office-address(office-index).
           move 35.6580043            to lat(office-index).
           move 139.772408            to lng(office-index).

           add 1 to office-index,
           move "Cloud Tech, S.L."    to description(office-index).
           move "Parque Nicol�s Salmer�n 33 04002 Almer�a, Espa�a" 
                                      to office-address(office-index).
           move 36.8373983            to lat(office-index).
           move -2.4730287            to lng(office-index).

           add 1                      to office-index,
           move "Dorsett Retail Systems" 
                                      to description(office-index).
           move "196 Greenhill Road, 5Eastwood, SA, Australia 5063" 
                                      to office-address(office-index).
           move -34.9408023           to lat(office-index).
           move 138.614853            to lng(office-index).

           add 1                      to office-index
           move "ProRM"               to description(office-index).
           move "Luis A. de Herrera 1248. Torre 1 Oficina 1001, Montevid
      -         "eo, Uruguay"         to office-address(office-index).
           move -34.9046685           to lat(office-index).
           move -56.1389565           to lng(office-index).

           add 1                      to office-index,
           move "Viking Global CO., LTD" 
                                      to description(office-index).
           move "3rd FL, Jongam-ro 100, Seongbuk-gu, Seoul, Korea." 
                                      to office-address(office-index).
           move 37.5990587            to lat(office-index).
           move 127.0325322           to lng(office-index).

           add 1                      to office-index,
           move "Digital Dinamika"    to description(office-index).
           move "1512 1 Jalan SS 20/27 , Damansara Utama, 47400 Petaling
      -         "Jaya, Selangor, Malaysia." 
                                      to office-address(office-index).
           move 3.1302184             to lat(office-index).
           move 101.6268134           to lng(office-index).

