      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CLOCKPID2.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select file1 assign to path-file1
           organization indexed
           access dynamic
           record key f1-cod
           status file-status
           .

       FILE SECTION.

       FD  file1.
       01  f1-rec.
           03 f1-cod               pic 9(9).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  file-status             pic x(2).
       77  path-file1              pic x any length.
       
       78  78-no-lock              value "No Lock".
       78  78-record-locked        value "Record Locked".
       78  78-file-locked          value "File Locked".

       77  lb-status-title         pic x(30) value 78-no-lock.

       77  base-sorg-path          pic x(20). 
       77  command                 pic x(100).

       01  last-lock               pic x.
           88 rec-lock             value "R".
           88 file-lock            value "F".
           88 no-lock              value "N".

       SCREEN SECTION.
       01  Mask.
           03  lb-status
               label
               line                3 
               col                 2
               title               lb-status-title 
               .
           03  push-button
               line                5 
               col                 2
               size                14 cells
               title               "Lock Record" 
               exception-value     101
               .
           03  push-button
               line                7
               col                 2
               size                14 cells
               title               "Lock File" 
               exception-value     102
               .
           03  push-button
               line                9
               col                 2
               size                14 cells
               title               "Unlock Record" 
               exception-value     103
               .
           03  push-button
               line                20
               col                 2 
               size                20 cells
               title               "Source code" 
               exception-value     201
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.

       INI.
           set environment "file.index" to "ctreej"
           set environment "file.errors_ok" to 1

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 140
                   title "C$LOCKPID Routine (Lock file)"
                   control font control-font
                   lines 21
                   min-lines 21
                   size 70
                   min-size 70
                   handle hWin
                   event  WIN-EVT

           perform NAME-OF-FILE

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status
              when 101
                   if file-lock
                      close file1
                   end-if
                   open i-o file1
                   move 1   to f1-cod
                   read file1 with lock
                   modify lb-status title 78-record-locked
                   set rec-lock to true
              when 102
                   if rec-lock
                      close file1
                   end-if
                   modify lb-status title 78-file-locked 
                   open exclusive i-o file1
                   set file-lock to true
              when 103
                   evaluate true
                   when rec-lock
                        unlock file1 record
                        close file1
                   when file-lock
                        close file1
                   end-evaluate
                   modify lb-status title 78-no-lock  
                   set no-lock to true
              when 201
                   perform VIEW-SORG
              end-evaluate
              move 4   to accept-control
           end-perform.

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .

       NAME-OF-FILE.
           call  "C$GETENV" USING "user.home"
                                  path-file1.

           string path-file1       delimited by trailing space
                  "/CLOCKPID-FILE" delimited by size
                  into path-file1.

       VIEW-SORG.
           initialize command
           string base-sorg-path      delimited by trailing space
                  "s-routines"        delimited by space
                  "/CLOCKPID2.cbl"    delimited by size
                                      into command.
           call run "TEXTVIEWER"  using command.
