      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. CMAKEDIR.

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              is special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.

       77  wstatus                 pic s9.
       77  dir-name                pic x(256).

       77  rb-value                pic 9.
       01  execution-type          pic X.
           88 standalone-execution value "A".
           88 client-execution     value "C".
           88 server-execution     value "S".
       77  e-remote                pic 9.
       77  e-standalone            pic 9.

       SCREEN SECTION.
       01  Mask.
           03 radio-button 
              line                 2 
              col                  2
              title                "Stand alone"
              group                1
              group-value          1 
              value                rb-value
              exception-value      103
              enabled              e-standalone
              . 
           03 radio-button 
              line                 2 
              col                  17
              title                "Run on Client"
              group                1
              group-value          2
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03 radio-button 
              line                 2 
              col                  34
              title                "Run on Server"
              group                1
              group-value          3
              value                rb-value
              exception-value      103
              enabled              e-remote
              . 
           03  label
               line                04
               col                 02
               title               "Directory to be created" 
               .
           03  ef-dir
               entry-field
               size                68 cells
               line                06 
               col                 02 
               value               dir-name
               .
           03  push-button
               line                8
               col                 2 
               title               "&Create" 
               exception-value     101
               self-act
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.
           accept terminal-abilities from terminal-info.
           if is-remote
              move 1                     to e-remote
              move zero                  to e-standalone
              move 2                     to rb-value
              set client-execution       to true
           else
              move zero                  to e-remote
              move 1                     to e-standalone
              move 1                     to rb-value
              set standalone-execution   to true
           end-if
           perform RETRIVE-USER-HOME-DIR

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low  
                   resizable 
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$MAKEDIR Routine"
                   lines 21 
                   min-lines 21
                   size 70 
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept  Mask
                 on exception
                    continue
              end-accept
              evaluate crt-status 
              when 101
                   perform MAKE-DIR
              when 103
                   if rb-value = 2
                      set client-execution   to true
                   else
                      set server-execution   to true
                   end-if
                   perform RETRIVE-USER-HOME-DIR
                   modify ef-dir value dir-name
              end-evaluate
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           goback
           .
           
       MAKE-DIR.
           evaluate true
           when client-execution
                call client "C$MAKEDIR" using dir-name
                                       giving wstatus
           when standalone-execution
           when server-execution
                call "C$MAKEDIR" using dir-name
                                giving wstatus
           end-evaluate
           evaluate wstatus
           when 0
                display message "Directory successfully created"
                        icon mb-default-icon
           when 1
                display message "Wrong path"
                        icon mb-error-icon
           end-evaluate
           .

       RETRIVE-USER-HOME-DIR.
           evaluate true
           when client-execution
                call client "C$GETENV" USING "user.home"
                                              dir-name
           when standalone-execution
           when server-execution
                call "C$GETENV" USING "user.home"
                                      dir-name
           end-evaluate
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
