      *> Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *> may freely modify and redistribute this program.

       PROGRAM-ID. fullname.

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
       select arc assign to "iss-fullname"
           organization indexed      
           access dynamic
           record key arc-key. 

       FILE SECTION.
       fd  arc.
       01  arc-rec.
           03 arc-key  pic 9(5).
           03 arc-data pic x(100).

       WORKING-STORAGE SECTION.
       copy "isgui.def".
       copy "isfonts.def".
       copy "iscrt.def".
       copy "isopensave.def".
       copy "iscobol.def".   
       copy "isresize.def".
       77  crt-status              special-names crt status pic 9(5).
       77  hWin                    handle of window.
       77  control-font            handle of font.
       77  close-win               pic 9 value 0.
       77  fullname                pic x(256).
       77  fsfullname              pic x(256).
       77  fileprefix              pic x any length.

       SCREEN SECTION.
       01  Mask.
           03  label
               line                03
               col                 03
               title               "File-Control name: "
               .
           03  label
               line                03
               col                 19
               title               "iss-fullname"
               . 

           03  frame
               engraved
               line                05
               col                 02
               lines               07
               size                68
               title               "C$FULLNAME"
               .

           03  label
               line                06 
               col                 03 
               title               "Parameter: "
               . 
           03  label
               line                06 
               col                 19 
               title               "iss-fullname.dat"
               . 
           03  label
               line                08
               col                 03
               title               "Result: "
               . 
           03  entry-field
               read-only
               multiline
               line                08  
               col                 19 
               lines               03 cells
               size                49 cells  
               value               fullname
               .

           03  frame
               engraved
               line                12
               col                 02
               lines               07
               size                68
               title               "C$FSFULLNAME"
               .

           03  label
               line                13
               col                 03 
               title               "Parameter: "
               . 
           03  label
               line                13
               col                 19 
               title               "iss-fullname"
               . 


           03  label
               line                15
               col                 03 
               title               "FSFullname: "
               . 
           03  entry-field
               read-only
               multiline
               line                15  
               col                 19 
               lines               03 cells
               size                49 cells  
               value               fsfullname
               .
           03  Pb-exit  
               push-button
               line                20
               col                 62
               size                8 cells
               title               "Exit" 
               exception-value     27
               .

       PROCEDURE DIVISION.
       MAIN.

           call  "C$GETENV" USING "user.home"
                                  fileprefix.

           string fileprefix delimited by trailing space
                  x"0A"      delimited by size
                  "."        delimited by size
                  into fileprefix
           set environment "file.prefix" to fileprefix.

           set environment "file.index" to "jisam".

           set environment "file.errors_ok" to "1".
           open output arc
           close arc
           set environment "file.errors_ok" to "0".
 
           call "C$FULLNAME"   using "iss-fullname.dat", 
                                     fullname.
           call "C$FSFULLNAME" using "iss-fullname", 
                                     fsfullname.

           call "CUST_FONT" using control-font
              on exception
                 set control-font to default-font
           end-call
           display standard graphical window
                   background-low
                   resizable
                   layout-manager lm-zoom
                   line 2
                   col 65
                   title  "C$FULLNAME and C$FSFULLNAME Routines"
                   lines 21
                   min-lines 21
                   size 70
                   min-size 70
                   control font control-font  
                   handle hWin 
                   event  WIN-EVT

           display Mask

           perform until crt-status = 27 or close-win = 1
              accept Mask
                 on exception 
                    continue
              end-accept
              move 4   to accept-control
           end-perform

           destroy Mask
           destroy hWin
           destroy control-font
           delete file arc
           goback
           .

       WIN-EVT.
           evaluate event-type
           when cmd-close
                move 1 to close-win
           when msg-close
                move event-action-fail-terminate  to event-action 
                move 1 to close-win
           end-evaluate
           .
