      *    Copyright (c) 2005 - 2025 Veryant. Users of isCOBOL
      *    may freely modify and redistribute this program.
      
       PROGRAM-ID. ISCUSTOMER.
       configuration section.
       special-names.   

       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           copy "customer.sl".
       DATA DIVISION.
       FILE SECTION.
           copy "customer.fd".

       WORKING-STORAGE SECTION.
           copy "common.wrk".
           copy "color.wrk".
           copy "iwc.wrk".
           copy "iwc.lks".
           copy "lookup.lks".
           copy "maps.lks".

       77  STATUS-Customer   PIC XX.

       01  screen-value.
           05 scr-id            pic  x(10).
           05 scr-fname         pic  x(20).
           05 scr-lname         pic  x(50).
           05 scr-tel1          pic  x(20).
           05 scr-tel2          pic  x(20).
           05 scr-fax           pic  x(20).
           05 scr-addr          pic  x(100).
           05 scr-latitude      pic s9(3)v9(7).
           05 scr-longitude     pic s9(3)v9(7).
           05 scr-contact       pic  x(20).
           05 scr-email         pic  x(30).

       78  id-ef-scr-id         value 100.
       78  id-ef-scr-fname      value 101.
       78  id-ef-scr-lname      value 102.
       78  id-ef-scr-tel1       value 103.
       78  id-ef-scr-tel2       value 104.
       78  id-ef-scr-fax        value 105.
       78  id-ef-scr-addr       value 106.
       78  id-ef-scr-longitude  value 107.
       78  id-ef-scr-latitude   value 108.
       78  id-ef-scr-contact    value 109.
       78  id-ef-scr-email      value 110.

       01                       pic 9.
           88 all-ok            value 1 false zero.

       77  choice               pic x.
       77  wrk-customer         pic x(10).
       77  cont                 pic 9(3).

       screen section.
       01  mask-main.
           05 frame 
              raised
              line 1
              col 2
              lines 3 cells
              size 106 cells
              high-color rgb 78-frame-backback-color
              low-color rgb 78-frame-backback-color
              gradient-color-1 rgb 78-frame-backback-color
              gradient-color-2 rgb 78-frame-backback-color
              transparent
              .
           05 Label, 
              col 3
              line 2
              title r"Customer_id"
              transparent
              .
           05 Label
              col 3
              line 5
              title r"First_Name"
              transparent
              .
           05 Label
              col 3
              line 7
              title r"Last_Name"
              transparent
              .
           05 Label
              col 3
              line 9
              title r"Telephone_1"
              transparent
              .
           05 Label
              col 3
              line 11
              title r"Telephone_2"
              transparent
              .
           05 Label
              col 3
              line 13
              title r"Fax"
              transparent
              .
           05 Label
              col 3
              line 15
              title r"Address"
              transparent
              .
           05 Label
              col 3
              line 17
              title r"Longitude"
              transparent
              .
           05 Label
              col 40
              line 17
              title r"Latitude"
              transparent
              .
           05 Label
              col 3
              line 19
              title r"Contact"
              transparent
              .
           05 Label
              col 3
              line 21
              title r"E-mail"
              transparent
              .
           05 ef-scr-id 
              entry-field
              col 21 
              line 2
              size 10
              max-text 10
              id id-ef-scr-id
              value scr-id
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              after AFT-EF-SCR-ID
              .
           05 ef-scr-fname 
              entry-field, 
              col 21
              line 5
              size 85
              max-text 20
              value scr-fname
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              id id-ef-scr-fname
              .
           05 ef-scr-lname 
              entry-field, 
              col 21
              line 7
              size 85
              max-text 50
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              value scr-lname
              id id-ef-scr-lname
              .
           05 ef-scr-tel1 
              entry-field, 
              col 21
              line 9
              size 85
              max-text 15
              value scr-tel1
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              id id-ef-scr-tel1
              .
           05 ef-scr-tel2 
              entry-field, 
              col 21
              line 11
              size 85
              max-text 15
              value scr-tel2
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              id id-ef-scr-tel2
              .
           05 ef-scr-fax 
              entry-field, 
              col 21
              line 13
              size 85
              max-text 15
              value scr-fax
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              id id-ef-scr-fax
              .
           05 ef-scr-addr 
              entry-field, 
              col 21
              line 15
              size 85
              max-text 50
              value scr-addr
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              id id-ef-scr-addr
              .
           05 ef-scr-longitude
              entry-field, 
              col 21
              line 17
              size 15
              value scr-longitude 
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              id id-ef-scr-longitude
              numeric
              right
              .
           05 ef-scr-latitude
              entry-field, 
              col 50
              line 17
              size 15
              value scr-latitude
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              id id-ef-scr-latitude
              numeric
              right
              .
           05 push-button, 
              col 70 
              line 16.8
              lines 1.7 
              cells
              size 22 cells
              bitmap-width 18
              bitmap-number 78-n-maps
              bitmap-rollover 78-n-maps-rollover
              exception-value 2003
              title r"Show_on_map"
              title-position 2
              self-act
              flat
              background-color rgb 78-pb-background-color
              foreground-color rgb 78-pb-foreground-color
              disabled-background-color 
                               rgb 78-pb-disabled-background-color
              disabled-foreground-color 
                               rgb 78-pb-disabled-foreground-color
              rollover-foreground-color 
                               rgb 78-pb-rollover-foreground-color
              rollover-background-color 
                               rgb 78-pb-rollover-background-color
              .
           05 ef-scr-contact 
              entry-field, 
              col 21
              line 19
              size 85
              max-text 20
              value scr-contact
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              id id-ef-scr-contact
              .
           05 ef-scr-email 
              entry-field, 
              col 21
              line 21
              size 85
              max-text 30
              value scr-email
              border-width (0, 0, 2, 0)
              border-color rgb 78-ef-border-color
              id id-ef-scr-email
              .

           copy "standard-mask-tool.scr".

       PROCEDURE DIVISION.
       DECLARATIVES.
       CUSTOMER-ERR section.
           use after standard error procedure on customer.
           perform ERROR-FILE
           .
       END DECLARATIVES.
       
       MAIN.

           perform OPEN-FILES.

           initialize screen-value.
           
           display independent graphical window
                   title R"isCOBOL_Application_Customer"
                   lines 27
                   size 108
                   resizable
                   layout-manager lm-scale
                   line 0
                   col 0
                   lines 22
                   size 107
                   control font h-font
                   handle h-sta
                   visible 0
                   system menu
                   link to thread
                   background-color rgb 78-window-independent-back-color
                   min-lines 15
                   min-size 80
                   undecorated
                   .

           display mask-main upon h-sta
           perform DISPLAY-TOOLBAR

           modify h-sta action action-maximize 
           modify h-sta visible 1

           perform until key-status = 27
              accept mask-main
                 on exception continue
              end-accept
              perform AFTER-ACCEPT
              move 4 to accept-control
           end-perform
           
           perform EXIT-PRG.
           
           goback
           .

       AFTER-ACCEPT.
           evaluate key-status
           when 78-exe-new
                initialize cust-record
                perform DISPLAY-SCREEN
           when 78-exe-save
                perform SAVE-RECORD
           when 78-exe-delete
                perform DELETE-RECORD
                initialize cust-record
                perform DISPLAY-SCREEN
           when 78-exe-first
                perform READ-FIRST
                perform DISPLAY-SCREEN
           when 78-exe-prev
                perform READ-PREV
                perform DISPLAY-SCREEN
           when 78-exe-next
                perform READ-NEXT
                perform DISPLAY-SCREEN
           when 78-exe-last
                perform READ-LAST
                perform DISPLAY-SCREEN
           when 78-exe-zoom
                PERFORM ZOOM-PARAGRAPH
           when 2003
                perform SHOW-MAP
           when w-event
                evaluate event-type
                when cmd-close
                     move 27 to key-status
                end-evaluate
           end-evaluate.

           copy "iwc-accept.prd".
           .

       DELETE-RECORD.
           display message box 
                          R"Are_you_sure_to_delete_the_selected_record?"
                   type mb-yes-no
                   default mb-no
                   icon mb-warning-icon 
                   giving choice
           if choice = mb-yes
             inquire ef-scr-id  value scr-id
             move scr-id   to Cust-id
             delete Customer record
                invalid
                   continue
             end-delete

             move R"Customer_deleted" to iwc-notification
             call "IWC-ADD-NOTIFICATION" using 78-sys-icon 
                                               78-evt-system
                                               iwc-notification
           end-if.

       SAVE-RECORD.
           set all-ok  to true
           perform CONTROL-ALL
           
           if all-ok
              move scr-id          to cust-id
              move scr-fname       to cust-fname
              move scr-lname       to cust-lname
              move scr-tel1        to cust-tel1
              move scr-tel2        to cust-tel2
              move scr-fax         to cust-fax
              move scr-addr        to cust-addr
              move scr-longitude   to cust-longitude
              move scr-latitude    to cust-latitude
              move scr-contact     to cust-contact
              move scr-email       to cust-email

              rewrite cust-record
                 invalid
                    write cust-record
              end-rewrite

              move R"Information"  to iwc-notification-description
              move R"Customer_saved_successfully"
                                   to iwc-notification
              call "IWC-NOTIFY" using 78-notification-success
                                      iwc-notification-description,
                                      iwc-notification
           end-if.
 
       CONTROL-ALL.
           inquire ef-scr-id          value cust-id
           inquire ef-scr-fname       value cust-fname
           inquire ef-scr-lname       value cust-lname
           inquire ef-scr-tel1        value cust-tel1
           inquire ef-scr-tel2        value cust-tel2
           inquire ef-scr-addr        value cust-addr
           inquire ef-scr-longitude   value cust-longitude
           inquire ef-scr-latitude    value cust-latitude
           inquire ef-scr-fax         value cust-fax
           inquire ef-scr-contact     value cust-contact
           inquire ef-scr-email       value cust-email
           
           if cust-id = space
              move R"Customer_id_is_mandatory!"
                                      to iwc-notification
              call "IWC-NOTIFY" using 78-notification-warning,
                                      "Warning"
                                      iwc-notification

              display message box R"Customer_id_is_mandatory!"
                    icon mb-warning-icon
              move id-ef-scr-id  to control-id
              set all-ok          to false
           end-if.
           
           if all-ok
              if cust-lname = space
                 display message box R"Last_name_is_mandatory!"
                    icon mb-warning-icon
                 move id-ef-scr-lname   to control-id
                 set all-ok             to false
              end-if
           end-if.
           
           if all-ok and cust-email not = space
              move zero   to cont
              inspect cust-email tallying cont for all "@"
              if cont not = 1
                 display message box R"Wrong_e-mail_address!"
                    icon mb-warning-icon
                 move id-ef-scr-email   to control-id
                 set all-ok             to false
              end-if
           end-if.
 
       READ-FIRST.
           move low-value  to Cust-id
           start Customer key not < Cust-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize cust-record
              not invalid
                read Customer next no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize cust-record
                end-read
           end-start.
 
       READ-LAST.
           move high-value  to Cust-id
           start Customer key not > Cust-key
              invalid
                 perform RECORD-NOT-FOUND
                 initialize cust-record
              not invalid
                read Customer previous no lock
                   at end
                      perform RECORD-NOT-FOUND
                      initialize cust-record
                end-read
           end-start.
 
       READ-PREV.
           inquire ef-scr-id VALUE scr-id.
           if scr-id = space
              perform READ-LAST
           else
              move scr-id  to Cust-id
              read Customer no lock
                invalid
                   start Customer key not < Cust-key
                      invalid
                         initialize cust-record
                   end-start
              end-read
              read Customer previous no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.

       READ-NEXT.
           inquire ef-scr-id VALUE scr-id.
           if scr-id = space
              perform READ-FIRST
           else
              move scr-id  to Cust-id
              read Customer no lock
                invalid
                   start Customer key not > Cust-key
                      invalid
                         initialize cust-record
                   end-start
              end-read
              read Customer next no lock
                at end
                   perform RECORD-NOT-FOUND
              end-read
           end-if.
 
       RECORD-NOT-FOUND.
           move "File Customer"       to iwc-notification-description
           move R"Record_not_found"   to iwc-notification
           call "IWC-NOTIFY" using 78-notification-warning
                                   iwc-notification-description,
                                   iwc-notification
           .
 
       DISPLAY-SCREEN.
           move cust-id         to scr-id
           move cust-fname      to scr-fname
           move cust-lname      to scr-lname
           move cust-tel1       to scr-tel1
           move cust-tel2       to scr-tel2
           move cust-fax        to scr-fax
           move cust-addr       to scr-addr
           move cust-longitude  to scr-longitude
           move cust-latitude   to scr-latitude
           move cust-contact    to scr-contact
           move cust-email      to scr-email

           display mask-main.
 
       OPEN-FILES.
           open I-O Customer.

       EXIT-PRG.
           call "IWC-QUIT-TAB".
           
           perform DESTROY-RESOURCE
           perform CLOSE-FILE
           .

       CLOSE-FILE.
           close Customer.

       DESTROY-RESOURCE.
           modify h-sta visible 0
           destroy mask-main mask-tool h-tool 
                   h-sta 
           .

       AFT-EF-SCR-ID.
           if key-status = 13
              perform LOAD-RECORD
           end-if.

       LOAD-RECORD.
           move scr-id  to Cust-id
           read Customer no lock
              invalid
                 perform RECORD-NOT-FOUND
              not invalid
                 perform DISPLAY-SCREEN
           end-read.

       ZOOM-PARAGRAPH.
           evaluate control-id
           when id-ef-scr-id
                call "ZCUSTOMER" using wrk-customer 
                                       lookup-status 
                cancel "ZCUSTOMER"
                evaluate true
                when ls-record-selected
                     move wrk-customer   to scr-id
                     perform LOAD-RECORD
                when ls-force-close 
                     move 27 to key-status
                end-evaluate
           end-evaluate.

       SHOW-MAP.

           inquire ef-scr-fname       value maps-fname.
           inquire ef-scr-lname       value maps-lname.
           inquire ef-scr-addr        value maps-addr.
           inquire ef-scr-longitude   value maps-longitude.
           inquire ef-scr-latitude    value maps-latitude.

           call "MAPS" using maps-linkage 
                             lookup-status.
           cancel "MAPS".
           if ls-force-close 
              move 27 to key-status
           end-if
           .

           copy "dec-file.prd".
           copy "standard-toolbar.prd".

