/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.iiop;

import IT.picosoft.iiop.CorbaException;
import IT.picosoft.iiop.IiopObj;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class Connection {
    public static final String rcsid = "$Id: Connection.java,v 1.5 2011/11/14 10:42:23 picoSoft Exp $";
    private Socket sock;
    private Process proc;
    private int timeOut;
    private InputStream inp;
    private OutputStream out;
    private IiopObj obj;
    private String pgmToExec;

    public Connection(IiopObj iiopObj) {
        this.obj = iiopObj;
    }

    public Connection(String string) {
        this.pgmToExec = string;
    }

    public Connection(Socket socket) {
        this.sock = socket;
    }

    public synchronized void setTimeout(int n) {
        this.timeOut = n;
    }

    public synchronized int getTimeout() {
        return this.timeOut;
    }

    public synchronized void close() {
        this.finalize();
    }

    public synchronized void finalize() {
        if (this.inp != null) {
            try {
                this.inp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inp = null;
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out = null;
        }
        if (this.sock != null) {
            try {
                this.sock.setSoLinger(true, 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sock = null;
        }
        if (this.proc != null) {
            try {
                this.proc.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.proc = null;
        }
    }

    public synchronized void recv(byte[] byArray, int n, int n2) throws CorbaException {
        int n3 = 0;
        try {
            for (int i = 0; i < n2 && (n3 = this.inp.read(byArray, n + i, n2 - i)) > 0; i += n3) {
            }
            if (n3 < 0) {
                throw new CorbaException(11, "");
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new CorbaException(7, socketTimeoutException);
        }
        catch (IOException iOException) {
            throw new CorbaException(5, iOException);
        }
    }

    public synchronized void send(byte[] byArray, int n, int n2) throws CorbaException {
        try {
            this.out.write(byArray, n, n2);
            this.out.flush();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            throw new CorbaException(7, socketTimeoutException);
        }
        catch (IOException iOException) {
            throw new CorbaException(5, iOException);
        }
    }

    public void connect() throws CorbaException {
        if (this.pgmToExec != null) {
            try {
                this.proc = Runtime.getRuntime().exec(this.pgmToExec);
                this.inp = this.proc.getInputStream();
                this.out = this.proc.getOutputStream();
                final InputStream inputStream = this.proc.getErrorStream();
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        int n = 0;
                        try {
                            while ((n = inputStream.read()) >= 0) {
                                System.err.print((char)n);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
            catch (Exception exception) {
                throw new CorbaException(5, exception);
            }
        }
        try {
            if (this.sock == null) {
                this.sock = new Socket(this.obj.getHost(), this.obj.getPort());
                if (this.timeOut > 0) {
                    this.sock.setSoTimeout(this.timeOut);
                }
            }
            this.inp = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
        }
        catch (UnknownHostException unknownHostException) {
            throw new CorbaException(5, unknownHostException);
        }
        catch (IOException iOException) {
            throw new CorbaException(5, iOException);
        }
    }
}

