/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.iiop;

import IT.picosoft.iiop.Connection;
import IT.picosoft.iiop.Corba;
import IT.picosoft.iiop.CorbaArg;
import IT.picosoft.iiop.CorbaException;
import IT.picosoft.iiop.CorbaMethod;
import IT.picosoft.iiop.Giop;
import IT.picosoft.iiop.IiopObj;
import IT.picosoft.iiop.Message;
import IT.picosoft.iiop.MessageHeader;
import IT.picosoft.iiop.MethodTable;
import java.util.Enumeration;

public class IiopServer
implements Corba {
    public static final String rcsid = "$Id: IiopServer.java,v 1.5 2011/09/19 15:40:41 picoSoft Exp $";
    protected MethodTable methods = new MethodTable();
    private String key;
    private Connection conn;
    private int reqId;

    public IiopServer(IiopObj iiopObj) throws CorbaException {
        if (iiopObj == null) {
            throw new CorbaException(1);
        }
        this.key = iiopObj.key;
        this.conn = new Connection(iiopObj);
        this.conn.connect();
        this.debug(null);
    }

    public IiopServer(String string) throws CorbaException {
        if (string == null) {
            throw new CorbaException(1);
        }
        this.key = "pipe";
        this.conn = new Connection(string);
        this.conn.connect();
        this.debug(null);
    }

    public synchronized void invoke(String string, Object[] objectArray) throws CorbaException {
        CorbaArg corbaArg;
        int n;
        boolean bl = false;
        if (string == null) {
            throw new CorbaException(3, "Invalid name in invoke");
        }
        CorbaMethod corbaMethod = (CorbaMethod)this.methods.get(string);
        if (corbaMethod == null) {
            throw new CorbaException(2, "Method not found: " + string);
        }
        Message message = new Message();
        int n2 = Giop.header(message, 0);
        message.putLong(0);
        message.putLong(this.reqId++);
        message.putBoolean(true);
        message.encode(TCD_string, this.key);
        message.encode(TCD_string, string);
        message.putLong(0);
        if (corbaMethod.args != null) {
            for (n = 0; n < corbaMethod.args.length; ++n) {
                corbaArg = corbaMethod.args[n];
                if (string.equals("D_init") && n == 0 && objectArray[0] != null) {
                    corbaArg.mode = 3;
                    corbaArg.size = 16L;
                    message.encode(corbaArg.type, objectArray[n]);
                    objectArray[n] = null;
                    continue;
                }
                if (corbaArg.mode != 1 && corbaArg.mode != 3) continue;
                message.encode(corbaArg.type, objectArray[n]);
            }
        }
        message.putLongAt(message.getSize() - 12, n2);
        this.conn.send(message.getBuffer(), 0, message.getSize());
        message = new Message();
        this.conn.recv(message.getBuffer(), 0, 12);
        MessageHeader messageHeader = new MessageHeader();
        if (!Giop.checkHeader(messageHeader, message)) {
            throw new CorbaException(4, "Error in reception");
        }
        if (messageHeader.type == 6) {
            throw new CorbaException(0, "Error in reception");
        }
        int n3 = 0;
        byte[] byArray = message.getBuffer(messageHeader.size + 12, messageHeader.byteOrder);
        this.conn.recv(byArray, n3 += 12, messageHeader.size);
        int n4 = (int)message.getULong();
        int n5 = (int)message.getULong();
        int n6 = (int)message.getULong();
        if (n6 == 0) {
            if (corbaMethod.args != null) {
                for (n = 0; n < corbaMethod.args.length; ++n) {
                    corbaArg = corbaMethod.args[n];
                    if (corbaArg.mode != 3 && corbaArg.mode != 2) continue;
                    objectArray[n] = message.decode(corbaArg.type, objectArray[n]);
                }
            }
        } else {
            throw new CorbaException(10, (String)message.decode(TCD_string, null));
        }
        bl = true;
    }

    protected void finalize() {
        this.conn.close();
    }

    private void debug(Object[] objectArray) {
        Enumeration enumeration = this.methods.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("name=" + string + ",meth=" + this.methods.get(string));
        }
    }
}

