/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolMethod;
import com.iscobol.compiler.CobolProgram;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Entry;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.FileDescriptorList;
import com.iscobol.compiler.FileSection;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.LinkageSection;
import com.iscobol.compiler.LocalStorageSection;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.ReportDescriptor;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.ReportSection;
import com.iscobol.compiler.ScreenSection;
import com.iscobol.compiler.ServiceBridgeUtility;
import com.iscobol.compiler.ThreadLocalStorageSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableDeclarationList;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.VariableNameList;
import com.iscobol.compiler.Version;
import com.iscobol.compiler.WorkingStorageSection;
import com.iscobol.compiler.remote.RemoteBridgeFile;
import com.iscobol.compiler.remote.RemoteFileFinder;
import com.iscobol.compiler.remote.server.RemoteCompiler;
import com.iscobol.interfaces.compiler.CachedFileFinder;
import com.iscobol.interfaces.compiler.IDataDivisionExtension2;
import com.iscobol.rts.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;

public class DataDivision
implements CobolToken,
ErrorsNumbers,
IDataDivisionExtension2 {
    public static final String WORKING_STORAGE_SECTION_ID = "W";
    public static final String LINKAGE_SECTION_ID = "L";
    public static final String FILE_SECTION_ID = "F";
    public static final String SCREEN_SECTION_ID = "S";
    public static final String REPORT_SECTION_ID = "R";
    public static final String LOCAL_STORAGE_SECTION_ID = "LS";
    public static final String THREAD_LOCAL_STORAGE_SECTION_ID = "TLS";
    TokenManager tm;
    Errors error;
    FileSection fileSec;
    WorkingStorageSection wsSec;
    LocalStorageSection lsSec;
    ThreadLocalStorageSection tlsSec;
    ScreenSection screenSec;
    LinkageSection linkSec;
    ReportSection repoSec;
    Pcc pc;
    Map<String, Integer> wdslArraySizes = new HashMap<String, Integer>();
    private static final String NS_SOAPENC = "http://schemas.xmlsoap.org/soap/encoding/";
    Hashtable<String, StringBuffer> tagAreas = new Hashtable();
    public static final String startTag = "*>start ";
    public static final String endTag = "*>end ";
    public static final String tagCompDir = "{iscobol}compiler-directives";
    public static final String tagProgCom = "{iscobol}prog-comment";
    public static final String tagProgId = "{iscobol}progid";
    public static final String tagReposit = "{iscobol}repository";
    public static final String tagWorkSto = "{iscobol}working-storage";
    public static final String tagLinkage = "{iscobol}linkage";
    public static final String tagProcUsi = "{iscobol}procedure-using";
    public static final String tagAcceHtt = "{iscobol}accept-http";
    public static final String tagHttpLin = "{iscobol}http-to-linkage";
    public static final String tagCall = "{iscobol}call";
    public static final String tagLinkHtt = "{iscobol}linkage-to-http";
    public static final String tagHttpRes = "{iscobol}http-response";
    public static final String tagGoback = "{iscobol}goback";
    private Token firstToken;
    private Token lastToken;
    private final boolean serviceBridgeActivated;
    private boolean jj;
    private boolean jc;

    public DataDivision(Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        this(p, t, err, null, null);
    }

    public DataDivision(Pcc p, TokenManager t, Errors err, Token tk) throws GeneralErrorException, EndOfProgramException {
        this(p, t, err, tk, null);
    }

    public DataDivision(Pcc p, TokenManager t, Errors err, Token tk, LinkageSection ls) throws GeneralErrorException, EndOfProgramException {
        VariableDeclaration vd;
        this.jj = t.getOptionList().getOption("-jj") != null;
        this.jc = t.getOptionList().getOption("-jc") != null;
        this.firstToken = tk;
        this.serviceBridgeActivated = p.isServiceBridgeActivated();
        boolean goOn = true;
        this.pc = p;
        this.pc.inProcedure = false;
        this.error = err;
        this.tm = t;
        this.linkSec = ls;
        block20: while (goOn && (tk = this.tm.getToken()).getToknum() != 652 && tk.getToknum() != 706 && tk.getToknum() != 423) {
            switch (tk.getToknum()) {
                case 483: {
                    if (this.fileSec != null) {
                        throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
                    }
                    try {
                        this.fileSec = new FileSection(this.pc, this.tm, this.error, tk);
                    }
                    catch (GeneralErrorException e) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 815: {
                    if (this.wsSec != null) {
                        throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
                    }
                    try {
                        this.wsSec = new WorkingStorageSection(this.pc, this.tm, this.error, tk);
                    }
                    catch (GeneralErrorException e) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 570: {
                    if (!(this.pc instanceof CobolProgram) && !(this.pc instanceof CobolMethod)) {
                        throw new UnexpectedTokenException(tk, err);
                    }
                    if (this.lsSec != null) {
                        throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
                    }
                    try {
                        this.lsSec = new LocalStorageSection(this.pc, this.tm, this.error, tk);
                    }
                    catch (GeneralErrorException e) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 766: {
                    if (!(this.pc instanceof CobolProgram) && !(this.pc instanceof CobolMethod)) {
                        throw new UnexpectedTokenException(tk, err);
                    }
                    if (this.tlsSec != null) {
                        throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
                    }
                    try {
                        this.tlsSec = new ThreadLocalStorageSection(this.pc, this.tm, this.error, tk);
                    }
                    catch (GeneralErrorException e) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 569: {
                    if (this.linkSec != null) {
                        throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
                    }
                    try {
                        this.linkSec = new LinkageSection(this.pc, this.tm, this.error, tk, this.wsSec);
                    }
                    catch (GeneralErrorException e) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
                case 685: {
                    if (this.repoSec != null) {
                        throw new GeneralErrorException(225, 4, tk, tk.getWord(), this.error);
                    }
                    try {
                        this.repoSec = new ReportSection(this.pc, this.tm, this.error);
                    }
                    catch (GeneralErrorException e) {
                        this.tm.skipToDot();
                    }
                    continue block20;
                }
            }
            goOn = false;
        }
        if (this.wsSec != null && this.wsSec.tlVars.getItemNum() > 0) {
            if (this.tlsSec == null) {
                this.tlsSec = new ThreadLocalStorageSection(p, null, this.error, tk);
            }
            vd = this.wsSec.tlVars.getFirst();
            while (vd != null) {
                vd.setParentSection(this.tlsSec);
                this.tlsSec.loadVariable(vd);
                vd = this.wsSec.tlVars.getNext();
            }
        }
        if (this.lsSec != null && this.lsSec.tlVars.getItemNum() > 0) {
            if (this.tlsSec == null) {
                this.tlsSec = new ThreadLocalStorageSection(p, null, this.error, tk);
            }
            vd = this.lsSec.tlVars.getFirst();
            while (vd != null) {
                vd.setParentSection(this.tlsSec);
                this.tlsSec.loadVariable(vd);
                vd = this.lsSec.tlVars.getNext();
            }
        }
        if (this.fileSec != null && this.fileSec.hasThreadLocal() && this.tlsSec == null) {
            this.tlsSec = new ThreadLocalStorageSection(p, null, this.error, tk);
        }
        this.lastToken = tk;
        this.tm.ungetToken();
        if (this.pc.parent != null) {
            if (this.pc.parent.parent != null) {
                this.pc.parent.parent.theDatas.addElement(this);
            } else {
                this.pc.parent.theDatas.addElement(this);
            }
        }
        this.pc.loadCounters();
    }

    void check() {
        if (this.repoSec != null) {
            this.repoSec.check();
        }
        if (this.fileSec != null) {
            this.fileSec.check();
        }
    }

    public void scanScreenSection(Token tk) throws GeneralErrorException, EndOfProgramException {
        try {
            this.screenSec = new ScreenSection(this.pc, this.tm, this.error, tk);
            this.screenSec.loadSS();
            this.lastToken = this.screenSec.getLastToken();
        }
        catch (GeneralErrorException generalErrorException) {
            // empty catch block
        }
        this.tm.ungetToken();
    }

    public String getCode(StringBuffer dynPart, String secId) {
        return this.getCode(dynPart, null, secId);
    }

    public String getCode(StringBuffer dynPart, StringBuffer syncMemory, String secId) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.tm.getCommentCode(this.firstToken, ""));
        if (syncMemory == null) {
            syncMemory = Return2;
        }
        if (secId == LOCAL_STORAGE_SECTION_ID) {
            if (this.lsSec != null) {
                Return2.append(this.lsSec.getCode(dynPart));
            }
        } else if (secId == THREAD_LOCAL_STORAGE_SECTION_ID) {
            if (this.fileSec != null) {
                Return2.append(this.fileSec.getCode(dynPart, true));
                FileDescriptorList fdList = this.fileSec.getFileDescriptorList();
                FileDescriptor fd = fdList.getFirst();
                while (fd != null) {
                    if (fd.threadLocal) {
                        Return2.append(fd.getSelect().getCode(dynPart));
                    }
                    fd = fdList.getNext();
                }
            }
            if (this.tlsSec != null) {
                Return2.append(this.tlsSec.getCode(dynPart));
            }
        } else {
            if (this.fileSec != null) {
                Return2.append(this.fileSec.getCode(dynPart, false));
            }
            if (this.wsSec != null) {
                Return2.append(this.wsSec.getCode(dynPart));
            }
            if (this.linkSec != null) {
                Return2.append(this.linkSec.getCode(dynPart));
            }
            if (this.repoSec != null) {
                Return2.append(this.repoSec.getCode(dynPart));
            }
            if (this.screenSec != null && this.screenSec.vars.getItemNum() > 0 || this.pc.useScreen) {
                dynPart.append("ScrFactory.getGUIEnviroment()");
                dynPart.append(".setProgName(\"" + this.pc.getClassName() + "\");" + eol);
            }
            if (this.screenSec != null) {
                Return2.append(this.screenSec.getCode(this.pc, dynPart));
                Return2.append(eol);
            }
            this.getBridgesCode();
        }
        if (this.pc instanceof CobolProgram && this.pc.getOption("-cp") != null) {
            VariableDeclaration v;
            if (secId == LOCAL_STORAGE_SECTION_ID || secId == THREAD_LOCAL_STORAGE_SECTION_ID) {
                syncMemory.append("   ");
            }
            syncMemory.append("   public void syncMemory() {");
            if (secId == LOCAL_STORAGE_SECTION_ID) {
                if (this.lsSec != null) {
                    v = this.lsSec.vars.getFirst();
                    while (v != null) {
                        this.getSyncMemoryCode(v, syncMemory);
                        v = this.lsSec.vars.getNext();
                    }
                }
            } else if (secId == THREAD_LOCAL_STORAGE_SECTION_ID) {
                if (this.tlsSec != null) {
                    v = this.tlsSec.vars.getFirst();
                    while (v != null) {
                        this.getSyncMemoryCode(v, syncMemory);
                        v = this.tlsSec.vars.getNext();
                    }
                }
            } else {
                if (this.wsSec != null) {
                    v = this.wsSec.vars.getFirst();
                    while (v != null) {
                        this.getSyncMemoryCode(v, syncMemory);
                        v = this.wsSec.vars.getNext();
                    }
                }
                if (this.linkSec != null) {
                    v = this.linkSec.vars.getFirst();
                    while (v != null) {
                        this.getSyncMemoryCode(v, syncMemory);
                        v = this.linkSec.vars.getNext();
                    }
                }
            }
            if (secId == LOCAL_STORAGE_SECTION_ID || secId == THREAD_LOCAL_STORAGE_SECTION_ID) {
                syncMemory.append("   ");
            }
            syncMemory.append("   }");
            syncMemory.append(eol);
        }
        return Return2.toString();
    }

    void getBridgesCode() {
        String name;
        VariableNameList using;
        if ((Config.getProperty(".compiler.easylinkage", 0) == 1 || Config.getProperty(".compiler.easylinkage", false) || Config.getProperty(".compiler.easylinkage", 0) == 3) && Config.getProperty(".compiler.easylinkage", 0) != 2) {
            using = null;
            name = this.pc.getOutNameBase();
            if (this.pc.getProcedureDivision() != null) {
                using = this.pc.getProcedureDivision().using;
                this.getEasyLinkCode(this.pc, name, using, this.pc.getProcedureDivision().getByValueParameters(), false);
            } else {
                this.getEasyLinkCode(this.pc, name, using, new HashSet(), false);
            }
        }
        if (this.serviceBridgeActivated) {
            try {
                using = null;
                name = this.pc.outName;
                String callName = this.pc.outName;
                if (this.pc.getProcedureDivision() != null) {
                    using = this.pc.getProcedureDivision().using;
                    if (this.pc.getProcedureDivision().getServiceBridgeOperation() != null) {
                        name = this.pc.getProcedureDivision().getServiceBridgeOperation();
                    }
                }
                if (Config.getProperty(".compiler.servicebridge.type", "SOAP").equalsIgnoreCase("SOAP")) {
                    this.getServiceBridgeWsdlCode(this.pc, name, using);
                }
                this.getServiceBridgeCobCode(this.pc, name, callName, using, 0, false);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void getSyncMemoryCode(VariableDeclaration v, StringBuffer syncMemory) {
        if (!v.isPrimitive() && !v.isObjectReference()) {
            if (v.isUsed()) {
                syncMemory.append("      ");
                syncMemory.append(v.getUnivoqueName());
                syncMemory.append(".getMemory();");
                syncMemory.append(eol);
            } else {
                VariableDeclarationList vdl = v.getChildren();
                VariableDeclaration c = vdl.getFirst();
                while (c != null) {
                    if (c.getLevel() <= 49) {
                        this.getSyncMemoryCode(c, syncMemory);
                    }
                    c = vdl.getNext();
                }
            }
        }
    }

    public StringBuffer getDataMap(String eol, String pfx) {
        VariableDeclaration vd;
        StringBuffer dataMap = new StringBuffer();
        if (this.fileSec != null) {
            FileDescriptor fd = this.fileSec.fdArray.getFirst();
            while (fd != null) {
                if (!fd.hasReports()) {
                    vd = fd.recordDesc.getFirst();
                    while (vd != null) {
                        vd.getLineDatamap(dataMap, "FD", " ", pfx);
                        vd = fd.recordDesc.getNext();
                    }
                }
                fd = this.fileSec.fdArray.getNext();
            }
        }
        if (this.repoSec != null) {
            for (int i = this.repoSec.getRdList().size() - 1; i >= 0; --i) {
                ReportDescriptor rd = (ReportDescriptor)this.repoSec.getRdList().elementAt(i);
                for (ReportGroup rg : rd.getReportGroups()) {
                    dataMap.append(rg.getLineDatamap(pfx));
                }
            }
        }
        if (this.wsSec != null) {
            vd = this.wsSec.vars.getFirst();
            while (vd != null) {
                vd.getLineDatamap(dataMap, "WS", " ", pfx);
                vd = this.wsSec.vars.getNext();
            }
        }
        if (this.lsSec != null) {
            vd = this.lsSec.vars.getFirst();
            while (vd != null) {
                vd.getLineDatamap(dataMap, "LC", " ", pfx);
                vd = this.lsSec.vars.getNext();
            }
        }
        if (this.tlsSec != null) {
            vd = this.tlsSec.vars.getFirst();
            while (vd != null) {
                vd.getLineDatamap(dataMap, "TL", " ", pfx);
                vd = this.tlsSec.vars.getNext();
            }
        }
        if (this.linkSec != null) {
            vd = this.linkSec.vars.getFirst();
            while (vd != null) {
                vd.getLineDatamap(dataMap, LOCAL_STORAGE_SECTION_ID, " ", pfx);
                vd = this.linkSec.vars.getNext();
            }
        }
        if (this.screenSec != null) {
            vd = this.screenSec.vars.getFirst();
            while (vd != null) {
                vd.getLineDatamap(dataMap, "SS", " ", pfx);
                vd = this.screenSec.vars.getNext();
            }
        }
        vd = this.pc.fixedVars.getFirst();
        while (vd != null) {
            vd.getLineDatamap(dataMap, "PG", " ", pfx);
            vd = this.pc.fixedVars.getNext();
        }
        return dataMap;
    }

    void writeExtDataMap(Element elem) {
        VariableDeclaration vd;
        boolean m1;
        boolean bl = m1 = this.pc.getOption("-m1") != null;
        if (this.fileSec != null) {
            FileDescriptor fd = this.fileSec.fdArray.getFirst();
            while (fd != null) {
                if (!fd.hasReports()) {
                    vd = fd.recordDesc.getFirst();
                    while (vd != null) {
                        vd.writeExtDatamap(elem, "FD", m1);
                        vd = fd.recordDesc.getNext();
                    }
                }
                fd = this.fileSec.fdArray.getNext();
            }
        }
        if (this.repoSec != null) {
            for (int i = this.repoSec.getRdList().size() - 1; i >= 0; --i) {
                ReportDescriptor rd = (ReportDescriptor)this.repoSec.getRdList().elementAt(i);
                for (ReportGroup rg : rd.getReportGroups()) {
                    rg.writeExtDatamap(elem);
                }
            }
        }
        if (this.wsSec != null) {
            vd = this.wsSec.vars.getFirst();
            while (vd != null) {
                vd.writeExtDatamap(elem, "WS", m1);
                vd = this.wsSec.vars.getNext();
            }
        }
        if (this.lsSec != null) {
            vd = this.lsSec.vars.getFirst();
            while (vd != null) {
                vd.writeExtDatamap(elem, "LC", m1);
                vd = this.lsSec.vars.getNext();
            }
        }
        if (this.tlsSec != null) {
            vd = this.tlsSec.vars.getFirst();
            while (vd != null) {
                vd.writeExtDatamap(elem, "TL", m1);
                vd = this.tlsSec.vars.getNext();
            }
        }
        if (this.linkSec != null) {
            vd = this.linkSec.vars.getFirst();
            while (vd != null) {
                vd.writeExtDatamap(elem, LOCAL_STORAGE_SECTION_ID, m1);
                vd = this.linkSec.vars.getNext();
            }
        }
        vd = this.pc.fixedVars.getFirst();
        while (vd != null) {
            vd.writeExtDatamap(elem, "PG", m1);
            vd = this.pc.fixedVars.getNext();
        }
    }

    public StringBuffer getDataSize(String eol, String pfx) {
        VariableDeclaration vd;
        StringBuffer dataSize = new StringBuffer();
        int size = 0;
        String tmpSpace = "                                            ";
        String tmpSize = "";
        int screenSize = 0;
        int linkSize = 0;
        int extSize = 0;
        int tlsSize = 0;
        int lsSize = 0;
        int wsSize = 0;
        int rdSize = 0;
        int fdExtSize = 0;
        int fdSize = 0;
        if (this.fileSec != null) {
            FileDescriptor fd = this.fileSec.fdArray.getFirst();
            while (fd != null) {
                if (!fd.hasReports()) {
                    if (fd.isExternal()) {
                        fdExtSize += fd.getMaxRecLen();
                    } else {
                        fdSize += fd.getMaxRecLen();
                    }
                }
                fd = this.fileSec.fdArray.getNext();
            }
        }
        tmpSize = "" + fdSize;
        dataSize.append(pfx + "File Description data size               " + tmpSpace.substring(tmpSize.length()) + tmpSize + eol);
        tmpSize = "" + fdExtSize;
        dataSize.append(pfx + "External File Description data size      " + tmpSpace.substring(tmpSize.length()) + tmpSize + eol);
        if (this.repoSec != null) {
            for (int i = this.repoSec.getRdList().size() - 1; i >= 0; --i) {
                ReportDescriptor rd = (ReportDescriptor)this.repoSec.getRdList().elementAt(i);
                for (ReportGroup rg : rd.getReportGroups()) {
                    rdSize = rg.getDataMapSize();
                }
            }
        }
        tmpSize = "" + rdSize;
        dataSize.append(pfx + "Report Description data size             " + tmpSpace.substring(tmpSize.length()) + tmpSize + eol);
        if (this.wsSec != null) {
            vd = this.wsSec.vars.getFirst();
            while (vd != null) {
                if (!vd.isRedefines()) {
                    if (vd.getOccurs() == 0) {
                        if (vd.isExternal()) {
                            extSize += vd.getPhisicLen();
                        } else {
                            wsSize += vd.getPhisicLen();
                        }
                    } else if (vd.isExternal()) {
                        extSize += vd.getPhisicLen() * vd.getOccurs();
                    } else {
                        wsSize += vd.getPhisicLen() * vd.getOccurs();
                    }
                }
                vd = this.wsSec.vars.getNext();
            }
        }
        tmpSize = "" + wsSize;
        dataSize.append(pfx + "Working-Storage data size                " + tmpSpace.substring(tmpSize.length()) + tmpSize + eol);
        if (this.lsSec != null) {
            vd = this.lsSec.vars.getFirst();
            while (vd != null) {
                if (!vd.isRedefines()) {
                    if (vd.getOccurs() == 0) {
                        if (vd.isExternal()) {
                            extSize += vd.getPhisicLen();
                        } else {
                            lsSize += vd.getPhisicLen();
                        }
                    } else if (vd.isExternal()) {
                        extSize += vd.getPhisicLen() * vd.getOccurs();
                    } else {
                        lsSize += vd.getPhisicLen() * vd.getOccurs();
                    }
                }
                vd = this.lsSec.vars.getNext();
            }
        }
        tmpSize = "" + lsSize;
        dataSize.append(pfx + "Local-Storage data size                  " + tmpSpace.substring(tmpSize.length()) + tmpSize + eol);
        if (this.tlsSec != null) {
            vd = this.tlsSec.vars.getFirst();
            while (vd != null) {
                if (!vd.isRedefines()) {
                    if (vd.getOccurs() == 0) {
                        if (vd.isExternal()) {
                            extSize += vd.getPhisicLen();
                        } else {
                            tlsSize += vd.getPhisicLen();
                        }
                    } else if (vd.isExternal()) {
                        extSize += vd.getPhisicLen() * vd.getOccurs();
                    } else {
                        tlsSize += vd.getPhisicLen() * vd.getOccurs();
                    }
                }
                vd = this.tlsSec.vars.getNext();
            }
        }
        tmpSize = "" + tlsSize;
        dataSize.append(pfx + "Thread-Local-Storage data size           " + tmpSpace.substring(tmpSize.length()) + tmpSize + eol);
        tmpSize = "" + extSize;
        dataSize.append(pfx + "External variable data size              " + tmpSpace.substring(tmpSize.length()) + tmpSize + eol);
        if (this.linkSec != null) {
            vd = this.linkSec.vars.getFirst();
            while (vd != null) {
                if (!vd.isRedefines()) {
                    linkSize = vd.getOccurs() == 0 ? (linkSize += vd.getPhisicLen()) : (linkSize += vd.getPhisicLen() * vd.getOccurs());
                }
                vd = this.linkSec.vars.getNext();
            }
        }
        tmpSize = "" + linkSize;
        dataSize.append(pfx + "Linkage data size                        " + tmpSpace.substring(tmpSize.length()) + tmpSize + eol);
        if (this.screenSec != null) {
            vd = this.screenSec.vars.getFirst();
            while (vd != null) {
                screenSize += vd.getDataMapSize();
                vd = this.screenSec.vars.getNext();
            }
        }
        tmpSize = "" + screenSize;
        dataSize.append(pfx + "Screen data size                         " + tmpSpace.substring(tmpSize.length()) + tmpSize + eol);
        size = fdSize + fdExtSize + extSize + rdSize + wsSize + lsSize + tlsSize + linkSize + screenSize;
        tmpSize = "" + size;
        dataSize.append(pfx + "Total Data Size                          " + tmpSpace.substring(tmpSize.length()) + tmpSize + "   " + eol);
        return dataSize;
    }

    void getEasyLinkCode(Pcc pc, String name, VariableNameList using, Set byValues, boolean isEntry) {
        String eLnkPrefix = Config.getProperty(".compiler.easylinkage.prefix", "link").trim();
        StringBuffer classLinkage = new StringBuffer();
        String memBuff = null;
        StringBuffer myDynPart = new StringBuffer();
        VariableDeclarationList usingVars = new VariableDeclarationList();
        String vName = "";
        String iName = name;
        if (name.lastIndexOf(File.separatorChar) > 0) {
            iName = name.substring(name.lastIndexOf(File.separatorChar) + 1);
        }
        if (iName == null || iName.length() == 0) {
            return;
        }
        if (using != null) {
            VariableName vnu = using.getFirst();
            while (vnu != null) {
                if (!vnu.isFactory()) {
                    usingVars.addItem(vnu.getVarDecl());
                }
                vnu = using.getNext();
            }
        }
        classLinkage.append("/**" + eol);
        classLinkage.append(" * Class generated by isCobol compiler for EasyLinkage feature" + eol);
        classLinkage.append(" * " + Version.getRelease() + eol);
        classLinkage.append(" * " + Pcc.getCopyrightInfo() + eol);
        classLinkage.append(" *" + eol);
        classLinkage.append(" * source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        classLinkage.append(" * compiler options: " + pc.getOptions().getAll().replace('\\', '/') + eol);
        if (isEntry) {
            classLinkage.append(" * This Class is for a Cobol Entry point." + eol);
            classLinkage.append(" * Ensure to have the entry point in memory or run the main cobol program" + eol);
            classLinkage.append(" * " + pc.getOutNameBase() + " before." + eol);
        }
        classLinkage.append(" */");
        classLinkage.append(eol);
        classLinkage.append(eol);
        String prop = Config.getProperty(".compiler.easylinkage.package", null);
        if (prop != null) {
            classLinkage.append("package " + prop + ";" + eol);
        }
        classLinkage.append(eol);
        classLinkage.append("import com.iscobol.java.IsCobol;" + eol);
        classLinkage.append("import com.iscobol.java.StopRunAsException;" + eol);
        classLinkage.append("import com.iscobol.rts.IscobolRuntimeException;" + eol);
        if (pc.getOptions().getOption("-xms") == null && pc.getOptions().getOption("-cp") == null) {
            classLinkage.append("import com.iscobol.rts.Factory;" + eol);
            classLinkage.append("import com.iscobol.types.*;" + eol);
        } else {
            classLinkage.append("import com.iscobol.rts_n.Factory;" + eol);
            classLinkage.append("import com.iscobol.rts.Memory;" + eol);
            classLinkage.append("import com.iscobol.types_n.*;" + eol);
        }
        classLinkage.append(eol);
        classLinkage.append(eol);
        classLinkage.append("public class " + eLnkPrefix + iName + " {" + eol);
        classLinkage.append(eol);
        if (pc.getOption("-sddp") != null && !pc.getSplitFlag()) {
            classLinkage.append("   public static final boolean $isDPC$ = Factory.isDPC();" + eol);
        }
        if (pc.getOption("-sdcs") != null && !pc.isSdcsIgnored() && !pc.getSplitFlag()) {
            classLinkage.append("   public static final char $CurrencySign$ = Factory.getCS();" + eol);
        }
        if (pc.getOption("-m1") != null) {
            if (pc.getOption("-xms") != null) {
                if (pc.getOption("-xmsn") != null) {
                    classLinkage.append("   public Memory wsMem=Factory.getNotOptmzdMem(");
                } else {
                    classLinkage.append("   public Memory wsMem = Factory.getMem (");
                }
            } else {
                classLinkage.append("   public byte wsMem[] = Factory.getMem (");
            }
            int lMem = 18;
            VariableDeclaration v = usingVars.getFirst();
            while (v != null) {
                lMem += v.getPhisicLen();
                v = usingVars.getNext();
            }
            classLinkage.append(lMem);
            byte defB = VariableDeclaration.getDefaultByte(pc.getOptions(), false, true);
            if (defB != 32) {
                classLinkage.append(", (byte)");
                classLinkage.append(defB);
            }
            classLinkage.append(");" + eol);
            classLinkage.append(eol);
        }
        classLinkage.append("   public " + eLnkPrefix + iName + "() {" + eol);
        classLinkage.append("      this(true);" + eol);
        classLinkage.append("   }" + eol);
        classLinkage.append(eol);
        classLinkage.append("   public " + eLnkPrefix + iName + "(boolean create) {" + eol);
        classLinkage.append("      if (create) {" + eol);
        VariableDeclaration v = usingVars.getFirst();
        while (v != null) {
            vName = v.getDeclUnivoqueName(true);
            vName = vName.length() > 1 ? vName.substring(0, 1).toUpperCase() + vName.substring(1) : vName.toUpperCase();
            classLinkage.append("          new" + vName + "();" + eol);
            v = usingVars.getNext();
        }
        classLinkage.append("       }" + eol);
        classLinkage.append("   }" + eol);
        v = usingVars.getFirst();
        while (v != null) {
            vName = v.getDeclUnivoqueName(true);
            vName = vName.length() > 1 ? vName.substring(0, 1).toUpperCase() + vName.substring(1) : vName.toUpperCase();
            myDynPart.append("    public void new" + vName + "()" + eol);
            myDynPart.append("    {" + eol + "      ");
            if (v.isRedefines()) {
                classLinkage.append(v.getRedefinesVar().getCode(memBuff, myDynPart, true));
            }
            classLinkage.append(v.getCode(memBuff, myDynPart, true));
            myDynPart.append("    }" + eol);
            v = usingVars.getNext();
        }
        classLinkage.append(eol);
        classLinkage.append(eol);
        classLinkage.append(eol);
        classLinkage.append(myDynPart.toString());
        classLinkage.append(eol);
        classLinkage.append(eol);
        classLinkage.append(eol);
        classLinkage.append("   public int run()" + eol);
        classLinkage.append("      throws IscobolRuntimeException," + eol);
        classLinkage.append("             StopRunAsException {" + eol);
        classLinkage.append("      return run(false);" + eol);
        classLinkage.append("   }" + eol);
        classLinkage.append("   public int run(boolean isNew)" + eol);
        classLinkage.append("      throws IscobolRuntimeException," + eol);
        classLinkage.append("             StopRunAsException {" + eol);
        classLinkage.append("      if (isNew)" + eol);
        classLinkage.append("         IsCobol.cancel(\"" + iName + "\");" + eol);
        boolean containsObject = false;
        VariableDeclaration v2 = usingVars.getFirst();
        while (v2 != null && !containsObject) {
            if (v2.isObjectReference()) {
                containsObject = true;
            }
            v2 = usingVars.getNext();
        }
        if (containsObject) {
            classLinkage.append("      return IsCobol.call (\"" + iName + "\", new Object[] {");
        } else {
            classLinkage.append("      return IsCobol.call (\"" + iName + "\", new CobolVar[] {");
        }
        int i = 0;
        VariableDeclaration v3 = usingVars.getFirst();
        while (v3 != null) {
            if (i > 0) {
                classLinkage.append(",");
            }
            if (!v3.isObjectReference()) {
                if (byValues.contains(using.getAt(i))) {
                    classLinkage.append(v3.getEasyDeclUnivoqueName() + ".byVal()");
                } else {
                    classLinkage.append(v3.getEasyDeclUnivoqueName() + ".byRef()");
                }
            } else {
                classLinkage.append(v3.getEasyDeclUnivoqueName());
            }
            ++i;
            v3 = usingVars.getNext();
        }
        classLinkage.append("}, false);" + eol);
        classLinkage.append("   }" + eol);
        classLinkage.append("   public int run(Object argv[])" + eol);
        classLinkage.append("      throws IscobolRuntimeException," + eol);
        classLinkage.append("             StopRunAsException {" + eol);
        classLinkage.append("      return run(argv, false);" + eol);
        classLinkage.append("   }" + eol);
        classLinkage.append("   public int run(Object argv[], boolean isNew)" + eol);
        classLinkage.append("      throws IscobolRuntimeException," + eol);
        classLinkage.append("             StopRunAsException {" + eol);
        classLinkage.append("      if (isNew)" + eol);
        classLinkage.append("         IsCobol.cancel(\"" + iName + "\");" + eol);
        classLinkage.append("      return IsCobol.call (\"" + iName + "\", argv, false);" + eol);
        classLinkage.append("   }" + eol);
        classLinkage.append("}" + eol);
        try {
            String easyLinkName = Pcc.getEasyLinkageFileName(iName + ".java", true, this.tm);
            PrintWriter out = PreProcessor.newPrintWriter(easyLinkName);
            out.print(classLinkage.toString());
            out.close();
            if (this.jj) {
                System.out.println("Generated '" + easyLinkName + "'");
            }
            if (this.jc || !this.jj && !this.jc) {
                System.out.println("Generated '" + easyLinkName.replace(".java", ".class") + "'");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void getServiceBridgeWsdlCode(Pcc pc, String name, VariableNameList using) {
        int i;
        StringBuffer wsdlBuffer = new StringBuffer();
        StringBuffer dynPart = new StringBuffer();
        String ind = "  ";
        String formDef = "unqualified";
        String style = Config.getProperty(".compiler.servicebridge.soap.style", "RPC");
        boolean rpc = true;
        if (style.equalsIgnoreCase("DOCUMENT")) {
            rpc = false;
            formDef = "qualified";
        }
        String targetRoot = Config.getProperty(".compiler.servicebridge.soap.namespace", "http://tempuri.org/");
        String namespaceSuffix = Config.getProperty(".compiler.servicebridge.soap.namespace_suffix", name);
        String schemas = Config.getProperty(".compiler.servicebridge.schemas", "http://schemas.xmlsoap.org/wsdl/");
        String xmlschema = Config.getProperty(".compiler.servicebridge.xmlschema", "http://www.w3.org/2001/XMLSchema");
        String formDefault = Config.getProperty(".compiler.servicebridge.formdefault", formDef);
        String address = Config.getProperty(".compiler.servicebridge.soap.url", "http://localhost:8080");
        String wsiClaim = Config.getProperty(".compiler.servicebridge.wsiclaim", "http://ws-i.org/schemas/conformanceClaim/");
        String servName = name;
        VariableDeclarationList usingVars = new VariableDeclarationList();
        String wsdlName = pc.getWsdlFileName();
        if (using != null) {
            VariableName vnu = using.getFirst();
            while (vnu != null) {
                if (!vnu.isFactory()) {
                    usingVars.addItem(vnu.getVarDecl());
                }
                vnu = using.getNext();
            }
        }
        wsdlBuffer.append("<?xml version=\"");
        wsdlBuffer.append(Config.getProperty(".compiler.servicebridge.xmlversion", "1.0"));
        wsdlBuffer.append("\" encoding=\"");
        wsdlBuffer.append(Config.getProperty(".compiler.servicebridge.encoding", "UTF-8"));
        wsdlBuffer.append("\" standalone=\"");
        wsdlBuffer.append(Config.getProperty(".compiler.servicebridge.standalone", "no"));
        wsdlBuffer.append("\" ?>" + eol);
        wsdlBuffer.append("<definitions name=\"" + name + "\" targetNamespace=\"" + targetRoot + namespaceSuffix + "\"" + eol);
        wsdlBuffer.append("            xmlns=\"" + schemas + "\"" + eol);
        wsdlBuffer.append("            xmlns:soap=\"" + schemas + "soap/\"" + eol);
        wsdlBuffer.append("            xmlns:tns=\"" + targetRoot + namespaceSuffix + "\"" + eol);
        wsdlBuffer.append("            xmlns:wsdl=\"" + schemas + "\"" + eol);
        if (!rpc) {
            wsdlBuffer.append("            xmlns:wsi=\"" + wsiClaim + "\"" + eol);
        }
        wsdlBuffer.append("            xmlns:xs=\"" + xmlschema + "\">" + eol);
        wsdlBuffer.append(" <!-- isCOBOL generated WSDL                     " + eol);
        wsdlBuffer.append("     * " + Version.getRelease() + eol);
        wsdlBuffer.append("     * " + Pcc.getCopyrightInfo() + eol);
        wsdlBuffer.append("     *" + eol);
        wsdlBuffer.append("     * source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        wsdlBuffer.append("     * compiler options: " + pc.getOptions().getAll().replace('\\', '/') + "-->" + eol);
        wsdlBuffer.append(ind + "<types>" + eol);
        ind = ind + "  ";
        wsdlBuffer.append(ind + "<schema elementFormDefault=\"" + formDefault + "\" targetNamespace=\"" + targetRoot + namespaceSuffix + "\"" + eol);
        wsdlBuffer.append(ind + "        xmlns=\"" + xmlschema + "\"" + eol);
        if (rpc) {
            wsdlBuffer.append(ind + "        xmlns:SOAP-ENC=\"" + NS_SOAPENC + "\"" + eol);
        }
        wsdlBuffer.append(ind + "        xmlns:tns=\"" + targetRoot + namespaceSuffix + "\">" + eol);
        HashMap<String, List[]> ioNames = new HashMap<String, List[]>();
        ioNames.put(servName, this.doWsdlElement(servName, usingVars, wsdlBuffer, dynPart, ind, rpc));
        Entry[] entries = pc.getEntryPoints();
        for (i = 0; i < entries.length; ++i) {
            VariableDeclarationList intUsingVars = new VariableDeclarationList();
            if (entries[i].using != null) {
                VariableName vnu = entries[i].using.getFirst();
                while (vnu != null) {
                    if (!vnu.isFactory()) {
                        intUsingVars.addItem(vnu.getVarDecl());
                    }
                    vnu = entries[i].using.getNext();
                }
            }
            String opName = entries[i].getServiceBridgeValueName();
            ioNames.put(opName, this.doWsdlElement(opName, intUsingVars, wsdlBuffer, dynPart, ind, rpc));
        }
        ind = ind.substring(0, ind.length() - 2);
        wsdlBuffer.append(ind + "</schema>" + eol);
        ind = ind.substring(0, ind.length() - 2);
        wsdlBuffer.append(ind + "</types>" + eol);
        this.doWsdlMessage(servName, wsdlBuffer, ind, (List[])ioNames.get(servName));
        for (i = 0; i < entries.length; ++i) {
            String opName = entries[i].getServiceBridgeValueName();
            this.doWsdlMessage(opName, wsdlBuffer, ind, (List[])ioNames.get(opName));
        }
        wsdlBuffer.append(ind + "<portType name=\"" + name + "\">" + eol);
        this.doWsdlPortOperation(servName, wsdlBuffer, ind);
        for (i = 0; i < entries.length; ++i) {
            this.doWsdlPortOperation(entries[i].getServiceBridgeValueName(), wsdlBuffer, ind);
        }
        wsdlBuffer.append(ind + "</portType>" + eol);
        wsdlBuffer.append(ind + "<binding name=\"" + name + "\" type=\"tns:" + name + "\">" + eol);
        if (!rpc) {
            wsdlBuffer.append(ind + "  <soap:binding style=\"document\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>" + eol);
        } else {
            wsdlBuffer.append(ind + "  <soap:binding style=\"rpc\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>" + eol);
        }
        this.doWsdlBindOperation(servName, wsdlBuffer, ind, targetRoot, name, rpc, namespaceSuffix);
        for (i = 0; i < entries.length; ++i) {
            this.doWsdlBindOperation(entries[i].getServiceBridgeValueName(), wsdlBuffer, ind, targetRoot, name, rpc, namespaceSuffix);
        }
        wsdlBuffer.append(ind + "</binding>" + eol);
        wsdlBuffer.append(ind + "<service name=\"" + name + "\">" + eol);
        wsdlBuffer.append(ind + "  <port binding=\"tns:" + name + "\" name=\"" + name + "\">" + eol);
        wsdlBuffer.append(ind + "      <soap:address location=\"" + address + "\"/>" + eol);
        wsdlBuffer.append(ind + "  </port>" + eol);
        wsdlBuffer.append(ind + "</service>" + eol);
        wsdlBuffer.append(eol);
        wsdlBuffer.append("</definitions>" + eol);
        try {
            PrintWriter out = PreProcessor.newPrintWriter(wsdlName);
            out.print(wsdlBuffer.toString());
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    List[] doWsdlElement(String servName, VariableDeclarationList usingVars, StringBuffer wsdlBuffer, StringBuffer dynPart, String ind, boolean rpc) {
        ArrayList<String> inputNameLst = new ArrayList<String>();
        ArrayList<String> outputNameLst = new ArrayList<String>();
        if (rpc) {
            VariableDeclaration v = usingVars.getFirst();
            while (v != null) {
                int mode = v.getWsdlMode();
                if (mode == 0) {
                    if (rpc && v.picture != null && (v.level == 1 || v.level == 77)) {
                        inputNameLst.add("fil_" + v.getWsdlNameReal(true) + v.getWsdlDecoration(true, true));
                    } else {
                        inputNameLst.add(v.getWsdlNameReal(true) + v.getWsdlDecoration(true, true));
                    }
                    outputNameLst.add(v.getWsdlNameReal(false) + v.getWsdlDecoration(false, true));
                } else if (mode == 2) {
                    if (v.hasChildDifferentMode(false)) {
                        inputNameLst.add(v.getWsdlNameReal(true) + v.getWsdlDecoration(true, true));
                        outputNameLst.add(v.getWsdlNameReal(false) + v.getWsdlDecoration(false, true));
                    } else {
                        outputNameLst.add(v.getWsdlName(false));
                    }
                } else if (mode == 1) {
                    if (v.hasChildDifferentMode(true)) {
                        inputNameLst.add(v.getWsdlName(true) + v.getWsdlDecoration(true, true));
                        outputNameLst.add(v.getWsdlName(false) + v.getWsdlDecoration(false, true));
                    } else if (rpc && v.picture != null && (v.level == 1 || v.level == 77)) {
                        inputNameLst.add("fil_" + v.getWsdlName(true));
                    } else {
                        inputNameLst.add(v.getWsdlName(true));
                    }
                }
                v = usingVars.getNext();
            }
        }
        ind = ind + "  ";
        for (int i = 0; i < 2; ++i) {
            if (usingVars.getFirst() != null) {
                if (!rpc) {
                    wsdlBuffer.append(ind + "<element name=\"" + servName);
                    if (i == 0) {
                        wsdlBuffer.append("\">" + eol);
                    } else {
                        wsdlBuffer.append("Response\">" + eol);
                    }
                    ind = ind + "  ";
                    wsdlBuffer.append(ind + "<complexType>" + eol);
                    ind = ind + "  ";
                    wsdlBuffer.append(ind + "<sequence>" + eol);
                }
                VariableDeclaration v = usingVars.getFirst();
                while (v != null) {
                    StringBuffer code = v.getServiceBridgeWsdlCode(ind, i == 0, dynPart, rpc);
                    if (!rpc || rpc && v.getPicture() != null) {
                        wsdlBuffer.append(code);
                    }
                    v = usingVars.getNext();
                }
                if (!rpc) {
                    wsdlBuffer.append(ind + "</sequence>" + eol);
                    ind = ind.substring(0, ind.length() - 2);
                    wsdlBuffer.append(ind + "</complexType>" + eol);
                    ind = ind.substring(0, ind.length() - 2);
                    wsdlBuffer.append(ind + "</element>" + eol);
                }
                wsdlBuffer.append(dynPart);
                if (dynPart.length() <= 0) continue;
                dynPart.delete(0, dynPart.length() - 1);
                continue;
            }
            if (!rpc) {
                wsdlBuffer.append(ind + "<element name=\"" + servName);
                if (i == 0) {
                    wsdlBuffer.append("\">" + eol);
                } else {
                    wsdlBuffer.append("Response\">" + eol);
                }
                ind = ind + "  ";
                wsdlBuffer.append(ind + "<complexType>" + eol);
                ind = ind + "  ";
                wsdlBuffer.append(ind + "<sequence/>" + eol);
                ind = ind.substring(0, ind.length() - 2);
                wsdlBuffer.append(ind + "</complexType>" + eol);
                ind = ind.substring(0, ind.length() - 2);
                wsdlBuffer.append(ind + "</element>" + eol);
            }
            wsdlBuffer.append(dynPart);
            if (dynPart.length() <= 0) continue;
            dynPart.delete(0, dynPart.length() - 1);
        }
        return new List[]{inputNameLst, outputNameLst};
    }

    void doWsdlMessage(String servName, StringBuffer wsdlBuffer, String ind, List[] ioNames) {
        int i;
        if (ioNames[0].size() > 0) {
            wsdlBuffer.append(ind + "<message name=\"" + servName + "Input\">" + eol);
            for (i = 0; i < ioNames[0].size(); ++i) {
                wsdlBuffer.append(ind + "   <part name=\"" + ioNames[0].get(i) + "\" type=\"tns:" + ioNames[0].get(i) + "\"/>" + eol);
            }
            wsdlBuffer.append(ind + "</message>" + eol);
        } else {
            wsdlBuffer.append(ind + "<message name=\"" + servName + "Input\">" + eol);
            wsdlBuffer.append(ind + "   <part element=\"tns:" + servName + "\" name=\"parameters\"/>" + eol);
            wsdlBuffer.append(ind + "</message>" + eol);
        }
        if (ioNames[1].size() > 0) {
            wsdlBuffer.append(ind + "<message name=\"" + servName + "Output\">" + eol);
            for (i = 0; i < ioNames[1].size(); ++i) {
                wsdlBuffer.append(ind + "   <part name=\"" + ioNames[1].get(i) + "\" type=\"tns:" + ioNames[1].get(i) + "\"/>" + eol);
            }
            wsdlBuffer.append(ind + "</message>" + eol);
        } else {
            wsdlBuffer.append(ind + "<message name=\"" + servName + "Output\">" + eol);
            wsdlBuffer.append(ind + "   <part element=\"tns:" + servName + "Response\" name=\"parameters\"/>" + eol);
            wsdlBuffer.append(ind + "</message>" + eol);
        }
    }

    void doWsdlPortOperation(String servName, StringBuffer wsdlBuffer, String ind) {
        wsdlBuffer.append(ind + "   <operation name=\"" + servName + "\">" + eol);
        wsdlBuffer.append(ind + "     <input message=\"tns:" + servName + "Input\"/>" + eol);
        wsdlBuffer.append(ind + "     <output message=\"tns:" + servName + "Output\"/>" + eol);
        wsdlBuffer.append(ind + "   </operation>" + eol);
    }

    void doWsdlBindOperation(String servName, StringBuffer wsdlBuffer, String ind, String targetRoot, String name, boolean rpc, String namespaceSuffix) {
        wsdlBuffer.append(ind + "    <operation name=\"" + servName + "\">" + eol);
        wsdlBuffer.append(ind + "    <soap:operation soapAction=\"\"/>" + eol);
        wsdlBuffer.append(ind + "      <input>" + eol);
        if (!rpc) {
            wsdlBuffer.append(ind + "         <soap:body use=\"literal\"/>" + eol);
        } else {
            wsdlBuffer.append(ind + "         <soap:body encodingStyle=\"" + NS_SOAPENC + "\" namespace=\"" + targetRoot + namespaceSuffix + "\" use=\"encoded\"/>" + eol);
        }
        wsdlBuffer.append(ind + "      </input>" + eol);
        wsdlBuffer.append(ind + "      <output>" + eol);
        if (!rpc) {
            wsdlBuffer.append(ind + "         <soap:body use=\"literal\"/>" + eol);
        } else {
            wsdlBuffer.append(ind + "         <soap:body encodingStyle=\"" + NS_SOAPENC + "\" namespace=\"" + targetRoot + namespaceSuffix + "\" use=\"encoded\"/>" + eol);
        }
        wsdlBuffer.append(ind + "      </output>" + eol);
        wsdlBuffer.append(ind + "    </operation>" + eol);
    }

    void getServiceBridgeCobCode(Pcc pc, String name, String callName, VariableNameList using, int numEntry, boolean isEntry) {
        String type = Config.getProperty(".compiler.servicebridge.type", "SOAP");
        if (type.equalsIgnoreCase("SOAP")) {
            this.getServiceBridgeCobCodeSOAP(pc, name, callName, using, numEntry, isEntry);
            if (Config.getProperty(".compiler.servicebridge.bean", "").equalsIgnoreCase("soap")) {
                this.getServiceBridgeCobCodeBeanSOAP(pc, name, callName, using, numEntry, isEntry);
            }
        } else if (type.equalsIgnoreCase("REST")) {
            this.getServiceBridgeCobCodeREST(pc, name, callName, using, numEntry, isEntry);
            if (Config.getProperty(".compiler.servicebridge.bean", "").equalsIgnoreCase("rest")) {
                this.getServiceBridgeCobCodeBeanREST(pc, name, callName, using, numEntry, isEntry);
            }
        } else if (type.equalsIgnoreCase("EJB")) {
            this.getServiceBridgeCobCodeREST(pc, name, callName, using, numEntry, isEntry);
        } else {
            this.error.print(227, 2, this.firstToken, type);
        }
    }

    void getServiceBridgeCobCodeSOAP(Pcc pc, String name, String callName, VariableNameList using, int numEntry, boolean isEntry) {
        StringBuffer cblBuffer = new StringBuffer();
        VariableDeclarationList usingVars = new VariableDeclarationList();
        String style = Config.getProperty(".compiler.servicebridge.soap.style", "RPC");
        String ind = "       ";
        boolean rpc = false;
        String cblName = pc.getServiceBridgeSoapFileName(name);
        boolean hasOccDyn = false;
        Object vOccDyn = null;
        this.loadTagAreas(cblName);
        if (style.equalsIgnoreCase("RPC")) {
            rpc = true;
        }
        if (using != null) {
            VariableName vnu = using.getFirst();
            while (vnu != null) {
                if (!vnu.isFactory()) {
                    usingVars.addItem(vnu.getVarDecl());
                }
                vnu = using.getNext();
            }
        }
        cblBuffer.append("            >>SOURCE FORMAT FREE" + eol);
        cblBuffer.append("*>start {iscobol}compiler-directives" + eol);
        cblBuffer.append("            >>SET servicebridge false" + eol);
        cblBuffer.append("            >>SET easylinkage 0" + eol);
        cblBuffer.append("*>end {iscobol}compiler-directives" + eol);
        cblBuffer.append(this.tagAreas.get(tagCompDir));
        cblBuffer.append("*>start {iscobol}prog-comment" + eol);
        cblBuffer.append("*>*" + eol);
        cblBuffer.append("*> Program generated by isCobol compiler for ServiceBridge feature SOAP type" + eol);
        cblBuffer.append("*> " + Version.getRelease() + eol);
        cblBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
        cblBuffer.append("*>" + eol);
        cblBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        cblBuffer.append("*> compiler options: " + pc.getOptions().getAll().replace('\\', '/') + eol);
        String serviceBridgeSoapPrefix = Config.getProperty(".compiler.servicebridge.soap.prefix", "soap").trim();
        cblBuffer.append("*>end {iscobol}prog-comment" + eol);
        cblBuffer.append(this.tagAreas.get(tagProgCom));
        cblBuffer.append("*>start {iscobol}progid" + eol);
        cblBuffer.append("program-id. " + serviceBridgeSoapPrefix + name + "." + eol);
        cblBuffer.append("*>end {iscobol}progid" + eol);
        if (this.tagAreas.get(tagProgId).length() == 0) {
            cblBuffer.append("configuration section." + eol);
        } else {
            cblBuffer.append(this.tagAreas.get(tagProgId));
        }
        cblBuffer.append("*>start {iscobol}repository" + eol);
        cblBuffer.append("repository. " + eol);
        cblBuffer.append("      class xml-stream  as \"com.iscobol.rts.XMLStream\"" + eol);
        cblBuffer.append("           class web-area as \"com.iscobol.rts.HTTPHandler\"" + eol);
        if (isEntry) {
            cblBuffer.append("           class varcob as \"" + Pcc.TYPES_PACKAGE + ".CobolVar[]\"" + eol);
            cblBuffer.append("           class withentrypoints as \"com.iscobol.rts.WithEntryPoints\"" + eol);
            cblBuffer.append("           class jclass as \"java.lang.Class\"" + eol);
        }
        cblBuffer.append("*>end {iscobol}repository" + eol);
        if (this.tagAreas.get(tagReposit).length() == 0) {
            cblBuffer.append("           ." + eol);
            cblBuffer.append("working-storage section." + eol);
        } else {
            cblBuffer.append(this.tagAreas.get(tagReposit));
        }
        cblBuffer.append("*>start {iscobol}working-storage" + eol);
        VariableDeclaration v = usingVars.getFirst();
        while (v != null) {
            if (v.isWithDynamic() && !v.hasCapacity()) {
                hasOccDyn = true;
            }
            v.getServiceBridgeCobCode(ind, cblBuffer);
            v = usingVars.getNext();
        }
        cblBuffer.append(eol);
        cblBuffer.append("       77  prg-x-stream object reference xml-stream." + eol);
        if (isEntry) {
            cblBuffer.append("       77  classProg object reference withentrypoints." + eol);
            cblBuffer.append("       77  cobvars   object reference varcob." + eol);
        }
        cblBuffer.append("       77  ind0                      pic 9(18)." + eol);
        cblBuffer.append("       77  ind1                      pic 9(18)." + eol);
        cblBuffer.append("       77  ind2                      pic 9(18)." + eol);
        cblBuffer.append("       77  ind3                      pic 9(18)." + eol);
        cblBuffer.append("       77  ind4                      pic 9(18)." + eol);
        cblBuffer.append("       77  ind5                      pic 9(18)." + eol);
        cblBuffer.append("       77  ind6                      pic 9(18)." + eol);
        cblBuffer.append("       77  ind7                      pic 9(18)." + eol);
        cblBuffer.append("       77  ind8                      pic 9(18)." + eol);
        cblBuffer.append(eol);
        this.runWsdl2Cobol(pc, name, cblBuffer);
        cblBuffer.append(eol);
        cblBuffer.append("*>end {iscobol}working-storage" + eol);
        if (this.tagAreas.get(tagWorkSto).length() == 0) {
            cblBuffer.append("linkage section." + eol);
        } else {
            cblBuffer.append(this.tagAreas.get(tagWorkSto));
        }
        cblBuffer.append("*>start {iscobol}linkage" + eol);
        cblBuffer.append("       01  comm-area object reference web-area." + eol);
        cblBuffer.append("*>end {iscobol}linkage" + eol);
        cblBuffer.append(this.tagAreas.get(tagLinkage));
        cblBuffer.append("*>start {iscobol}procedure-using" + eol);
        cblBuffer.append("procedure division using comm-area." + eol);
        cblBuffer.append("*>end {iscobol}procedure-using" + eol);
        if (this.tagAreas.get(tagProcUsi).length() == 0) {
            cblBuffer.append("main." + eol);
        } else {
            cblBuffer.append(this.tagAreas.get(tagProcUsi));
        }
        cblBuffer.append("*>start {iscobol}accept-http" + eol);
        cblBuffer.append("    comm-area:>acceptFromXML(soap-in-" + name + ")" + eol);
        cblBuffer.append(eol);
        cblBuffer.append("*>end {iscobol}accept-http" + eol);
        cblBuffer.append(this.tagAreas.get(tagAcceHtt));
        cblBuffer.append("*>start {iscobol}http-to-linkage" + eol);
        v = usingVars.getFirst();
        while (v != null) {
            v.getServiceBridgeCobMove("    ", "a-", "", cblBuffer, true, "", name, rpc);
            v = usingVars.getNext();
        }
        cblBuffer.append(eol);
        cblBuffer.append("*>end {iscobol}http-to-linkage" + eol);
        cblBuffer.append(this.tagAreas.get(tagHttpLin));
        cblBuffer.append("*>start {iscobol}call" + eol);
        if (isEntry) {
            String pack = Config.getProperty(".compiler.servicebridge.package", "");
            if (pack.length() > 0) {
                pack = pack + ".";
            }
            cblBuffer.append("    try" + eol);
            cblBuffer.append("       set classProg to jclass:>forName(\"" + pack + pc.getClassName() + "\"):>newInstance as withentrypoints" + eol);
            cblBuffer.append("    catch exception" + eol);
            cblBuffer.append("    end-try" + eol);
            cblBuffer.append("    set cobvars   to varcob:>new(" + usingVars.getItemNum() + ")" + eol);
            int i = 0;
            VariableDeclaration v2 = usingVars.getFirst();
            while (v2 != null) {
                cblBuffer.append("    set cobvars(" + i + ") to " + v2.getName() + pc.getNumName(v2.getNameToken()) + eol);
                ++i;
                v2 = usingVars.getNext();
            }
            cblBuffer.append("    classProg:>call(" + numEntry + ", cobvars)" + eol);
        } else {
            if (usingVars.getFirst() != null) {
                cblBuffer.append("    call \"" + callName + "\" using " + eol);
            } else {
                cblBuffer.append("    call \"" + callName + "\"" + eol);
            }
            v = usingVars.getFirst();
            while (v != null) {
                cblBuffer.append("                   " + v.getName() + pc.getNumName(v.getNameToken()) + eol);
                v = usingVars.getNext();
            }
        }
        cblBuffer.append(eol);
        cblBuffer.append("*>end {iscobol}call" + eol);
        cblBuffer.append(this.tagAreas.get(tagCall));
        cblBuffer.append("*>start {iscobol}linkage-to-http" + eol);
        v = usingVars.getFirst();
        while (v != null) {
            v.getServiceBridgeCobMove("    ", "a-", "", cblBuffer, false, "", name, rpc);
            v = usingVars.getNext();
        }
        cblBuffer.append(eol);
        cblBuffer.append("                   ." + eol);
        cblBuffer.append("*>end {iscobol}linkage-to-http" + eol);
        cblBuffer.append(this.tagAreas.get(tagLinkHtt));
        cblBuffer.append("*>start {iscobol}http-response" + eol);
        String chrSet = Config.getProperty(".compiler.servicebridge.soap.charset", "UTF-8");
        cblBuffer.append("    comm-area:>addOutHeader(\"Content-Type\",\"text/xml;charset=" + chrSet + "\")" + eol);
        cblBuffer.append("    comm-area:>displayXML(soap-out-" + name + ")" + eol);
        cblBuffer.append(eol);
        cblBuffer.append("*>end {iscobol}http-response" + eol);
        cblBuffer.append(this.tagAreas.get(tagHttpRes));
        cblBuffer.append("*>start {iscobol}goback" + eol);
        cblBuffer.append("    goback." + eol);
        cblBuffer.append("*>end {iscobol}goback" + eol);
        cblBuffer.append(this.tagAreas.get(tagGoback));
        try {
            PrintWriter out = PreProcessor.newPrintWriter(cblName);
            out.print(cblBuffer.toString());
            System.out.println("Generated '" + cblName + "'");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void getServiceBridgeCobCodeREST(Pcc pc, String name, String callName, VariableNameList using, int numEntry, boolean isEntry) {
        StringBuffer cblBuffer = new StringBuffer();
        VariableDeclarationList usingVars = new VariableDeclarationList();
        int mode = 0;
        boolean hasInput = false;
        boolean hasOutput = false;
        String cblName = pc.getServiceBridgeRestFileName(name);
        boolean hasOccDyn = false;
        Token vOccDyn = null;
        this.loadTagAreas(cblName);
        if (using != null) {
            VariableName vnu = using.getFirst();
            while (vnu != null) {
                if (!vnu.isFactory()) {
                    usingVars.addItem(vnu.getVarDecl());
                }
                vnu = using.getNext();
            }
        }
        VariableDeclaration v = usingVars.getFirst();
        while (!(v == null || hasInput && hasOutput)) {
            if (v.isWithDynamic() && !v.hasCapacity()) {
                hasOccDyn = true;
                vOccDyn = v.getNameToken();
            }
            if (v.has49LevChildOf48Lev()) {
                this.error.print(286, 2, v.getNameToken(), cblName);
                return;
            }
            mode = v.getWsdlMode();
            if (mode != -2 && (mode == 1 || mode == 0) && v.picture != null || v.hasChildDifferentMode(false)) {
                hasInput = true;
            }
            if (mode != -2 && (mode == 2 || mode == 0) && v.picture != null || v.hasChildDifferentMode(true)) {
                hasOutput = true;
            }
            v = usingVars.getNext();
        }
        cblBuffer.append("            >>SOURCE FORMAT FREE" + eol);
        cblBuffer.append("*>start {iscobol}compiler-directives" + eol);
        cblBuffer.append("            >>SET servicebridge false" + eol);
        cblBuffer.append("            >>SET easylinkage 0" + eol);
        cblBuffer.append("*>end {iscobol}compiler-directives" + eol);
        cblBuffer.append(this.tagAreas.get(tagCompDir));
        cblBuffer.append("*>start {iscobol}prog-comment" + eol);
        cblBuffer.append("*>*" + eol);
        cblBuffer.append("*> Program generated by isCobol compiler for ServiceBridge feature REST type" + eol);
        cblBuffer.append("*> " + Version.getRelease() + eol);
        cblBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
        cblBuffer.append("*>" + eol);
        cblBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        cblBuffer.append("*> compiler options: " + pc.getOptions().getAll().replace('\\', '/') + eol);
        String serviceBridgeRestPrefix = Config.getProperty(".compiler.servicebridge.rest.prefix", "rest").trim();
        cblBuffer.append("*>end {iscobol}prog-comment" + eol);
        cblBuffer.append(this.tagAreas.get(tagProgCom));
        cblBuffer.append("*>start {iscobol}progid" + eol);
        cblBuffer.append("program-id. " + serviceBridgeRestPrefix + name + "." + eol);
        cblBuffer.append("*>end {iscobol}progid" + eol);
        if (this.tagAreas.get(tagProgId).length() == 0) {
            cblBuffer.append("configuration section." + eol);
        } else {
            cblBuffer.append(this.tagAreas.get(tagProgId));
        }
        cblBuffer.append("*>start {iscobol}repository" + eol);
        cblBuffer.append("repository. " + eol);
        cblBuffer.append("           class web-area as \"com.iscobol.rts.HTTPHandler\"" + eol);
        if (isEntry) {
            cblBuffer.append("           class varcob as \"" + Pcc.TYPES_PACKAGE + ".CobolVar[]\"" + eol);
            cblBuffer.append("           class withentrypoints as \"com.iscobol.rts.WithEntryPoints\"" + eol);
            cblBuffer.append("           class jclass as \"java.lang.Class\"" + eol);
        }
        cblBuffer.append("*>end {iscobol}repository" + eol);
        if (this.tagAreas.get(tagReposit).length() == 0) {
            cblBuffer.append("           ." + eol);
            cblBuffer.append("working-storage section." + eol);
        } else {
            cblBuffer.append(this.tagAreas.get(tagReposit));
        }
        cblBuffer.append("*>start {iscobol}working-storage" + eol);
        VariableDeclaration v2 = usingVars.getFirst();
        while (v2 != null) {
            v2.getServiceBridgeCobCode("", "int", cblBuffer, true);
            v2 = usingVars.getNext();
        }
        cblBuffer.append(eol);
        if (isEntry) {
            cblBuffer.append("77  classProg object reference withentrypoints." + eol);
            cblBuffer.append("77  cobvars   object reference varcob." + eol);
        }
        cblBuffer.append("77  ind0                      pic 9(18)." + eol);
        cblBuffer.append("77  ind1                      pic 9(18)." + eol);
        cblBuffer.append("77  ind2                      pic 9(18)." + eol);
        cblBuffer.append("77  ind3                      pic 9(18)." + eol);
        cblBuffer.append("77  ind4                      pic 9(18)." + eol);
        cblBuffer.append("77  ind5                      pic 9(18)." + eol);
        cblBuffer.append("77  ind6                      pic 9(18)." + eol);
        cblBuffer.append("77  ind7                      pic 9(18)." + eol);
        cblBuffer.append("77  ind8                      pic 9(18)." + eol);
        cblBuffer.append("77  request-method            pic x any length." + eol);
        cblBuffer.append("    88  post-method     value \"POST\"." + eol);
        cblBuffer.append("    88  put-method      value \"PUT\"." + eol);
        cblBuffer.append("    88  delete-method   value \"DELETE\"." + eol);
        cblBuffer.append("    88  get-method      value \"GET\"." + eol);
        cblBuffer.append("01  request-varin identified by \"Request\"." + eol);
        v2 = usingVars.getFirst();
        while (v2 != null) {
            v2.getServiceBridgeRestCobCode("", cblBuffer, true);
            v2 = usingVars.getNext();
        }
        if (!hasInput) {
            cblBuffer.append("         03  iscobol-dummy-varin pic x." + eol);
        }
        cblBuffer.append("01  response-varout identified by \"Response\"." + eol);
        v2 = usingVars.getFirst();
        while (v2 != null) {
            v2.getServiceBridgeRestCobCode("  ", cblBuffer, false);
            v2 = usingVars.getNext();
        }
        if (!hasOutput) {
            cblBuffer.append("         03  iscobol-dummy-varout pic x." + eol);
        }
        cblBuffer.append("*>end {iscobol}working-storage" + eol);
        cblBuffer.append(eol);
        if (this.tagAreas.get(tagWorkSto).length() == 0) {
            cblBuffer.append("linkage section." + eol);
        } else {
            cblBuffer.append(this.tagAreas.get(tagWorkSto));
        }
        cblBuffer.append("*>start {iscobol}linkage" + eol);
        cblBuffer.append("01  comm-area object reference web-area." + eol);
        cblBuffer.append("*>end {iscobol}linkage" + eol);
        cblBuffer.append(this.tagAreas.get(tagLinkage));
        cblBuffer.append("*>start {iscobol}procedure-using" + eol);
        cblBuffer.append("procedure division using comm-area." + eol);
        cblBuffer.append("*>end {iscobol}procedure-using" + eol);
        if (this.tagAreas.get(tagProcUsi).length() == 0) {
            cblBuffer.append("main." + eol);
        } else {
            cblBuffer.append(this.tagAreas.get(tagProcUsi));
        }
        cblBuffer.append("*>start {iscobol}accept-http" + eol);
        cblBuffer.append(eol);
        cblBuffer.append("    set request-method to comm-area:>getMethod()" + eol);
        if (hasInput) {
            cblBuffer.append("   if post-method or put-method" + eol);
            cblBuffer.append("*> POST and PUT methods" + eol);
            cblBuffer.append("     comm-area:>acceptEx(request-varin)" + eol);
            cblBuffer.append("   else" + eol);
            cblBuffer.append("*> GET, DELETE and other methods" + eol);
            v2 = usingVars.getFirst();
            while (v2 != null) {
                mode = v2.getWsdlMode();
                if (mode != -2 && (mode == 1 || mode == 0) || v2.hasChildDifferentMode(false)) {
                    v2.getServiceBridgeCobRestAccept("     ", cblBuffer, "");
                }
                v2 = usingVars.getNext();
            }
            cblBuffer.append("   end-if" + eol);
            cblBuffer.append(eol);
            cblBuffer.append("*>end {iscobol}accept-http" + eol);
            cblBuffer.append(this.tagAreas.get(tagAcceHtt));
            cblBuffer.append("*>start {iscobol}http-to-linkage" + eol);
            v2 = usingVars.getFirst();
            while (v2 != null) {
                mode = v2.getWsdlMode();
                if (mode != -2 && (mode == 1 || mode == 0) || v2.hasChildDifferentMode(false)) {
                    v2.getServiceBridgeCobMove("    ", "", "int", cblBuffer, true, "", true, name);
                }
                v2 = usingVars.getNext();
            }
            cblBuffer.append("*>end {iscobol}http-to-linkage" + eol);
            cblBuffer.append(this.tagAreas.get(tagHttpLin));
        } else {
            cblBuffer.append("*>end {iscobol}accept-http" + eol);
            cblBuffer.append(this.tagAreas.get(tagAcceHtt));
        }
        cblBuffer.append(eol);
        cblBuffer.append("*>start {iscobol}call" + eol);
        if (isEntry) {
            String pack = Config.getProperty(".compiler.servicebridge.package", "");
            if (pack.length() > 0) {
                pack = pack + ".";
            }
            cblBuffer.append("    try" + eol);
            cblBuffer.append("       set classProg to jclass:>forName(\"" + pack + pc.getClassName() + "\"):>newInstance as withentrypoints" + eol);
            cblBuffer.append("    catch exception" + eol);
            cblBuffer.append("    end-try" + eol);
            cblBuffer.append("    set cobvars   to varcob:>new(" + usingVars.getItemNum() + ")" + eol);
            int i = 0;
            VariableDeclaration v3 = usingVars.getFirst();
            while (v3 != null) {
                cblBuffer.append("    set cobvars(" + i + ") to int" + v3.getName() + eol);
                ++i;
                v3 = usingVars.getNext();
            }
            cblBuffer.append("    classProg:>call(" + numEntry + ", cobvars)" + eol);
        } else {
            if (usingVars.getFirst() != null) {
                cblBuffer.append("    call \"" + callName + "\" using " + eol);
            } else {
                cblBuffer.append("    call \"" + callName + "\"" + eol);
            }
            v2 = usingVars.getFirst();
            while (v2 != null) {
                cblBuffer.append("                   int" + v2.getName() + eol);
                v2 = usingVars.getNext();
            }
        }
        cblBuffer.append("*>end {iscobol}call" + eol);
        cblBuffer.append(this.tagAreas.get(tagCall));
        cblBuffer.append("*>start {iscobol}linkage-to-http" + eol);
        cblBuffer.append(eol);
        if (hasOutput) {
            v2 = usingVars.getFirst();
            while (v2 != null) {
                mode = v2.getWsdlMode();
                if (mode != -2 && (mode == 2 || mode == 0 || v2.hasChildDifferentMode(true))) {
                    v2.getServiceBridgeCobMove("    ", "", "int", cblBuffer, false, "", true, name);
                }
                v2 = usingVars.getNext();
            }
        }
        cblBuffer.append("                   ." + eol);
        cblBuffer.append("*>end {iscobol}linkage-to-http" + eol);
        cblBuffer.append(this.tagAreas.get(tagLinkHtt));
        cblBuffer.append("*>start {iscobol}http-response" + eol);
        if (hasOutput) {
            cblBuffer.append("    comm-area:>displayEx(response-varout)" + eol);
        }
        cblBuffer.append(eol);
        cblBuffer.append("*>end {iscobol}http-response" + eol);
        cblBuffer.append(this.tagAreas.get(tagHttpRes));
        cblBuffer.append("*>start {iscobol}goback" + eol);
        cblBuffer.append(eol);
        cblBuffer.append("    goback." + eol);
        cblBuffer.append("*>end {iscobol}goback" + eol);
        try {
            PrintWriter out = PreProcessor.newPrintWriter(cblName);
            out.print(cblBuffer.toString());
            out.close();
            System.out.println("Generated '" + cblName + "'");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void getServiceBridgeCobCodeBeanREST(Pcc pc, String name, String callName, VariableNameList using, int numEntry, boolean isEntry) {
        Enumeration en;
        VariableDeclaration v;
        StringBuffer cblBuffer = new StringBuffer();
        Vector usings = new Vector();
        VariableDeclarationList usingVars = new VariableDeclarationList();
        boolean hasInput = false;
        boolean hasOutput = false;
        int mode = 0;
        String serviceBridgeBeanPrefix = Config.getProperty(".compiler.servicebridge.bean.prefix", "bean").trim();
        boolean hasOccDyn = false;
        Token vOccDyn = null;
        if (using != null) {
            VariableName vnu = using.getFirst();
            while (vnu != null) {
                if (!vnu.isFactory()) {
                    usingVars.addItem(vnu.getVarDecl());
                }
                vnu = using.getNext();
            }
        }
        VariableDeclaration v2 = usingVars.getFirst();
        while (v2 != null) {
            if (v2.isWithDynamic()) {
                hasOccDyn = true;
                vOccDyn = v2.getNameToken();
            }
            v2 = usingVars.getNext();
        }
        v2 = usingVars.getFirst();
        while (!(v2 == null || hasInput && hasOutput)) {
            mode = v2.getWsdlMode();
            if (mode != -2 && (mode == 1 || mode == 0) && v2.picture != null || v2.hasChildDifferentMode(false)) {
                hasInput = true;
            }
            if (mode != -2 && (mode == 2 || mode == 0) && v2.picture != null || v2.hasChildDifferentMode(true)) {
                hasOutput = true;
            }
            v2 = usingVars.getNext();
        }
        cblBuffer.append("            >>SOURCE FORMAT FREE" + eol);
        cblBuffer.append("            >>IMP OPTION \"#whttp\"" + eol);
        cblBuffer.append("            >>SET servicebridge false" + eol);
        cblBuffer.append("            >>SET easylinkage 0" + eol);
        cblBuffer.append("*>*" + eol);
        cblBuffer.append("*> Program generated by isCobol compiler for ServiceBridge feature REST type" + eol);
        cblBuffer.append("*> " + Version.getRelease() + eol);
        cblBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
        cblBuffer.append("*>" + eol);
        cblBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        cblBuffer.append("*> compiler options: " + pc.getOptions().getAll().replace('\\', '/') + eol);
        String serviceBridgeBeanPackage = Config.getProperty(".compiler.servicebridge.bean.package", "").trim();
        if (serviceBridgeBeanPackage.length() > 0) {
            serviceBridgeBeanPackage = serviceBridgeBeanPackage + ".";
        }
        cblBuffer.append("class-id. " + serviceBridgeBeanPrefix + name + " as \"" + serviceBridgeBeanPackage + serviceBridgeBeanPrefix + name + "\"." + eol);
        cblBuffer.append("configuration section." + eol);
        cblBuffer.append("repository. " + eol);
        cblBuffer.append("           class HTTP-CLIENT as \"com.iscobol.rts.HTTPClient\"" + eol);
        cblBuffer.append("           class HTTP-PARAM as \"com.iscobol.rts.HTTPData.Params\"." + eol);
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("factory." + eol);
        cblBuffer.append("data division." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append("procedure division." + eol);
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("method-id. \"main\"." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("   copy \"" + serviceBridgeBeanPrefix + name + ".wrk\"." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("01 var object reference " + serviceBridgeBeanPrefix + name + "." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("linkage section." + eol);
        cblBuffer.append("01 value-in object reference \"java.lang.String[]\"." + eol);
        cblBuffer.append("procedure division using value-in." + eol);
        cblBuffer.append("main." + eol);
        cblBuffer.append("   set var to " + serviceBridgeBeanPrefix + name + ":>new()." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("   copy \"" + serviceBridgeBeanPrefix + name + ".cpy\"." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("end method \"main\"." + eol);
        cblBuffer.append("end factory." + eol);
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("object." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append(eol);
        VariableDeclaration v3 = usingVars.getFirst();
        while (v3 != null) {
            v3.getServiceBridgeCobCode("", "bean-", cblBuffer);
            v3 = usingVars.getNext();
        }
        cblBuffer.append("       01  LNK-INVAR identified by \"Request\"." + eol);
        if (!hasInput) {
            cblBuffer.append("         03  iscobol-dummy-varin pic x." + eol);
        }
        v3 = usingVars.getFirst();
        while (v3 != null) {
            v3.getServiceBridgeRestCobCode("", cblBuffer, true);
            v3 = usingVars.getNext();
        }
        cblBuffer.append("       01  response-varout identified by \"Response\"." + eol);
        v3 = usingVars.getFirst();
        while (v3 != null) {
            v3.getServiceBridgeRestCobCode("", cblBuffer, false);
            v3 = usingVars.getNext();
        }
        if (!hasOutput) {
            cblBuffer.append("         03  iscobol-dummy-varout pic x." + eol);
        }
        cblBuffer.append(eol);
        String urlName = Config.getProperty(".compiler.servicebridge.bean.url", "http://localhost:8080/services").trim() + "/" + name;
        cblBuffer.append("01  url pic x any length value" + eol);
        cblBuffer.append("    \"" + urlName.trim() + "\"." + eol);
        cblBuffer.append("77  http object reference http-client." + eol);
        cblBuffer.append("77  params object reference http-param." + eol);
        cblBuffer.append("77  response-code        pic S9(3)." + eol);
        cblBuffer.append("77  response-message     pic x(256)." + eol);
        cblBuffer.append("77  indx                 pic 9(18)." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("procedure division." + eol);
        cblBuffer.append("*> --------->" + eol);
        cblBuffer.append(eol);
        int numUsing = 0;
        VariableDeclaration tmpVar = null;
        StringBuffer tmpBuf = new StringBuffer();
        if (usingVars.getFirst() != null) {
            tmpBuf.append(eol);
            tmpBuf.append("identification division." + eol);
            tmpBuf.append("method-id. \"run\"." + eol);
            tmpBuf.append("working-storage section." + eol);
            tmpBuf.append("linkage section." + eol);
            v = usingVars.getFirst();
            while (v != null) {
                v.getServiceBridgeBeanCobCode("", "", tmpBuf, usings, true);
                v = usingVars.getNext();
            }
            en = usings.elements();
            while (en.hasMoreElements()) {
                tmpVar = (VariableDeclaration)en.nextElement();
                if (tmpVar.getOccursAll() == 0) {
                    ++numUsing;
                    continue;
                }
                numUsing += tmpVar.getOccursAll();
            }
            if (numUsing > 254) {
                this.error.print(250, 2, this.firstToken, serviceBridgeBeanPrefix + callName);
            } else if (hasOccDyn) {
                this.error.print(270, 2, vOccDyn, serviceBridgeBeanPrefix + callName);
            } else {
                int i;
                cblBuffer.append(tmpBuf);
                cblBuffer.append("procedure division using");
                en = usings.elements();
                while (en.hasMoreElements()) {
                    tmpVar = (VariableDeclaration)en.nextElement();
                    if (tmpVar.haveOccursClause() && tmpVar.isDynamic()) {
                        cblBuffer.append(eol + " dyn-" + tmpVar.name.getWord());
                        continue;
                    }
                    if (tmpVar.getOccursAll() == 0) {
                        cblBuffer.append(eol + " " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name));
                        continue;
                    }
                    for (i = 0; i < tmpVar.getOccursAll(); ++i) {
                        cblBuffer.append(eol + eol + " " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "_" + i);
                    }
                }
                cblBuffer.append("." + eol);
                cblBuffer.append("main." + eol);
                en = usings.elements();
                while (en.hasMoreElements()) {
                    tmpVar = (VariableDeclaration)en.nextElement();
                    if (tmpVar.haveOccursClause() && tmpVar.isDynamic()) {
                        cblBuffer.append("     set dynamic-bean-" + tmpVar.name.getWord() + " to dyn-" + tmpVar.name.getWord() + eol);
                        continue;
                    }
                    if (tmpVar.getOccursAll() == 0) {
                        cblBuffer.append("     set bean-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + " to " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + eol);
                        continue;
                    }
                    for (i = 0; i < tmpVar.getOccursAll(); ++i) {
                        cblBuffer.append("     set bean-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "(" + (i + 1) + ") to " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "_" + i + eol);
                    }
                }
                en = usings.elements();
                while (en.hasMoreElements()) {
                    tmpVar = (VariableDeclaration)en.nextElement();
                    if (tmpVar.haveOccursClause() && tmpVar.isDynamic()) {
                        cblBuffer.append("     set " + tmpVar.getWsdlNameSuff(true) + "-in to dyn-" + tmpVar.name.getWord() + eol);
                        continue;
                    }
                    if (tmpVar.getOccursAll() == 0) {
                        cblBuffer.append("     set " + tmpVar.getWsdlNameSuff(true) + "-in to " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + eol);
                        continue;
                    }
                    for (i = 0; i < tmpVar.getOccursAll(); ++i) {
                        cblBuffer.append("     set " + tmpVar.getWsdlNameSuff(true) + "-in(" + (i + 1) + ") to " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "_" + i + eol);
                    }
                }
                cblBuffer.append("     if http = null" + eol);
                cblBuffer.append("        set  http = http-client:>new()" + eol);
                cblBuffer.append("     end-if" + eol);
                cblBuffer.append("     try" + eol);
                cblBuffer.append("        http:>doPostEx (url, LNK-invar )" + eol);
                cblBuffer.append("        http:>getResponseCode (response-code)" + eol);
                cblBuffer.append(eol);
                cblBuffer.append("        if response-code = 200" + eol);
                cblBuffer.append("           http:>getResponseEx (response-varout)" + eol);
                v = usingVars.getFirst();
                while (v != null) {
                    v.getServiceBridgeBeanCobMove("           ", "", "bean-", false, cblBuffer, 0);
                    v = usingVars.getNext();
                }
                cblBuffer.append("        else" + eol);
                cblBuffer.append("           http:>getResponseMessage (response-message)" + eol);
                cblBuffer.append("           display \"ERROR\" response-code \"-\" response-message" + eol);
                cblBuffer.append("        end-if" + eol);
                cblBuffer.append("     catch exception" + eol);
                cblBuffer.append("        display \"error[\" exception-object:>toString \"]\"" + eol);
                cblBuffer.append("     end-try" + eol);
                cblBuffer.append("     goback." + eol);
                cblBuffer.append(eol);
                cblBuffer.append("end method \"run\"." + eol);
            }
        }
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("method-id. \"run\"." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append("procedure division." + eol);
        cblBuffer.append("main." + eol);
        en = usings.elements();
        while (en.hasMoreElements()) {
            tmpVar = (VariableDeclaration)en.nextElement();
            if (tmpVar.haveOccursClause() && tmpVar.isInDynamic()) {
                cblBuffer.append("    perform varying indx from 1 by 1 until  indx > ");
                if (tmpVar.getCapacityAll() != null) {
                    cblBuffer.append(tmpVar.getCapacityAll().getVarDecl().name.getWord() + eol);
                } else if (tmpVar.isDynamic()) {
                    cblBuffer.append("cap-" + tmpVar.name.getWord() + "-in" + eol);
                } else {
                    cblBuffer.append("cap-" + tmpVar.getDynamicVarName() + "-in" + eol);
                }
                cblBuffer.append("       move bean-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "(indx) to " + tmpVar.getWsdlNameSuff(true) + "-in(indx)" + eol);
                cblBuffer.append("    end-perform" + eol);
                continue;
            }
            if (tmpVar.getOccursAll() == 0) {
                cblBuffer.append("     move bean-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + " to " + tmpVar.getWsdlNameSuff(true) + "-in" + eol);
                continue;
            }
            cblBuffer.append("     perform varying indx from 1 by 1 until  indx > " + tmpVar.getOccursAll() + eol);
            cblBuffer.append("        move bean-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "(indx) to " + tmpVar.getWsdlNameSuff(true) + "-in(indx)" + eol);
            cblBuffer.append("     end-perform" + eol);
        }
        cblBuffer.append("     if http = null" + eol);
        cblBuffer.append("        set  http = http-client:>new()" + eol);
        cblBuffer.append("     end-if" + eol);
        cblBuffer.append("     try" + eol);
        cblBuffer.append("        http:>doPostEx (url, LNK-invar )" + eol);
        cblBuffer.append("        http:>getResponseCode (response-code)" + eol);
        cblBuffer.append(eol);
        cblBuffer.append("        if response-code = 200" + eol);
        cblBuffer.append("           http:>getResponseEx (response-varout)" + eol);
        v = usingVars.getFirst();
        while (v != null) {
            v.getServiceBridgeBeanCobMove("           ", "", "bean-", false, cblBuffer, 0);
            v = usingVars.getNext();
        }
        cblBuffer.append("        else" + eol);
        cblBuffer.append("           http:>getResponseMessage (response-message)" + eol);
        cblBuffer.append("           display \"ERROR\" response-code \"-\" response-message" + eol);
        cblBuffer.append("     end-if" + eol);
        cblBuffer.append("     catch exception" + eol);
        cblBuffer.append("        display \"error[\" exception-object:>toString \"]\"" + eol);
        cblBuffer.append("     end-try" + eol);
        cblBuffer.append("     goback." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("end method \"run\"." + eol);
        cblBuffer.append(eol);
        v = usingVars.getFirst();
        while (v != null) {
            v.getServiceBridgeBeanSetGetCobCode(cblBuffer);
            v = usingVars.getNext();
        }
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("method-id. \"set_url\"." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append("linkage section." + eol);
        cblBuffer.append("77 value-in object reference \"java.lang.String\"." + eol);
        cblBuffer.append("procedure division using value-in." + eol);
        cblBuffer.append("main." + eol);
        cblBuffer.append("   set url to value-in." + eol);
        cblBuffer.append("end method \"set_url\"." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("method-id. \"get_url\"." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append("linkage section." + eol);
        cblBuffer.append("77 value-out object reference \"java.lang.String\"." + eol);
        cblBuffer.append("procedure division returning value-out." + eol);
        cblBuffer.append("main." + eol);
        cblBuffer.append("   set value-out to url." + eol);
        cblBuffer.append("end method \"get_url\"." + eol);
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("end object." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("*> end class " + serviceBridgeBeanPrefix + name + eol);
        try {
            String cblName = pc.getServiceBridgeRestBeanFileName(name);
            PrintWriter out = PreProcessor.newPrintWriter(cblName);
            out.print(cblBuffer.toString());
            out.close();
            System.out.println("Generated '" + cblName + "'");
            this.doCopyFile(pc, serviceBridgeBeanPrefix + name, false);
            this.doCopyFile(pc, serviceBridgeBeanPrefix + name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void getServiceBridgeCobCodeBeanSOAP(Pcc pc, String name, String callName, VariableNameList using, int numEntry, boolean isEntry) {
        StringBuffer cblBuffer = new StringBuffer();
        Vector usings = new Vector();
        VariableDeclarationList usingVars = new VariableDeclarationList();
        String serviceBridgeBeanPrefix = Config.getProperty(".compiler.servicebridge.bean.prefix", "bean").trim();
        boolean hasOccDyn = false;
        Token vOccDyn = null;
        if (using != null) {
            VariableName vnu = using.getFirst();
            while (vnu != null) {
                if (!vnu.isFactory()) {
                    usingVars.addItem(vnu.getVarDecl());
                }
                vnu = using.getNext();
            }
        }
        VariableDeclaration v = usingVars.getFirst();
        while (v != null && !hasOccDyn) {
            if (v.isWithDynamic()) {
                hasOccDyn = true;
                vOccDyn = v.getNameToken();
            }
            v = usingVars.getNext();
        }
        cblBuffer.append("            >>SOURCE FORMAT FREE" + eol);
        cblBuffer.append("            >>IMP OPTION \"#whttp\"" + eol);
        cblBuffer.append("            >>SET servicebridge false" + eol);
        cblBuffer.append("            >>SET easylinkage 0" + eol);
        cblBuffer.append("*>*" + eol);
        cblBuffer.append("*> Program generated by isCobol compiler for ServiceBridge feature SOAP type" + eol);
        cblBuffer.append("*> " + Version.getRelease() + eol);
        cblBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
        cblBuffer.append("*>" + eol);
        cblBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
        cblBuffer.append("*> compiler options: " + pc.getOptions().getAll().replace('\\', '/') + eol);
        String serviceBridgeBeanPackage = Config.getProperty(".compiler.servicebridge.bean.package", "").trim();
        if (serviceBridgeBeanPackage.length() > 0) {
            serviceBridgeBeanPackage = serviceBridgeBeanPackage + ".";
        }
        cblBuffer.append("class-id. " + serviceBridgeBeanPrefix + name + " as \"" + serviceBridgeBeanPackage + serviceBridgeBeanPrefix + name + "\"." + eol);
        cblBuffer.append("configuration section." + eol);
        cblBuffer.append("repository. " + eol);
        cblBuffer.append("           class HTTP-CLIENT as \"com.iscobol.rts.HTTPClient\"" + eol);
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("factory." + eol);
        cblBuffer.append("data division." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append("procedure division." + eol);
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("method-id. \"main\"." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("01 var object reference " + serviceBridgeBeanPrefix + name + "." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("   copy \"" + serviceBridgeBeanPrefix + name + ".wrk\"." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("linkage section." + eol);
        cblBuffer.append("01 value-in object reference \"java.lang.String[]\"." + eol);
        cblBuffer.append("procedure division using value-in." + eol);
        cblBuffer.append("main." + eol);
        cblBuffer.append("   set var to " + serviceBridgeBeanPrefix + name + ":>new()." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("   copy \"" + serviceBridgeBeanPrefix + name + ".cpy\"." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("end method \"main\"." + eol);
        cblBuffer.append("end factory." + eol);
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("object." + eol);
        cblBuffer.append("working-storage section." + eol);
        String urlN = Config.getProperty(".compiler.servicebridge.bean.url", "http://localhost:8080/services").trim() + "/" + name;
        cblBuffer.append("01  var-url pic x any length value \"" + urlN + "/" + name + "\"." + eol);
        cblBuffer.append("77  ind0        pic 9(18)." + eol);
        VariableDeclaration v2 = usingVars.getFirst();
        while (v2 != null) {
            v2.getServiceBridgeCobCode("", "bean-", cblBuffer);
            v2 = usingVars.getNext();
        }
        this.runWsdl2Cobol(pc, name, cblBuffer);
        cblBuffer.append(eol);
        cblBuffer.append("77  http object reference http-client." + eol);
        cblBuffer.append("01  plain-response       pic x any length." + eol);
        cblBuffer.append("01  response-code        pic S9(3)." + eol);
        cblBuffer.append("01  response-message     pic x(256)." + eol);
        cblBuffer.append("77  indx                 pic 9(18)." + eol);
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("procedure division." + eol);
        cblBuffer.append("*>---------->");
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("method-id. \"run\"." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append(eol);
        cblBuffer.append(eol);
        cblBuffer.append("procedure division." + eol);
        cblBuffer.append("main." + eol);
        v2 = usingVars.getFirst();
        while (v2 != null) {
            v2.getServiceBridgeCobMove("    ", "a-", "bean-", cblBuffer, true, "", name);
            v2 = usingVars.getNext();
        }
        cblBuffer.append("    set environment \"xmlstream.omit_empty_elements\" to 0." + eol);
        cblBuffer.append("    set http = http-client:>new." + eol);
        cblBuffer.append("    try" + eol);
        cblBuffer.append("       http:>doPostEx (" + eol);
        cblBuffer.append("                var-url " + eol);
        cblBuffer.append("                \"application/soap+xml; charset=utf-8\"" + eol);
        cblBuffer.append("                 soap-in-" + name + ")" + eol);
        cblBuffer.append("       http:>getResponseCode (response-code)" + eol);
        cblBuffer.append("       if response-code = 200" + eol);
        cblBuffer.append("          http:>getResponseXML (soap-out-" + name + ")" + eol);
        v2 = usingVars.getFirst();
        while (v2 != null) {
            v2.getServiceBridgeCobMove("          ", "a-", "bean-", cblBuffer, false, "", name);
            v2 = usingVars.getNext();
        }
        cblBuffer.append("       else" + eol);
        cblBuffer.append("          http:>getResponsePlain (plain-response)" + eol);
        cblBuffer.append("          display \"error[\" plain-response \"]\"" + eol);
        cblBuffer.append("       end-if" + eol);
        cblBuffer.append("    catch exception" + eol);
        cblBuffer.append("       display \"error[\" exception-object:>toString \"]\"" + eol);
        cblBuffer.append("    end-try" + eol);
        cblBuffer.append(eol);
        cblBuffer.append("end method \"run\"." + eol);
        cblBuffer.append(eol);
        int numUsing = 0;
        VariableDeclaration tmpVar = null;
        StringBuffer tmpBuf = new StringBuffer();
        tmpBuf.append(eol);
        tmpBuf.append("identification division." + eol);
        tmpBuf.append("method-id. \"run\"." + eol);
        tmpBuf.append("working-storage section." + eol);
        tmpBuf.append("linkage section." + eol);
        VariableDeclaration v3 = usingVars.getFirst();
        while (v3 != null) {
            v3.getServiceBridgeBeanCobCode("", "", tmpBuf, usings, true);
            v3 = usingVars.getNext();
        }
        Enumeration en = usings.elements();
        while (en.hasMoreElements()) {
            tmpVar = (VariableDeclaration)en.nextElement();
            if (tmpVar.getOccursAll() == 0) {
                ++numUsing;
                continue;
            }
            numUsing += tmpVar.getOccursAll();
        }
        if (numUsing > 254) {
            this.error.print(250, 2, this.firstToken, serviceBridgeBeanPrefix + callName);
        } else if (hasOccDyn) {
            this.error.print(270, 2, vOccDyn, serviceBridgeBeanPrefix + callName);
        } else {
            int i;
            cblBuffer.append(tmpBuf);
            cblBuffer.append("procedure division using");
            en = usings.elements();
            while (en.hasMoreElements()) {
                tmpVar = (VariableDeclaration)en.nextElement();
                if (tmpVar.haveOccursClause() && tmpVar.isDynamic()) {
                    cblBuffer.append(eol + " dyn-" + tmpVar.name.getWord());
                    continue;
                }
                if (tmpVar.getOccursAll() == 0) {
                    cblBuffer.append(eol + " " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name));
                    continue;
                }
                for (i = 0; i < tmpVar.getOccursAll(); ++i) {
                    cblBuffer.append(eol + " " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "_" + i);
                }
            }
            cblBuffer.append("." + eol);
            cblBuffer.append("main." + eol);
            en = usings.elements();
            while (en.hasMoreElements()) {
                tmpVar = (VariableDeclaration)en.nextElement();
                if (tmpVar.isDynamic()) {
                    cblBuffer.append("    set dynamic-bean-" + tmpVar.name.getWord() + " to dyn-" + tmpVar.name.getWord() + eol);
                    continue;
                }
                if (tmpVar.getOccursAll() == 0) {
                    cblBuffer.append("    set bean-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + " to " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + eol);
                    continue;
                }
                for (i = 0; i < tmpVar.getOccursAll(); ++i) {
                    cblBuffer.append("    set bean-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "(" + (i + 1) + ") to " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "_" + i + eol);
                }
            }
            v3 = usingVars.getFirst();
            while (v3 != null) {
                v3.getServiceBridgeCobMove("    ", "a-", "bean-", cblBuffer, true, "", name);
                v3 = usingVars.getNext();
            }
            cblBuffer.append("    ." + eol);
            cblBuffer.append(eol);
            cblBuffer.append("    set environment \"xmlstream.omit_empty_elements\" to 0." + eol);
            cblBuffer.append("    set http = http-client:>new." + eol);
            cblBuffer.append("    try" + eol);
            cblBuffer.append("       http:>doPostEx (" + eol);
            cblBuffer.append("                var-url" + eol);
            cblBuffer.append("                \"application/soap+xml; charset=utf-8\"" + eol);
            cblBuffer.append("                 soap-in-" + name + ")" + eol);
            cblBuffer.append("       http:>getResponseCode (response-code)" + eol);
            cblBuffer.append("       if response-code = 200" + eol);
            cblBuffer.append("          http:>getResponseXML (soap-out-" + name + ")" + eol);
            v3 = usingVars.getFirst();
            while (v3 != null) {
                v3.getServiceBridgeCobMove("          ", "a-", "bean-", cblBuffer, false, "", name);
                v3 = usingVars.getNext();
            }
            en = usings.elements();
            while (en.hasMoreElements()) {
                tmpVar = (VariableDeclaration)en.nextElement();
                if (tmpVar.isDynamic()) {
                    cblBuffer.append("          set dyn-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + " to dynamic-bean-" + tmpVar.name.getWord() + eol);
                    continue;
                }
                if (tmpVar.getOccursAll() == 0) {
                    cblBuffer.append("          set " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + " to bean-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + eol);
                    continue;
                }
                for (i = 0; i < tmpVar.getOccursAll(); ++i) {
                    cblBuffer.append("          set " + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "_" + i + " to bean-" + tmpVar.name.getWord() + pc.getNumName(tmpVar.name) + "(" + (i + 1) + ")" + eol);
                }
            }
            cblBuffer.append("       else" + eol);
            cblBuffer.append("          http:>getResponsePlain (plain-response)" + eol);
            cblBuffer.append("          display \"error[\" plain-response \"]\"" + eol);
            cblBuffer.append("       end-if" + eol);
            cblBuffer.append("    catch exception" + eol);
            cblBuffer.append("       display \"error[\" exception-object:>toString \"]\"" + eol);
            cblBuffer.append("    end-try" + eol);
            cblBuffer.append(eol);
            cblBuffer.append("end method \"run\"." + eol);
        }
        cblBuffer.append(eol);
        v3 = usingVars.getFirst();
        while (v3 != null) {
            v3.getServiceBridgeBeanSetGetCobCode(cblBuffer);
            v3 = usingVars.getNext();
        }
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("method-id. \"set_url\"." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append("linkage section." + eol);
        cblBuffer.append("77 value-in object reference \"java.lang.String\"." + eol);
        cblBuffer.append("procedure division using value-in." + eol);
        cblBuffer.append("main." + eol);
        cblBuffer.append("   set var-url to value-in." + eol);
        cblBuffer.append("end method \"set_url\"." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("identification division." + eol);
        cblBuffer.append("method-id. \"get_url\"." + eol);
        cblBuffer.append("working-storage section." + eol);
        cblBuffer.append("linkage section." + eol);
        cblBuffer.append("77 value-out object reference \"java.lang.String\"." + eol);
        cblBuffer.append("procedure division returning value-out." + eol);
        cblBuffer.append("main." + eol);
        cblBuffer.append("   set value-out to var-url." + eol);
        cblBuffer.append("end method \"get_url\"." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("end object." + eol);
        cblBuffer.append(eol);
        cblBuffer.append("*> end class " + serviceBridgeBeanPrefix + name + eol);
        try {
            String cblName = pc.getServiceBridgeSoapBeanFileName(name);
            PrintWriter out = PreProcessor.newPrintWriter(cblName);
            out.print(cblBuffer.toString());
            out.close();
            System.out.println("Generated '" + cblName + "'");
            this.doCopyFile(pc, serviceBridgeBeanPrefix + name, false);
            this.doCopyFile(pc, serviceBridgeBeanPrefix + name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void doCopyFile(Pcc pc, String name) {
        this.doCopyFile(pc, name, true);
    }

    void doCopyFile(Pcc pc, String name, boolean isCpy) {
        String cpyName = pc.getServiceBridgeCopyFileName(name);
        if (!isCpy) {
            cpyName = pc.getServiceBridgeCopyFileNameWrk(name);
        }
        File inp = new File(cpyName);
        if (pc.getTokenManager().pp.getFileFinder().findFile(inp.getName()) == null && !inp.exists()) {
            if (pc.getTokenManager().pp.getFileFinder() instanceof CachedFileFinder) {
                ((CachedFileFinder)pc.getTokenManager().pp.getFileFinder()).clearCache();
            }
            StringBuffer cblBuffer = new StringBuffer();
            cblBuffer.append("*>*" + eol);
            cblBuffer.append("*> Copyfile generated by isCobol compiler for ServiceBridge feature" + eol);
            cblBuffer.append("*> " + Version.getRelease() + eol);
            cblBuffer.append("*> " + Pcc.getCopyrightInfo() + eol);
            cblBuffer.append("*>" + eol);
            cblBuffer.append("*> source file name: " + this.tm.getFileName().replace('\\', '/') + eol);
            cblBuffer.append("*> compiler options: " + pc.getOptions().getAll().replace('\\', '/') + eol);
            cblBuffer.append("*>*" + eol);
            cblBuffer.append(eol);
            cblBuffer.append(eol);
            cblBuffer.append(eol);
            cblBuffer.append("*> --------->" + eol);
            cblBuffer.append("*> --------->" + eol);
            if (isCpy) {
                cblBuffer.append("*> ---------> ADD YOUR CODE HERE" + eol);
            } else {
                cblBuffer.append("*> ---------> ADD YOUR VARIABLE DECLARATION  HERE" + eol);
            }
            cblBuffer.append("*> --------->" + eol);
            cblBuffer.append("*> --------->" + eol);
            try {
                PrintWriter out = PreProcessor.newPrintWriter(cpyName);
                out.print(cblBuffer.toString());
                out.close();
                if (pc.getFileFinder() instanceof RemoteFileFinder) {
                    RemoteFileFinder rff = (RemoteFileFinder)pc.getFileFinder();
                    rff.getCompileUnit().addBridgeFile((RemoteBridgeFile)RemoteCompiler.createRemoteFile(cpyName, cpyName.substring(rff.getSourceDir().length() + 1), 4));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    void runWsdl2Cobol(Pcc pc, String name, StringBuffer cblBuffer) {
        int version = Config.getProperty(".compiler.servicebridge.soap.envelope.version", 0);
        if (version < 0 || version > 1) {
            version = 0;
        }
        ServiceBridgeUtility wsdl2cob = new ServiceBridgeUtility(pc.getWsdlFileName(), version);
        wsdl2cob.setArraySizes(this.wdslArraySizes);
        try {
            Map<String, StringBuilder> map = wsdl2cob.generateCopyfiles();
            cblBuffer.append((Object)map.get(name));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void loadTagAreas(String cblName) {
        this.tagAreas.clear();
        this.tagAreas.put(tagCompDir, new StringBuffer());
        this.tagAreas.put(tagProgCom, new StringBuffer());
        this.tagAreas.put(tagProgId, new StringBuffer());
        this.tagAreas.put(tagReposit, new StringBuffer());
        this.tagAreas.put(tagWorkSto, new StringBuffer());
        this.tagAreas.put(tagLinkage, new StringBuffer());
        this.tagAreas.put(tagProcUsi, new StringBuffer());
        this.tagAreas.put(tagAcceHtt, new StringBuffer());
        this.tagAreas.put(tagHttpLin, new StringBuffer());
        this.tagAreas.put(tagCall, new StringBuffer());
        this.tagAreas.put(tagLinkHtt, new StringBuffer());
        this.tagAreas.put(tagHttpRes, new StringBuffer());
        this.tagAreas.put(tagGoback, new StringBuffer());
        try {
            FileReader finp = new FileReader(cblName);
            BufferedReader binp = new BufferedReader(finp);
            String line = binp.readLine();
            String tag = "";
            while (line != null) {
                if (line.trim().startsWith(endTag) && this.tagAreas.containsKey(tag = line.trim().substring(endTag.length()).trim())) {
                    line = binp.readLine();
                    while (line != null && !line.trim().startsWith(startTag)) {
                        this.tagAreas.get(tag).append(line + eol);
                        line = binp.readLine();
                    }
                }
                if (line == null) continue;
                line = binp.readLine();
            }
            binp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public WorkingStorageSection getWorkingStorageSection() {
        return this.wsSec;
    }

    @Override
    public LocalStorageSection getLocalStorageSection() {
        return this.lsSec;
    }

    @Override
    public ThreadLocalStorageSection getThreadLocalStorageSection() {
        return this.tlsSec;
    }

    @Override
    public LinkageSection getLinkageSection() {
        return this.linkSec;
    }

    @Override
    public FileSection getFileSection() {
        return this.fileSec;
    }

    @Override
    public ReportSection getReportSection() {
        return this.repoSec;
    }

    @Override
    public ScreenSection getScreenSection() {
        return this.screenSec;
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getLastToken() {
        return this.lastToken;
    }
}

