/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.PreProcessor;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.SelectList;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.Version;
import com.iscobol.interfaces.compiler.IInputOutputSectionExtension;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;

public class InputOutputSection
implements CobolToken,
ErrorsNumbers,
IInputOutputSectionExtension {
    private Pcc pc;
    TokenManager tm;
    Errors error;
    SelectList selects = new SelectList();
    private Token firstToken;
    private Token fcFirstToken;

    public InputOutputSection(Pcc p, TokenManager t, Errors err, Token firstToken) throws GeneralErrorException, EndOfProgramException {
        this.firstToken = firstToken;
        boolean goOn = true;
        this.pc = p;
        this.error = err;
        this.tm = t;
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 710) {
            if (this.tm.getToken().getToknum() != 10006) {
                this.error.print(188, 3, tk, "'.'");
                this.tm.ungetToken();
            }
            block8: while (goOn && (tk = this.tm.getToken()).getToknum() != 388 && tk.getToknum() != 652) {
                switch (tk.getToknum()) {
                    case 484: {
                        this.fcFirstToken = tk;
                        try {
                            this.fileControl();
                        }
                        catch (GeneralErrorException e) {
                            this.tm.skipToDot();
                        }
                        continue block8;
                    }
                    case 520: {
                        try {
                            this.ioControl();
                        }
                        catch (GeneralErrorException e) {
                            this.tm.skipToDot();
                        }
                        continue block8;
                    }
                }
                goOn = false;
            }
        } else {
            throw new UnexpectedTokenException(tk, err);
        }
        this.tm.ungetToken();
    }

    private void fileControl() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10006) {
            while ((tk = this.tm.getToken()).getToknum() == 713) {
                Select sn = new Select(this.pc, this.tm, this.error);
                Select s = this.selects.getFirst();
                while (s != null) {
                    if (s.fileName.getWord().equals(sn.fileName.getWord())) {
                        throw new GeneralErrorException(155, 4, sn.fileName, sn.fileName.getWord(), this.error);
                    }
                    s = this.selects.getNext();
                }
                this.selects.addItem(sn);
            }
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
        this.tm.ungetToken();
    }

    private void ioControl() throws GeneralErrorException, EndOfProgramException {
        boolean full = false;
        HashSet<Select> same = new HashSet<Select>();
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 10006) {
            boolean goOn = true;
            block4: while (goOn) {
                tk = this.tm.getToken();
                switch (tk.getToknum()) {
                    case 705: {
                        Select s;
                        boolean sameRecord;
                        Select s1 = null;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 671 || tk.getToknum() == 673) {
                            sameRecord = true;
                            tk = this.tm.getToken();
                        } else if (tk.getToknum() == 733 || tk.getToknum() == 734) {
                            sameRecord = false;
                            tk = this.tm.getToken();
                        } else {
                            sameRecord = false;
                        }
                        if (tk.getToknum() == 278) {
                            tk = this.tm.getToken();
                        }
                        if (tk.getToknum() != 495) {
                            this.tm.ungetToken();
                        }
                        while ((tk = this.tm.getToken()).getToknum() == 10009) {
                            s = this.selects.getFirst();
                            while (s != null && !s.fileName.getWord().equals(tk.getWord())) {
                                s = this.selects.getNext();
                            }
                            if (s == null) {
                                throw new GeneralErrorException(26, 4, tk, tk.getWord(), this.error);
                            }
                            if (!sameRecord) continue;
                            if (same.contains(s)) {
                                throw new GeneralErrorException(153, 4, tk, tk.getWord(), this.error);
                            }
                            same.add(s);
                            if (s1 == null) {
                                s1 = s;
                                continue;
                            }
                            s.setSameRecordArea(s1);
                        }
                        this.tm.ungetToken();
                        full = true;
                        continue block4;
                    }
                    case 276: {
                        boolean lockHolding;
                        Select s;
                        tk = this.tm.getToken();
                        if (tk.getToknum() == 572) {
                            lockHolding = true;
                            tk = this.tm.getToken();
                            if (tk.getToknum() != 614) {
                                throw new ExpectedFoundException(tk, this.error, "ON");
                            }
                        } else if ("WRITE-ONLY".equals(tk.getWord())) {
                            if (this.tm.getToken().getToknum() != 614) {
                                this.tm.ungetToken();
                            }
                            lockHolding = false;
                        } else {
                            throw new UnexpectedTokenException(tk, this.error);
                        }
                        while ((tk = this.tm.getToken()).getToknum() == 10009) {
                            s = this.selects.getFirst();
                            while (s != null && !s.fileName.getWord().equals(tk.getWord())) {
                                s = this.selects.getNext();
                            }
                            if (s == null) {
                                throw new GeneralErrorException(26, 4, tk, tk.getWord(), this.error);
                            }
                            if (!lockHolding) continue;
                            s.setMultipleRecords(true);
                        }
                        this.tm.ungetToken();
                        full = true;
                        continue block4;
                    }
                }
                goOn = false;
            }
            if (full) {
                if (tk.getToknum() != 10006) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
            } else {
                this.tm.ungetToken();
            }
        } else {
            throw new UnexpectedTokenException(tk, this.error);
        }
    }

    void check(Pcc pcc) {
        Select s = this.selects.getFirst();
        while (s != null) {
            try {
                s.check(pcc);
            }
            catch (GeneralErrorException generalErrorException) {
                // empty catch block
            }
            s = this.selects.getNext();
        }
    }

    @Override
    public void generateEfdFiles() throws Exception {
        this.makeEFD();
    }

    void makeEFD() throws GeneralErrorException {
        char save1 = Pcc.hyphenRepl;
        char save2 = Pcc.identifierSep;
        Pcc.hyphenRepl = (char)95;
        Pcc.identifierSep = (char)36;
        try {
            this.makeEFD0();
        }
        finally {
            Pcc.hyphenRepl = save1;
            Pcc.identifierSep = save2;
        }
    }

    private void makeEFD0() throws GeneralErrorException {
        String efo = this.tm.getOptionList().getOption("-efo=");
        String fillB = "                                                                                          ";
        Select s = this.selects.getFirst();
        while (s != null) {
            if (!(s.isPrinter || s.isSort() || this.pc.options.getOption("-efa") == null && s.organization != 530)) {
                try {
                    String tmpS;
                    PrintWriter fos;
                    File f;
                    StringBuffer path = new StringBuffer();
                    StringBuffer pathIss = new StringBuffer();
                    if (efo == null) {
                        if (this.pc.sourceDir != null && this.pc.sourceDir.length() > 0) {
                            path.append(this.pc.sourceDir);
                            path.append(File.separator);
                        }
                    } else {
                        path.append(efo);
                        path.append(File.separator);
                    }
                    pathIss.append(path.toString());
                    path.append(s.getEfdName() + ".xml");
                    pathIss.append(s.getEfdName() + ".iss");
                    if (this.pc.options.getOption("-efc") != null && s.organization == 530) {
                        f = new File(pathIss.toString());
                        if (f.exists()) {
                            f.delete();
                        }
                        if (f.createNewFile()) {
                            fos = PreProcessor.newPrintWriter(f);
                            tmpS = "<!-- Generated by " + Version.getRelease();
                            tmpS = tmpS.length() < 75 ? tmpS + fillB.substring(0, 75 - tmpS.length()) + "-->" + eol : tmpS + "-->" + eol;
                            fos.print(tmpS);
                            tmpS = "<!-- compiler options: " + this.pc.getOptions().getAll().replace('\\', '/');
                            tmpS = tmpS.length() < 75 ? tmpS + fillB.substring(0, 75 - tmpS.length()) + "-->" + eol : tmpS + "-->" + eol;
                            fos.print(tmpS);
                            fos.print(s.getEfcCode());
                            fos.close();
                        }
                    }
                    if (this.pc.options.getOption("-efd") != null || this.pc.options.getOption("-efa") != null) {
                        f = new File(path.toString());
                        if (f.exists()) {
                            f.delete();
                        }
                        if (f.createNewFile()) {
                            fos = PreProcessor.newPrintWriter(f);
                            tmpS = "<!-- Generated by " + Version.getRelease();
                            tmpS = tmpS.length() < 75 ? tmpS + fillB.substring(0, 75 - tmpS.length()) + "-->" + eol : tmpS + "-->" + eol;
                            fos.print(tmpS);
                            tmpS = "<!-- compiler options: " + this.pc.getOptions().getAll().replace('\\', '/');
                            tmpS = tmpS.length() < 75 ? tmpS + fillB.substring(0, 75 - tmpS.length()) + "-->" + eol : tmpS + "-->" + eol;
                            fos.print(tmpS);
                            fos.print(s.getEfdCode());
                            fos.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            s = this.selects.getNext();
        }
    }

    public String getCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        Select s = this.selects.getFirst();
        while (s != null) {
            if (!s.getFD().threadLocal) {
                Return2.append(s.getCode(dynPart));
            }
            s = this.selects.getNext();
        }
        return Return2.toString();
    }

    @Override
    public Token getFirstToken() {
        return this.firstToken;
    }

    @Override
    public Token getFileControlFirstToken() {
        return this.fcFirstToken;
    }

    @Override
    public SelectList getSelectList() {
        return this.selects;
    }
}

