/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.ExpectedFoundException;
import com.iscobol.compiler.FileDescriptor;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.ReportGroup;
import com.iscobol.compiler.ReportSection;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclaration;
import com.iscobol.compiler.VariableName;
import com.iscobol.interfaces.compiler.IReportDescriptor;
import java.util.List;
import java.util.Vector;

public class ReportDescriptor
implements CobolToken,
ErrorsNumbers,
IReportDescriptor {
    private Pcc pc;
    private TokenManager tm;
    private Errors error;
    final Token reportName;
    final VariableName reportVar;
    final ReportSection repoSec;
    final VariableDeclaration vParent;
    final VariableDeclaration lineCnt;
    final VariableDeclaration pageCnt;
    final VariableDeclaration printSw;
    FileDescriptor fd;
    private boolean isGlobal;
    private boolean isControlsFinal;
    private Vector controls = new Vector();
    public final int pageLimit;
    private int lineLimit;
    private int maxLen;
    private int heading;
    private int firstDetail;
    private int lastDetail;
    final int footing;
    private Vector<ReportGroup> reportGroups = new Vector();

    public ReportDescriptor(ReportSection rs, Token tk, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        int lpageLimit = 0;
        int lfooting = 0;
        this.repoSec = rs;
        this.pc = p;
        this.error = err;
        this.tm = t;
        tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(17, 4, tk, tk.getWord(), this.error);
        }
        this.reportName = tk;
        this.tm.ungetToken();
        this.reportVar = VariableName.get(this.tm, this.error);
        this.vParent = VariableDeclaration.getGroup01(this.pc, this.tm, this.reportName);
        this.vParent.setUsed();
        tk = new Token(10009, "LINE-COUNTER", 0, 0, this.tm.getFileName());
        this.lineCnt = VariableDeclaration.getPicDefaultNum(this.pc, this.tm, tk, false);
        this.lineCnt.setUsed();
        this.lineCnt.level = 2;
        this.lineCnt.parent = this.vParent;
        this.vParent.addChild(this.lineCnt);
        this.pc.loadVariable(this.lineCnt);
        tk = new Token(10009, "PAGE-COUNTER", 0, 0, this.tm.getFileName());
        this.pageCnt = VariableDeclaration.getPicDefaultNum(this.pc, this.tm, tk, false);
        this.pageCnt.setUsed();
        this.pageCnt.level = 2;
        this.pageCnt.parent = this.vParent;
        this.vParent.addChild(this.pageCnt);
        this.pc.loadVariable(this.pageCnt);
        tk = new Token(10009, "PRINT-SWITCH", 0, 0, this.tm.getFileName());
        this.printSw = VariableDeclaration.getPicDefaultNum(this.pc, this.tm, tk, false);
        this.printSw.setUsed();
        this.printSw.level = 2;
        this.printSw.parent = this.vParent;
        this.vParent.addChild(this.printSw);
        this.pc.loadVariable(this.printSw);
        block14: while ((tk = this.tm.getToken()).getToknum() != 10006) {
            switch (tk.getToknum()) {
                case 546: {
                    continue block14;
                }
                case 503: {
                    this.isGlobal = true;
                    continue block14;
                }
                case 373: 
                case 374: {
                    VariableName vn;
                    Token t1 = this.tm.getToken();
                    if (t1.getToknum() == 546 || t1.getToknum() == 277) {
                        t1 = this.tm.getToken();
                    }
                    if (t1.getToknum() == 488) {
                        this.isControlsFinal = true;
                    } else {
                        this.tm.ungetToken();
                    }
                    while ((vn = VariableName.get(this.tm, this.error)) != null) {
                        this.controls.add(vn);
                    }
                    if (this.isControlsFinal || this.controls.size() != 0) continue block14;
                    throw new GeneralErrorException(29, 4, tk, tk.getWord(), this.error);
                }
                case 566: {
                    this.lineLimit();
                    continue block14;
                }
                case 630: {
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 563 || tk.getToknum() == 564) {
                        tk = this.tm.getToken();
                    }
                    if (tk.getToknum() == 546 || tk.getToknum() == 277) {
                        tk = this.tm.getToken();
                    }
                    if (!Token.isIntLit(tk)) {
                        throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                    }
                    lpageLimit = tk.longValue();
                    if (lpageLimit <= 0) {
                        throw new GeneralErrorException(30, 4, tk, tk.getWord(), this.error);
                    }
                    tk = this.tm.getToken();
                    if (tk.getToknum() != 566 && tk.getToknum() != 567) {
                        this.tm.ungetToken();
                    }
                    block16: while ((tk = this.tm.getToken()).getToknum() != 10006) {
                        switch (tk.getToknum()) {
                            case 512: {
                                tk = this.tm.getToken();
                                if (tk.getToknum() == 546) {
                                    tk = this.tm.getToken();
                                }
                                if (!Token.isIntLit(tk)) {
                                    throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                                }
                                this.heading = tk.longValue();
                                if (this.heading >= 1) continue block16;
                                throw new GeneralErrorException(30, 4, tk, tk.getWord(), this.error);
                            }
                            case 490: {
                                tk = this.tm.getToken();
                                if (tk.getToknum() != 405) {
                                    throw new ExpectedFoundException(tk, this.error, "DETAIL");
                                }
                                tk = this.tm.getToken();
                                if (tk.getToknum() == 546) {
                                    tk = this.tm.getToken();
                                }
                                if (!Token.isIntLit(tk)) {
                                    throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                                }
                                this.firstDetail = tk.longValue();
                                continue block16;
                            }
                            case 555: {
                                tk = this.tm.getToken();
                                if (tk.getToknum() != 405) {
                                    throw new ExpectedFoundException(tk, this.error, "DETAIL");
                                }
                                tk = this.tm.getToken();
                                if (tk.getToknum() == 546) {
                                    tk = this.tm.getToken();
                                }
                                if (!Token.isIntLit(tk)) {
                                    throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                                }
                                this.lastDetail = tk.longValue();
                                continue block16;
                            }
                            case 494: {
                                tk = this.tm.getToken();
                                if (tk.getToknum() == 546) {
                                    tk = this.tm.getToken();
                                }
                                if (!Token.isIntLit(tk)) {
                                    throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
                                }
                                lfooting = tk.longValue();
                                continue block16;
                            }
                            case 566: {
                                this.lineLimit();
                                continue block16;
                            }
                        }
                    }
                    this.tm.ungetToken();
                    continue block14;
                }
            }
            throw new UnexpectedTokenException(tk, err);
        }
        this.pageLimit = lpageLimit;
        this.footing = lfooting;
        while ((tk = this.tm.getToken()).getToknum() == 10002 && tk.longValue() == 1) {
            ReportGroup rg = new ReportGroup(this, tk, this.pc, this.tm, this.error);
            this.reportGroups.add(rg);
        }
        this.tm.ungetToken();
    }

    void lineLimit() throws EndOfProgramException, GeneralErrorException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 563 || tk.getToknum() == 564) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 546 || tk.getToknum() == 277) {
            tk = this.tm.getToken();
        }
        if (!Token.isIntLit(tk)) {
            throw new GeneralErrorException(22, 4, tk, tk.getWord(), this.error);
        }
        this.lineLimit = tk.longValue();
        if (this.lineLimit <= 0) {
            throw new GeneralErrorException(30, 4, tk, tk.getWord(), this.error);
        }
    }

    ReportGroup getDetail(Token name) throws GeneralErrorException {
        ReportGroup rg = this.getReportGroup(name);
        if (rg != null) {
            if (rg.type == 4) {
                return rg;
            }
            throw new GeneralErrorException(182, 4, name, name.getWord(), this.error);
        }
        return null;
    }

    ReportGroup getReportGroup(Token name) {
        String n = name.getWord();
        for (int i = this.reportGroups.size() - 1; i >= 0; --i) {
            ReportGroup rg = this.reportGroups.elementAt(i);
            if (rg.getName() == null || !n.equals(rg.getName().getWord())) continue;
            return rg;
        }
        return null;
    }

    public void check() throws GeneralErrorException {
        int i;
        for (i = this.controls.size() - 1; i >= 0; --i) {
            VariableName vn = (VariableName)this.controls.elementAt(i);
            vn.check(this.pc);
            vn.getVarDecl().setUsed();
        }
        for (i = this.reportGroups.size() - 1; i >= 0; --i) {
            ReportGroup rg = this.reportGroups.elementAt(i);
            rg.check();
        }
        this.fd = this.pc.getFdByReport(this.reportName.getWord());
        if (this.fd == null) {
            throw new GeneralErrorException(51, 4, this.reportName, this.reportName.getWord(), this.error);
        }
        this.fd.defineReportVar(this.reportName, this.maxLen);
        if (this.pageLimit > 0) {
            int hd;
            int pg = this.pageLimit;
            int ft = this.footing > 0 ? this.footing : pg;
            int ld = this.lastDetail > 0 ? this.lastDetail : ft;
            int fd = this.firstDetail > 0 ? this.firstDetail : ld;
            int n = hd = this.heading > 0 ? this.heading : fd;
            if (ft > pg) {
                throw new GeneralErrorException(30, 4, this.reportName, "FOOTING " + ft, this.error);
            }
            if (ld > ft) {
                throw new GeneralErrorException(30, 4, this.reportName, "LAST DETAIL " + ld, this.error);
            }
            if (fd > ld) {
                throw new GeneralErrorException(30, 4, this.reportName, "FIRST DETAIL " + fd, this.error);
            }
            if (hd > fd) {
                throw new GeneralErrorException(30, 4, this.reportName, "HEADING " + hd, this.error);
            }
        }
    }

    @Override
    public String getName() {
        return "rw$" + this.reportName.getCode();
    }

    @Override
    public Token getTokenName() {
        return this.reportName;
    }

    public String getCode(StringBuffer dynPart) {
        StringBuffer Return2 = new StringBuffer();
        Return2.append("/* isGlobal = " + this.isGlobal + " */" + eol);
        Return2.append(this.tm.getCommentCode(this.reportName, "   "));
        Return2.append("   ReportWriter ");
        Return2.append(this.getName());
        Return2.append(";");
        Return2.append(eol);
        this.lineCnt.parent = null;
        Return2.append(this.lineCnt.getCode(dynPart));
        this.pageCnt.parent = null;
        Return2.append(this.pageCnt.getCode(dynPart));
        this.printSw.parent = null;
        Return2.append(this.printSw.getCode(dynPart));
        dynPart.append(this.getName());
        dynPart.append("=new ReportWriter (");
        dynPart.append(this.lineLimit > 0 && this.lineLimit < this.maxLen ? this.lineLimit : this.maxLen);
        dynPart.append(");");
        dynPart.append(eol);
        if (this.pageLimit > 0 || this.controls.size() > 0) {
            dynPart.append(this.getName());
            for (int i = 0; i < this.controls.size(); ++i) {
                dynPart.append(".setControl(");
                dynPart.append(((VariableName)this.controls.elementAt(i)).getCode());
                dynPart.append(")");
            }
            if (this.pageLimit > 0) {
                dynPart.append(".setPage(");
                dynPart.append(this.pageLimit);
                dynPart.append(")");
                if (this.heading > 0) {
                    dynPart.append(".setHeading(");
                    dynPart.append(this.heading);
                    dynPart.append(")");
                }
                if (this.firstDetail > 0) {
                    dynPart.append(".setFirstDetail(");
                    dynPart.append(this.firstDetail);
                    dynPart.append(")");
                }
                if (this.lastDetail > 0) {
                    dynPart.append(".setLastDetail(");
                    dynPart.append(this.lastDetail);
                    dynPart.append(")");
                }
                if (this.footing > 0) {
                    dynPart.append(".setFooting(");
                    dynPart.append(this.footing);
                    dynPart.append(")");
                }
            }
            dynPart.append(";");
            dynPart.append(eol);
        }
        for (int i = 0; i < this.reportGroups.size(); ++i) {
            ReportGroup rg = this.reportGroups.elementAt(i);
            Return2.append(rg.getCode(dynPart));
        }
        return Return2.toString();
    }

    void setLen(int l) {
        if (l > this.maxLen) {
            this.maxLen = l;
        }
    }

    @Override
    public int getLen() {
        return this.maxLen;
    }

    boolean isControl(VariableName vn) {
        VariableDeclaration vd = vn.getVarDecl();
        for (int i = this.controls.size() - 1; i >= 0; --i) {
            if (((VariableName)this.controls.elementAt(i)).getVarDecl() != vd) continue;
            return true;
        }
        return false;
    }

    @Override
    public VariableDeclaration getLineCountVariable() {
        this.lineCnt.parent = null;
        return this.lineCnt;
    }

    @Override
    public VariableDeclaration getPageCountVariable() {
        this.pageCnt.parent = null;
        return this.pageCnt;
    }

    @Override
    public VariableDeclaration getPrintSwitchVariable() {
        this.printSw.parent = null;
        return this.printSw;
    }

    @Override
    public VariableDeclaration getVirtualParent() {
        return this.vParent;
    }

    @Override
    public List<ReportGroup> getReportGroups() {
        return this.reportGroups;
    }

    @Override
    public List getControls() {
        return this.controls;
    }

    @Override
    public int getHeading() {
        return this.heading;
    }

    @Override
    public int getFirstDetail() {
        return this.firstDetail;
    }

    @Override
    public int getLastDetail() {
        return this.lastDetail;
    }

    @Override
    public int getFooting() {
        return this.footing;
    }

    @Override
    public FileDescriptor getFileDescriptor() {
        return this.fd;
    }
}

