/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.Paragraph;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UndefinedException;
import com.iscobol.compiler.Verb;

public class Resume
extends Verb
implements CobolToken,
ErrorsNumbers {
    Token label;
    int toNums;

    public Resume(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(47, 4, this.keyWord, null, this.error);
        }
        this.label = tk;
    }

    @Override
    public void check() throws GeneralErrorException {
        Paragraph p = this.pc.getParagraph(this.label.getWord(), this.parent.parent);
        if (p == null) {
            throw new UndefinedException(this.keyWord, this.error, this.label.getWord());
        }
        if (p.isDeclaratives()) {
            throw new GeneralErrorException(47, 4, this.keyWord, this.label.getWord(), this.error);
        }
        this.toNums = p.getIdNumber();
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        boolean debug = this.tm.getOptionList().getOption("-d") != null;
        this.getCodeDebug(Return2);
        if (debug) {
            Paragraph.getDebugExitCode(Return2);
            Return2.append(" ");
        }
        Return2.append("if (true) throw new GotoException (");
        Return2.append(this.toNums);
        Return2.append(");");
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }
}

