/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.AtEnd;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GetVarOpts;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Select;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;

public class Return
extends Verb
implements CobolToken,
ErrorsNumbers {
    Select sel;
    AtEnd atEnd;
    VariableName into;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Return(Token kw, Block par, Pcc p, TokenManager t, Errors err) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        Token tk = this.tm.getToken();
        if (tk.getToknum() != 10009) {
            throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
        }
        this.sel = this.pc.getSelect(tk.getWord());
        if (this.sel == null) {
            throw new GeneralErrorException(53, 4, this.keyWord, tk.getWord(), this.error);
        }
        if (!this.sel.isSort()) {
            throw new GeneralErrorException(104, 4, tk, this.sel.fileName.getWord(), this.error);
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 671) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 543) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 10009) {
                throw new GeneralErrorException(24, 4, this.keyWord, tk.getWord(), this.error);
            }
            this.tm.ungetToken();
            this.into = VariableName.get(this.tm, this.error, this.pc, new GetVarOpts(this, 1));
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 599) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 284 && tk.getToknum() != 423) throw new UnexpectedTokenException(tk, this.error);
            this.tm.ungetToken();
            this.tm.ungetToken();
            this.atEnd();
        } else if (tk.getToknum() == 284 || tk.getToknum() == 423) {
            this.tm.ungetToken();
            this.atEnd();
        } else {
            this.tm.ungetToken();
        }
        tk = this.tm.getToken();
        if (tk.getToknum() == 444) return;
        this.tm.ungetToken();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void atEnd() throws GeneralErrorException, EndOfProgramException {
        Token tk = this.tm.getToken();
        if (tk.getToknum() == 599) {
            tk = this.tm.getToken();
            if (tk.getToknum() != 284 && tk.getToknum() != 423) throw new UnexpectedTokenException(tk, this.error);
            this.tm.ungetToken();
            this.tm.ungetToken();
            this.atEnd = new AtEnd(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            return;
        } else if (tk.getToknum() == 284 || tk.getToknum() == 423) {
            this.tm.ungetToken();
            this.atEnd = new AtEnd(this.keyWord, this.sel, this.parent, this, this.pc, this.tm, this.error);
            return;
        } else {
            this.tm.ungetToken();
        }
    }

    @Override
    public void check() throws GeneralErrorException {
    }

    @Override
    public String getCode() {
        StringBuffer Return2 = new StringBuffer();
        Return2.append(this.parent.getIndent());
        this.getCodeDebug(Return2);
        if (this.atEnd != null) {
            Return2.append(this.atEnd.getCodeBefore());
        }
        if (this.tm.getOptionList().getOption("-cv") != null) {
            Return2.append("if (" + this.getLocalVar("SORT-RETURN") + ".toint()==16) throw new SortAbort();");
            Return2.append(eol);
            Return2.append(this.parent.getIndent());
        }
        Return2.append(this.sel.getName());
        if (this.tm.getOptionList().getOption("-xosrt") == null) {
            Return2.append(".returnRecord(");
        } else {
            Return2.append(".returnSort(");
        }
        if (this.into != null) {
            Return2.append(this.into.getCode());
        } else {
            Return2.append("null");
        }
        Return2.append(");");
        if (this.atEnd != null) {
            Return2.append(this.atEnd.getCode());
        }
        Return2.append(eol);
        this.getCodeDebugEnd(Return2);
        return Return2.toString();
    }

    public VariableName getInto() {
        return this.into;
    }

    public AtEnd getAtEnd() {
        return this.atEnd;
    }

    public Select getSelect() {
        return this.sel;
    }
}

