/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.VariableName;

public class SetGetProperty {
    static final String PREFIX = "tmp";
    static final int GET = 0;
    static final int SET = 1;
    static final int GET_OR_SET = 2;
    private VariableName obj;
    private int propType;
    private boolean isField;
    private String propertyName;
    private MyClass objType;
    private MyClass type;
    private SetGetProperty prev;

    public SetGetProperty(VariableName obj, MyClass objType, MyClass type, String propertyName, int propType, boolean isField, SetGetProperty prev) {
        this.obj = obj;
        this.type = type;
        this.objType = objType;
        this.propertyName = propertyName;
        this.propType = propType;
        this.isField = isField;
        this.prev = prev;
    }

    public VariableName getObject() {
        return this.obj;
    }

    public int getPropType() {
        return this.propType;
    }

    public void setPropType(int t) {
        this.propType = t;
    }

    public boolean isField() {
        return this.isField;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public SetGetProperty getPrev() {
        return this.prev;
    }

    public MyClass getType() {
        return this.type;
    }

    public String getCode() {
        return this.getCode(false, false);
    }

    public String getCode(boolean tmpget, boolean tmpset) {
        StringBuffer sb = new StringBuffer();
        if (this.prev != null) {
            sb.append(this.prev.getCode(tmpget, tmpset));
        } else {
            if (this.obj.isSelf() || this.obj.isSuper()) {
                sb.append(this.objType.getName());
                sb.append(".");
            }
            if (this.obj.isFactory()) {
                sb.append(this.obj.getType().getName());
            } else {
                sb.append(this.obj.getCode());
            }
        }
        sb.append(".");
        if (this.isField) {
            sb.append(this.propertyName);
        } else {
            boolean isGet;
            boolean isSet = this.propType == 1;
            boolean bl = isGet = this.propType == 0;
            if (tmpget) {
                if (isGet || tmpset) {
                    sb.append(PREFIX);
                }
                sb.append(isSet || !isGet && !tmpset ? "set" : "get");
                sb.append(this.propertyName);
            } else {
                if (isSet) {
                    sb.append(PREFIX);
                }
                sb.append(isSet ? "set" : "get");
                sb.append(this.propertyName);
                if (!isSet) {
                    sb.append("()");
                }
            }
        }
        return sb.toString();
    }
}

