/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler;

import com.iscobol.compiler.As;
import com.iscobol.compiler.Block;
import com.iscobol.compiler.CobolToken;
import com.iscobol.compiler.ConcatToken;
import com.iscobol.compiler.EndOfProgramException;
import com.iscobol.compiler.Errors;
import com.iscobol.compiler.ErrorsNumbers;
import com.iscobol.compiler.Expression;
import com.iscobol.compiler.GeneralErrorException;
import com.iscobol.compiler.GenericObject;
import com.iscobol.compiler.InlineInvoke;
import com.iscobol.compiler.Invoke;
import com.iscobol.compiler.MyClass;
import com.iscobol.compiler.Pcc;
import com.iscobol.compiler.Token;
import com.iscobol.compiler.TokenManager;
import com.iscobol.compiler.UnexpectedTokenException;
import com.iscobol.compiler.VariableDeclarationScreen;
import com.iscobol.compiler.VariableName;
import com.iscobol.compiler.Verb;
import com.iscobol.rts.Config;
import com.iscobol.types.NumericVar;

public class Using
extends Verb
implements CobolToken,
ErrorsNumbers {
    private int asType;
    private String as;
    private boolean makeCast = true;
    private As oas;
    private MyClass[] interfaces;
    private Token nameToken;
    private GenericObject nameObj;
    boolean byContent;
    boolean byValue;
    boolean ofInvoke;
    private boolean callThread;
    private boolean isCobolVar;
    private boolean isExpr;
    private String code;

    public Using(Token kw, Block par, Pcc p, TokenManager t, Errors err, boolean[] byCntnt, boolean[] byValue) throws GeneralErrorException, EndOfProgramException {
        this(kw, par, p, t, err, byCntnt, byValue, false);
    }

    /*
     * Unable to fully structure code
     */
    public Using(Token kw, Block par, Pcc p, TokenManager t, Errors err, boolean[] byCntnt, boolean[] byValue, boolean inv) throws GeneralErrorException, EndOfProgramException {
        super(kw, par, p, t, err);
        this.ofInvoke = inv;
        this.byContent = byCntnt[0];
        this.byValue = byValue[0];
        tk = this.tm.getToken();
        if (tk.getToknum() == 312) {
            tk = this.tm.getToken();
        }
        if (tk.getToknum() == 371) {
            byCntnt[0] = true;
            this.byContent = true;
            byValue[0] = false;
            this.byValue = false;
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 804) {
            byCntnt[0] = false;
            this.byContent = false;
            byValue[0] = true;
            this.byValue = true;
            tk = this.tm.getToken();
        } else if (tk.getToknum() == 677) {
            byCntnt[0] = false;
            this.byContent = false;
            byValue[0] = false;
            this.byValue = false;
            tk = this.tm.getToken();
        }
        switch (tk.getToknum()) {
            case 481: 
            case 781: {
                if (!inv) {
                    throw new UnexpectedTokenException(this.keyWord, this.error);
                }
                this.asType = 2;
                this.nameToken = tk;
                break;
            }
            case 613: {
                this.nameToken = tk;
                this.nameToken.setNull((char)this.tm.getLowValue());
                break;
            }
            case 10009: {
                if (!"SELF".equals(tk.getWord())) ** GOTO lbl66
                this.nameToken = tk;
                tk = this.tm.getToken();
                if (tk.getToknum() == 10018) {
                    this.nameObj = new Invoke(this.nameToken, tk, this.parent, this.pc, this.tm, this.error);
                    break;
                }
                this.tm.ungetToken();
                try {
                    this.as = this.pc.existsClass("this").getName();
                }
                catch (ClassNotFoundException _ex) {
                    this.as = this.pc.getInheritsClass();
                    if (this.as != null) ** GOTO lbl55
                    this.as = "java.lang.Object";
                }
lbl55:
                // 3 sources

                intfs = this.pc.getImplementsClass();
                if (intfs == null || intfs.length <= 0) break;
                this.interfaces = new MyClass[intfs.length];
                for (i = 0; i < intfs.length; ++i) {
                    try {
                        this.interfaces[i] = this.pc.existsClass(intfs[i]);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        this.interfaces[i] = MyClass.getInstance(Object.class);
                    }
                }
                break;
            }
lbl66:
            // 2 sources

            default: {
                this.tm.ungetToken();
                openParl = new int[]{0};
                expr = new Expression(openParl, tk, par, this.pc, this.tm, this.error, true, true);
                if (expr.isVoid()) {
                    throw new UnexpectedTokenException(tk, this.error);
                }
                vn = expr.getAsVar();
                if (vn != null) {
                    vd = vn.getVarDecl();
                    vd.setUsedAsParameter(true);
                    this.nameObj = vn;
                    if (vd instanceof VariableDeclarationScreen) {
                        throw new GeneralErrorException(165, 4, vd.getNameToken(), vd.getName(), this.error);
                    }
                    if (vd instanceof InlineInvoke && vd.getTypeName().equals("void")) {
                        throw new GeneralErrorException(149, 4, vd.getNameToken(), vd.getName(), this.error);
                    }
                    vd.setAccessedByAddress();
                    this.isCobolVar = this.nameObj.isObjectReference() == false && this.nameObj.isPrimitive() == false;
                    tk = this.tm.getToken();
                    if (tk.getToknum() == 10018) {
                        this.nameObj = new Invoke((VariableName)this.nameObj, tk, this.parent, this.pc, this.tm, this.error);
                        break;
                    }
                    this.tm.ungetToken();
                    break;
                }
                tk = expr.getAsToken();
                if (tk != null) {
                    this.nameToken = tk;
                    break;
                }
                if (!inv && !this.byValue) {
                    throw new GeneralErrorException(308, 4, expr.getKW(), expr.toString(), this.error);
                }
                this.nameObj = expr;
                this.isExpr = true;
            }
        }
        if (this.ofInvoke) {
            tk = this.tm.getToken();
            if (tk.getToknum() == 280) {
                this.oas = new As(kw, par, p, t, err, this.nameObj);
            } else {
                this.tm.ungetToken();
            }
        }
    }

    void setCallThread() {
        this.callThread = true;
    }

    private void checkType() throws GeneralErrorException {
        if (this.oas != null) {
            this.oas.check();
            this.asType = this.oas.asType;
            this.as = this.oas.as;
        }
        if (this.asType == 0) {
            if (this.nameObj != null && this.nameObj.getCType() != null) {
                if (this.isPrimitive()) {
                    int i;
                    this.as = this.nameObj.getCType().getName();
                    for (i = As.DESC.length - 1; i > 0 && !As.DESC[i].equals(this.as); --i) {
                    }
                    if (i == 0) {
                        this.asType = 10;
                        MyClass clazz = this.nameObj.getCType();
                        this.makeCast = MyClass.isClassAccessible(this.pc, clazz);
                        this.as = clazz.getName();
                    } else {
                        this.asType = i;
                    }
                } else if (this.nameObj.isObjectReference()) {
                    this.asType = 10;
                    MyClass clazz = this.nameObj.getCType();
                    this.makeCast = false;
                    this.as = clazz.getName();
                } else if (this.isCobolVar()) {
                    this.asType = 12;
                    this.as = this.nameObj.getCType().getName();
                }
            } else if (this.nameToken != null && !this.nameToken.isNull()) {
                this.asType = 12;
                if (this.nameToken.getToknum() == 10001) {
                    this.as = Pcc.TYPES_PACKAGE + ".PicX";
                } else if (this.nameToken.getToknum() == 10002 || this.nameToken.getToknum() == 10017) {
                    this.as = Pcc.TYPES_PACKAGE + ".NumericVar";
                }
            }
        } else if (this.asType == 10 && (this.nameObj == null || this.nameObj.isPrimitive())) {
            throw new GeneralErrorException(75, 4, this.nameToken, this.as, this.error);
        }
    }

    void forceCast() throws GeneralErrorException {
        if (!this.makeCast && this.nameObj != null && this.nameObj.isObjectReference()) {
            this.makeCast = MyClass.isClassAccessible(this.pc, this.nameObj.getCType());
        }
    }

    @Override
    public void check() throws GeneralErrorException {
        if (this.nameObj != null) {
            this.nameObj.check();
            if (this.nameObj.getCType() != null && this.asType == 0 && this.nameObj.isObjectReference()) {
                this.asType = 10;
                this.as = this.nameObj.getCType().getName();
            }
        }
    }

    void setAs(MyClass asVal) {
        if (asVal == null) {
            this.asType = 0;
        }
        if (asVal.isClass(String.class)) {
            this.asType = 1;
        } else if (asVal.isClass(Boolean.TYPE)) {
            this.asType = 2;
        } else if (asVal.isClass(Byte.TYPE)) {
            this.asType = 3;
        } else if (asVal.isClass(Character.TYPE)) {
            this.asType = 4;
        } else if (asVal.isClass(Short.TYPE)) {
            this.asType = 5;
        } else if (asVal.isClass(Integer.TYPE)) {
            this.asType = 6;
        } else if (asVal.isClass(Long.TYPE)) {
            this.asType = 7;
        } else if (asVal.isClass(Float.TYPE)) {
            this.asType = 8;
        } else if (asVal.isClass(Double.TYPE)) {
            this.asType = 9;
        } else if (asVal.isClass(byte[].class)) {
            this.asType = 11;
        } else {
            this.asType = 10;
            this.as = asVal.getName();
        }
    }

    public boolean isAssignableTo(MyClass c) throws ClassNotFoundException, GeneralErrorException {
        boolean Return2 = c.isAssignableFrom(this.getType());
        if (!Return2 && this.interfaces != null) {
            for (int i = 0; i < this.interfaces.length && !(Return2 = c.isAssignableFrom(this.interfaces[i])); ++i) {
            }
        }
        return Return2;
    }

    public boolean isCobolVarClass() throws ClassNotFoundException, GeneralErrorException {
        return MyClass.getInstance(Pcc.TYPES_PACKAGE + ".CobolVar").isAssignableFrom(this.getType());
    }

    MyClass getType() throws ClassNotFoundException, GeneralErrorException {
        if (this.asType == 0) {
            this.checkType();
        }
        switch (this.asType) {
            case 1: {
                return MyClass.getInstance(String.class);
            }
            case 2: {
                return MyClass.getInstance(Boolean.TYPE);
            }
            case 3: {
                return MyClass.getInstance(Byte.TYPE);
            }
            case 4: {
                return MyClass.getInstance(Character.TYPE);
            }
            case 5: {
                return MyClass.getInstance(Short.TYPE);
            }
            case 6: {
                return MyClass.getInstance(Integer.TYPE);
            }
            case 7: {
                return MyClass.getInstance(Long.TYPE);
            }
            case 8: {
                return MyClass.getInstance(Float.TYPE);
            }
            case 9: {
                return MyClass.getInstance(Double.TYPE);
            }
            case 11: {
                return MyClass.getInstance(byte[].class);
            }
            case 10: {
                return this.pc.existsClass(this.as);
            }
            case 0: {
                return null;
            }
        }
        if (this.nameObj != null) {
            return this.nameObj.getCType();
        }
        if (this.as != null) {
            return this.pc.existsClass(this.as);
        }
        return MyClass.getInstance(Pcc.TYPES_PACKAGE + ".CobolVar");
    }

    boolean isCobolVar() {
        if (this.nameObj != null) {
            return this.nameObj.isCobolVar();
        }
        return this.isCobolVar;
    }

    boolean isTypeCobolVar() {
        return this.oas != null ? this.oas.getType().isCobolVar() : this.isCobolVar();
    }

    boolean isTypeNumericVar() {
        return this.oas != null ? this.oas.getType().isNumericVar() : this.isNumericVar();
    }

    boolean isNumericVar() {
        if (this.nameObj != null) {
            return this.nameObj.isNumericVar();
        }
        try {
            MyClass mc = this.getType();
            return mc != null ? mc.isAssignableTo(NumericVar.class) : false;
        }
        catch (GeneralErrorException _ex) {
            return false;
        }
        catch (ClassNotFoundException _ex) {
            return false;
        }
    }

    boolean isPrimitive() {
        if (this.nameObj != null) {
            return this.nameObj.isPrimitive();
        }
        return false;
    }

    boolean isPlainLiteral() {
        if (this.nameToken != null && this.oas == null) {
            int tkn = this.nameToken.getToknum();
            return tkn == 10001 || tkn == 10002 || tkn == 10017;
        }
        return false;
    }

    boolean isPlainStrLiteral() {
        if (this.nameToken != null && this.oas == null) {
            return this.nameToken.getToknum() == 10001;
        }
        return false;
    }

    VariableName getVariableName() {
        if (this.nameObj != null && this.nameObj instanceof VariableName) {
            return (VariableName)this.nameObj;
        }
        return null;
    }

    private String makeCast() {
        if (this.as != null && this.as.charAt(0) == '[') {
            int i;
            for (i = 1; i < this.as.length() && this.as.charAt(i) == '['; ++i) {
            }
            String dim = "";
            if (this.nameObj instanceof VariableName) {
                i -= ((VariableName)this.nameObj).getDimension();
            }
            for (int j = 0; j < i; ++j) {
                dim = dim + "[]";
            }
            if (i < this.as.length() && this.as.charAt(i) == 'L') {
                return "(" + MyClass.getClassNameCode(this.as.substring(i + 1, this.as.length() - 1)) + dim + ")";
            }
            switch (this.as.charAt(i)) {
                case 'B': {
                    return "(byte" + dim + ")";
                }
                case 'C': {
                    return "(char" + dim + ")";
                }
                case 'S': {
                    return "(short" + dim + ")";
                }
                case 'I': {
                    return "(int" + dim + ")";
                }
                case 'J': {
                    return "(long" + dim + ")";
                }
                case 'F': {
                    return "(float" + dim + ")";
                }
                case 'D': {
                    return "(double" + dim + ")";
                }
                case 'Z': {
                    return "(boolean" + dim + ")";
                }
            }
            return "";
        }
        if (this.as != null) {
            return "(" + MyClass.getClassNameCode(this.as) + ")";
        }
        return "";
    }

    @Override
    public String getCode() {
        int t;
        if (this.code != null) {
            return this.code;
        }
        StringBuffer Return2 = new StringBuffer();
        if (this.nameToken != null) {
            if ("SELF".equals(this.nameToken.getWord())) {
                if (this.nameObj == null) {
                    Pcc rootPcc = this.pc.getRoot();
                    if (rootPcc != this.pc) {
                        Return2.append(rootPcc.getFullClassName() + ".");
                    }
                    Return2.append("this");
                } else if (this.nameObj instanceof VariableName) {
                    Pcc rootPcc = this.pc.getRoot();
                    if (rootPcc != this.pc) {
                        Return2.append(rootPcc.getFullClassName() + ".");
                    }
                    Return2.append("this.");
                    Return2.append(this.nameObj.getCode());
                } else {
                    Return2.append(this.nameObj.getCode());
                }
                this.code = Return2.toString();
                return this.code;
            }
            if (this.nameToken.isNull()) {
                Return2.append("null");
                this.code = Return2.toString();
                return this.code;
            }
        }
        if ((t = this.asType) == 10 && this.as != null) {
            if ("java.lang.Boolean".equals(this.as)) {
                t = 2;
            } else if ("java.lang.Byte".equals(this.as)) {
                t = 3;
            } else if ("java.lang.Short".equals(this.as)) {
                t = 5;
            } else if ("java.lang.Integer".equals(this.as)) {
                t = 6;
            } else if ("java.lang.Long".equals(this.as)) {
                t = 7;
            } else if ("java.lang.Float".equals(this.as)) {
                t = 8;
            } else if ("java.lang.Double".equals(this.as)) {
                t = 9;
            } else if ("java.lang.Character".equals(this.as)) {
                t = 4;
            }
        }
        boolean mfCompatibility = false;
        switch (t) {
            case 0: {
                if (this.nameToken != null) {
                    mfCompatibility = this.pc.getOption("-ccmf") != null;
                    if (mfCompatibility) {
                        if (this.nameToken.getToknum() == 10002 || this.nameToken.getToknum() == 10017) {
                            if (this.byValue || this.nameToken.getWord().charAt(0) == '-') {
                                Return2.append("_getVarNeg(");
                            } else {
                                Return2.append("_getVarNotNeg(");
                            }
                        } else {
                            Return2.append("_getVarAlphanum(");
                            Return2.append(this.nameToken.getRealLength());
                            Return2.append(",");
                        }
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(")");
                    } else {
                        if (this.nameToken.getToknum() == 10002 && this.byContent) {
                            this.nameToken.setNativeSize(4);
                        }
                        Return2.append(this.getCodeLiteral(this.nameToken));
                    }
                    this.byContent = true;
                    break;
                }
                Return2.append(this.nameObj.getCode());
                break;
            }
            case 12: {
                if (this.nameToken != null) {
                    this.byContent = true;
                    Return2.append(this.getCodeLiteral(this.nameToken) + ".byVal()");
                } else {
                    Return2.append(this.nameObj.getCode());
                }
                Return2.insert(0, this.makeCast());
                break;
            }
            case 10: {
                if (this.nameToken != null) {
                    this.byContent = true;
                    Return2.append(this.getCodeLiteral(this.nameToken));
                } else {
                    Return2.append(this.nameObj.getCode());
                }
                if (!this.makeCast || this.nameObj instanceof VariableName && ((VariableName)this.nameObj).isLambdaExpression()) break;
                Return2.insert(0, this.makeCast());
                break;
            }
            case 1: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 10001) {
                        if (this.nameToken instanceof ConcatToken) {
                            Return2.append(this.nameToken.getCode());
                        } else {
                            Return2.append('\"');
                            Return2.append(this.nameToken.getCode());
                            Return2.append('\"');
                        }
                    } else {
                        this.byContent = true;
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".toString()");
                    }
                } else if (this.isCobolVar) {
                    int v;
                    String prop = Config.getProperty("iscobol.compiler.oop.trim_parameters", "1");
                    try {
                        v = Integer.parseInt(prop);
                    }
                    catch (NumberFormatException ex) {
                        int n = v = Config.isTrue(prop) ? 1 : 0;
                    }
                    if (v == 2) {
                        Return2.append("com.iscobol.rts.Factory.rightTrim(");
                        Return2.append(this.nameObj.getCode());
                        Return2.append(".toString())");
                    } else {
                        Return2.append(this.nameObj.getCode());
                        Return2.append(".toString()");
                        if (v == 1) {
                            Return2.append(".trim()");
                        }
                    }
                } else {
                    Return2.append(this.nameObj.getCode());
                    Return2.insert(0, this.makeCast());
                }
                this.isCobolVar = false;
                break;
            }
            case 2: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 781 || this.nameToken.getToknum() == 481) {
                        if (this.nameToken.getToknum() == 781) {
                            Return2.append("true");
                        } else {
                            Return2.append("false");
                        }
                    } else {
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".toboolean()");
                    }
                } else {
                    Return2.append(this.nameObj.getCode());
                    if (this.isCobolVar) {
                        Return2.append(".toboolean()");
                    }
                }
                this.isCobolVar = false;
                break;
            }
            case 3: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 10002) {
                        Return2.append("(byte)");
                        Return2.append(this.nameToken.getAsInt());
                    } else if (this.nameToken.getToknum() == 10001) {
                        Return2.append("(byte)");
                        String s = this.nameToken.getCode();
                        if (s.length() > 0) {
                            Return2.append('\'');
                            Return2.append(s.charAt(0));
                            Return2.append('\'');
                        } else {
                            Return2.append('0');
                        }
                    } else {
                        this.byContent = true;
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".tobyte()");
                    }
                } else if (this.isExpr) {
                    Return2.append("((byte) ");
                    Return2.append(this.nameObj.getCode());
                    Return2.append(".intValue())");
                } else {
                    Return2.append(this.nameObj.getCode());
                    if (this.isCobolVar) {
                        Return2.append(".tobyte()");
                    }
                }
                this.isCobolVar = false;
                break;
            }
            case 4: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 10002) {
                        Return2.append("(char)");
                        Return2.append(this.nameToken.getAsInt());
                    } else if (this.nameToken.getToknum() == 10001) {
                        Return2.append("(char)");
                        String s = this.nameToken.getCode();
                        if (s.length() > 0) {
                            Return2.append('\'');
                            Return2.append(s.charAt(0));
                            Return2.append('\'');
                        } else {
                            Return2.append('0');
                        }
                    } else {
                        this.byContent = true;
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".tochar()");
                    }
                } else {
                    Return2.append(this.nameObj.getCode());
                    if (this.isCobolVar) {
                        Return2.append(".tochar()");
                    }
                }
                this.isCobolVar = false;
                break;
            }
            case 5: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 10002) {
                        Return2.append("(short)");
                        Return2.append(this.nameToken.getAsInt());
                    } else {
                        this.byContent = true;
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".toshort()");
                    }
                } else {
                    Return2.append(this.nameObj.getCode());
                    if (this.isCobolVar) {
                        Return2.append(".toshort()");
                    } else if (this.isExpr) {
                        Return2.append(".shortValue()");
                    }
                }
                this.isCobolVar = false;
                break;
            }
            case 6: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 10002) {
                        Return2.append("(int)");
                        Return2.append(this.nameToken.getAsInt());
                    } else {
                        this.byContent = true;
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".toint()");
                    }
                } else if (this.nameObj != null) {
                    Return2.append(this.nameObj.getCode());
                    if (this.isCobolVar) {
                        Return2.append(".toint()");
                    } else if (this.isExpr) {
                        Return2.append(".intValue()");
                    }
                }
                this.isCobolVar = false;
                break;
            }
            case 7: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 10002) {
                        Return2.append("(long)");
                        Return2.append(this.nameToken.getAsInt());
                    } else {
                        this.byContent = true;
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".tolong()");
                    }
                } else {
                    Return2.append(this.nameObj.getCode());
                    if (this.isCobolVar) {
                        Return2.append(".tolong()");
                    } else if (this.isExpr) {
                        Return2.append(".longValue()");
                    }
                }
                this.isCobolVar = false;
                break;
            }
            case 8: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 10002 || this.nameToken.getToknum() == 10017) {
                        Return2.append("(float)");
                        Return2.append(this.nameToken.getCode().replace(',', '.'));
                    } else {
                        this.byContent = true;
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".tofloat()");
                    }
                } else {
                    Return2.append(this.nameObj.getCode());
                    if (this.isCobolVar) {
                        Return2.append(".tofloat()");
                    } else if (this.isExpr) {
                        Return2.append(".floatValue()");
                    }
                }
                this.isCobolVar = false;
                break;
            }
            case 9: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 10002 || this.nameToken.getToknum() == 10017) {
                        Return2.append("(double)");
                        Return2.append(this.nameToken.getCode().replace(',', '.'));
                    } else {
                        this.byContent = true;
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".todouble()");
                    }
                } else {
                    Return2.append(this.nameObj.getCode());
                    if (this.isCobolVar) {
                        Return2.append(".todouble()");
                    } else if (this.isExpr) {
                        Return2.append(".doubleValue()");
                    }
                }
                this.isCobolVar = false;
                break;
            }
            case 11: {
                if (this.nameToken != null) {
                    if (this.nameToken.getToknum() == 10001) {
                        Return2.append('\"');
                        Return2.append(this.nameToken.getCode());
                        Return2.append("\".getBytes()");
                    } else {
                        this.byContent = true;
                        Return2.append(this.getCodeLiteral(this.nameToken));
                        Return2.append(".toString().getBytes()");
                    }
                } else {
                    Return2.append(this.nameObj.getCode());
                    if (this.isCobolVar) {
                        Return2.append(".getBytes()");
                    }
                }
                this.isCobolVar = false;
            }
        }
        if (!mfCompatibility) {
            if (this.byContent || this.byValue) {
                if (!this.ofInvoke) {
                    if (this.isExpr) {
                        Return2 = new StringBuffer("NumericVar.literal(").append(Return2);
                        Return2.append(", ");
                        Return2.append(this.pc.getDecimalPointIsComma());
                        Return2.append(")");
                    } else if (this.nameObj == null) {
                        Return2.append(".byVal()");
                    } else if (!this.nameObj.isObjectReference()) {
                        if (this.callThread && this.nameObj instanceof VariableName && !((VariableName)this.nameObj).getVarDecl().isPic1()) {
                            Return2.append(".copy()");
                        } else {
                            Return2.append(".byVal()");
                        }
                    }
                } else if (this.isCobolVar) {
                    Return2.append(".byVal()");
                }
            } else if (!(this.ofInvoke || this.nameObj != null && this.nameObj.isObjectReference() || !this.isCobolVar)) {
                Return2.append(".byRef()");
            }
        }
        this.code = Return2.toString();
        return this.code;
    }

    public As getAs() {
        return this.oas;
    }

    public Token getNameToken() {
        return this.nameToken;
    }

    public GenericObject getNameObj() {
        return this.nameObj;
    }

    public boolean isByContent() {
        return this.byContent;
    }

    public boolean isByValue() {
        return this.byValue;
    }

    public String toString() {
        StringBuffer Return2 = new StringBuffer();
        if (this.nameObj != null) {
            VariableName vn = this.nameObj.getVariableName();
            if (vn != null) {
                MyClass mc = vn.getType();
                if (mc != null) {
                    Return2.append(mc.getName());
                } else {
                    Return2.append(vn.getName());
                }
            } else {
                Return2.append(":using:");
            }
        } else if (this.nameToken != null) {
            Return2.append(this.nameToken.getOriginalWord());
        } else {
            Return2.append(":using:");
        }
        return Return2.toString();
    }
}

