/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.compiler.remote;

import com.iscobol.interfaces.compiler.remote.IRemoteError;
import com.iscobol.rts.RtsUtil;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class RemoteError
implements IRemoteError,
Externalizable {
    private static final long serialVersionUID = 1L;
    private int errorNumber;
    private int errorType;
    private int lineNumber;
    private int offset;
    private String message;
    private String filename;
    private String pathFilename;
    private String other;

    public RemoteError() {
    }

    public RemoteError(int num, int s, int line, int offs, String file, String msg, String other) {
        this.errorNumber = num;
        this.errorType = s;
        this.lineNumber = line;
        this.offset = offs;
        this.message = msg;
        File f = new File(file);
        this.filename = f.getName();
        this.pathFilename = f.getPath().replace('\\', '/');
        this.other = other;
    }

    @Override
    public int getErrorNumber() {
        return this.errorNumber;
    }

    @Override
    public int getErrorType() {
        return this.errorType;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getPathFilename() {
        return this.pathFilename;
    }

    @Override
    public String getOther() {
        return this.other;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        return this.message;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.errorNumber);
        out.writeInt(this.errorType);
        RtsUtil.writeUTF(this.filename, out);
        out.writeInt(this.lineNumber);
        RtsUtil.writeUTF(this.message, out);
        out.writeInt(this.offset);
        RtsUtil.writeUTF(this.other, out);
        RtsUtil.writeUTF(this.pathFilename, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.errorNumber = in.readInt();
        this.errorType = in.readInt();
        this.filename = RtsUtil.readUTF(in);
        this.lineNumber = in.readInt();
        this.message = RtsUtil.readUTF(in);
        this.offset = in.readInt();
        this.other = RtsUtil.readUTF(in);
        this.pathFilename = RtsUtil.readUTF(in);
    }
}

