/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.commands;

import com.iscobol.debugger.DebugTM;
import com.iscobol.debugger.DebuggerException;
import com.iscobol.debugger.Expression;
import com.iscobol.debugger.commands.DebugCommand;
import com.iscobol.rts.RtsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ProgramBreakpointCommand
implements DebugCommand {
    private static final long serialVersionUID = 1000007L;
    public static final int ID = 19;
    public static final String SHORT_DESCRIPTION = " : set a breakpoint at the start of 'classname'";
    public static final String STRING_ID = "b0";
    public static final String HELP_PAGE = "b0.html";
    public static final String USAGE = "usage:" + eol + "   b0 [" + "-d" + "] progname [when variable-name [=|!=|<|>|<=|>=] const]" + eol;
    private String progName;
    private boolean enabled;
    private Expression condition;

    public ProgramBreakpointCommand() {
    }

    public ProgramBreakpointCommand(String name, boolean en, Expression cond) {
        this.progName = name;
        this.enabled = en;
        this.condition = cond;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public String getProgName() {
        return this.progName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getId() {
        return 19;
    }

    @Override
    public String getStringId() {
        return STRING_ID;
    }

    @Override
    public String getShortDescription() {
        return SHORT_DESCRIPTION;
    }

    @Override
    public String getUsage() {
        return USAGE;
    }

    @Override
    public String getHelpPage() {
        return HELP_PAGE;
    }

    @Override
    public boolean isWholeWord() {
        return false;
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        RtsUtil.writeUTFOptmz(this.progName, out);
        out.writeBoolean(this.enabled);
        if (this.condition != null) {
            out.writeByte(1);
            this.condition.writeExternal(out);
        } else {
            out.writeByte(0);
        }
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.progName = RtsUtil.readUTFOptmz(in);
        this.enabled = in.readBoolean();
        switch (in.readByte()) {
            default: {
                break;
            }
            case 1: {
                this.condition = new Expression();
                this.condition.readExternal(in);
                break;
            }
            case 2: {
                try {
                    this.condition = new Expression(new DebugTM(RtsUtil.readUTFOptmz(in)), true, false, false);
                    break;
                }
                catch (DebuggerException e) {
                    throw new IOException(e);
                }
            }
        }
    }
}

