/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs;

import com.iscobol.debugger.DebugPanel;
import com.iscobol.debugger.DebugParagraph;
import com.iscobol.debugger.Filename;
import com.iscobol.debugger.GraphUtilities;
import com.iscobol.debugger.dialogs.DebugDialog;
import com.iscobol.debugger.dialogs.LMResize;
import com.iscobol.debugger.dialogs.LMResizeData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GotoDialog
extends DebugDialog {
    private static final long serialVersionUID = 123L;
    private JRadioButton lineRb;
    private JRadioButton parRb;
    private JTextField lineTf;
    private JComboBox<DebugParagraph> parCmb;
    private JComboBox<Filename> fileCmb;
    private JButton goTo;
    private JButton close;
    private DebugPanel preview;
    private HashMap<DebugParagraph, String> parNames = new HashMap();
    private ActionListener aListener = e -> {
        if (this.lineRb.isSelected()) {
            try {
                int l = Integer.parseInt(this.lineTf.getText());
                this.preview.goTo(l, null, this.fileCmb.getSelectedIndex());
            }
            catch (NumberFormatException nfe) {
                return;
            }
        } else {
            DebugParagraph item = (DebugParagraph)this.parCmb.getSelectedItem();
            if (item != null) {
                this.preview.goTo(item.getLineNumber(), this.parNames.get(item), item.getFileIndex());
            }
        }
    };

    public GotoDialog(JFrame parent, String title, boolean modal, DebugPanel p) {
        super(parent, title, modal);
        this.preview = p;
        LMResize layout = new LMResize(10, 10, 5, 0);
        this.getContentPane().setLayout(layout);
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent evt) {
                GotoDialog gotoDialog = GotoDialog.this;
                synchronized (gotoDialog) {
                    GotoDialog.this.notify();
                }
            }
        });
        this.lineRb = new JRadioButton("Go to Line");
        Dimension d = layout.getPreferredSize(this.lineRb);
        this.lineRb.setBounds(10, 10, d.width, d.height);
        this.getContentPane().add(this.lineRb);
        this.lineRb.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.lineTf.setEnabled(true);
                this.parCmb.setEnabled(false);
                this.fileCmb.setEnabled(true);
                this.lineTf.requestFocus();
            }
        });
        this.parRb = new JRadioButton("Go to Paragraph");
        d = layout.getPreferredSize(this.parRb);
        this.parRb.setBounds(LMResize.getLeft(this.lineRb), LMResize.getBottom(this.lineRb) + 20, d.width, d.height);
        this.getContentPane().add(this.parRb);
        this.parRb.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.parCmb.setEnabled(true);
                this.lineTf.setEnabled(false);
                this.fileCmb.setEnabled(false);
                this.parCmb.requestFocus();
            }
        });
        this.lineTf = new JTextField();
        this.lineTf.setBounds(LMResize.getRight(this.parRb) + 5, LMResize.getTop(this.lineRb) + 2, 70, this.lineTf.getPreferredSize().height);
        this.getContentPane().add((Component)this.lineTf, new LMResizeData(1));
        this.lineTf.addMouseListener(new GraphUtilities.TextFieldDefaultPopup(this.lineTf));
        this.lineTf.setHorizontalAlignment(4);
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.lineRb);
        btnGroup.add(this.parRb);
        this.parCmb = new JComboBox();
        this.parCmb.setBounds(LMResize.getLeft(this.lineTf), LMResize.getTop(this.parRb) + 2, 200, this.parCmb.getPreferredSize().height);
        this.parCmb.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent(list, GotoDialog.this.parNames.get(value), index, isSelected, cellHasFocus);
            }
        });
        this.getContentPane().add(this.parCmb, new LMResizeData(1));
        JLabel filenameLbl = new JLabel("Filename:");
        d = layout.getPreferredSize(filenameLbl);
        filenameLbl.setBounds(LMResize.getLeft(this.lineRb), LMResize.getBottom(this.parRb) + 20, d.width, d.height);
        this.getContentPane().add(filenameLbl);
        this.fileCmb = new JComboBox();
        this.fileCmb.setBounds(LMResize.getLeft(this.lineTf), LMResize.getTop(filenameLbl), 200, this.fileCmb.getPreferredSize().height);
        this.getContentPane().add(this.fileCmb, new LMResizeData(1));
        this.goTo = new JButton("Go To");
        this.goTo.setMnemonic('g');
        this.goTo.addActionListener(this.aListener);
        this.close = new JButton("Close");
        this.close.addActionListener(e -> this.closeDialog());
        this.close.setMnemonic('c');
        d = layout.getPreferredSize(this.close);
        this.close.setBounds(LMResize.getRight(this.fileCmb) - d.width + 5, LMResize.getBottom(this.fileCmb) + 20, d.width, d.height);
        this.getContentPane().add((Component)this.close, new LMResizeData(10));
        this.goTo.setBounds(LMResize.getLeft(this.close) - 15 - d.width, LMResize.getTop(this.close), d.width, d.height);
        this.getContentPane().add((Component)this.goTo, new LMResizeData(10));
        this.lineRb.setSelected(true);
        GotoDialog.setFirstFocusedComponent(this.lineTf);
        this.pack();
        this.setDefaultButton(this.goTo);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.fileCmb.removeAllItems();
            this.parCmb.removeAllItems();
            this.parNames.clear();
            Filename[] filenames = this.preview.getFile().getFilenames();
            for (int i = 0; i < filenames.length; ++i) {
                this.fileCmb.addItem(filenames[i]);
            }
            DebugParagraph par0 = new DebugParagraph("", 0, 0);
            this.parNames.put(par0, "");
            Object[] pars = this.preview.getFile().getDebugParagraphs();
            if (pars != null) {
                int i;
                for (i = pars.length - 1; i >= 0; --i) {
                    String n = pars[i].getParagraphName();
                    if (!((DebugParagraph)pars[i]).isSection()) {
                        for (int j = i - 1; j >= 0 && ((DebugParagraph)pars[j]).isInDeclaratives() == ((DebugParagraph)pars[i]).isInDeclaratives(); --j) {
                            if (!((DebugParagraph)pars[j]).isSection()) continue;
                            n = n + " of " + ((DebugParagraph)pars[j]).getParagraphName();
                            break;
                        }
                    }
                    this.parNames.put((DebugParagraph)pars[i], n);
                }
                this.parCmb.addItem(par0);
                Arrays.sort(pars);
                for (i = 0; i < pars.length; ++i) {
                    this.parCmb.addItem((DebugParagraph)pars[i]);
                }
            }
        }
        super.setVisible(b);
    }
}

