/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.debugger.dialogs.treetable.model;

import com.iscobol.debugger.GraphDebugger;
import com.iscobol.debugger.ParagraphObject;
import com.iscobol.debugger.dialogs.treetable.model.VectorModel;

public class CallStackModel
extends VectorModel {
    public CallStackModel(GraphDebugger graphDebug) {
        super(new Class[]{String.class, String.class, String.class}, new String[]{"Paragraph", "Program", "Location"}, graphDebug);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (node == this.vector) {
            return null;
        }
        ParagraphObject po = (ParagraphObject)node;
        switch (column) {
            case 0: {
                String s = po.getName();
                if (po.getParentSection() != null) {
                    s = s + " of " + po.getParentSection();
                }
                return s;
            }
            case 1: {
                String s = po.getProgName();
                if (po.getEntryPointName() != null) {
                    s = po.getEntryPointName() + " of " + s;
                } else if (po.getMethodName() != null) {
                    s = po.getMethodName() + " of " + s;
                }
                return s;
            }
            case 2: {
                String file = po.getFile();
                if (file != null) {
                    return file + ":" + po.getLine();
                }
                return String.valueOf(po.getLine());
            }
        }
        return null;
    }
}

