/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;

public class IsguiWorker
implements Runnable {
    private static final int MAX_INVOCATION_EVENTS = 3000;
    private static int invocationEventCount;
    private boolean wait;
    private Runnable runnable;

    public IsguiWorker(boolean wait) {
        this(wait, null);
    }

    public IsguiWorker(boolean wait, Runnable r) {
        this.wait = wait;
        this.runnable = r;
    }

    public void start() {
        if (EventQueue.isDispatchThread()) {
            this.launch();
        } else {
            this.invoke();
        }
    }

    @Override
    public void run() {
        this.launch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke() {
        Object lock = new Object();
        IsguiWorkerEvent event = new IsguiWorkerEvent(Toolkit.getDefaultToolkit(), this, lock);
        ++invocationEventCount;
        if (this.wait) {
            Object object = lock;
            synchronized (object) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(event);
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(event);
        while (invocationEventCount >= 3000) {
            Thread.yield();
        }
    }

    public void launch() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    private static class IsguiWorkerEvent
    extends InvocationEvent {
        private Exception exception;
        private Throwable throwable;

        IsguiWorkerEvent(Object src, IsguiWorker runnable, Object lock) {
            super(src, (Runnable)runnable, lock, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch() {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    this.exception = (Exception)t;
                }
                this.throwable = t;
                t.printStackTrace();
            }
            if (this.notifier != null) {
                Object object = this.notifier;
                synchronized (object) {
                    this.notifier.notifyAll();
                }
            }
            invocationEventCount--;
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        @Override
        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

