/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.client.ClientCallImpl;
import com.iscobol.gui.client.ClientHandler;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.RedirectException;
import com.iscobol.gui.client.UpdateException;
import com.iscobol.gui.client.swing.SwingErrorBox;
import com.iscobol.interfaces.debugger.Appender;
import com.iscobol.interfaces.debugger.IDebuggerExtension2;
import com.iscobol.rts.ArrayTable;
import com.iscobol.rts.Config;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.Factory;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.Version;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Vector;
import javax.swing.UIManager;

public class Client {
    private static final byte[] a = new byte[]{105, 115, 99, 111, 98, 111, 108, 46, 108, 105, 99, 101, 110, 115, 101, 46, 50, 48, 50, 53};
    private static final byte[] b = new byte[]{67, 76, 79, 79, 67, 74, 76, 65, 75, 76, 67, 74, 73, 69, 70, 79, 75, 75, 66, 72, 70, 68, 65, 70, 77, 73, 67, 65, 71, 65, 68, 65, 71, 79, 71, 75, 68, 77, 76, 80, 77, 77, 78, 78, 71, 79, 79, 65, 70, 78, 74, 75, 78, 73, 74, 69, 79, 73, 80, 75, 76, 75, 70, 80, 78, 72, 80, 79, 77, 67, 65, 76, 73, 65, 79, 73, 77, 76, 77, 71, 72, 66, 73, 66, 67, 67, 76, 65, 74, 74, 66, 73, 67, 79, 80, 70, 76, 77, 10};
    private static String u;
    private static String p;
    private static String webClient;
    private static boolean isClient;
    private ArrayTable objectIds = new ArrayTable();
    private static final String eol;
    private static final String usage;
    private boolean noexit = false;
    private String[][] isconfig;
    private GuiFactory gf;
    private static boolean exiting;

    public static String[] login() {
        return new String[]{u, p};
    }

    public Client() {
    }

    public synchronized int setId(Object obj) {
        return this.objectIds.put(obj);
    }

    public Object getId(int oi) {
        try {
            return this.objectIds.get(oi);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public void delId(int oi) {
        try {
            this.objectIds.remove(oi);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public Vector getObjectsId() {
        Vector<Object> Return2 = new Vector<Object>();
        for (int i = this.objectIds.length() - 1; i > 0; --i) {
            Object obj = this.objectIds.getObject(i);
            if (obj == null) continue;
            Return2.add(obj);
        }
        return Return2;
    }

    public int getUniqueHandle(Object obj) {
        return this.objectIds.getUniqueHandle(obj);
    }

    public int getHandle(Object obj) {
        return this.objectIds.getHandle(obj);
    }

    public void debug() {
        System.out.println("<Client> debug start ---length [" + this.objectIds.length() + "]-----");
        for (int i = this.objectIds.length() - 1; i > 0; --i) {
            Object obj = this.objectIds.getObject(i);
            if (obj == null) continue;
            System.out.println("[" + i + "]=" + obj);
        }
        System.out.println("<Client> debug end   ---length [" + this.objectIds.length() + "]-----");
    }

    public static void main(String[] args) {
        ClientCallImpl.mainThread = Thread.currentThread();
        Client.clinit();
        new Client(args);
    }

    public Client(String[][] isconfig, GuiFactory gf) {
        this.gf = gf;
        this.noexit = true;
        this.isconfig = isconfig;
    }

    public Client(String[] args) {
        this.init(args);
    }

    public static void clinit() {
        try {
            Properties p = new Properties();
            p.setProperty(RtsUtil.newUTFString(a), RtsUtil.newUTFString(b));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            p.store(out, "Client Static Configurations");
            out.close();
            Config.setStaticProps(out.toByteArray());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(String[] args) {
        String[] ARGS;
        Config.markNoIscobolRuntimeThread();
        String host = null;
        String timeout = null;
        String port = null;
        String remoteconf = null;
        String progname = null;
        String localconf = null;
        String updaterconf = null;
        boolean debug = false;
        boolean nodisconnecterr = false;
        boolean noupdate = false;
        boolean setLookAndFeel = !GraphicsEnvironment.isHeadless();
        boolean isUtility = false;
        String user = null;
        String pwd = null;
        String threadId = null;
        String debugport = null;
        int i = 0;
        String lookAndFeel = null;
        String flatLaf = null;
        if (setLookAndFeel) {
            lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        }
        String[] defs = new String[2];
        String[] propValues = Config.getPropertiesSeparateThread(new String[]{"iscobol.default_program", "iscobol.default_options"}, defs);
        String defaultProgname = propValues[0];
        String defaultOptions = propValues[1];
        if (defaultOptions != null) {
            String[] ss = RtsUtil.parseArguments(defaultOptions);
            String[] newArgs = new String[ss.length + args.length];
            System.arraycopy(ss, 0, newArgs, 0, ss.length);
            System.arraycopy(args, 0, newArgs, ss.length, args.length);
            args = newArgs;
        }
        for (i = 0; i < args.length; ++i) {
            File file;
            if (!args[i].equalsIgnoreCase("-lc")) continue;
            if (!((file = new File(localconf = args[++i])).exists() && file.isFile() && file.canRead())) {
                FileNotFoundException ex = new FileNotFoundException(localconf);
                ErrorBox.show(ex);
                System.exit(1);
            }
            System.setProperty("iscobol.conf", localconf);
            boolean[] get = new boolean[]{defaultProgname == null, defaultOptions == null};
            if (!get[0] && !get[1]) break;
            String[] propNames = new String[2];
            if (get[0]) {
                propNames[0] = "iscobol.default_program";
            }
            if (get[1]) {
                propNames[1] = "iscobol.default_options";
            }
            propValues = Config.getPropertiesSeparateThread(propNames, defs);
            if (get[0]) {
                defaultProgname = propValues[0];
            }
            if (!get[1] || (defaultOptions = propValues[1]) == null) break;
            String[] ss = RtsUtil.parseArguments(defaultOptions);
            String[] newArgs = new String[ss.length + args.length];
            System.arraycopy(ss, 0, newArgs, 0, ss.length);
            System.arraycopy(args, 0, newArgs, ss.length, args.length);
            args = newArgs;
            break;
        }
        String[] values = Config.getPropertiesSeparateThread(new String[]{"iscobol.rundebug", "iscobol.debug.port", "iscobol.redirect_streams", "iscobol.rundebug.auto_pause"}, new String[]{"0", "9999", "true", "true"});
        int rundebug = 0;
        try {
            rundebug = Integer.parseInt(values[0]);
        }
        catch (NumberFormatException propNames) {
            // empty catch block
        }
        if (rundebug >= 1 && rundebug <= 2) {
            int rundebugport = 9999;
            try {
                rundebugport = Integer.parseInt(values[1]);
            }
            catch (NumberFormatException ss) {
                // empty catch block
            }
            boolean redirStreams = Config.isTrue(values[2]);
            int blockingMode = Config.isTrue(values[3]) ? 0 : 1;
            Config.startDebugListener(rundebug, rundebugport, redirStreams, true, blockingMode);
        }
        KeyboardBuffer.clinit();
        isClient = true;
        try {
            block19: for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
                UIManager.LookAndFeelInfo[] lafs;
                if (args[i].equalsIgnoreCase("-port")) {
                    port = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-hostname")) {
                    host = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-timeout")) {
                    timeout = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-user")) {
                    user = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-password")) {
                    pwd = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-help")) {
                    SwingErrorBox.message("Help", usage, true);
                    System.exit(0);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-v")) {
                    String fullVersionNumber = RuntimeProperties.getFullVersionNumber();
                    if (fullVersionNumber.startsWith("isCOBOL")) {
                        fullVersionNumber = "isCOBOL-Client" + fullVersionNumber.substring(7);
                    }
                    SwingErrorBox.message(fullVersionNumber, Client.copyright(), true);
                    System.exit(0);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-admin")) {
                    isUtility = true;
                    progname = "ASA$GADMIN";
                    continue;
                }
                if (args[i].equalsIgnoreCase("-panel")) {
                    isUtility = true;
                    progname = "ASA$GPANEL";
                    continue;
                }
                if (args[i].equalsIgnoreCase("-info")) {
                    setLookAndFeel = false;
                    progname = "ASA$INFO";
                    continue;
                }
                if (args[i].equalsIgnoreCase("-kill")) {
                    setLookAndFeel = false;
                    nodisconnecterr = true;
                    progname = "ASA$KILL";
                    threadId = args[++i];
                    continue;
                }
                if (args[i].equalsIgnoreCase("-c")) {
                    remoteconf = args[++i];
                    System.setProperty("iscobol.remote_conf", remoteconf);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-lc")) {
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-uc")) {
                    File file;
                    if ((file = new File(updaterconf = args[++i])).exists() && file.isFile() && file.canRead()) continue;
                    FileNotFoundException ex = new FileNotFoundException(updaterconf);
                    ErrorBox.show(ex);
                    System.exit(1);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-d")) {
                    debug = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-utility")) {
                    isUtility = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-web")) {
                    webClient = "true";
                    continue;
                }
                if (args[i].length() > 5 && args[i].toLowerCase().startsWith("-web=")) {
                    webClient = args[i].substring(5).toLowerCase();
                    continue;
                }
                if (args[i].equalsIgnoreCase("-nodisconnecterr")) {
                    nodisconnecterr = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-noupdate")) {
                    noupdate = true;
                    continue;
                }
                if (args[i].equalsIgnoreCase("--system")) {
                    if (!setLookAndFeel) continue;
                    lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                    continue;
                }
                if (args[i].equalsIgnoreCase("--metal")) {
                    if (!setLookAndFeel) continue;
                    lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
                    continue;
                }
                if (args[i].equalsIgnoreCase("--nimbus")) {
                    if (!setLookAndFeel) continue;
                    lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                    lafs = UIManager.getInstalledLookAndFeels();
                } else {
                    if (args[i].equalsIgnoreCase("--motif")) {
                        if (!setLookAndFeel) continue;
                        lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("--GTK")) {
                        if (!setLookAndFeel) continue;
                        lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-debugport")) {
                        debugport = args[++i];
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("--nolaf")) {
                        setLookAndFeel = false;
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("--flatlaf") && args.length > i + 1) {
                        flatLaf = args[++i];
                        continue;
                    }
                    SwingErrorBox.message("Command line error: " + args[i], usage, false);
                    System.exit(0);
                    continue;
                }
                for (int y = 0; y < lafs.length; ++y) {
                    if (!"Nimbus".equals(lafs[y].getName())) continue;
                    lookAndFeel = lafs[y].getClassName();
                    continue block19;
                }
            }
        }
        catch (Exception e) {
            SwingErrorBox.message("Command line error: " + e.getMessage(), e);
            System.exit(0);
        }
        if (remoteconf == null) {
            remoteconf = Config.getProperty("iscobol.remote_conf", null);
        }
        if (host == null) {
            host = Config.getProperty("iscobol.hostname", "localhost");
        }
        if (port == null) {
            port = Config.getProperty("iscobol.port", ClientHandler.getDefaultPort());
        }
        if (timeout == null) {
            timeout = Config.getProperty("iscobol.timeout", "0");
        }
        if (debugport == null) {
            debugport = Config.getProperty("iscobol.debug.port", null);
        }
        if (debugport == null) {
            debugport = "0";
        }
        if (setLookAndFeel && System.getProperty("swing.defaultlaf") == null) {
            try {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception e) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
                try {
                    UIManager.setLookAndFeel(lookAndFeel);
                }
                catch (Exception y) {
                    // empty catch block
                }
            }
        }
        UIManager.getDefaults().put("Button.showMnemonics", Boolean.TRUE);
        if (flatLaf != null) {
            try {
                Class<?> clazFlatLaf = Class.forName("com.formdev.flatlaf.FlatLaf");
                Class<?> clazCustom = Class.forName("com.formdev.flatlaf." + flatLaf);
                Method methodRegisterCustomDefaultsSource = clazFlatLaf.getMethod("registerCustomDefaultsSource", File.class);
                Method methodSetup = clazCustom.getMethod("setup", new Class[0]);
                methodRegisterCustomDefaultsSource.invoke(null, new File(Config.getProperty("iscobol.gui.flatlaf.conf", System.getProperty("user.dir"))));
                methodSetup.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (progname == null && i < args.length) {
            progname = args[i];
        }
        if (args.length > ++i) {
            ARGS = new String[args.length - i];
            System.arraycopy(args, i, ARGS, 0, ARGS.length);
        } else {
            ARGS = threadId != null ? new String[]{threadId} : new String[]{};
        }
        if (progname == null && defaultProgname != null) {
            String[] ss = RtsUtil.parseArguments(defaultProgname);
            ARGS = new String[ss.length - 1];
            progname = ss[0];
            for (int j = 0; j < ARGS.length; ++j) {
                ARGS[j] = ss[j + 1];
            }
        }
        if (progname != null) {
            progname = Factory.prepareCallName(progname);
        }
        if (user == null) {
            user = Config.getProperty(".user.name", null);
        }
        if (pwd == null) {
            pwd = Config.getProperty(".user.password", ".user.passwd", null);
        }
        u = user;
        p = pwd;
        if (noupdate) {
            updaterconf = null;
        } else if (updaterconf == null) {
            updaterconf = "";
        }
        while (true) {
            try {
                new ClientHandler().init(host, port, timeout, progname, ARGS, remoteconf, this.noexit, updaterconf, this.isconfig, nodisconnecterr, new String[]{String.valueOf(debug), debugport}, isUtility, webClient, null, this.gf);
                return;
            }
            catch (RedirectException re) {
                host = re.host;
                port = re.port;
                timeout = re.timeout;
                continue;
            }
            catch (UpdateException ue) {
                try {
                    Factory.launchSoftwareUpdater(ue.sw, ue.propFileName, ue.props, ue.site, Client.class.getName(), args, true);
                    return;
                }
                catch (Exception e) {
                    SwingErrorBox.message(e.getMessage(), e);
                    if (this.noexit) return;
                    System.exit(4);
                    return;
                }
            }
            break;
        }
    }

    private static void addJavaArgs(Vector args, boolean addSslProps) {
        String javaHome = System.getProperty("java.home");
        args.addElement(javaHome != null ? javaHome + "/bin/java" : "java");
        String classpath = System.getProperty("java.class.path", "");
        if (classpath.length() > 0) {
            args.addElement("-classpath");
            args.addElement(classpath);
        }
        if (addSslProps) {
            for (String propName : new String[]{"iscobol.net.ssl.trust_store", "iscobol.net.ssl.trust_store_password"}) {
                String value = Config.getProperty(propName, null);
                if (value == null || value.length() <= 0) continue;
                args.addElement("-D" + propName + "=" + value);
            }
        }
    }

    static int startDebugListener(String host, String port, String debugport) throws IOException {
        Vector<String> args = new Vector<String>();
        Client.addJavaArgs(args, true);
        args.addElement("-Discobol.display_message=2");
        args.addElement(Client.class.getName());
        args.addElement("-noupdate");
        args.addElement("-port");
        args.addElement(port);
        args.addElement("-hostname");
        args.addElement(host);
        args.addElement("ASA$DEBUG_AUTO");
        args.addElement("start");
        args.addElement("1");
        args.addElement(debugport);
        String[] cmdLine = new String[args.size()];
        args.toArray(cmdLine);
        Process p = Runtime.getRuntime().exec(cmdLine);
        final InputStream err = p.getErrorStream();
        new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(err));
                try {
                    String s;
                    while ((s = reader.readLine()) != null) {
                        System.err.println(s);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        try {
            return p.waitFor();
        }
        catch (InterruptedException e) {
            return 0;
        }
    }

    static void stopDebugListener(String host, String port) throws IOException {
        Vector<String> args = new Vector<String>();
        Client.addJavaArgs(args, true);
        args.addElement("com.iscobol.gui.client.Client");
        args.addElement("-port");
        args.addElement(port);
        args.addElement("-hostname");
        args.addElement(host);
        args.addElement("ASA$DEBUG_AUTO");
        args.addElement("stop");
        String[] cmdLine = new String[args.size()];
        args.toArray(cmdLine);
        Runtime.getRuntime().exec(cmdLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void startGraphDebugger(String host, String port, boolean wait) throws IOException {
        Vector<String> args = new Vector<String>();
        Client.addJavaArgs(args, false);
        args.addAll(Factory.getJVMArguments());
        for (String p : new String[]{"iscobol.debug.code_prefix", "iscobol.debug.remote_source"}) {
            String v = Config.getProperty(p, null);
            if (v == null) continue;
            args.addElement("-D" + p + "=" + v);
        }
        args.addElement("com.iscobol.debugger.GraphDebugger");
        args.addElement("-r_notifyclient");
        args.addElement(host);
        args.addElement(port);
        String[] cmdLine = new String[args.size()];
        args.toArray(cmdLine);
        final Process p = Runtime.getRuntime().exec(cmdLine);
        final boolean[] ok = new boolean[]{false};
        final InputStream in = p.getInputStream();
        final InputStream err = p.getErrorStream();
        final OutputStream out = p.getOutputStream();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    in.read();
                    boolean[] blArray = ok;
                    synchronized (ok) {
                        ok[0] = true;
                        ok.notify();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                    return;
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(err));
                try {
                    String s;
                    while ((s = reader.readLine()) != null) {
                        System.err.println(s);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        if (wait) {
            boolean[] blArray = ok;
            // MONITORENTER : ok
            if (!ok[0]) {
                try {
                    ok.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // MONITOREXIT : blArray
        }
        IDebuggerExtension2 dbg = null;
        File dbgProps = new File(System.getProperty("user.home") + File.separator + "isdebugger.properties");
        boolean attachConsole = true;
        if (dbgProps.exists()) {
            Properties props = new Properties();
            try {
                FileInputStream propIn = new FileInputStream(dbgProps);
                props.load(propIn);
                propIn.close();
                attachConsole = "1".equals(props.getProperty("graphdebugger.consoleattached", "1"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (attachConsole) {
            try {
                dbg = (IDebuggerExtension2)Class.forName("com.iscobol.debugger.DebuggerImpl").newInstance();
            }
            catch (Throwable props) {
                // empty catch block
            }
        }
        if (dbg == null) return;
        final PrintStream sysout = System.out;
        System.setOut(dbg.newDebugOutputStream(new Appender(){

            @Override
            public void appendLine(String s) {
                try {
                    out.write((s + "\n").getBytes());
                    out.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }));
        new Thread(){

            @Override
            public void run() {
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.setOut(sysout);
            }
        }.start();
    }

    public static boolean isExiting() {
        return exiting;
    }

    public static void setExiting(boolean exiting) {
        Client.exiting = exiting;
    }

    private static String copyright() {
        String csVersion = "C/S Version " + Config.getProperty(".runtime.cs.version", "c/s version unknown");
        String fsVersion = "F/S Version " + Config.getProperty(".runtime.fs.version", "F/S version unknown");
        String javaInfo = System.getProperty("java.version") + " " + System.getProperty("java.vendor");
        String fullVersionNumber = RuntimeProperties.getFullVersionNumber();
        if (fullVersionNumber.startsWith("isCOBOL")) {
            fullVersionNumber = "isCOBOL-Client" + fullVersionNumber.substring(7);
        }
        String productCopyright = RuntimeProperties.getProductCopyright();
        return fullVersionNumber + eol + productCopyright + eol + csVersion + ", " + fsVersion + ", UID Version " + Version.getUIDVersion() + eol + eol + "Java version:    " + javaInfo + eol + "                 " + System.getProperty("java.home");
    }

    public static boolean isWebClient() {
        return webClient != null;
    }

    public static boolean isClient() {
        return isClient;
    }

    static {
        eol = System.getProperty("line.separator", "\n");
        usage = "usage:" + eol + "<command> [--system | --metal | --GTK | --nimbus | --flatlaf lafname] [-port n[,n2,...]] [-hostname host[,host2,...]] [-timeout t[,t2,...]] [-user user] [-password password] [-c conf-file] [-utility] [-noupdate] [-uc updater-conf-file] [-nodisconnecterr] progname [arg1 [arg2] ...]" + eol + "<command> -d [-debugport n] [-port n[,n2,...]] [-hostname host[,host2,...]] [-timeout t[,t2,...]] [-user user] [-password password] [-c conf-file] [-utility] [-noupdate] [-uc updater-conf-file] [-nodisconnecterr]" + eol + "          [-lc localconf-file] progname [arg1 [arg2] ...]" + eol + "<command> [-port n[,n2,...]] [-hostname host[,host2,...]] [-timeout t[,t2,...]] [-user user] [-password password] -admin" + eol + "<command> [-port n[,n2,...]] [-hostname host[,host2,...]] [-timeout t[,t2,...]] [-user user] [-password password] -info" + eol + "<command> [-port n[,n2,...]] [-hostname host[,host2,...]] [-timeout t[,t2,...]] [-user user] [-password password] -kill threadID|AS" + eol + "<command> [-port n[,n2,...]] [-hostname host[,host2,...]] [-timeout t[,t2,...]] [-user user] [-password password] -panel" + eol + "<command> -v";
    }
}

