/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client;

import com.iscobol.as.ServerHandler;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.client.AppFactoryMultitaskingImpl;
import com.iscobol.gui.client.Client;
import com.iscobol.gui.client.MultitaskingClientHandler;
import com.iscobol.gui.client.RedirectException;
import com.iscobol.gui.client.UpdateException;
import com.iscobol.gui.client.swing.SwingErrorBox;
import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rmi.IscobolMessageSerializer;
import com.iscobol.rmi.RemoteRegistry;
import com.iscobol.rmi.Worker;
import com.iscobol.rmi.client.ClientCaller;
import com.iscobol.rpc.dualrpc.client.AbstractClientRpcHandler;
import com.iscobol.rpc.dualrpc.client.DualRpcClient;
import com.iscobol.rpc.dualrpc.client.IClientCallbackHandler;
import com.iscobol.rpc.dualrpc.client.NotConnectedException;
import com.iscobol.rpc.dualrpc.common.CallException;
import com.iscobol.rpc.dualrpc.common.IRpcMessageDispatcher;
import com.iscobol.rpc.dualrpc.common.IRpcWorkerFactory;
import com.iscobol.rpc.dualrpc.server.IServerCallbackHandler;
import com.iscobol.rpc.messageserver.common.Message;
import com.iscobol.rpc.messageserver.common.RpcSocketFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.SoftwareUpdaterIntf;
import com.iscobol.rts.Version;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class ClientHandler
extends AbstractClientRpcHandler
implements IClientCallbackHandler,
IRpcWorkerFactory {
    private boolean redirect;
    private String hostname;
    private int portNumber;
    private int connectionTimeout;
    private boolean nodisconnecterr;

    @Override
    public void brokenConnection() {
        this.intBrokenConnection(this.redirect);
    }

    private void intBrokenConnection(boolean redirect) {
        if (Client.isExiting()) {
            return;
        }
        Logger log = RemoteRegistry.getClientProblemLogger();
        if (log != null) {
            log.info(ClientHandler.class.getName() + ": disconnected from " + this.hostname + ", port " + this.portNumber);
        }
        if (!redirect) {
            if (!this.nodisconnecterr) {
                String title = "Connection lost";
                String msg = "Disconnected from " + this.hostname + ", port " + this.portNumber;
                SwingErrorBox.optionPaneMessage(title, msg);
            }
            System.exit(-1);
        }
    }

    @Override
    public Thread getRpcWorkerThread(IRpcMessageDispatcher dispatcher, Message message) {
        return new Worker(dispatcher, message, RemoteRegistry.getSharedRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String host, String port, String timeout, String progname, String[] ARGS, String remoteconf, boolean noexit, String updaterconf, String[][] isconfig, boolean nodisconnecterr, String[] debugArgs, boolean isUtility, String webClient, Map ideParams, GuiFactory gf) throws RedirectException, UpdateException {
        block51: {
            int hostCommaIdx = host.indexOf(44);
            int portCommaIdx = port.indexOf(44);
            int timeoutCommandIdx = timeout.indexOf(44);
            String clientVer = Version.getCsVersion();
            try {
                Config.setWC(webClient);
                this.hostname = hostCommaIdx >= 0 ? host.substring(0, hostCommaIdx) : host;
                this.portNumber = portCommaIdx >= 0 ? Integer.parseInt(port.substring(0, portCommaIdx)) : Integer.parseInt(port);
                this.connectionTimeout = timeoutCommandIdx >= 0 ? Integer.parseInt(timeout.substring(0, timeoutCommandIdx)) : Integer.parseInt(timeout);
                this.nodisconnecterr = nodisconnecterr;
                final DualRpcClient client = new DualRpcClient(this.hostname, this.portNumber, this.connectionTimeout * 1000);
                RemoteRegistry.setClientCaller(new ClientCaller(client));
                if (RemoteRegistry.getSharedRegistry() == null) {
                    RemoteRegistry.setSharedRegistry(new RemoteRegistry());
                }
                Logger problemLog = LoggerFactory.get(64);
                Logger rpcCallLog = LoggerFactory.get(128);
                RemoteRegistry.setClientProblemLogger(problemLog);
                RemoteRegistry.setClientRpcCallLogger(rpcCallLog);
                client.registerClientSideHandler(this);
                final IscobolMessageSerializer messageSerializer = new IscobolMessageSerializer();
                client.setMessageSerializer(messageSerializer);
                client.setCallbackHandler(this);
                client.setRpcWorkerFactory(this);
                if (problemLog != null) {
                    problemLog.info(ClientHandler.class + ": connecting to " + this.hostname + ", port " + this.portNumber + (this.connectionTimeout > 0 ? ", timeout = " + this.connectionTimeout : ""));
                }
                client.connect();
                String server = ServerHandler.class.getName();
                String serverVer = (String)client.call(server, "getCSVersion");
                if (serverVer.charAt(0) == '@') {
                    int colon;
                    this.redirect = true;
                    client.disconnect();
                    if (serverVer.charAt(1) == '!') {
                        SwingErrorBox.message("No server available", "No server available: please try later", false);
                        if (!noexit) {
                            System.exit(3);
                        }
                    }
                    RedirectException re = (colon = serverVer.indexOf(58)) > 0 ? new RedirectException(serverVer.substring(1, colon), serverVer.substring(colon + 1, serverVer.length())) : new RedirectException(serverVer.substring(1, serverVer.length()), port);
                    throw re;
                }
                StringTokenizer stn = new StringTokenizer(serverVer, ";");
                serverVer = stn.nextToken();
                if (updaterconf != null && stn.hasMoreTokens()) {
                    String currVersion;
                    String updateSite = stn.nextToken();
                    String updateVersion = stn.nextToken();
                    Properties swProps = null;
                    if (stn.hasMoreTokens()) {
                        swProps = new Properties();
                        while (stn.hasMoreTokens()) {
                            String tk = stn.nextToken();
                            int idx = tk.indexOf(61);
                            swProps.setProperty(tk.substring(0, idx), tk.substring(idx + 1));
                        }
                    }
                    boolean update = RtsUtil.revisionCmp(currVersion = RuntimeProperties.getShortBuildNumber(), updateVersion) < 0;
                    Logger updaterLog = LoggerFactory.get(1);
                    if (updaterLog != null) {
                        updaterLog.info("isCOBOL server version: " + updateVersion);
                        updaterLog.info("isCOBOL client version: " + currVersion);
                        String msg = "";
                        if (!update) {
                            msg = msg + "no ";
                        }
                        msg = msg + "update required";
                        updaterLog.info(msg);
                    }
                    SoftwareUpdaterIntf sw = (SoftwareUpdaterIntf)Class.forName("com.iscobol.updater.SoftwareUpdater").newInstance();
                    String propFileName = updaterconf;
                    if (propFileName.length() == 0) {
                        propFileName = sw.findPropertiesFileName();
                    }
                    Properties props = null;
                    if (propFileName != null) {
                        props = new Properties();
                        RtsUtil.loadProperties(props, propFileName);
                        if (swProps != null) {
                            Enumeration<?> en = swProps.propertyNames();
                            while (en.hasMoreElements()) {
                                String library;
                                String p = (String)en.nextElement();
                                String prefix = "swupdater.version.";
                                boolean updt = false;
                                if (!p.startsWith(prefix) || "iscobol".equals(library = p.substring(prefix.length())) || "iscobolNative".equals(library)) continue;
                                String remoteValue = swProps.getProperty(p);
                                String localValue = props.getProperty(p);
                                if (localValue != null && RtsUtil.revisionCmp(localValue, remoteValue) < 0) {
                                    updt = true;
                                    update = true;
                                }
                                if (updaterLog == null) continue;
                                updaterLog.info(library + " server version: " + remoteValue);
                                updaterLog.info(library + " client version: " + localValue);
                                String msg = "";
                                if (!updt) {
                                    msg = msg + "no ";
                                }
                                msg = msg + "update required";
                                updaterLog.info(msg);
                            }
                        }
                    }
                    if (update) {
                        this.redirect = true;
                        client.disconnect();
                        if (updaterLog != null) {
                            updaterLog.info("invoking isUpdater...");
                        }
                        throw new UpdateException(updateSite, sw, propFileName, props);
                    }
                }
                boolean debug = false;
                String debugport = "";
                final String debugHost = host;
                String ideDebugPort = System.getProperty("ide.debugport", "");
                if (debugArgs != null && debugArgs.length > 0) {
                    debug = "true".equals(debugArgs[0]);
                    debugport = debugArgs.length > 1 ? debugArgs[1] : "";
                } else {
                    debugport = "";
                }
                int code = 0;
                if (debug) {
                    try {
                        code = Client.startDebugListener(host, port, debugport);
                        if (code < 0) {
                            SwingErrorBox.message("ERROR", "Unable to connect to Debug Listener", false);
                            if (!noexit) {
                                System.exit(3);
                            }
                        }
                        if (code == 0) {
                            if ("0".equals(debugport)) {
                                debugport = Integer.toString(9999);
                            }
                            Client.startGraphDebugger(host, debugport, true);
                            String h = host;
                            String p = port;
                            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                                try {
                                    Client.stopDebugListener(h, p);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (ideDebugPort.length() > 0) {
                    debug = true;
                }
                if (!clientVer.equals(serverVer)) {
                    SwingErrorBox.message("Software incompatibility", "Client release (" + clientVer + ") is incompatible with Application Server (" + serverVer + ")", false);
                    if (!noexit) {
                        System.exit(3);
                    }
                }
                Object synch = new Object();
                final AppFactoryMultitaskingImpl af = new AppFactoryMultitaskingImpl(synch, noexit, isconfig, nodisconnecterr, gf);
                final boolean startGD = debug && ideDebugPort.length() == 0 && (debugArgs == null || debugArgs.length <= 2 || Boolean.parseBoolean(debugArgs[2]));
                class MyHandler
                implements AppFactoryMultitaskingImpl.Handler,
                IServerCallbackHandler,
                Runnable {
                    int port;
                    String host;

                    MyHandler() {
                    }

                    @Override
                    public int handleMultitasking() {
                        ClientHandler.this.redirect = true;
                        try {
                            Socket s = client.getSession().getSocket();
                            this.host = s.getLocalAddress().getHostAddress();
                            this.port = ClientHandler.getFreePort(this.host, s.getLocalPort());
                        }
                        catch (NotConnectedException e) {
                            e.printStackTrace();
                        }
                        Thread t = new Thread(this);
                        t.start();
                        return this.port;
                    }

                    @Override
                    public void brokenConnection() {
                        ClientHandler.this.intBrokenConnection(false);
                    }

                    @Override
                    public void run() {
                        MultitaskingClientHandler.MyServer server = new MultitaskingClientHandler.MyServer(this.host, this.port, false, "MultitaskingHandler", debugHost, af, this, startGD);
                        try {
                            server.registerServerSideHandlerClassname(MultitaskingClientHandler.class.getName());
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        server.setRpcWorkerFactory(ClientHandler.this);
                        server.setMessageSerializer(messageSerializer);
                        try {
                            server.listen();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                af.setHandler(new MyHandler());
                if (ideParams != null) {
                    ArrayList<Object> params = new ArrayList<Object>();
                    params.add(progname);
                    params.add(ideParams.get("od"));
                    params.add(ideParams.get("runMode"));
                    params.add(ideParams.get("confFile"));
                    params.add(debug);
                    params.add(af);
                    client.call(server, "start", params);
                } else {
                    String[] clData = new String[6];
                    clData[0] = remoteconf;
                    clData[1] = Config.getProperty(".user.name", System.getProperty("user.name", null));
                    clData[3] = debug ? debugport : "false";
                    clData[4] = String.valueOf(isUtility);
                    clData[5] = webClient != null ? webClient : "";
                    client.call(server, "start", progname, ARGS, clData, af);
                }
                Object object = synch;
                synchronized (object) {
                    synch.wait();
                }
            }
            catch (CallException e) {
                String stk;
                int br;
                String msg = e.getMessage();
                if (msg == null) {
                    msg = "" + e;
                }
                if (msg.startsWith("getCSVersion")) {
                    SwingErrorBox.message("Software incompatibility", "Client release (" + clientVer + ") is incompatible with Application Server", false);
                    if (!noexit) {
                        System.exit(3);
                    }
                }
                if ((br = msg.indexOf(10)) > 0) {
                    stk = msg.substring(br + 1, msg.length());
                    msg = msg.substring(0, br);
                } else {
                    stk = msg;
                }
                if (msg.startsWith(IscobolRuntimeException.getErrorDesc(30))) {
                    SwingErrorBox.message(msg, "This application has exceeded the maximum number of allowed users.\nIf you see this message, please contact your system administrator and/or try again later.", false);
                } else {
                    SwingErrorBox.message(msg, stk, false);
                }
                if (!noexit) {
                    System.exit(2);
                }
            }
            catch (RedirectException e) {
                throw e;
            }
            catch (UpdateException e) {
                throw e;
            }
            catch (ConnectException | SocketTimeoutException | UnknownHostException e) {
                this.handleConnectException(e, host, hostCommaIdx, port, portCommaIdx, timeout, timeoutCommandIdx, noexit);
            }
            catch (Throwable e) {
                SwingErrorBox.message(e.getMessage(), e);
                if (noexit) break block51;
                System.exit(1);
            }
        }
    }

    private void handleConnectException(Exception e, String host, int hostCommaIdx, String port, int portCommaIdx, String timeout, int tmCommaIdx, boolean noexit) throws RedirectException {
        this.checkReconnect(host, hostCommaIdx, port, portCommaIdx, timeout, tmCommaIdx);
        SwingErrorBox.message("Unable to connect to '" + host + "', port = " + port, e);
        if (!noexit) {
            System.exit(1);
        }
    }

    private void checkReconnect(String host, int hostCommaIdx, String port, int portCommaIdx, String timeout, int tmCommandIdx) throws RedirectException {
        String tm;
        String string = tm = tmCommandIdx >= 0 ? timeout.substring(tmCommandIdx + 1) : timeout;
        if (hostCommaIdx >= 0) {
            throw new RedirectException(host.substring(hostCommaIdx + 1), portCommaIdx >= 0 ? port.substring(portCommaIdx + 1) : port, tm);
        }
        if (portCommaIdx >= 0) {
            throw new RedirectException(host, port.substring(portCommaIdx + 1), tm);
        }
    }

    public static String getDefaultPort() {
        return "10999";
    }

    public static int getFreePort(String host, int preferredPort) {
        ServerSocket ss = null;
        int Return2 = preferredPort;
        InetAddress address = null;
        try {
            address = InetAddress.getByName(host);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            ss = RpcSocketFactory.createServerSocket(preferredPort, 100, address);
        }
        catch (IOException e) {
            try {
                ss = RpcSocketFactory.createServerSocket(0, 100, address);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (ss != null) {
            Return2 = ss.getLocalPort();
            try {
                ss.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Return2;
    }
}

