/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.charva;

import charva.awt.Color;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Toolkit;

public class Graphics {
    Color backcol;
    Color forecol;
    Toolkit t = Toolkit.getDefaultToolkit();

    private int getColorG() {
        return this.getColorG(false);
    }

    private int getColorG(boolean reverse) {
        int Return2 = -1;
        if (reverse) {
            Graphics graphics = this;
            Graphics graphics2 = this;
            Return2 = Color.getCursesColor((Color)graphics.t.getDefaultBackground(), (Color)graphics2.t.getDefaultForeground());
        } else {
            Graphics graphics = this;
            Graphics graphics3 = this;
            Return2 = Color.getCursesColor((Color)graphics.t.getDefaultForeground(), (Color)graphics3.t.getDefaultBackground());
        }
        return Return2;
    }

    public void setBackColor(Color c) {
        if (c == null) {
            c = Color.black;
        }
        this.backcol = c;
        if (this.t.hasColors()) {
            Toolkit.setDefaultBackground((Color)c);
        }
    }

    public void setForeColor(Color c) {
        if (c == null) {
            c = Color.white;
        }
        this.forecol = c;
        if (this.t.hasColors()) {
            Toolkit.setDefaultForeground((Color)c);
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        this.t.blankBox(new Point(x, y), new Dimension(width - x, height - y), this.getColorG());
    }

    public void fillCursorOff(int x, int y, int width, int height) {
        this.t.blankBox(new Point(x, y), new Dimension(width, height), this.getColorG());
        this.t.setCursor(x, y);
    }

    public void fillCursorOn(char c, int a, int x, int y, int width, int height) {
        this.t.blankBox(new Point(x, y), new Dimension(width, height), this.getColorG(c != ' '));
        if (c != ' ') {
            this.addChar(c, a, x, y);
        } else {
            this.t.setCursor(x, y);
        }
    }

    public void fillCursorOffchar(char c, int x, int y, int width, int height) {
        int attr = 0;
        attr |= Toolkit.A_UNDERLINE;
        this.t.setCursor(x, y);
        this.t.addChar((int)c, attr |= Toolkit.A_BLINK, this.getColorG());
        this.t.setCursor(x, y);
    }

    public void fillCursorOnchar(char c, int x, int y, int width, int height) {
        int attr = 0;
        attr |= Toolkit.A_UNDERLINE;
        this.t.setCursor(x, y);
        this.t.addChar((int)c, attr |= Toolkit.A_BLINK, this.getColorG());
        this.t.setCursor(x, y);
    }

    public void addChar(int c, int x, int y) {
        this.addChar(c, 0, x, y);
    }

    public void addChar(int c, int a, int x, int y) {
        int attr = 0;
        if ((a & 0x1000000) != 0) {
            attr = Toolkit.A_BOLD;
        }
        if ((a & 0x2000000) != 0) {
            attr |= Toolkit.A_UNDERLINE;
        }
        if ((a & 0x8000000) != 0) {
            attr |= Toolkit.A_BLINK;
        }
        if ((a & 0x4000000) != 0) {
            attr |= Toolkit.A_REVERSE;
        }
        this.t.setCursor(x, y);
        if ((a & 0x10000000) == 0x10000000) {
            this.t.addChar(32, attr, this.getColorG());
        } else {
            this.t.addChar(c, attr, this.getColorG());
        }
        this.t.setCursor(x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (x1 == x2) {
            this.t.addVerticalLine(y2 - y1, 0, this.getColorG());
        } else if (y1 == y2) {
            this.t.addHorizontalLine(x2 - x1, 0, this.getColorG());
        }
    }

    public void repaint() {
        try {
            this.t.redrawWin();
        }
        catch (Throwable ex) {
            this.t.sync();
        }
    }

    public void repaintD() {
        this.t.sync();
    }
}

