/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.JPanel;

public class BorderedPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    Image offscreen;
    boolean paintSW;
    RemoteBaseGUIWindow parentDW;
    private int win3grid = -1;
    private GradientManager gradientMgr;

    public BorderedPanel(RemoteBaseGUIWindow dw, boolean b) {
        this.parentDW = dw;
        this.paintSW = b;
        if (dw != null) {
            this.win3grid = dw.win3_grid;
            this.gradientMgr = dw.gradientMgr;
            this.gradientMgr.addPropertyChangeListener(e -> this.repaint());
        }
    }

    public BorderedPanel(boolean b) {
        this((RemoteBaseGUIWindow)null, b);
    }

    void setParent(RemoteBaseGUIWindow dw) {
        this.parentDW = dw;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.gradientMgr != null) {
            this.gradientMgr.paint(g2d, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
        if (this.parentDW != null && this.win3grid >= 0) {
            Color orig = g.getColor();
            if (this.win3grid % 7 == 0) {
                g.setColor(Color.yellow);
            } else if (this.win3grid % 6 == 0) {
                g.setColor(Color.magenta);
            } else if (this.win3grid % 5 == 0) {
                g.setColor(Color.red);
            } else if (this.win3grid % 4 == 0) {
                g.setColor(Color.cyan);
            } else if (this.win3grid % 3 == 0) {
                g.setColor(Color.green);
            } else if (this.win3grid % 2 == 0) {
                g.setColor(Color.blue);
            }
            BasicStroke dash = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 0.0f);
            Stroke def = g2d.getStroke();
            Dimension size = this.getSize();
            int cw = this.parentDW.getCellWidth();
            int ch = this.parentDW.getCellHeight();
            int i = cw;
            int idx = 1;
            while (i <= size.width) {
                g2d.setStroke(idx % 10 > 0 ? dash : def);
                g.drawLine(i, 0, i, size.height - 1);
                i += cw;
                ++idx;
            }
            int j = ch;
            idx = 1;
            while (j < size.height) {
                g2d.setStroke(idx % 5 > 0 ? dash : def);
                g.drawLine(0, j, size.width - 1, j);
                j += ch;
                ++idx;
            }
            g2d.setStroke(def);
            g.setColor(orig);
        }
    }
}

