/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.TextOnIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ColorUIResource;

public class Button
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final Color defDisabledForeground;
    private boolean transparent;
    private boolean flat;
    private String title;
    private String toolTipText;
    private Image image;
    private Image imageWithTC;
    private final Border defaultBorder = this.getBorder();
    private int bitmapNumber;
    private int bitmapDisabled;
    private int bitmapPressed;
    private int bitmapRollover;
    private int bitmapWidth;
    private int imageHeight;
    private int imageWidth;
    private Dimension origSize;
    private boolean scaleBestQuality;
    private boolean multiline;
    private int titlePosition;
    private boolean hasBitmap;
    private char mnemonic;
    private Dimension scalebitmaptosize;
    private boolean usetextonicon;
    private Color disabledBackground;
    private Color disabledForeground;
    private int transparentColor = -1;
    private Color background;
    private Color foreground;
    private Color rolloverBackground;
    private Color rolloverForeground;
    private boolean isMouseHovering;
    private Vector<Integer> borderWidth;
    private Color borderColor;
    private Color rolloverBorderColor;
    private int bitmapScale;

    public Button() {
        this.setIconTextGap(3);
        this.addMouseListener(IsguiUtility.mouseAdapter(e -> {
            this.isMouseHovering = true;
            if (this.isEnabled()) {
                if (this.shouldManageBorder()) {
                    this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
                }
                if (this.rolloverBackground != null) {
                    this.updateBackground();
                }
                if (this.rolloverForeground != null) {
                    this.updateForeground();
                }
                if (this.rolloverBorderColor != null && this.flat) {
                    this.setBorder(this.getCustomRolloverBorder());
                }
            }
        }, e -> {
            this.isMouseHovering = false;
            if (this.isEnabled()) {
                if (this.shouldManageBorder()) {
                    this.setBorder(null);
                }
                if (this.rolloverBackground != null) {
                    this.updateBackground();
                }
                if (this.rolloverForeground != null) {
                    this.updateForeground();
                }
                if (this.rolloverBorderColor != null && this.flat) {
                    this.setBorder(this.borderColor != null ? this.getCustomBorder() : null);
                }
            }
        }, e -> {
            if (this.shouldManageBorder() && this.isEnabled()) {
                this.setBorder(BorderFactory.createLoweredSoftBevelBorder());
            }
        }, e -> {
            if (this.shouldManageBorder() && this.isEnabled() && this.contains(e.getPoint())) {
                this.setBorder(BorderFactory.createRaisedSoftBevelBorder());
            }
        }, null));
    }

    private MatteBorder getCustomRolloverBorder() {
        return this.getCustomBorder(this.rolloverBorderColor);
    }

    private MatteBorder getCustomBorder() {
        return this.getCustomBorder(this.borderColor != null ? this.borderColor : Color.darkGray);
    }

    private MatteBorder getCustomBorder(Color c) {
        if (this.borderWidth != null) {
            int sz = this.borderWidth.size();
            return new MatteBorder(sz > 0 ? this.borderWidth.elementAt(0) : 1, sz > 1 ? this.borderWidth.elementAt(1) : 1, sz > 2 ? this.borderWidth.elementAt(2) : 1, sz > 3 ? this.borderWidth.elementAt(3) : 1, c);
        }
        return new MatteBorder(1, 1, 1, 1, c);
    }

    private boolean shouldManageBorder() {
        return this.hasBitmap && this.flat && this.borderWidth == null && this.rolloverBorderColor == null && this.rolloverBackground == null && this.rolloverForeground == null;
    }

    @Override
    public void setBackground(Color bg) {
        this.background = bg;
        this.updateBackground();
    }

    @Override
    public void setForeground(Color fg) {
        this.foreground = fg;
        this.updateForeground();
    }

    public void setHasBitmap(boolean b) {
        if (this.hasBitmap != b) {
            this.hasBitmap = b;
            this.origSize = this.getSize();
        }
    }

    public void setMultiline(boolean m) {
        this.multiline = m;
        this.setTitle(this.title);
    }

    public void setBitmapNumber(int n) {
        this.bitmapNumber = n;
        if (this.image != null) {
            this.setIcon(this.getIcon(this.bitmapNumber));
        }
    }

    public void setBitmapDisabled(int n) {
        this.bitmapDisabled = n;
        if (this.image != null) {
            this.setDisabledIcon(this.getIcon(this.bitmapDisabled));
        }
    }

    public void setBitmapRollover(int n) {
        this.bitmapRollover = n;
        if (this.image != null) {
            this.setRolloverIcon(this.getIcon(this.bitmapRollover));
        }
    }

    public void setBitmapPressed(int n) {
        this.bitmapPressed = n;
        if (this.image != null) {
            this.setPressedIcon(this.getIcon(this.bitmapPressed));
        }
    }

    public void setBitmapWidth(int w) {
        this.bitmapWidth = w;
    }

    private Icon getIcon(int strip) {
        Image imageStrip;
        boolean sbts;
        Image im;
        if (strip <= 0) {
            return null;
        }
        Dimension sz = this.getSize();
        int imgWidth = this.bitmapWidth > 0 ? this.bitmapWidth : (this.scalebitmaptosize != null || this.titlePosition != 0 || this.bitmapScale > 0 ? this.imageWidth : this.imageWidth + sz.width - this.origSize.width);
        int imgHeight = this.scalebitmaptosize != null || this.titlePosition != 0 || this.bitmapScale > 0 ? this.imageHeight : this.imageHeight + sz.height - this.origSize.height;
        Image image = im = this.imageWithTC != null ? this.imageWithTC : this.image;
        if (im == null) {
            return null;
        }
        boolean bl = sbts = this.scalebitmaptosize != null && this.scalebitmaptosize.height > 0 && this.getPreferredSize().height > this.scalebitmaptosize.height;
        if (!(this.bitmapScale <= 0 || sbts || this.titlePosition != 0 && this.origSize == null)) {
            int scType;
            int align;
            if (this.bitmapScale == 1) {
                align = 5;
                scType = 0;
            } else {
                align = 7;
                scType = 1;
            }
            if (this.titlePosition != 0) {
                imageStrip = ScreenUtility.getImage(imgWidth, imgHeight, im, strip);
                float scaleX = (float)sz.width / (float)this.origSize.width;
                float scaleY = (float)sz.height / (float)this.origSize.height;
                if (imageStrip != null && (scaleX != 1.0f || scaleY != 1.0f)) {
                    imgWidth = Math.round(scaleX * (float)imageStrip.getWidth(null));
                    imgHeight = Math.round(scaleY * (float)imageStrip.getHeight(null));
                    imageStrip = IsguiUtility.scale(imageStrip, imgWidth, imgHeight, scType, align, false);
                }
            } else {
                imageStrip = ScreenUtility.getImage(this.bitmapWidth == 0 ? im.getWidth(null) : imgWidth, im.getHeight(null), im, strip);
                if (sz.width - 8 != imageStrip.getWidth(null) || sz.height - 7 != imageStrip.getHeight(null)) {
                    imageStrip = IsguiUtility.scale(imageStrip, sz.width - 8, sz.height - 7, scType, align, false);
                }
            }
        } else {
            imageStrip = ScreenUtility.getImage(imgWidth, imgHeight, im, strip);
        }
        if (imageStrip != null) {
            if (sbts) {
                return new ImageIcon(ScreenUtility.scale(imageStrip, this.scalebitmaptosize.width > 0 ? this.scalebitmaptosize.width : this.getPreferredSize().width, this.scalebitmaptosize.height > 0 ? this.scalebitmaptosize.height : this.getPreferredSize().height, 3, 5, this.scaleBestQuality));
            }
            if (this.usetextonicon && this.title != null) {
                StringBuffer sb = new StringBuffer(ScreenUtility.rightTrim(this.title));
                int idx = ScreenUtility.getMnemonicIdx(sb);
                TextOnIcon Return2 = new TextOnIcon(imageStrip, sb.toString(), this.titlePosition, this.getForeground(), this.getFont());
                Return2.setMnemonicIndex(idx);
                return Return2;
            }
            return new ImageIcon(imageStrip);
        }
        return null;
    }

    public void setImage(Image image, int width, int height, int transpColor) {
        if (this.image != image || this.imageWidth != width || this.imageHeight != height || this.transparentColor != transpColor) {
            this.setHasBitmap(image != null);
            this.image = image;
            this.imageHeight = height;
            this.imageWidth = width;
            if (this.bitmapNumber == 0) {
                this.bitmapNumber = 1;
            }
            this.transparentColor = transpColor;
            this.setImageWithTC();
            this.setIcons();
            if (this.hasBitmap) {
                if (this.bitmapPressed > 0 && this.flat) {
                    this.setBorderPainted(false);
                } else {
                    this.setBorderPainted(true);
                }
            }
        }
    }

    private void setImageWithTC() {
        this.imageWithTC = this.image != null && this.transparentColor >= 0 ? ScreenUtility.makeColorTransparent(this.image, this.transparentColor) : null;
    }

    private void setIcons() {
        this.setIcon(this.getIcon(this.bitmapNumber));
        this.setDisabledIcon(this.getIcon(this.bitmapDisabled));
        this.setRolloverIcon(this.getIcon(this.bitmapRollover));
        this.setPressedIcon(this.getIcon(this.bitmapPressed));
    }

    public void setTransparent(boolean t) {
        if (this.transparent != t) {
            this.transparent = t;
            this.setOpaque(!this.transparent);
        }
    }

    public void setFlat(boolean f) {
        if (this.flat != f) {
            this.flat = f;
            if (this.flat) {
                this.setBorder(null);
                this.setContentAreaFilled(false);
                if (!this.transparent) {
                    this.setOpaque(true);
                }
                if (this.bitmapPressed > 0) {
                    this.setBorderPainted(false);
                }
            } else {
                if (this.defaultBorder != null) {
                    this.setBorder(this.defaultBorder);
                }
                this.setContentAreaFilled(true);
            }
            this.updateColors();
        }
    }

    public void setTitle(String t) {
        this.title = t;
        t = ScreenUtility.rightTrim(this.title);
        if (t != null) {
            StringBuffer sb = new StringBuffer(t);
            int idx = ScreenUtility.getMnemonicIdx(sb);
            if (idx >= 0) {
                this.mnemonic = sb.charAt(idx);
            }
            if (this.hasBitmap && this.titlePosition <= 0) {
                this.setText(null);
                if (this.toolTipText == null || this.toolTipText.length() == 0) {
                    super.setToolTipText(RemoteBaseGUIControl.buildTitle(sb.toString(), idx, false));
                }
            } else if (this.multiline) {
                if (!this.usetextonicon) {
                    this.setText(RemoteBaseGUIControl.buildTitle(sb.toString(), idx, true));
                }
            } else if (!this.usetextonicon) {
                this.setText(sb.toString());
                if (idx >= 0 && idx < sb.length()) {
                    this.setDisplayedMnemonicIndex(idx);
                }
            } else if (this.image != null) {
                this.setIcon(this.getIcon(this.bitmapNumber));
            }
        }
    }

    @Override
    public void setToolTipText(String tt) {
        super.setToolTipText(tt);
        this.toolTipText = tt;
        if ((tt == null || tt.length() == 0) && this.title != null && this.hasBitmap && this.titlePosition <= 0) {
            this.setTitle(this.title);
        }
    }

    public char getMnemonicChar() {
        return this.mnemonic;
    }

    public void setTitlePosition(int pos) {
        int oldPos = this.titlePosition;
        this.titlePosition = pos;
        this.usetextonicon = false;
        switch (this.titlePosition) {
            case 2: {
                this.setHorizontalTextPosition(4);
                this.setVerticalTextPosition(0);
                break;
            }
            case 1: {
                this.setHorizontalTextPosition(2);
                this.setVerticalTextPosition(0);
                break;
            }
            case 3: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(1);
                break;
            }
            case 4: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                break;
            }
            case 5: {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(0);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.usetextonicon = true;
            }
        }
        if (this.image != null) {
            if (this.usetextonicon) {
                this.setText(null);
                this.setBorderPainted(false);
            } else if (this.bitmapPressed > 0 && this.flat) {
                this.setBorderPainted(false);
            } else {
                this.setBorderPainted(true);
            }
            this.setTitle(this.title);
            this.setIcon(this.getIcon(this.bitmapNumber));
        }
        if (oldPos == 0 ^ pos == 0) {
            this.setTitle(this.title);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        boolean old = this.isEnabled();
        super.setEnabled(b);
        if (old != b) {
            this.updateColors();
        }
    }

    public void setScaleBitmapToSize(Dimension scalebitmaptosize, boolean scaleBestQuality) {
        this.scalebitmaptosize = scalebitmaptosize;
        this.scaleBestQuality = scaleBestQuality;
    }

    public int getImageWidth() {
        return this.bitmapWidth;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        Dimension oldSize = this.getSize();
        super.setBounds(x, y, width, height);
        if (this.hasBitmap && this.scalebitmaptosize == null && (oldSize.width != width || oldSize.height != height)) {
            if (this.bitmapScale > 0) {
                this.setIcons();
            } else if (this.titlePosition == 0 && (oldSize.height != height || this.bitmapWidth == 0)) {
                this.setIcons();
            }
        }
    }

    public void setCustomBorder(Vector<Integer> borderWidth, Color borderColor) {
        this.borderWidth = borderWidth;
        this.borderColor = borderColor;
        if (this.flat && (this.borderColor != null || this.rolloverBorderColor == null)) {
            this.setBorder(this.getCustomBorder());
        }
    }

    public void setRolloverBorderColor(Color c) {
        this.rolloverBorderColor = c;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
        if (!this.isEnabled()) {
            this.updateBackground();
        }
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setDisabledForeground(Color disabledForeground) {
        this.disabledForeground = disabledForeground;
        if (!this.isEnabled()) {
            this.updateForeground();
        }
    }

    public Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public void setRolloverBackground(Color rolloverBackground) {
        this.rolloverBackground = rolloverBackground;
        if (this.isEnabled()) {
            this.updateBackground();
        }
    }

    public Color getRolloverForeground() {
        return this.rolloverForeground;
    }

    public void setRolloverForeground(Color rolloverForeground) {
        this.rolloverForeground = rolloverForeground;
        if (this.isEnabled()) {
            this.updateForeground();
        }
    }

    private void updateColors() {
        this.updateBackground();
        this.updateForeground();
    }

    private void updateBackground() {
        if (this.isEnabled()) {
            if (this.isMouseHovering && this.rolloverBackground != null) {
                super.setBackground(this.rolloverBackground);
            } else {
                super.setBackground(this.background);
            }
        } else if (this.flat && this.disabledBackground != null) {
            super.setBackground(this.disabledBackground);
        } else if (this.isMouseHovering && this.rolloverBackground != null) {
            super.setBackground(this.background);
        }
    }

    private void updateForeground() {
        Color fg = super.getForeground();
        Color newFg = null;
        if (this.isEnabled()) {
            if (this.isMouseHovering && this.rolloverForeground != null) {
                newFg = this.rolloverForeground;
                super.setForeground(newFg);
            } else {
                newFg = this.foreground;
                super.setForeground(newFg);
            }
        } else if (this.flat && this.disabledForeground != null) {
            newFg = this.disabledForeground;
            super.setForeground(newFg);
        } else {
            super.setForeground(defDisabledForeground);
        }
        if (this.usetextonicon && newFg != null && newFg != fg) {
            this.setIcon(this.getIcon(this.bitmapNumber));
        }
    }

    public int getTransparentColor() {
        return this.transparentColor;
    }

    public void setTransparentColor(int transparentColor) {
        if (this.transparentColor != transparentColor) {
            this.transparentColor = transparentColor;
            this.setImageWithTC();
            this.setIcons();
        }
    }

    public int getBitmapScale() {
        return this.bitmapScale;
    }

    public void setBitmapScale(int bitmapScale) {
        switch (bitmapScale) {
            case 1: 
            case 2: {
                this.bitmapScale = bitmapScale;
                break;
            }
            default: {
                this.bitmapScale = 0;
            }
        }
    }

    static {
        Color disableC = UIManager.getColor("Button.disabledText");
        if (disableC == null) {
            disableC = UIManager.getColor("Button.disabledForeground");
        }
        if (disableC == null) {
            disableC = new ColorUIResource(153, 153, 153);
        }
        defDisabledForeground = disableC;
    }
}

