/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.Events;
import com.iscobol.gui.RemoteRecordAccept;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.swing.BaseRemoteObject;
import com.iscobol.gui.client.swing.RemoteBaseGUIControl;
import com.iscobol.gui.client.swing.RemoteBaseGUIWindow;
import com.iscobol.gui.client.swing.WebClientEvent;
import java.io.IOException;

public class CobolEventCouple {
    private BaseRemoteObject sender;
    private BaseRemoteObject receiver;
    private RemoteRecordAccept rra;
    private int eventAction = -1;
    private boolean isControl;
    private boolean isLastEvent;
    private WebClientEvent wcEvent;

    private CobolEventCouple() {
        this.isLastEvent = true;
    }

    public CobolEventCouple(RemoteBaseGUIControl sender, BaseRemoteObject receiver, RemoteRecordAccept rra) {
        this((BaseRemoteObject)sender, receiver, rra);
        this.isControl = true;
    }

    public CobolEventCouple(BaseRemoteObject sender, BaseRemoteObject receiver, RemoteRecordAccept rra) {
        this.sender = sender;
        this.receiver = receiver;
        this.rra = rra;
    }

    public CobolEventCouple(RemoteBaseGUIControl sender, RemoteRecordAccept rra) {
        this((BaseRemoteObject)sender, rra);
        this.isControl = true;
    }

    public CobolEventCouple(BaseRemoteObject sender, RemoteRecordAccept rra) {
        this(sender, sender, rra);
    }

    public CobolEventCouple(RemoteBaseGUIWindow sender, RemoteRecordAccept rra, WebClientEvent wce) {
        this((BaseRemoteObject)sender, (BaseRemoteObject)sender, rra);
        this.wcEvent = wce;
    }

    public static CobolEventCouple getLastEvent() {
        return new CobolEventCouple();
    }

    public boolean sendToServer() {
        if (this.isLastEvent) {
            return false;
        }
        if (!this.sender.isInitialized() || this.wcEvent != null && this.wcEvent.isConsumed()) {
            return true;
        }
        try {
            if (this.isControl) {
                RemoteBaseGUIControl rbgc = (RemoteBaseGUIControl)this.sender;
                this.eventAction = rbgc.getParentBGW().controlfireevent(rbgc, this.rra);
            } else {
                Events events = this.sender.getEvents();
                if (events != null) {
                    this.eventAction = events.fireevent(this.rra);
                }
            }
            if (this.rra.isHotKeyEvent()) {
                this.receiver.handleResponse(this.eventAction, this.rra, true);
            } else {
                this.receiver.handleResponse(this.eventAction, this.rra);
            }
        }
        catch (IOException _re) {
            ScreenUtility.handleIOException(_re);
            return false;
        }
        return true;
    }

    public String toString() {
        return "event-type = " + (this.rra != null ? this.rra.getEventType() : 0);
    }

    public boolean handleResponse() {
        if (this.isLastEvent) {
            return false;
        }
        if (!this.sender.isInitialized()) {
            return true;
        }
        if (this.receiver != null) {
            if (this.rra.isHotKeyEvent()) {
                this.receiver.handleResponse(0, this.rra, true);
            } else {
                this.receiver.handleResponse(0, this.rra);
            }
        }
        return true;
    }

    public RemoteRecordAccept getRemoteRecordAccept() {
        return this.rra;
    }

    public BaseRemoteObject getSender() {
        return this.sender;
    }

    public String debug() {
        String Return2 = "";
        if (this.rra != null) {
            Return2 = Return2 + " rectype [" + this.rra.getRecordType() + "] evt [" + this.rra.getEventType() + "] sender [" + this.sender + "] sendername [" + (this.sender != null && this.sender instanceof RemoteBaseGUIControl ? ((RemoteBaseGUIControl)this.sender).getName() : " NULL ") + "] rra [" + this.rra.debugstr() + "]";
        }
        return Return2;
    }
}

