/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Dimension;
import java.awt.Insets;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class InputList
extends JPanel
implements ListSelectionListener,
DocumentListener {
    protected JLabel label = new JLabel();
    protected JTextField textfield;
    protected JList list;
    protected JScrollPane scroll;

    public InputList(Object[] data, String title) {
        this.setLayout(null);
        this.add(this.label);
        this.textfield = new OpelListText();
        this.label.setLabelFor(this.textfield);
        this.add(this.textfield);
        this.list = new OpelListList(data);
        this.list.setVisibleRowCount(4);
        this.textfield.getDocument().addDocumentListener(this);
        this.list.addListSelectionListener(this);
        this.scroll = new JScrollPane(this.list);
        this.add(this.scroll);
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.label.setToolTipText(text);
        this.textfield.setToolTipText(text);
        this.list.setToolTipText(text);
    }

    public void setDisplayedMnemonic(char ch) {
        this.label.setDisplayedMnemonic(ch);
    }

    public void setSelected(Object sel) {
        this.list.removeListSelectionListener(this);
        this.textfield.getDocument().removeDocumentListener(this);
        this.list.setSelectedValue(sel, true);
        this.textfield.setText(sel.toString());
        this.list.addListSelectionListener(this);
        this.textfield.getDocument().addDocumentListener(this);
    }

    public String getSelected() {
        Object o = this.list.getSelectedValue();
        return o != null ? o.toString() : null;
    }

    public void setSelectedInt(int value) {
        this.setSelected(new Integer(value));
    }

    public int getSelectedInt() {
        try {
            return Integer.parseInt(this.getSelected());
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object obj = this.list.getSelectedValue();
        if (obj != null) {
            this.textfield.getDocument().removeDocumentListener(this);
            this.textfield.setText(obj.toString());
            this.textfield.getDocument().addDocumentListener(this);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void textValueChanged() {
        ListModel model = this.list.getModel();
        if (model == null) {
            return;
        }
        this.list.removeListSelectionListener(this);
        String key = this.textfield.getText().toLowerCase();
        int k = -1;
        if (model.getElementAt(0) instanceof String) {
            boolean found = false;
            for (k = 0; !found && k < model.getSize(); ++k) {
                String data = (String)model.getElementAt(k);
                if (!data.toLowerCase().startsWith(key)) continue;
                this.list.setSelectedValue(data, true);
                found = true;
            }
            if (!found) {
                this.list.clearSelection();
            }
        } else if (model.getElementAt(0) instanceof Integer) {
            try {
                Integer idx = new Integer(key);
                boolean found = false;
                for (k = 0; !found && k < model.getSize(); ++k) {
                    Integer data = (Integer)model.getElementAt(k);
                    if (data.compareTo(idx) != 0) continue;
                    this.list.setSelectedValue(data, true);
                    found = true;
                }
                if (!found) {
                    this.list.clearSelection();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.list.addListSelectionListener(this);
    }

    public void addListSelectionListener(ListSelectionListener lst) {
        this.list.addListSelectionListener(lst);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        Dimension labelSize = this.label.getPreferredSize();
        Dimension textfieldSize = this.textfield.getPreferredSize();
        Dimension scrollPaneSize = this.scroll.getPreferredSize();
        int w = Math.max(Math.max(labelSize.width, textfieldSize.width), scrollPaneSize.width);
        int h = labelSize.height + textfieldSize.height + scrollPaneSize.height;
        return new Dimension(w + ins.left + ins.right, h + ins.top + ins.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void doLayout() {
        Insets ins = this.getInsets();
        Dimension size = this.getSize();
        int x = ins.left;
        int y = ins.top;
        int w = size.width - ins.left - ins.right;
        int h = size.height - ins.top - ins.bottom;
        Dimension labelSize = this.label.getPreferredSize();
        this.label.setBounds(x, y, w, labelSize.height);
        Dimension textfieldSize = this.textfield.getPreferredSize();
        this.textfield.setBounds(x, y += labelSize.height, w, textfieldSize.height);
        this.scroll.setBounds(x, y += textfieldSize.height, w, h - y);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleOpenList();
        }
        return this.accessibleContext;
    }

    protected class AccessibleOpenList
    extends JComponent.AccessibleJComponent {
        protected AccessibleOpenList() {
            super(InputList.this);
        }

        @Override
        public String getAccessibleName() {
            System.out.println("getAccessibleName: " + this.accessibleName);
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return InputList.this.label.getText();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }
    }

    class OpelListList
    extends JList {
        public OpelListList() {
        }

        public OpelListList(Object[] data) {
            super(data);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return InputList.this.getAccessibleContext();
        }

        @Override
        public void setSelectedIndex(int idx) {
            this.ensureIndexIsVisible(idx);
            super.setSelectedIndex(idx);
        }
    }

    class OpelListText
    extends JTextField {
        public OpelListText() {
        }

        public OpelListText(int numCols) {
            super(numCols);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return InputList.this.getAccessibleContext();
        }
    }

    class OpelListLabel
    extends JLabel {
        public OpelListLabel(String text, int alignment) {
            super(text, alignment);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return InputList.this.getAccessibleContext();
        }
    }
}

