/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.GradientManager;
import com.iscobol.gui.client.swing.MainPanel;
import com.iscobol.gui.client.swing.RemoteDisplayWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultDesktopManager;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class MDIPanel
extends MainPanel {
    private MDIDesktopPane desktopPane;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private GradientManager gradientMgr;

    public MDIPanel() {
        super(false);
        this.init();
    }

    public MDIPanel(RemoteDisplayWindow dw) {
        super(dw, false);
        this.gradientMgr = dw.gradientMgr;
        this.gradientMgr.addPropertyChangeListener(e -> this.repaint());
        this.init();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.addPropertyChangeListener(l);
        } else {
            super.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        } else {
            super.removePropertyChangeListener(l);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.desktopPane = new MDIDesktopPane(this.changeSupport, this.gradientMgr);
        this.add((Component)this.desktopPane, "Center");
    }

    public JDesktopPane getDesktopPane() {
        return this.desktopPane;
    }

    @Override
    public boolean isExpandable() {
        return false;
    }

    @Override
    public void setExpandable(boolean expandable) {
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.desktopPane != null) {
            this.desktopPane.setBackground(c);
        }
    }

    private static class MDIDesktopPane
    extends JDesktopPane {
        private final PropertyChangeSupport cs;
        private final GradientManager gradientMgr;

        public MDIDesktopPane(PropertyChangeSupport cs, GradientManager gradientMgr) {
            DefaultDesktopManager manager = new DefaultDesktopManager();
            this.cs = cs;
            this.gradientMgr = gradientMgr;
            this.setDesktopManager(manager);
        }

        @Override
        public void setSelectedFrame(JInternalFrame f) {
            JInternalFrame old = this.getSelectedFrame();
            if (old != f) {
                super.setSelectedFrame(f);
                this.cs.firePropertyChange("selectionChanged", old, f);
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.gradientMgr != null) {
                Graphics2D g2d = (Graphics2D)g;
                this.gradientMgr.paint(g2d, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
            }
        }
    }
}

