/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class MultilineLabel
extends JComponent
implements Accessible {
    private String text;
    private int mnemonicIndex = -1;
    private Font font;
    private Font underlineFont;
    private FontMetrics fontMetrics;
    private Dimension fontSize;
    private int align = 2;
    private boolean transparent;
    private ArrayList<Line> lines = new ArrayList();

    private static String[] split(String str) {
        ArrayList<String> l = new ArrayList<String>();
        while (str.length() > 0) {
            int idx1 = str.indexOf("\r\n");
            int idx2 = str.indexOf(10);
            if (idx1 >= 0) {
                if (idx2 >= 0) {
                    if (idx1 < idx2) {
                        l.add(str.substring(0, idx1));
                        l.add("\r\n");
                        str = str.substring(idx1 + 2);
                        continue;
                    }
                    l.add(str.substring(0, idx2));
                    l.add("\n");
                    str = str.substring(idx2 + 1);
                    continue;
                }
                l.add(str.substring(0, idx1));
                l.add("\r\n");
                str = str.substring(idx1 + 2);
                continue;
            }
            if (idx2 >= 0) {
                l.add(str.substring(0, idx2));
                l.add("\n");
                str = str.substring(idx2 + 1);
                continue;
            }
            l.add(str);
            break;
        }
        return l.toArray(new String[l.size()]);
    }

    private void buildLines() {
        ArrayList<Line> newLines = new ArrayList<Line>();
        if (this.text != null && this.text.length() > 0) {
            int textMaxW = this.getSize().width;
            int mnIdx = this.mnemonicIndex;
            int len = 0;
            String line = "";
            block0: for (String str : MultilineLabel.split(this.text)) {
                if (str.equals("\r\n") || str.equals("\n")) {
                    mnIdx -= str.length();
                    continue;
                }
                while (true) {
                    int lineW;
                    int idx1 = -1;
                    int idx2 = str.length();
                    line = str;
                    while ((lineW = this.fontMetrics.stringWidth(line)) > textMaxW && (idx1 = str.lastIndexOf(32, idx2 - 1)) >= 0) {
                        for (idx2 = idx1; idx2 > 0 && str.charAt(idx2 - 1) == ' '; --idx2) {
                        }
                        line = str.substring(0, idx2);
                    }
                    int underlineIdx = -1;
                    if (mnIdx >= len && mnIdx < len + line.length()) {
                        underlineIdx = mnIdx - len;
                    }
                    newLines.add(new Line(line, lineW, underlineIdx));
                    len += line.length();
                    if (idx2 >= str.length() - 1) continue block0;
                    if (mnIdx > len) {
                        mnIdx -= idx2 + 1 - line.length();
                    }
                    str = str.substring(idx2 + 1);
                }
            }
        }
        this.setLines(newLines);
    }

    public void setText(String text) {
        this.text = text;
        this.buildLines();
        this.repaint();
    }

    public void setMnemonicIndex(int idx) {
        this.mnemonicIndex = idx;
        this.buildLines();
        this.repaint();
    }

    public void setTextAlignment(int a) {
        this.align = a;
        this.repaint();
    }

    public void setTransparent(boolean t) {
        this.transparent = t;
        this.repaint();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.setFontAttrs(f);
        this.buildLines();
        this.repaint();
    }

    private void setFontAttrs(Font f) {
        this.font = f;
        HashMap<TextAttribute, Integer> attrs = new HashMap<TextAttribute, Integer>();
        attrs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        this.underlineFont = this.font.deriveFont(attrs);
        this.fontMetrics = this.getFontMetrics(f);
        this.fontSize = new Dimension(Math.round((float)this.fontMetrics.stringWidth("0123456789") / 10.0f), this.fontMetrics.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        if (this.font == null) {
            this.setFontAttrs(this.getFont());
        }
        Graphics2D g2d = (Graphics2D)g;
        Toolkit tlk = Toolkit.getDefaultToolkit();
        Map map = (Map)tlk.getDesktopProperty("awt.font.desktophints");
        if (map != null) {
            g2d.addRenderingHints(map);
        }
        int currWidth = this.getWidth();
        int currHeight = this.getHeight();
        if (!this.transparent) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, currWidth, currHeight);
        }
        if (this.text != null && this.text.length() > 0) {
            Line[] currLines;
            int textY = this.fontMetrics.getAscent();
            g.setColor(this.getForeground());
            g.setFont(this.font);
            for (Line line : currLines = this.getLines()) {
                int textX = 0;
                int textW = line.width;
                switch (this.align) {
                    default: {
                        break;
                    }
                    case 0: {
                        int d = currWidth - textW;
                        if (d <= 0) break;
                        textX += d / 2;
                        break;
                    }
                    case 4: {
                        int d = currWidth - textW;
                        if (d <= 0) break;
                        textX += d;
                    }
                }
                String lineText = line.text;
                int underlineIdx = line.uIndex;
                if (underlineIdx >= 0) {
                    if (underlineIdx > 0) {
                        String lineText0 = lineText.substring(0, underlineIdx);
                        g.drawString(lineText0, textX, textY);
                        textX += this.fontMetrics.stringWidth(lineText0);
                    }
                    g.setFont(this.underlineFont);
                    String underlineText = "" + lineText.charAt(underlineIdx);
                    g.drawString(underlineText, textX, textY);
                    g.setFont(this.font);
                    textX += this.fontMetrics.stringWidth(underlineText);
                    if (underlineIdx < lineText.length() - 1) {
                        String lineText0 = lineText.substring(underlineIdx + 1);
                        g.drawString(lineText0, textX, textY);
                        textX += this.fontMetrics.stringWidth(lineText0);
                    }
                } else {
                    g.drawString(lineText, textX, textY);
                }
                textX += textW;
                textY += this.fontSize.height;
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Dimension d = this.getSize();
        super.setBounds(x, y, w, h);
        if (d.width != w || d.height != h) {
            this.buildLines();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Line[] getLines() {
        ArrayList<Line> arrayList = this.lines;
        synchronized (arrayList) {
            return this.lines.toArray(new Line[this.lines.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLines(ArrayList<Line> newLines) {
        ArrayList<Line> arrayList = this.lines;
        synchronized (arrayList) {
            this.lines.clear();
            this.lines.addAll(newLines);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.fontMetrics != null && this.text != null) {
            return new Dimension(this.fontMetrics.stringWidth(this.text), this.fontMetrics.getHeight());
        }
        return super.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getDisplayedMnemonic() {
        ArrayList<Line> arrayList = this.lines;
        synchronized (arrayList) {
            for (Line l : this.lines) {
                if (l.uIndex < 0 || l.text == null || l.uIndex >= l.text.length()) continue;
                return l.text.charAt(l.uIndex);
            }
        }
        return -1;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultilineLabel();
        }
        return this.accessibleContext;
    }

    private static class Line {
        final String text;
        final int width;
        final int uIndex;

        Line(String text, int width, int uIndex) {
            this.text = text;
            this.width = width;
            this.uIndex = uIndex;
        }
    }

    private class AccessibleMultilineLabel
    extends JComponent.AccessibleJComponent {
        private AccessibleMultilineLabel() {
            super(MultilineLabel.this);
        }

        @Override
        public String getAccessibleName() {
            String name = this.accessibleName;
            if (name == null) {
                name = (String)MultilineLabel.this.getClientProperty("AccessibleName");
            }
            if (name == null) {
                name = MultilineLabel.this.text;
            }
            if (name == null) {
                name = super.getAccessibleName();
            }
            return name;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        @Override
        public AccessibleIcon[] getAccessibleIcon() {
            return null;
        }

        @Override
        public AccessibleText getAccessibleText() {
            return null;
        }

        @Override
        public String getToolTipText() {
            return MultilineLabel.this.getToolTipText();
        }

        @Override
        public String getTitledBorderText() {
            return null;
        }

        @Override
        public AccessibleKeyBinding getAccessibleKeyBinding() {
            int mnemonic = MultilineLabel.this.getDisplayedMnemonic();
            if (mnemonic == 0) {
                return null;
            }
            return new MultilineLabelKeyBinding(mnemonic);
        }

        class MultilineLabelKeyBinding
        implements AccessibleKeyBinding {
            int mnemonic;

            MultilineLabelKeyBinding(int mnemonic) {
                this.mnemonic = mnemonic;
            }

            @Override
            public int getAccessibleKeyBindingCount() {
                return 1;
            }

            @Override
            public Object getAccessibleKeyBinding(int i) {
                if (i != 0) {
                    throw new IllegalArgumentException();
                }
                return KeyStroke.getKeyStroke(this.mnemonic, 0);
            }
        }
    }
}

