/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.gui.client.swing;

import com.iscobol.gui.client.swing.PicobolMenuElement;
import com.iscobol.gui.client.swing.RemoteMenu;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JMenu;

public class PicobolMenu
extends JMenu
implements PicobolMenuElement {
    private static final long serialVersionUID = 1L;
    private boolean block;
    private int mnemonic = -1;
    private boolean released;
    private RemoteMenu parent;
    private JLabel rightLabel;

    public PicobolMenu(RemoteMenu parent) {
        this.parent = parent;
        this.mnemonic = super.getMnemonic();
        this.setLayout(new BorderLayout());
    }

    public RemoteMenu getParentMenu() {
        return this.parent;
    }

    public void setBlock(boolean b) {
        if (this.released) {
            return;
        }
        this.block = b;
        if (this.block) {
            super.setMnemonic(-1);
        } else if (this.mnemonic > -1) {
            super.setMnemonic(this.mnemonic);
        }
    }

    @Override
    public void setMnemonic(int mnemonic) {
        this.mnemonic = mnemonic;
        if (!this.block) {
            super.setMnemonic(mnemonic);
        }
    }

    @Override
    public int getMnemonic() {
        return this.mnemonic;
    }

    public boolean getBlock() {
        return this.block;
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (!this.released && !this.block) {
            super.processEvent(e);
        }
    }

    public void setReleased(boolean r) {
        this.setBlock(true);
        this.released = r;
    }

    public boolean getReleased() {
        return this.released;
    }

    @Override
    public void processEvent(KeyEvent evt) {
        super.processKeyEvent(evt);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (this.rightLabel != null) {
            this.remove(this.rightLabel);
            this.rightLabel = null;
            this.doLayout();
        }
    }

    public void setText(String text, String rightText) {
        int strlen;
        FontMetrics fm;
        int i;
        if (this.rightLabel != null) {
            this.remove(this.rightLabel);
        }
        String centerText = text;
        int len = rightText.length();
        for (i = 0; i <= len; ++i) {
            centerText = centerText + " ";
        }
        super.setText(centerText);
        for (i = 0; i <= 5; ++i) {
            rightText = rightText + " ";
        }
        this.rightLabel = new JLabel(rightText);
        this.add((Component)this.rightLabel, "East");
        if (this.getFont() != null && (fm = this.getFontMetrics(this.getFont())) != null && this.getPreferredSize().width < (strlen = fm.stringWidth(centerText) + fm.stringWidth(rightText))) {
            this.setPreferredSize(new Dimension(strlen + 10, this.getPreferredSize().height));
        }
        this.doLayout();
    }
}

